#include "defines.h"

//#############################################################################
//             DFLASH读写 相关程序
//#############################################################################
#define Read_near(Addr)  ((unsigned int)(*(volatile unsigned int *__near)(Addr)))
#define Read_far(Addr)   ((unsigned int)(*(volatile unsigned int *__far)(Addr)))
/*************************************************************/
/*   ע: ADDR32ΪGlobal address                          */
/*         ADDR32ȡֵΧ 0x007E_0000-0x7F_FFFF            */
/*************************************************************/
INT32U PFlash_Read (INT32U ADDR32)
{
    uint data;
    data = Read_far(ADDR32);
    return(data);              //һ
}

INT32U PFlash_Near_Read (INT32U ADDR32)
{
    uint data;
    data = Read_near(ADDR32);
    return(data);              //һ
}

// D-Flash的本地地址范围:  0x0400 - 0x13FF
// D-Flash的全局地址范围:  0x4400 + 0x53FF

static INT8U Send_Command[] =
{
    0x1C, 0x01, 0x06, 0x80, 0x1F, 0x01, 0x06, 0x80, 0xFB, 0x3D

};

///==============================================================================
//Local2Global
//把本地地址 转换?全局地址                  2015-4-21
//入口:本地地址
//出口:全局地址
//==============================================================================
INT32U Local2Global(INT32U address)
{
    //PAGE_F8       = READ_ONLY   DATA_FAR IBCC_FAR  0xF88000 TO 0xF8BFFF; //16K   7E0000 - 7E3FFF
    if ((0xF88000 <= address) && (address <= 0xF8BFFF))
    {
        address = address - 0xF88000 + 0x7E0000;
        return address;
    }

    //PAGE_F9       = READ_ONLY   DATA_FAR IBCC_FAR  0xF98000 TO 0xF9BFFF; //16K    7E4000 - 7E7FFF
    if ((0xF98000 <= address) && (address <= 0xF9BFFF))
    {
        address = address - 0xF98000 + 0x7E4000;
        return address;
    }

    //PAGE_FA       = READ_ONLY   DATA_FAR IBCC_FAR  0xFA8000 TO 0xFABFFF; //16K    7E8000 - 7EBFFF
    if ((0xFA8000 <= address) && (address <= 0xFABFFF))
    {
        address = address - 0xFA8000 + 0x7E8000;
        return address;
    }

    //PAGE_FB       = READ_ONLY   DATA_FAR IBCC_FAR  0xFB8000 TO 0xFBBFFF; //16K    7EC000 - 7EFFFF
    if ((0xFB8000 <= address) && (address <= 0xFBBFFF))
    {
        address = address - 0xFB8000 + 0x7EC000;
        return address;
    }

    //PAGE_FC       = READ_ONLY   DATA_FAR IBCC_FAR  0xFC8000 TO 0xFCBFFF; //16K    7F0000 - 7F3FFF
    if ((0xFC8000 <= address) && (address <= 0xFCBFFF))
    {
        address = address - 0xFC8000 + 0x7F0000;
        return address;
    }

    /*    PAGE_FD       = READ_ONLY                      0xFD8000 TO 0xFDBFFF; //16K    7F4000 - 7F7FFF  intentionally not defined: equivalent to ROM_4000 */
    /*    PAGE_FF       = READ_ONLY                      0xFF8000 TO 0xFFBFFF; //15K    7FC000 - 7FFBFF  intentionally not defined: equivalent to ROM_C000 */
    if (((address >= 0x4000) && (address <= 0x7FFF)) || ((address >= 0xC000) && (address <= 0xFFFF)))
    {
        address = address | 0x7F0000;
        return address;                                  //FFF8
    }

    //PAGE_FE       = READ_ONLY   DATA_FAR IBCC_FAR  0xFE8000 TO 0xFEBFFF; //16K    7F8000 - 7FBFFF
    if ((0xFE8000 <= address) && (address <= 0xFEBFFF))
    {
        address = address - 0xFE8000 + 0x7F8000;
        return address;
    }
    return 0;
}

//==============================================================================
//Global2Local
//?全局地址 转换?本地地址                  2015-4-21
//入口:本地地址
//出口:全局地址
//==============================================================================
INT32U Global2Local(INT32U address)
{
    //PAGE_F8       = READ_ONLY   DATA_FAR IBCC_FAR  0xF88000 TO 0xF8BFFF; //16K   7E0000 - 7E3FFF
    if ((0x7E0000 <= address) && (address <= 0x7E3FFF))
    {
        address = address - 0x7E0000 + 0xF88000;
        return address;
    }

    //PAGE_F9       = READ_ONLY   DATA_FAR IBCC_FAR  0xF98000 TO 0xF9BFFF; //16K    7E4000 - 7E7FFF
    if ((0x7E4000 <= address) && (address <= 0x7E7FFF))
    {
        address = address - 0x7E4000 + 0xF98000;
        return address;
    }

    //PAGE_FA       = READ_ONLY   DATA_FAR IBCC_FAR  0xFA8000 TO 0xFABFFF; //16K    7E8000 - 7EBFFF
    if ((0x7E8000 <= address) && (address <= 0x7EBFFF))
    {
        address = address - 0x7E8000 + 0xFA8000;
        return address;
    }

    //PAGE_FB       = READ_ONLY   DATA_FAR IBCC_FAR  0xFB8000 TO 0xFBBFFF; //16K    7EC000 - 7EFFFF
    if ((0x7EC000 <= address) && (address <= 0x7EFFFF))
    {
        address = address - 0x7EC000 + 0xFB8000;
        return address;
    }

    //PAGE_FC       = READ_ONLY   DATA_FAR IBCC_FAR  0xFC8000 TO 0xFCBFFF; //16K    7F0000 - 7F3FFF
    if ((0x7F0000 <= address) && (address <= 0x7F3FFF))
    {
        address = address - 0x7F0000 + 0xFC8000;
        return address;
    }

    if ((0x7F4000 <= address) && (address <= 0x7F7FFF))
    {
        address = address - 0x7F4000 + 0x4000;
        return address;
    }

    if ((0x7FC000 <= address) && (address <= 0x7FFBFF))
    {
        address = address - 0x7FC000 + 0xC000;
        return address;
    }

    //PAGE_FE       = READ_ONLY   DATA_FAR IBCC_FAR  0xFE8000 TO 0xFEBFFF; //16K    7F8000 - 7FBFFF
    if ((0x7F8000 <= address) && (address <= 0x7FBFFF))
    {
        address = address - 0x7F8000 + 0xFE8000;
        return address;
    }
    return 0;
}

//=============================================================================
//判断全局地址在哪个SECTOR
//入口:全局地址
//出口:sector (0---127)
//=============================================================================
INT8U GET_Global_sector_PRG(INT32U address)
{
    INT8U m8;

    //PAGE_F8       0xF88000 TO 0xF89FFF; //8K     7E0000 - 7E1FFF  (0--7)
    //PAGE_F9       0xF98000 TO 0xF9BFFF; //16K    7E4000 - 7E7FFF  (16--31)
    //PAGE_FA       0xFA8000 TO 0xFABFFF; //16K    7E8000 - 7EBFFF  (32--47)
    //PAGE_FB       0xFB8000 TO 0xFBBFFF; //16K    7EC000 - 7EFFFF  (48--63)
    //PAGE_FC       0xFC8000 TO 0xFCBFFF; //16K    7F0000 - 7F3FFF  (64--79)
    //PAGE_FD       0xFD8000 TO 0xFDBFFF; //16K    7F4000 - 7F7FFF  (80--95)    equivalent to ROM_4000
    //PAGE_FE       0xFE8000 TO 0xFEBFFF; //16K    7F8000 - 7FBFFF  (96--111)
    //PAGE_FF       0xFF8000 TO 0xFFBFFF; //15K    7FC000 - 7FFBFF  (112--126)  equivalent to ROM_C000
    m8 = (INT8U)((address - 0x7E0000) >> 10);
    return m8;
}

//==============================================================================
//DFLASH/PFLASH_Erase_Verify_Section                  2015-4-18
//
//入口:mTYPE   0:DFLASH, 1:PFLASH
//     address 为全局地址
//     number_of_words 为要校验的字单元个数
//==============================================================================
INT8U D_P_FLASH_Erase_Verify_Section(INT8U mTYPE, INT32U address, INT16U number_of_words)
{
    INT16U code;

    //DFLASH size of sector is 256 BYTE
    //PFLASH size of sector is 1024 BYTE

    if (mTYPE == 0)
    {
        code = 0x1000;
    }
    else
    {
        code = 0x0300;
    }

    while(FSTAT_CCIF == 0);   //wait if command in progress
    FSTAT = 0x30;             //clear ACCERR and PVIOL

    FCCOBIX = 0x00;
    FCCOB = code | ((address & 0x007F0000) >> 16);        //0x00FF0000
    FCCOBIX = 0x01;
    FCCOB = (INT16U)address;
    FCCOBIX = 0x02;
    FCCOB = number_of_words;

    cli();								//我加?
    asm JSR Send_Command;
    sei();								//我加?
    FSTAT = 0x30;

    if((FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK)) != 0)
        return ACCESS_ERROR;

    if(FSTAT_MGSTAT != 0)
        return NON_ERASED;
    else
        return ERASED;
}

//==============================================================================
//DFLASH/PFLASH Program                                     2015-4-18
//
//入口:mTYPE   0:DFLASH, 1:PFLASH
//     address 为全局地址
//     number_of_words:   对于DFLASH     1<=number_of_words<=4
//                        对于PFLASH     number_of_words=4
//==============================================================================
INT8U D_P_FLASH_Program(INT8U mTYPE, INT32U  address, INT16U *ptr, INT8U number_of_words)
{
    INT8U i;
    INT16U code;
    INT32U m32;

    //DFLASH size of sector is 256 BYTE
    //PFLASH size of sector is 1024 BYTE

    if (mTYPE == 0)
    {
        code = 0x1100;
        m32 = 0x00000001;
    }
    else
    {
        code = 0x0600;
        m32 = 0x00000007;
    }

    //check if address is aligned (global address [0] != 0)     DFLASH
    //check if address is aligned (global address [2:0] != 0)   PFLASH
    if((address & m32) != 0)
        return MISALIGNED_ADDRESS;

    while(FSTAT_CCIF == 0);   //wait if command in progress
    FSTAT = 0x30;             //clear ACCERR and PVIOL

    FCCOBIX = 0x00;
    FCCOB = code | ((address & 0x007F0000) >> 16);       //0x00030000

    FCCOBIX = 0x01;
    FCCOB = (INT16U)address;


    for (i = 1; i <= number_of_words; i++)    //fill appropriate number of words to FCCOB
    {
        FCCOBIX = i + 1;
        FCCOB = *ptr;
        ptr++;
    }

    cli();								//我加?
    asm JSR Send_Command;
    sei();
    FSTAT = 0x30;								//我加?

    if ((FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK)) != 0)
        return ACCESS_ERROR;

    if (FSTAT_MGSTAT != 0)
        return VERIFICATION_FAILED;
    return Ok;
}

//==============================================================================
//DFLASH/PFLASH_N_Program              2015-4-18
//
//入口:mTYPE   0:DFLASH, 1:PFLASH
//     address 为全局地址
//     number_of_words:   对于DFLASH     1<=number_of_words<=128
//                        对于PFLASH     4<=number_of_words<=512   ?number_of_words必须?的倍数
//
//==============================================================================
INT8U  D_P_FLASH_N_Program(INT8U mTYPE, INT32U  address, INT16U *ptr, INT8U number_of_words)
{
    INT8U mRUL;
    for(;;)
    //while (1)
    {
        wdt_reset();
        if (number_of_words >= 4)
        {
            mRUL = D_P_FLASH_Program(mTYPE, address, ptr, 4);
            if (mRUL != Ok)
                return mRUL;
            ptr = ptr + 4;
            address = address + 8;
            number_of_words = number_of_words - 4;
        }
        else
        {
            if (number_of_words == 0)
                return  Ok;
            if(mTYPE)
                number_of_words = 4;
            mRUL = D_P_FLASH_Program(mTYPE, address, ptr, number_of_words);
            return mRUL;
        }
    }
}

//==============================================================================
//DFLASH/PFLASH_N_Program              2015-5-13
//
//入口:
//     address 为全局地址
//     number_of_bytes:    1<=number_of_bytes<=1024
//
//==============================================================================
INT8U  PP_FLASH_N_Program(INT32U  address, INT8U *ptr, INT8U number_of_bytes)
{
    INT8U mRUL;
   
    INT8U  buff[8];

    if (number_of_bytes == 0)
        return Ok;

    //while (1)
    for(;;)
    {
        wdt_reset();
        if (number_of_bytes >= 8)
        {
            mRUL = D_P_FLASH_Program(1, address, (INT16U *)ptr, 4);
            if (mRUL != Ok)
                return mRUL;
            ptr = ptr + 8;
            address = address + 8;
            number_of_bytes = number_of_bytes - 8;
        }
        else
        {
            if (number_of_bytes == 0)
                return Ok;
            (void)memset(buff, 0xff, 8);
            (void)memcpy(buff, ptr, number_of_bytes);

            mRUL = D_P_FLASH_Program(1, address, (INT16U *)buff, 4);
            return mRUL;
        }
    }
}

//==============================================================================
//DFLASH/PFLASH Erase_Sector                  2015-4-18
//
//入口: mTYPE   0:DFLASH, 1:PFLASH
//      address 为全局地址
//==============================================================================
INT8U  D_P_FLASH_Erase_Sector(INT8U mTYPE, INT32U  address)
{

    INT16U code;
    INT32U m32;

    //DFLASH size of sector is 256 BYTE
    //PFLASH size of sector is 1024 BYTE

    if (mTYPE == 0)
    {
        code = 0x1200;
        m32 = 0xFFFFFFFE;
    }
    else
    {
        code = 0x0A00;
        m32 = 0xFFFFFFF8;
    }

    address = address & m32;

    while(FSTAT_CCIF == 0);   //wait if command in progress
    FSTAT = 0x30;             //clear ACCERR and PVIOL
    FCCOBIX = 0x00;
    FCCOB = code | ((address & 0x007F0000) >> 16);         //0x00030000
    FCCOBIX = 0x01;
    FCCOB = (INT16U)address;

    cli();								//我加?
    asm JSR Send_Command;
    sei();
    FSTAT = 0x30; 							//我加?

    if((FSTAT & (FSTAT_ACCERR_MASK | FSTAT_FPVIOL_MASK)) != 0)
        return ACCESS_ERROR;
    if(FSTAT_MGSTAT != 0)
        return VERIFICATION_FAILED;
    return Ok;
}

INT16U data16;
//==============================================================================
//DFLASH_Read_Word
//
//入口: address 为全局地址
//==============================================================================
INT16U DFLASH_Read_Word(INT32U  address)
{

    EPAGE = 0;
    data16 = (*(volatile unsigned short * )(address - (DFLASH_FirstAddress - 0x800)));
    return data16;
}

//==============================================
//在DFLASH?个扇区写标志?
//==============================================
void WRITE_BZ_inDFLAH2Sector(INT16U bz)
{
    if (D_P_FLASH_Erase_Sector(0, DFLASH_APPvAddress) != Ok)
        return;
    (void)D_P_FLASH_Program(0, DFLASH_APPvAddress, &bz, 1);
}

INT16U GetResetAddr_Word(void)
{
    INT16U  data16;
    EPAGE = 0;
    data16 = (*(volatile unsigned short * )0xfffe );
    return data16;
}
