#define GLOBALS_GUI_TXT
#define GLOBALS_VARIABLE
#include "defines.h"
#include "g_includes.h"
#include "protocol_class.h"
#include "APP_Service.h"
#include "UDS_def.h"
#include "UDS_CFG.h"
#include "TP_Layer.h"
#include "app_ServiceProc.h"
#include "dtc_handle.h"
#include "JAC.h"
#include "User_def.h"

volatile               _BootReg                g_bootReg;

//-- JH-JL-N721- --//
void main(void) 
{
	IVBR = 0xFB;
	bsp_Sys_Init();
	Api_MeterLightOFFCtl();
	DiagnosisInit_main();
	bsp_Delay(100000);
	EnableInterrupts;
	App_DTC_EEpromInit();
	App_StarUpInfo();
	bsp_TFT_Init();
	Gui_MotorFirstReset();
	Init2EData();
	App_CalFuelInit();
	//Reset_Device();    
	//Power_Up();
	App_StarUpInfo1();

	for(;;)
	{
		_FEED_COP();
		T2MS_Task();
		Api_GetAdcResult();
		App_SendCanMsg();
		if(g_curkeyinput == KeyON)
		{
			App_FuelManage();
			switch(g_runStep)
			{
				case SYS_INIT_TASK:
					bsp_Sys_ON();
					if(g_validFlag.Bits.BD8379Init)
					{
						DB8379_Init();
					}
					g_validFlag.Bits.BD8379Init=Disable;

					DiagnosisInit_main();
					if(g_30LOGOFlag==0)
					{
						bsp_TFT_Init();
					}
					App_Paramer_Init();
					App_Load_Data();

					if((g_Lastkeyinput == KeyLow) || (g_Lastkeyinput == KeyHi))
					{
						Gui_MotorFirstReset();
					}
					else
					{
						Gui_MotorStarReset();
					}
					g_Lastkeyinput = g_curkeyinput;
					Api_ReadAccKm();
					g_runStep = CAN_TASK;
					break;
				case CAN_TASK:
					CheckEcmMulDTC();
					CheckOSC();
					g_runStep = CALCULATE_TASK;
					break;
				case SCI_TASK:
					g_runStep = CALCULATE_TASK;
					break;
				case CALCULATE_TASK:
					App_CalBorad();
					App_CalFre((_FreType *)&VehFre);
					Gui_ButtonProc((_Button *)&G_Button);
					g_runStep = STORE_TASK;
					break;
				case STORE_TASK:
					App_CalFuelEconomy();
					//App_CalAccKm((_MeterPos *)&g_vehMeter);
					App_CalAccKm();
					g_runStep = GUI_TASK;
					break;
				case GUI_TASK:
					Gui_BeepPrioProc((_Beep *)g_Beep);
					if(g_ReadState == RunErr)
					{
						Api_ReadAccKm();
					}
					Gui_LCD_Display();
					g_runStep = CAN_TASK;
					break;
				default:
					g_runStep = SYS_INIT_TASK;
			}
		}
		App_ChcekSleep();
		PowerManage();       
		T20MS_Task();
		Gui_LightProc();
		Diagnosis_main();
		App_CheckCanDrop();
		App_StoreDTC_handle(); 
		if(g_curkeyinput == KeyOFF)
		{
			SetPowerSt(0);
			g_Init.InitLogoTime = null;
			g_curLightFlag = 0;
			if(g_sysFlag.Bits.SysOffEn)
			{
				Disable_signal(g_sysFlag.Bits.SysOffEn);
				App_State_OFF();
				Gui_MotorOffReset();
			}
			Gui_BeepPrioProc((_Beep *)g_Beep);
			if(g_sysFlag.Bits.AccSaveState)
			{
				Disable_signal(g_sysFlag.Bits.AccSaveState);
				Disable_signal(g_sysFlag.Bits.WakeUpState);
				Api_WriteAccReg();
				SaveDtcInfo.EE_WriteDtcSel = StoreDTC_EE;
			}
			if(WriteleFlag2E == Enable)
			{
				App_2E_Write_handle();
				Init2EData();
				App_CalFuelInit();
				WriteleFlag2E = Disable;
			}
			g_runStep = SYS_INIT_TASK;
			App_SleepProc();
		}
		Api_ClockGenerate();
	}
}
