#define GLOBALS_API_BD8379_H
#include "g_includes.h"
#include "defines.h"

/*-------------------------------------------------------------------------
* Function Name  : DB8379_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void delay_ns(INT32U time)
{
    INT32U i;
    for(i = 0; i < time; i++)
    {
        asm NOP;
        _FEED_COP();
    }
}
/*-------------------------------------------------------------------------
* Function Name  : DB8379_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void DB8379_Init(void)
{
    DB8379_OE_P = 0;
    DB8379_RST_P = 0;
    delay_ns(30);
    DB8379_RST_P = 1;
}
/*-------------------------------------------------------------------------
* Function Name  : DB8379_WriteData
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void DB8379_WriteData(INT8U State)
{
    INT8U i = 0;
    INT8U num = 0; 
    INT32U tmp[2];
    INT32U mask = 0x80000000; 
    
    if(State == ON) 
    {
      tmp[0] = BD83790B;
      tmp[1] = BD83790A; 
    }
    else
    {
      tmp[0] = 0;
      tmp[1] = 0;
    }
    
    DB8379_SIN_P = 0;
    DB8379_CLK_P = 0;
    DB8379_LE_P = 0;

    for(num = 0; num < 2; num++)  
    {
        for(i = 0; i < 12; i++)                   
        {
            if(tmp[num] & mask)          
            {
              DB8379_SIN_P = 1; 
            }
            else                           
            {
              DB8379_SIN_P = 0;
            }
            
            delay_ns(8);
            DB8379_CLK_P = 1;

            delay_ns(28);
            DB8379_CLK_P = 0;
            mask >>= 1;
        }

        mask = 0x80000000;       
    }
    DB8379_LE_P = 1;
    delay_ns(14);
    DB8379_LE_P = 0;
}
