#include "defines.h"
#include "protocol_class.h"
#include "TP_Layer.h"
#include "app_Service.h"
#include "Link_Layer.h"
#include "UDS_def.h"
#include "User_def.h"
#include "UDS_CFG.h"
#include "JAC.h"
#include "dtc_handle.h"
#include "g_includes.h"
#include "app_ServiceProc.h"

#define  GLOBALS_UDS_CFG
#define  GLOBALS_USER_DEF

extern INT8U APP_MODE_FLAG;
volatile       _SnapShot             DiagSnap[ TotalDTCNum ];

unsigned int nc_uds_keymul[32] =
{
    
    0x7678, 0x9130, 0xd753, 0x750f, 0x72cb, 0x55f7, 0x13da, 0x786b,
    
    
    0x372a, 0x4932, 0x0e7c, 0x3687, 0x3261, 0xa82c, 0x8935, 0xd00c,
    
    
    0x1995, 0x4311, 0xb854, 0x0d8d, 0x9863, 0x1a21, 0xf753, 0xd6d3,
    
    
    0xb15d, 0x7f3d, 0x6821, 0x791c, 0x26c5, 0x2e37, 0x0e69, 0x64a0
};

  //-- IO --// 
  _DIDValid DIDFlag; 
  
  _IOCTL_Data IOCTL_DID1001;
  _IOCTL_Data IOCTL_DID1002; 
  _IOCTL_Data IOCTL_DID1003;
  _IOCTL_Data IOCTL_DID1004;
  _IOCTL_Data IOCTL_DID1005;
  _IOCTL_Data IOCTL_DID1006;
  _IOCTL_Data IOCTL_DID1007;
  _IOCTL_Data IOCTL_DID1008;
  _IOCTL_Data IOCTL_DID1009;
  _IOCTL_Data IOCTL_DID100A;
  _IOCTL_Data IOCTL_DID100B;
  _IOCTL_Data IOCTL_DID100C;
  _IOCTL_Data IOCTL_DID100D;
  _IOCTL_Data IOCTL_DID100E;
  _IOCTL_Data IOCTL_DID100F;
  _IOCTL_Data IOCTL_DID1010;
  _IOCTL_Data IOCTL_DID1011;
  _IOCTL_Data IOCTL_DID1012;
  _IOCTL_Data IOCTL_DID1013; 
  _IOCTL_Data IOCTL_DID1014;
  _IOCTL_Data IOCTL_DID1015;
  _IOCTL_Data IOCTL_DID1016;
  _IOCTL_Data IOCTL_DID1017;
  _IOCTL_Data IOCTL_DID1018;
  _IOCTL_Data IOCTL_DID1019;
  _IOCTL_Data IOCTL_DID101A;
  _IOCTL_Data IOCTL_DID101B;
  _IOCTL_Data IOCTL_DID101C;
  _IOCTL_Data IOCTL_DID101D;
  _IOCTL_Data IOCTL_DID101E;
  _IOCTL_Data IOCTL_DID101F;
  _IOCTL_Data IOCTL_DID1020;
  _IOCTL_Data IOCTL_DID1021;
  _IOCTL_Data IOCTL_DID1022;
  _IOCTL_Data IOCTL_DID1023;
  _IOCTL_Data IOCTL_DID1024;
  _IOCTL_Data IOCTL_DID1025;
  _IOCTL_Data IOCTL_DID1026;
  _IOCTL_Data IOCTL_DID1027;
  _IOCTL_Data IOCTL_DID1028;
  _IOCTL_Data IOCTL_DID1029;
  _IOCTL_Data IOCTL_DID102A;
  _IOCTL_Data IOCTL_DID102B;
  _IOCTL_Data IOCTL_DID102C;
  _IOCTL_Data IOCTL_DID1030;
  _IOCTL_Data IOCTL_DID1031;
  _IOCTL_Data IOCTL_DID1032;
  _IOCTL_Data IOCTL_DID1033;
  _IOCTL_Data IOCTL_DID1034;
  _IOCTL_Data IOCTL_DID1035;
  _IOCTL_Data IOCTL_DID1045;
  _IOCTL_Data IOCTL_DID1046;  
  _IOCTL_Data IOCTL_DID1047; 
  _IOCTL_Data IOCTL_DID1048;  
        
  _Power       Power;

DIAG_2E_DATA   Diag2eData;//2EϢ
volatile       INT32U                JACseed[2];
volatile       INT32U                ECUNum[4];
volatile       INT32U                ECUNum2[4];
volatile       _DiagnoCtl            DiagnoCtl;//ϵǰ״̬
volatile       _N_USData             Exct_USData;//ĽյID
volatile       INT32U                Seed;
volatile       _DiagClock            DiagClock;
volatile       _ErrorFrame           Error; //Ϣ
volatile       _DiagFlag             DiagFlag;
volatile       INT32U                CrcCheckSum;
volatile       _SID_27_INFO          sid_27_Info;
volatile       _DownInfo             DownInfo;
volatile       INT8U                 eraseRoutine;
volatile       _19_6RetRecord        D19_6RetRecord;
INT8U NormalCanSt = 0;
INT8U NMCanSt = 0;
/*-------------------------------------------------------------------------
* Function Name  : DiagnosisInit_main
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void DiagnosisInit_main(void)
{
    INT8U i;
    N_US_R_MultiData.ind.N_Result = STATE0;
    N_US_S_MultiData.ind.N_Result = STATE0;
    N_USSFData[0].ind.N_Result = STATE0;
    N_USSFData[1].ind.N_Result = STATE0;
    Exct_USData.ind.N_Result = STATE0;
    N_RSPData.ind.N_Result = STATE0;
    LinkDataBuf[0].TransferStatus = empoty;
    LinkDataBuf[1].TransferStatus = empoty;
    
    //IO Clear
    (void)memset(&DIDFlag, 0, sizeof(DIDFlag)); 

    DiagnoCtl.SubFunction = Disable;
    DiagnoCtl.CommCtl = SubEnableRxAndTx;
    DiagnoCtl.SessionType = DefSession;
    DiagnoCtl.AccessLock = Lock;
    DiagnoCtl.N_REV_MAX_BS = MaxBuff / 8;
    DiagnoCtl.N_STmin = 20;
    DiagnoCtl.DTCSettingType = DtcSetOn;
    DiagnoCtl.tDiagStart = 0;
    DiagnoCtl.DTCByStatusMask = 0x09; //0x08ȷϵϹϴ
                                      //0x01ʧ
    
    g_canClock.BusOffTime    = null;
    g_canClock.CanKeepTime   = null;
    g_canClock.CanDataCn     = null;
    
    Error.FrameErr = Disable;
    
    TP_SetSTminTimer(DiagnoCtl.N_STmin, (_DiagClock *)&DiagClock);
    
    eraseRoutine = 0;
    
    for(i = 0; i < MaxDtcNum; i++)
    {
        if(dtc_map_info[ i ].Exist)
        {
            DiagDtc[i].Status.Bits.TestFailedThisOprCyc = 0;        //bit1
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DTCNum
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Load_DTCNum(INT32U *DtcNum, INT8U *data)
{
    *(DtcNum) = data[0];
    *(DtcNum) = *(DtcNum) << 8;
    *(DtcNum) |= data[1];
    *(DtcNum) = *(DtcNum) << 8;
    *(DtcNum) |= data[2];
    //*(DtcNum) = *(DtcNum);
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_DTCAndStatus_Mask                      ж
* Description    :                                      ȡDTC
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_Load_DTCAndStatus_Mask(INT8U mask, INT8U MaskValid)
{
    INT8U  sn = null;
    INT8U  i;
    for(i = 0; i < TotalDTCNum ; i ++)
    {                                                             
                               //09                               //1              //1
        if(((App_CheckDtcStatus(mask, (_DTC *)&DiagDtc[ i ])) || (!MaskValid)) && (dtc_map_info[ i ].Exist))
        {
            DtcAndStatus[ sn ].DTCHighByte = (INT8U)(DiagDtc[ i ].DtcNum.Num >> 16);
            DtcAndStatus[ sn ].DTCMiddleByte = (INT8U)(DiagDtc[ i ].DtcNum.Num >> 8);
            DtcAndStatus[ sn ].DTCLowByte = (INT8U)DiagDtc[ i ].DtcNum.Num;
            DtcAndStatus[ sn ].statusOfDTC = DiagDtc[ i ].Status.Flag & DiagnoCtl.DTCByStatusMask; //08  09
            if(g_curkeyinput == KeyOFF) DtcAndStatus[ sn ].statusOfDTC &= 0x08;
                sn ++;
        }
    }
    return sn;
}
/*-------------------------------------------------------------------------
* Function Name  : Diagnosis_main
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Diagnosis_main(void)
{
    TP_Buffer_handle();
    Seed++;
    if(LinkData.TransferStatus == full)
    {
        TP_ReciveSF_handle();
        TP_ReciveMultiF_handle();
        
        TP_NormalRecFC_handle();
        LinkData.TransferStatus = empoty;
    }
    
    TP_NormalSendFC_Fun();
    
    if(N_USSFData[0].ind.N_Result == N_OK)
    {
        App_CopyRam((INT8U *)&Exct_USData, (INT8U *)&N_USSFData[0], sizeof(_N_USSFData));
        Exct_USData.ind.N_Result = N_OK;
        N_USSFData[0].ind.N_Result = STATE0;
    }
    else if((N_USSFData[1].ind.N_Result == N_OK) && (Exct_USData.ind.N_Result == STATE0))
    {
        App_CopyRam((INT8U *)&Exct_USData, (INT8U *)&N_USSFData[1], sizeof(_N_USSFData));
        Exct_USData.ind.N_Result = N_OK;
        N_USSFData[1].ind.N_Result = STATE0;
    }
    else if((N_US_R_MultiData.ind.N_Result == N_OK) && (Exct_USData.ind.N_Result == STATE0) && \
            (N_US_S_MultiData.ind.N_Result == STATE0))
    {
        App_CopyRam((INT8U *)&Exct_USData, (INT8U *)&N_US_R_MultiData, sizeof(_N_USData));
        N_US_R_MultiData.ind.N_Result = STATE0;
    }
    
    if(N_US_S_Data_FF.ind.N_PCI == FC_WAIT)
    {
        if(TP_BsTimerOver((_DiagClock *)&DiagClock))
        {
            N_US_S_MultiData.ind.N_Result = N_TIMEOUT_Bs;
        }
    }
    
    if(N_US_S_MultiData.ind.N_Result == STATE0)
    {
        DiagClock.TT_BsEnable = Disable;
        N_US_S_Data_FF.ind.N_FC_Num = null;
    }
    
    if(N_US_R_MultiData.ind.N_Result == N_OK)
    {
        N_US_R_Data_FF.ind.pos = null;
        N_US_R_Data_FF.ind.N_PCI = null;
    }
    if((N_US_R_MultiData.ind.N_Result == N_TIMEOUT_Bs) || (N_US_R_MultiData.ind.N_Result == N_WRONG_SN))
    {
        N_US_R_MultiData.ind.N_Result = STATE0;
        N_US_R_Data_FF.ind.pos = null;
        N_US_R_Data_FF.ind.N_PCI = null;
        N_US_R_Data_FF.ind.N_RecSN_L = null;
    }
    
    if((N_US_S_MultiData.ind.N_Result == N_TIMEOUT_Bs) || \
       (N_US_S_MultiData.ind.N_Result == OVFLW) || \
       (N_US_S_MultiData.ind.N_Result == N_INVALID_FS))
    {
        N_US_S_MultiData.ind.N_Result = STATE0;
        N_US_S_Data_FF.ind.N_PCI = null;
        N_US_S_Data_FF.ind.N_SID = null;
        N_US_S_Data_FF.ind.N_BS_CNT = null;
    }
    
    if(App_SessionTimerOver((_DiagClock *)&DiagClock))
    {
        DiagnoCtl.SessionType = DefSession;
        DiagnoCtl.A5_Sequence = null;
        
    }
    if(App_ReUnlockTimerOver((_DiagClock *)&DiagClock))
    {
        DiagnoCtl.AccessCount = 0;
        sid_27_Info.SAFC = DiagnoCtl.AccessCount;
        sid_27_Info.bCheckSun = Api_CreateCRCCheckSum((INT8U *)&sid_27_Info, 14);  //lifeng
        
    }
    if(DiagnoCtl.SessionType == DefSession)
    {
        DiagnoCtl.AccessLock = Lock;
        DiagnoCtl.CommCtl = SubEnableRxAndTx;
        DiagnoCtl.CommType = NOR_NM_Message;
        
        DiagnoCtl.DTCSettingType = DtcSetOn;

        //IO Clear
        (void)memset(&DIDFlag, 0, sizeof(DIDFlag));               
    }
    
    if(Exct_USData.ind.N_Result == N_OK)
    {
        switch(Exct_USData.ind.N_TAtype)
        {
                
            case ID_FunPGN:
                switch(Exct_USData.ind.MsgData[0])
                {
                    case ReqSessionCtlId:
                        App_10_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqECUResetId:
                        App_11_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqClrDiagInfoId:
                        App_14_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqReadDtcId:
                        App_19_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqCommCtlId:
                        App_28_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqReadDataId:
                        App_22_service((_N_USData *)&Exct_USData);
                        break;
                    case RequestTransferExitId:
                        App_37_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqTesterId:
                        App_3E_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqCtlDTCSetId:
                        App_85_service((_N_USData *)&Exct_USData);
                        break;
                    default:
                        Error.N_TAtype = Exct_USData.ind.N_TAtype;
                        Error.FrameErr = ServiceNotSupported;
                        Error.RespSerId = Exct_USData.ind.MsgData[0];
                }
                break;
            case ID_PhyPGN:
                switch(Exct_USData.ind.MsgData[0])
                {
                    case ReqSessionCtlId:
                        App_10_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqECUResetId:
                        App_11_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqClrDiagInfoId:
                        App_14_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqReadDtcId:
                        App_19_service((_N_USData *)&Exct_USData);	//
                        break;
                    case ReqAccessId:
                        App_27_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqCommCtlId:
                        App_28_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqReadDataId:
                        App_22_service((_N_USData *)&Exct_USData);	//
                        break;
                    case ReqInAndOutCtlId:
                        App_2F_service((_N_USData *)&Exct_USData);	//
                        break;
                    case ReqWriteDataId:
                        App_2E_service((_N_USData *)&Exct_USData); //
                        break;
                    case ReqRoutineControlId:
                        App_31_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqDownloadId:
                        App_34_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqMessageId:
                        App_36_service((_N_USData *)&Exct_USData);
                        break;
                    case RequestTransferExitId:
                        App_37_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqTesterId:
                        App_3E_service((_N_USData *)&Exct_USData);
                        break;
                    case ReqCtlDTCSetId:
                        App_85_service((_N_USData *)&Exct_USData);
                        break;
                    default:
                        Error.N_TAtype = ID_PhyPGN;
                        Error.FrameErr = ServiceNotSupported; //֧
                        Error.RespSerId = Exct_USData.ind.MsgData[0];
                }
                break;
            default:
                ;
        }
        Exct_USData.ind.N_Result = STATE0;
    }
    
    TP_TransmitPDU();//Ǳϻظ
    App_11_Reset_handle();
    if (g_bootReg.ProgSel == 0x55)
    {
       // while (1);
        for(;;);
    }
    
}

/*-------------------------------------------------------------------------
* Function Name  : App_10_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_10_service(_N_USData *AppUSData)
{
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    SubFun.SubData = AppUSData->ind.MsgData[1];
    
    if(AppUSData->ind.Length == 0x02)//ֽڳ 2  10 01
    {
        if (DiagnoCtl.SessionType == SubDefSession)//ǰΪĬϻỰģʽ
        {
            if((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubDefSession)//ӹ 01
            {
                DiagnoCtl.AccessLock = Lock;//
                DiagnoCtl.SessionType = DefSession;//Ĭģʽ
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
            }
            else if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubExtSession)//ӹ 03
            {
                DiagnoCtl.AccessLock = Lock;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
                
                App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
            }
            else
            {
                Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ 10 04
            }
        }
        else if (DiagnoCtl.SessionType == SubExtSession)//ǰģʽ
        {
            if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubDefSession)
            {
                DiagnoCtl.AccessLock = Lock;
                DiagnoCtl.SessionType = DefSession;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
            }
            else if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubExtSession)
            {
                DiagnoCtl.AccessLock = Lock;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
                
                App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
            }
            else if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubProgSession)
            {
                DiagnoCtl.AccessLock = Lock;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                    g_bootReg.Checkflag = 0x55;
                    g_bootReg.ProgSel = 0x55;
                    g_bootReg.SessionType = ProgSession;
                    g_bootReg.bCheckSun = Api_CreateCRCCheckSum((INT8U *) &g_bootReg, 14);
                    if (D_P_FLASH_Erase_Sector(0, DFLASH_APPvAddress) != Ok)
                    {
                        Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
                    }
                    else
                    {
                        INT8U i;
                        for (i = 0; i < 16; i += 2)
                        {
                            (void)D_P_FLASH_Program(0, DFLASH_APPvAddress + i, (INT16U *)((INT8U *)&g_bootReg + i), 1);
                        }
                    }
                    DiagnoCtl.SubFunction = ProgramReset;
                }
                
                App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
            }
            else
            {
                Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
            }
        }
        else if (DiagnoCtl.SessionType == SubProgSession) //ǰΪչģʽ
        {
            if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubDefSession)
            {
                DiagnoCtl.AccessLock = Lock;
                DiagnoCtl.SessionType = DefSession;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
                DiagnoCtl.SubFunction = ProgramReset;
            }
            else if ((SubFun.SubBits.SubFunBit0_6 & 0xf) == SubProgSession)
            {
                DiagnoCtl.AccessLock = Lock;
                if(DiagnoCtl.SessionType != SubFun.SubBits.SubFunBit0_6)
                {
                    DiagnoCtl.SessionType = SubFun.SubBits.SubFunBit0_6;
                    DiagnoCtl.A5_Sequence = null;
                }
                
                App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
            }
            else
            {
                Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
            }
        }
        
    }
    else
    {
        Error.FrameErr = ErrFormatLength; //Ȳ
    }
    
    //ʽȷȷ      ͷ + 50 01 00 32 01 F4
    if(Error.FrameErr == Disable)
    {
        if(!SubFun.SubBits.SubFunBit7_7)//ӹ 7λΪ0
        {
            N_RSPData.ind.len = 7; //7ֽ
            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;  //ͷ
            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;//50
            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;//01
            N_RSPData.ind.MsgData[3] = 0x00;
            N_RSPData.ind.MsgData[4] = 0x32;
            N_RSPData.ind.MsgData[5] = 0x01;
            N_RSPData.ind.MsgData[6] = 0xF4;
            
            N_RSPData.ind.N_Result = N_OK; //ȷ
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_11_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_11_service(_N_USData *AppUSData)
{
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if((DiagnoCtl.SessionType == ExtSession) || \
       (DiagnoCtl.SessionType == ProgSession))
    {
        if(AppUSData->ind.Length > 1)
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];
            switch(SubFun.SubBits.SubFunBit0_6)
            {
                case SubHardReset: //11 01
                    if(AppUSData->ind.Length == 0x02)
                    {
                        DiagnoCtl.SubFunction = SubHardReset;
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength; //Ȳ
                    }
                    break;
                case SubKeyOffOnReset: //11 02
                    if(AppUSData->ind.Length == 0x02)
                    {
                        DiagnoCtl.SubFunction = SubKeyOffOnReset;
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;//Ȳ
                    }
                    break;
                case SubSoftReset: //11 03
                    if(AppUSData->ind.Length == 0x02)
                    {
                        DiagnoCtl.SubFunction = SubSoftReset;
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength; //Ȳ
                    }
                    break;
                default:
                    Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength;//Ȳ
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    if(Error.FrameErr == Disable)
    {
        if(! SubFun.SubBits.SubFunBit7_7)
        {
            N_RSPData.ind.len = 3;
            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
            N_RSPData.ind.N_Result = N_OK;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_85_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_85_service(_N_USData *AppUSData)
{
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(DiagnoCtl.SessionType == ExtSession)
    {
        if(AppUSData->ind.Length > 1)
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];
            
            switch(SubFun.SubBits.SubFunBit0_6)
            {
                case DtcSetOn:
                    if(AppUSData->ind.Length == 0x02)
                    {
                        DiagnoCtl.DTCSettingType = SubFun.SubBits.SubFunBit0_6;
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;//Ȳ
                    }
                    break;
                case DtcSetOff:
                    if(AppUSData->ind.Length == 0x02)
                    {
                        DiagnoCtl.DTCSettingType = SubFun.SubBits.SubFunBit0_6;
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength; //Ȳ
                    }
                    
                    break;
                default:
                    Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength;//Ȳ
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    if(Error.FrameErr == Disable)
    {
        if(!SubFun.SubBits.SubFunBit7_7)
        {
            N_RSPData.ind.len = 3;
            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
            N_RSPData.ind.N_Result = N_OK;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_27_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_27_service(_N_USData *AppUSData)
{
    INT8U i;
    INT16U ret;
    INT8U EcuNum[4];
    _SubFun SubFun;
    EcuNum[0] = 0x11;
    EcuNum[1] = 0x22;
    EcuNum[2] = 0x33;
    EcuNum[3] = 0x44;
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if((DiagnoCtl.SessionType == ProgSession) || (DiagnoCtl.SessionType == SubExtSession))
    {
        if(AppUSData->ind.Length > 0x01)
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];
            switch(SubFun.SubBits.SubFunBit0_6)
            {
                case SubReqSeed1: //27 01
                case SubReqSeed5: //27 05
                    if(AppUSData->ind.Length == 0x02)
                    {
                        JACseed[0] = Seed;        //v[0]
                        JACseed[1] = ~JACseed[0]; //v[1]
                        if(!SubFun.SubBits.SubFunBit7_7)
                        {
                            N_RSPData.ind.len = 7;
                            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;            //06
                            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40; //67
                            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;      //01
                            if((DiagnoCtl.AccessLock == UnLockLv1) || (DiagnoCtl.AccessLock == UnLockLv4))
                            {
                                N_RSPData.ind.MsgData[3] = 0; //Ѿظ0
                                N_RSPData.ind.MsgData[4] = 0;
                                N_RSPData.ind.MsgData[5] = 0;
                                N_RSPData.ind.MsgData[6] = 0;
                                
                            }
                            else
                            {
                                N_RSPData.ind.MsgData[3] = (INT8U)(JACseed[0]>>24); //ظ
                                N_RSPData.ind.MsgData[4] = (INT8U)(JACseed[0]>>16);
                                N_RSPData.ind.MsgData[5] = (INT8U)(JACseed[0]>>8);
                                N_RSPData.ind.MsgData[6] = (INT8U)(JACseed[0]);
                            }
                            N_RSPData.ind.N_Result = N_OK;
                        }
                        if(SubFun.SubBits.SubFunBit0_6==SubReqSeed5)//27 _05
                        {
                            for(i=0;i<3;i++)
                           {
                            
                           if(EcuNum[0] & 1)  EcuNum[0] = (EcuNum[0]>>1) + 0x80;
                           else EcuNum[0] = EcuNum[0]>>1;
                           //
                           if(EcuNum[1] & 1)  EcuNum[1] = (EcuNum[1]>>1) + 0x80;
                           else EcuNum[1] = EcuNum[1]>>1;
                           //
                           if(EcuNum[2] & 1)  EcuNum[2] = (EcuNum[2]>>1) + 0x80;
                           else EcuNum[2] = EcuNum[2]>>1;
                           //
                           if(EcuNum[3] & 1)  EcuNum[3] = (EcuNum[3]>>1) + 0x80;
                           else EcuNum[3] = EcuNum[3]>>1;
                            
                           }
                            
                            ECUNum2[0]=(INT32U)EcuNum[0];
                            ECUNum2[1]=(INT32U)EcuNum[1];
                            ECUNum2[2]=(INT32U)EcuNum[2];
                            ECUNum2[3]=(INT32U)EcuNum[3];
                            encipher(2, JACseed,ECUNum2); //ȫ㷨
                            //
                            Key2[0] = (INT8U)(JACseed[0]>>24);//Կ
                            Key2[1] = (INT8U)(JACseed[0]>>16);
                            Key2[2] = (INT8U)(JACseed[0]>>8);
                            Key2[3] = (INT8U)(JACseed[0]);
                        }
                        if(SubFun.SubBits.SubFunBit0_6==SubReqSeed1)//27 _01
                        {
                            
                            encipher(2, JACseed,ECUNum);//ȫ㷨
                            Key1[0] = (INT8U)(JACseed[0]>>24);//Կ
                            Key1[1] = (INT8U)(JACseed[0]>>16);
                            Key1[2] = (INT8U)(JACseed[0]>>8);
                            Key1[3] = (INT8U)(JACseed[0]);
                        }
                        
                        
                        DiagnoCtl.w27_Sequence = SubFun.SubBits.SubFunBit0_6;
                        
                        if(DiagClock.TT_UnlockEnable)
                        {
                            N_RSPData.ind.len = 4;
                            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                            N_RSPData.ind.MsgData[1] = NegativeId;
                            N_RSPData.ind.MsgData[2] = AppUSData->ind.MsgData[0];
                            N_RSPData.ind.MsgData[3] = ReqTimeDelayNotExpired;
                            N_RSPData.ind.N_Result = N_OK;
                        }
                        
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;//Ȳ
                    }
                    break;
                case SubSendKey2: //27 02 
                case SubSendKey6: //27 06 
                    if(((DiagnoCtl.w27_Sequence == SubReqSeed1) && (SubFun.SubBits.SubFunBit0_6 == SubSendKey2)) ||
                       ((DiagnoCtl.w27_Sequence == SubReqSeed3) && (SubFun.SubBits.SubFunBit0_6 == SubSendKey4)) ||
                       ((DiagnoCtl.w27_Sequence == SubReqSeed5) && (SubFun.SubBits.SubFunBit0_6 == SubSendKey6)) ||
                       ((DiagnoCtl.w27_Sequence == SubReqSeed7) && (SubFun.SubBits.SubFunBit0_6 == SubSendKey8)))
                    {
                        DiagnoCtl.w27_Sequence = SubFun.SubBits.SubFunBit0_6;
                        if(!DiagClock.TT_UnlockEnable)
                        {
                            if(AppUSData->ind.Length == 0x06)
                            {
                                if(DiagnoCtl.AccessCount < 5)
                                {
                                    DiagnoCtl.AccessCount ++;
                                }
                                if (SubFun.SubBits.SubFunBit0_6 == SubSendKey2)
                                {
                                    ret = memcmp(&AppUSData->ind.MsgData[2], Key1, 4);
                                }
                                
                                if (SubFun.SubBits.SubFunBit0_6 == SubSendKey6)
                                {
                                    ret = memcmp(&AppUSData->ind.MsgData[2], Key2, 4);
                                }
                                /*if (SubFun.SubBits.SubFunBit0_6 == SubSendKey8)
                                {
                                    ret = memcmp(&AppUSData->ind.MsgData[2], Key4, 16);
                                }  */
                                if(ret == 0)
                                {
                                    if(!SubFun.SubBits.SubFunBit7_7)
                                    {
                                        N_RSPData.ind.len = 3;
                                        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                                        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
                                        N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
                                        N_RSPData.ind.N_Result = N_OK;
                                    }
                                    if(DiagnoCtl.AccessCount <= 3)
                                    {
                                        if (SubFun.SubBits.SubFunBit0_6 == SubSendKey2)//27 _02
                                        {
                                            DiagnoCtl.AccessLock = UnLockLv1;//
                                        }
                                        
                                        else if (SubFun.SubBits.SubFunBit0_6 == SubSendKey6)//27 _06
                                        {
                                            DiagnoCtl.AccessLock = UnLockLv4; //
                                        }
                                        /* else if (SubFun.SubBits.SubFunBit0_6 == SubSendKey8)
                                        {
                                            DiagnoCtl.AccessLock = UnLockLv4;
                                        }*/
                                        
                                        DiagnoCtl.AccessCount = null;
                                        
                                        
                                        sid_27_Info.Checkflag = 0x55;
                                        sid_27_Info.SAFC = null;
                                        sid_27_Info.bCheckSun = Api_CreateCRCCheckSum((INT8U *)&sid_27_Info, 14);     //lifeng
                                        //     bsp_IIC_WritePage(0xAE,EE_27_ADDR,(INT8U*)&sid_27_Info,sizeof(_SID_27_INFO));    //lifeng
                                    }
                                }
                            }
                            else
                            {
                                Error.FrameErr = ErrFormatLength;
                            }
                        }
                    }
                    else
                    {
                        Error.FrameErr = ReqSequenceError;
                    }
                    break;
                default:
                    Error.FrameErr = SubFunctionNotSupported;//ӹ֧ܲ
            }
            
            if(Error.FrameErr == Disable)
            {
                if((DiagnoCtl.w27_Sequence == SubSendKey2) || (DiagnoCtl.w27_Sequence == SubSendKey6) )
                {
                    DiagnoCtl.w27_Sequence = Disable;
                    
                    if((DiagnoCtl.AccessLock != UnLockLv1) && (DiagnoCtl.AccessLock != UnLockLv4) )
                    {
                        if(DiagnoCtl.AccessCount <= 1)
                        {
                            N_RSPData.ind.len = 4;
                            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                            N_RSPData.ind.MsgData[1] = NegativeId;
                            N_RSPData.ind.MsgData[2] = AppUSData->ind.MsgData[0];
                            N_RSPData.ind.MsgData[3] = InvalidKey; //Կ
                            N_RSPData.ind.N_Result = N_OK;
                        }
                        if(DiagnoCtl.AccessCount >= 2)
                        {
                            N_RSPData.ind.len = 4;
                            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                            N_RSPData.ind.MsgData[1] = NegativeId;
                            N_RSPData.ind.MsgData[2] = AppUSData->ind.MsgData[0];
                            N_RSPData.ind.MsgData[3] = ExceedNumberOfAttempts;
                            N_RSPData.ind.N_Result = N_OK;
                            
                            if(!DiagClock.TT_UnlockEnable)
                            {
                                App_SetReUnlockTimer(N_Unlock, (_DiagClock *)&DiagClock);
                            }
                        }
                        sid_27_Info.Checkflag = 0x55;
                        sid_27_Info.SAFC = DiagnoCtl.AccessCount;
                        sid_27_Info.bCheckSun = Api_CreateCRCCheckSum((INT8U *)&sid_27_Info, 14);    //lifeng
                        //		bsp_IIC_WritePage(0xAE,EE_27_ADDR,(INT8U*)&sid_27_Info,sizeof(_SID_27_INFO));   //lifeng
                    }
                }
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength; //Ȳ
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession; //˻Ựֹ֧
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_31_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_31_service(_N_USData *AppUSData)
{
    INT8U  ret = 0;
    INT8U  data = 1;
    INT16U DID;
    INT32U wTemp = 0;
    
    
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if ((DiagnoCtl.SessionType == ProgSession) || (DiagnoCtl.SessionType == SubExtSession))
    {
        if(AppUSData->ind.Length > 0x01)
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];
            switch(SubFun.SubBits.SubFunBit0_6)
            {
                case 1://startRoutine
                    if(AppUSData->ind.Length >= 4)
                    {
                        App_Load_DID((INT16U *)&DID, (INT8U *)&AppUSData->ind.MsgData[2]);
                        if ((DiagnoCtl.AccessLock == UnLockLv1) || (DiagnoCtl.AccessLock == UnLockLv4))
                        {
                            
                            if (DID == 0xFF00)  	//eraseMemory
                            {
                                if(AppUSData->ind.Length == 13)
                                {
                                    if (AppUSData->ind.MsgData[4] == 0x44)
                                    {
                                        eraseRoutine = 1;
                                        DownInfo.memoryAddress = AppUSData->ind.MsgData[5];
                                        DownInfo.memoryAddress <<= 8;
                                        DownInfo.memoryAddress |= AppUSData->ind.MsgData[6];
                                        DownInfo.memoryAddress <<= 8;
                                        DownInfo.memoryAddress |= AppUSData->ind.MsgData[7];
                                        DownInfo.memoryAddress <<= 8;
                                        DownInfo.memoryAddress |= AppUSData->ind.MsgData[8];
                                        
                                        DownInfo.memorySize = AppUSData->ind.MsgData[9];
                                        DownInfo.memorySize <<= 8;
                                        DownInfo.memorySize |= AppUSData->ind.MsgData[10];
                                        DownInfo.memorySize <<= 8;
                                        DownInfo.memorySize |= AppUSData->ind.MsgData[11];
                                        DownInfo.memorySize <<= 8;
                                        DownInfo.memorySize |= AppUSData->ind.MsgData[12];
                                        // ret = App_EraseRoutine_handle();
                                        DownInfo.RecCount = 0;
                                        DownInfo.memoryAddress = 0;
                                        CrcCheckSum = 0xFFFFFFFF;
                                        if(ret)
                                        {
                                            data = 0;
                                        }
                                        g_bootReg.Checkflag = 0x55;
                                        g_bootReg.ProgSel = 0x55;
                                        g_bootReg.SessionType = DefSession;
                                        g_bootReg.bCheckSun = Api_CreateCRCCheckSum((INT8U *) &g_bootReg, 14);
                                        if (D_P_FLASH_Erase_Sector(0, DFLASH_APPvAddress) != Ok)
                                        {
                                            Error.FrameErr = FlashEraseFailed;
                                        }
                                        else
                                        {
                                            INT8U i;
                                            for (i = 0; i < 16; i += 2)
                                            {
                                                (void)D_P_FLASH_Program(0, DFLASH_APPvAddress + i, (INT16U *)((INT8U *)&g_bootReg + i), 1);
                                            }
                                            
                                            data = 0;
                                        }
                                        
                                    }
                                    else
                                    {
                                        Error.FrameErr = RequestOutOfRange;
                                    }
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength; //Ȳ
                                }
                            }
                            
                            else if (DID == 0xFF01)  		//checkProgrammingDependencies
                            {
                                if(AppUSData->ind.Length == 4)
                                {
                                    g_bootReg.Checkflag = 0x55;
                                    g_bootReg.ProgSel = 0x66;
                                    g_bootReg.SessionType = DefSession;
                                    g_bootReg.bCheckSun = Api_CreateCRCCheckSum((INT8U *) &g_bootReg, 14);
                                    if (D_P_FLASH_Erase_Sector(0, DFLASH_APPvAddress) != Ok)
                                    {
                                        Error.FrameErr = FlashEraseFailed;
                                    }
                                    else
                                    {
                                        INT8U i;
                                        for (i = 0; i < 16; i += 2)
                                        {
                                            (void)D_P_FLASH_Program(0, DFLASH_APPvAddress + i, (INT16U *)((INT8U *)&g_bootReg + i), 1);
                                        }
                                        
                                        data = 0;
                                    }
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;//Ȳ
                                }
                            }
                            else
                            {
                                Error.FrameErr = RequestOutOfRange;
                            }
                        }
                        else
                        {
                            Error.FrameErr = SecurityAccessDenied;
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;//Ȳ
                    }
                    break;
                case 2://stopRoutine
                    if(AppUSData->ind.Length == 4)
                    {
                        App_Load_DID((INT16U *)&DID, (INT8U *)&AppUSData->ind.MsgData[2]);
                        if ((DiagnoCtl.AccessLock == UnLockLv1)  || (DiagnoCtl.AccessLock == UnLockLv4))
                        {
                            
                            if(DID == 0xFF00)
                            {
                                if(eraseRoutine == 0)
                                {
                                    Error.FrameErr = ReqSequenceError;
                                }
                                else
                                {
                                    eraseRoutine = 0;
                                }
                            }
                            
                            else
                            {
                                Error.FrameErr = RequestOutOfRange;
                            }
                            
                        }
                        else
                        {
                            Error.FrameErr = SecurityAccessDenied;
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;//Ȳ
                    }
                    break;
                case 3://requestRoutineResults
                    if ((DiagnoCtl.AccessLock == UnLockLv1) || (DiagnoCtl.AccessLock == UnLockLv4))
                    {
                        
                        //  data = 1;
                        
                        
                    }
                    break;
                default:
                    ;
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength; //Ȳ
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    
    if(Error.FrameErr == Disable)
    {
        if(! SubFun.SubBits.SubFunBit7_7)
        {
            N_RSPData.ind.len = 5;
            if (DID == 0x0203)
                N_RSPData.ind.len = 8;
            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
            N_RSPData.ind.MsgData[3] = (INT8U)(DID >> 8);
            N_RSPData.ind.MsgData[4] = (INT8U)DID;
            N_RSPData.ind.MsgData[5] = data;
            N_RSPData.ind.MsgData[6] = 0;
            N_RSPData.ind.MsgData[7] = 0;
            N_RSPData.ind.MsgData[8] = 0;
            //N_RSPData.ind.N_Result = N_OK;
            
            (void)memcpy((INT8U *)N_US_S_MultiData.ind.MsgData, N_RSPData.ind.MsgData + 1, N_RSPData.ind.len);
            if(N_RSPData.ind.len >= 8)
            {
                N_US_S_Data_FF.ind.Length = N_RSPData.ind.len;
                N_US_S_Data_FF.ind.N_PCI = FirstFrame;
            }
            else
            {
                N_US_S_MultiData.ind.Length = N_RSPData.ind.len;
                N_US_S_Data_FF.ind.N_PCI = null;
            }
            N_US_S_MultiData.ind.N_Result = N_OK;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_34_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_34_service(_N_USData *AppUSData)
{
    INT32U wTemp = 0;
        INT32U diff = 0;
    INT8U  i = 0;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(DiagnoCtl.SessionType == ProgSession)
    {
        if(DiagnoCtl.AccessLock == UnLockLv4)
        {
            if(AppUSData->ind.Length == 11)
            {
            }
            else
            {
                Error.FrameErr = ErrFormatLength;//Ȳ
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    if(DiagnoCtl.AccessLock == UnLockLv4)
    {
        if(Error.FrameErr == Disable)
        {
            N_RSPData.ind.len = 5;
            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
            N_RSPData.ind.MsgData[2] = 0x20;
            N_RSPData.ind.MsgData[3] = 0x00;
            N_RSPData.ind.MsgData[4] = 128;
            
            N_RSPData.ind.N_Result = N_OK;
            
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_36_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_36_service(_N_USData *AppUSData)
{
    INT16U i = 0;
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(DiagnoCtl.SessionType == ProgSession)
    {
        if(DiagnoCtl.AccessLock == UnLockLv4)
        {
            if((AppUSData->ind.Length > 2) && (AppUSData->ind.Length <= 1024))
            {
                
            }
            else
            {
                Error.FrameErr = ErrFormatLength; //Ȳ
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    
    
    if(Error.FrameErr == Disable)
    {
        N_RSPData.ind.len = 3;
        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
        N_RSPData.ind.MsgData[2] = AppUSData->ind.MsgData[1];
        
        N_RSPData.ind.N_Result = N_OK;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_37_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_37_service(_N_USData *AppUSData)
{
    App_ErrorInfoInit((_N_USData *)AppUSData);
    if(DiagnoCtl.SessionType == ProgSession)
    {
        if(DiagnoCtl.AccessLock == UnLockLv4)
        {
            if(AppUSData->ind.Length == 1)
            {
            }
            else
            {
                Error.FrameErr = ErrFormatLength;//Ȳ
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    
    if(Error.FrameErr == Disable)
    {
        N_RSPData.ind.len = 2;
        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
        
        N_RSPData.ind.N_Result = N_OK;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_28_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_28_service(_N_USData *AppUSData)
{
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(DiagnoCtl.SessionType == ExtSession)
    {
        if(AppUSData->ind.Length > 1)
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];
            switch(SubFun.SubBits.SubFunBit0_6) //ӹж
            {
                    /*case SubEnableRxAndDisTx:
                    if(AppUSData->ind.Length == 0x03)
                    {
                        if (AppUSData->ind.MsgData[2] == NOR_Message)
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndDisTx;
                            DiagnoCtl.CommType = NOR_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NM_Message)
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndDisTx;
                            DiagnoCtl.CommType = NM_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NOR_NM_Message)
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndDisTx;
                            DiagnoCtl.CommType = NOR_NM_Message;
                        }
                        else
                        {
                            Error.FrameErr  = RequestOutOfRange;
                        }
                    }
                    else
                    {
                        Error.FrameErr  = RequestOutOfRange;
                    }
                    break;
                case SubDisableRxAndEnTx:
                    if(AppUSData->ind.Length == 0x03)
                    {
                        if (AppUSData->ind.MsgData[2] == NOR_Message)
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndEnTx;
                            DiagnoCtl.CommType = NOR_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NM_Message)
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndEnTx;
                            DiagnoCtl.CommType = NM_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NOR_NM_Message)
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndEnTx;
                            DiagnoCtl.CommType = NOR_NM_Message;
                        }
                        else
                        {
                            Error.FrameErr  = RequestOutOfRange;
                        }
                    }
                    else
                    {
                        Error.FrameErr  = RequestOutOfRange;
                    }
                    break;*/
                case SubEnableRxAndTx://28 00
                    if(AppUSData->ind.Length == 0x03)//Ϊ3
                    {
                        if (AppUSData->ind.MsgData[2] == NOR_Message)//28 00 01 Ӧñ
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndTx;//ʹܽշ
                            DiagnoCtl.CommType = NOR_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NM_Message)//28 00 02 
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndTx;//ʹܽշ
                            DiagnoCtl.CommType = NM_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NOR_NM_Message)//28 00 03 Ӧú
                        {
                            DiagnoCtl.CommCtl = SubEnableRxAndTx;//ʹܽշ
                            DiagnoCtl.CommType = NOR_NM_Message;
                        }
                        else
                        {
                            Error.FrameErr  = RequestOutOfRange;//Χ
                        }
                    }
                    else
                    {
                        Error.FrameErr  = RequestOutOfRange; //Χ
                    }
                    break;
                case SubDisableRxAndTx://28 03
                    if(AppUSData->ind.Length == 0x03)
                    {
                        if (AppUSData->ind.MsgData[2] == NOR_Message)//28 03 01  Ӧñ
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndTx;//ر
                            DiagnoCtl.CommType = NOR_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NM_Message)//28 03 02 
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndTx;//ر
                            DiagnoCtl.CommType = NM_Message;
                        }
                        else if (AppUSData->ind.MsgData[2] == NOR_NM_Message)//28 03 03 Ӧú
                        {
                            DiagnoCtl.CommCtl = SubDisableRxAndTx;//ر
                            DiagnoCtl.CommType = NOR_NM_Message;
                        }
                        else
                        {
                            Error.FrameErr  = RequestOutOfRange;
                        }
                    }
                    else
                    {
                        Error.FrameErr  = RequestOutOfRange;
                    }
                    break;
                default:
                    Error.FrameErr = SubFunctionNotSupported; //ӹ֧ܲ
            }
        }
        else
        {
            Error.FrameErr  = ErrFormatLength; //Ȳ
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    if(Error.FrameErr == Disable)
    {
        N_RSPData.ind.len = 3;
        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
        N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
        
        
        N_RSPData.ind.N_Result = N_OK;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_22_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_22_service(_N_USData *AppUSData)
{
    INT16U   DID_Num;
    INT16U  MsgLen = null;
    INT16U  DID[20];
    INT32U  i;
    INT8U   wTemp[64];
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    //if(1/*(DiagnoCtl.SessionType == DefSession)||(DiagnoCtl.SessionType == ExtSession)*/)
    {
        if(((AppUSData->ind.Length - 1) % 2 == null) && (AppUSData->ind.Length > 2))
        {
            DID_Num = (AppUSData->ind.Length - 1) / 2;
            if(DID_Num < 20)
            {
                N_US_S_MultiData.ind.MsgData[MsgLen] = AppUSData->ind.MsgData[0] + 0x40;
                MsgLen = 1;//1λΪͷ,busmasterʾ
                
                for(i = 0; i < DID_Num; i++)
                {
                    //ȡDID
                    App_Load_DID((INT16U *)&DID[i], (INT8U *)&AppUSData->ind.MsgData[i * 2 + 1]);
                    N_US_S_MultiData.ind.MsgData[MsgLen] = DID[i] >> 8;      //DID
                    N_US_S_MultiData.ind.MsgData[MsgLen + 1] = (INT8U)DID[i];
                    MsgLen += 2;
                    
                    wTemp[0] = 0;
                    wTemp[1] = 0;
                    wTemp[2] = 0;
                    wTemp[3] = 0;
                    
                    switch(DID[i])
                    {
                        case DIDF186: //-ǰỰģʽ
                            wTemp[0] = DiagnoCtl.SessionType;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 1);
                            MsgLen += 1;
                            break;  
                        case DIDF187: //
                            wTemp[0] = 'M';
                            wTemp[1] = 'N';
                            wTemp[2] = '1';
                            wTemp[3] = '2';
                            wTemp[4] = '3';
                            wTemp[5] = '4';
                            wTemp[6] = '5';
                            wTemp[7] = '6';
                            wTemp[8] = '7';
                            wTemp[9] = '8';
                            wTemp[10] = '9';
                            wTemp[11] = '0';
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 12);
                            MsgLen += 12;
                            break; 
                        case DIDF18A: //-Ӧ̱ʶ [3 Byte ASCII+2 Byte BCD]
                            wTemp[0] = 'L';
                            wTemp[1] = '3';
                            wTemp[2] = '2';
                            wTemp[3] = 0x08;
                            wTemp[4] = 0x05;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 5);
                            MsgLen += 5;
                            break;  
                        case DIDF18B: //-ECU
                            wTemp[0] = 0x20;
                            wTemp[1] = 0x19;
                            wTemp[2] = 0x01;
                            wTemp[3] = 0x14;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 4);
                            MsgLen += 4;
                            break;      
                        case DIDF18C: //-ECUˮ
                            wTemp[0] = 0x00;
                            wTemp[1] = 0x00;
                            wTemp[2] = 0x00;
                            wTemp[3] = 0x00;
                            wTemp[4] = 0x00;
                            wTemp[5] = 0x00;
                            wTemp[6] = 0x00;
                            wTemp[7] = 0x00;
                            wTemp[8] = 0x00;
                            wTemp[9] = 0x00;
                            wTemp[10] = 0x00;
                            wTemp[11] = 0x00;
                            wTemp[12] = 0x00;                        
                            wTemp[13] = 0x11;
                            wTemp[14] = 0x22;
                            wTemp[15] = 0x33;
                            wTemp[16] = 0x44;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 17);
                            MsgLen += 17;
                            break;                                                                                                                                 
                        case DIDF190://-ʶ
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&Diag2eData.D_F190[0], 17);
                            MsgLen += 17;
                            break;
                        case DIDF192://ӦECUӲ
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&Diag2eData.D_F192[0], 11);
                            MsgLen += 11;
                            break;                            
                        case DIDF193://-Ӳ汾
                            wTemp[0] = 0x01;
                            wTemp[1] = 0x00;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 2);
                            MsgLen += 2;
                            break;
                        case DIDF194: //-
                            wTemp[0] = 0x00;
                            wTemp[1] = 0x00;
                            wTemp[2] = 0x01;
                            wTemp[3] = 0x00;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 4);
                            MsgLen += 4;
                            break;
                        case DIDF195: //-汾
                            wTemp[0] = 0x01;
                            wTemp[1] = 0x00;
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 2);
                            MsgLen += 2;
                            break;
                        case DIDF19D: //-
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&Diag2eData.D_F19D[0], 4);
                            MsgLen += 4;
                            break;                                                       
                        case DIDF1A8://-Ϣ
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&Diag2eData.D_F1A8[0], 20);
                            MsgLen += 20;
                            break; 
                        case DID5000://-ܼ
                            wTemp[0] = (INT8U)((g_accKm.LongAccKm/10) >>24);
                            wTemp[1] = (INT8U)((g_accKm.LongAccKm/10) >>16);
                            wTemp[2] = (INT8U)((g_accKm.LongAccKm/10) >>8);
                            wTemp[3] = (INT8U)((g_accKm.LongAccKm/10));                         
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&wTemp[0], 4);
                            MsgLen += 4;
                            break;                              
                        case DIDFCAA://-PPK
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[MsgLen], (INT8U *)&Diag2eData.D_FCAA[0], 2);
                            MsgLen += 2;
                            break;   
                        default:
                            MsgLen -= 2;
                    }
                }
            }
            else
            {
                Error.FrameErr  = RequestOutOfRange;
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength; //Ȳ
        }
        
        if(MsgLen == 1)
        {
            Error.FrameErr = RequestOutOfRange;
        }
        
        if(Error.FrameErr == Disable)
        {
            if(MsgLen >= 8)
            {
                N_US_S_Data_FF.ind.Length = MsgLen;
                N_US_S_Data_FF.ind.N_PCI = FirstFrame;
            }
            else
            {
                N_US_S_MultiData.ind.Length = MsgLen;
                N_US_S_Data_FF.ind.N_PCI = null;
            }
            N_US_S_MultiData.ind.N_Result = N_OK;
        }
    }
    //else
    //{
        //    Error.FrameErr = NotSuppInActiveSession;
    //}
}

/*-------------------------------------------------------------------------
* Function Name  : App_2E_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_2E_service(_N_USData *AppUSData)
{
    INT16U    DID;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if((DiagnoCtl.SessionType == ExtSession) || ((DiagnoCtl.SessionType == ProgSession)))
    {
        if((DiagnoCtl.AccessLock == UnLockLv1) ||  (DiagnoCtl.AccessLock == UnLockLv4))
        {
            if(AppUSData->ind.Length > 1)
            {
                App_Load_DID((INT16U *)&DID, (INT8U *)&AppUSData->ind.MsgData[1]);
                switch(DID)
                {
                    case DIDF190: //д-ʶ
                        if(AppUSData->ind.Length  == 20) //2E F1 90 ...17Bytes
                        {
                            Api_CopyRam((INT8U *)&Diag2eData.D_F190[0], (INT8U *)&AppUSData->ind.MsgData[3], 17);
                        }
                        else
                        {
                            Error.FrameErr  = ErrFormatLength; //Ȳ
                        }
                        break;
                    case DIDF192: //д-ӦECUӲ
                        if(AppUSData->ind.Length  == 14) //2E F1 92 ...11Bytes
                        {
                            Api_CopyRam((INT8U *)&Diag2eData.D_F192[0], (INT8U *)&AppUSData->ind.MsgData[3], 11);
                        }
                        else
                        {
                            Error.FrameErr  = ErrFormatLength; //Ȳ
                        }
                        break;                        
                    case DIDF19D://д-װʱ
                        if(AppUSData->ind.Length  == 7)
                        {
                            Api_CopyRam((INT8U *)&Diag2eData.D_F19D[0], (INT8U *)&AppUSData->ind.MsgData[3], 4);
                        }
                        else
                        {
                            Error.FrameErr  = ErrFormatLength;//Ȳ
                        }
                        break;
                    case DIDF1A8://д-
                        if(AppUSData->ind.Length  == 23) //2E F1 90 ...20Bytes
                        {
                         /*   if(((AppUSData->ind.MsgData[DateByte1] & 0xF0) <= 0x30) &&    //0-3
                               ((AppUSData->ind.MsgData[DateByte2] & 0x0F) >= 0x00) &&    //״̬0-C  ԭ1-8
                               ((AppUSData->ind.MsgData[DateByte2] & 0x0F) <= 0x0C) &&
                               ((AppUSData->ind.MsgData[DateByte3] & 0x0E) <= 0x08) &&    //ˮ±0-4
                               ((AppUSData->ind.MsgData[DateByte3] & 0xF0) <= 0x50) &&    //תٺ0-5
                               ((AppUSData->ind.MsgData[DateByte4] & 0x60) != 0x40) &&    //ȼ0 1 3
                               ((AppUSData->ind.MsgData[DateByte5] & 0x03) != 0x03) &&    //(ABS+EBD)/ESC 0-2
                               ((AppUSData->ind.MsgData[DateByte5] & 0x30) != 0x30))      //̥ѹ0-2
                            {
                               Api_CopyRam((INT8U *)&Diag2eData.D_F1A8[0], (INT8U *)&AppUSData->ind.MsgData[3], 20);
                            }
                            else
                            {
                              Error.FrameErr  = RequestOutOfRange;//Χ-Ԥ
                            }
                         */   
                            Api_CopyRam((INT8U *)&Diag2eData.D_F1A8[0], (INT8U *)&AppUSData->ind.MsgData[3], 20);
                        }
                        else
                        {
                            Error.FrameErr  = ErrFormatLength;
                        }
                        break;                       
                    case DIDFCAA://д-PPK
                        if(AppUSData->ind.Length  == 5) //2E FC AA  38 48
                        {
                            Api_CopyRam((INT8U *)&Diag2eData.D_FCAA[0], (INT8U *)&AppUSData->ind.MsgData[3], 2);
                        }
                        else
                        {
                            Error.FrameErr  = ErrFormatLength;
                        }
                        break;
                    default:
                        Error.FrameErr  = RequestOutOfRange;
                }
               
                WriteleFlag2E = Enable;//ʹܴ洢 
            }
            else
            {
                Error.FrameErr = ErrFormatLength;
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
        
        if((DiagnoCtl.AccessLock == UnLockLv1)  || ((DiagnoCtl.AccessLock == UnLockLv4)))
        {
            if(Error.FrameErr == Disable)
            {
                N_RSPData.ind.len = 4;
                N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
                N_RSPData.ind.MsgData[2] = (INT8U)(DID >> 8);
                N_RSPData.ind.MsgData[3] = (INT8U)(DID);
                N_RSPData.ind.N_Result = N_OK;
                
                DiagFlag.FlagBits.DiagWriteEn = Enable;
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_14_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_14_service(_N_USData *AppUSData)
{
    INT8U i;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if((DiagnoCtl.SessionType == DefSession) || (DiagnoCtl.SessionType == ExtSession))
    {
        if(AppUSData->ind.Length > 1)
        {
            if(AppUSData->ind.Length == 0x04)
            {
                if((AppUSData->ind.MsgData[1] == 0xFF) && (AppUSData->ind.MsgData[2] == 0xFF) && (AppUSData->ind.MsgData[3] == 0xFF))
                {
                    for(i = 0; i < 11; i++)   //2021-04-02ⷢĹʹ ֳ)1411
                    {
                        App_DtcInfoInit((_DTC *)&DiagDtc[ i ], dtc_map_info[ i ].DtcNum); //lifeng
                    }
                        // g_Clock.T10msTime = 0;      //lifeng
                    SaveDtcInfo.EE_WriteDtcSel = ClearDTC_EE;
                }
                else
                {
                        Error.FrameErr = RequestOutOfRange;
                }
            }
            else
            {
                Error.FrameErr = ErrFormatLength;
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
    if(Error.FrameErr == Disable)
    {
        N_RSPData.ind.len = 2;
        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
        N_RSPData.ind.N_Result = N_OK;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_19_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_19_service(_N_USData *AppUSData)
{
    INT16U  count;
    INT8U  i;
    //INT32U           DtcNum;
    _SnapShot       *pSnap;
    _SnapShot        SnapEmpoty;
    
    _19_6ReqRecord   D19_6ReqRecord;
    
    _SubFun          SubFun;//ӹ
    
    pSnap = &SnapEmpoty;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if((DiagnoCtl.SessionType == DefSession) || (DiagnoCtl.SessionType == ExtSession))
    {
        if(AppUSData->ind.Length > 1) //ֽڳ3  19 02 0A
        {
            SubFun.SubData = AppUSData->ind.MsgData[1];//ȡӹ 02
            switch(SubFun.SubBits.SubFunBit0_6)
            {
                case RepNumByStatusMask: //1
                    if(AppUSData->ind.Length == 3)
                    {
                        if(!SubFun.SubBits.SubFunBit7_7)
                        {
                            N_RSPData.ind.len = 7;
                            
                            N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                            N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
                            N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
                            N_RSPData.ind.MsgData[3] = DiagnoCtl.DTCByStatusMask;
                            N_RSPData.ind.MsgData[4] = 0x00;
                            
                            count = App_DTCCount_handle(AppUSData->ind.MsgData[2]);
                            N_RSPData.ind.MsgData[5] = (INT8U)(count >> 8);
                            N_RSPData.ind.MsgData[6] = (INT8U)count;
                            N_RSPData.ind.N_Result = N_OK;
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;
                    }
                    break;
                case  RepDTCByStatusMask: //2
                    if(AppUSData->ind.Length == 3)//ֽڳ3  19 02 0A
                    {
                        //0A
                        count = App_Load_DTCAndStatus_Mask(AppUSData->ind.MsgData[2], 1); //lifeng
                        count = count * 4; // *4    9103013-08
                        
                        if(count == null)
                        {
                            if(!SubFun.SubBits.SubFunBit7_7)
                            {
                                N_RSPData.ind.len = 4;
                                
                                N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                                N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
                                N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
                                N_RSPData.ind.MsgData[3] = DiagnoCtl.DTCByStatusMask;
                                N_RSPData.ind.N_Result = N_OK;
                            }
                        }
                        else
                        {
                            if(!SubFun.SubBits.SubFunBit7_7)
                            {
                                N_US_S_MultiData.ind.MsgData[0] = AppUSData->ind.MsgData[0] + 0x40;
                                N_US_S_MultiData.ind.MsgData[1] = SubFun.SubBits.SubFunBit0_6;
                                
                                N_US_S_MultiData.ind.MsgData[2] = DiagnoCtl.DTCByStatusMask;
                                
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[3], (INT8U *)&DtcAndStatus[0], (INT8U)count);
                                
                                N_US_S_Data_FF.ind.Length = count + 3;
                                N_US_S_Data_FF.ind.N_PCI = FirstFrame;
                                N_US_S_MultiData.ind.N_Result = N_OK;
                            }
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;
                    }
                    break;
                    /*case RepSnapRecordDTCNum: // 4
                    if(AppUSData->ind.Length == 6)
                    {
                        App_Load_DTCNum((INT32U *)&DtcNum, (INT8U *)&AppUSData->ind.MsgData[2]);  //lifeng
                            
                        for(i = 0; i < 12; i++)
                        {
                            if((DtcNum == DiagDtc[ i ].DtcNum.Num) && (dtc_map_info[ i ].Exist))
                            {
                                Error.FrameErr = Disable;
                                pSnap = App_GetSnap((_SnapShot *)pSnap, DiagDtc, DiagSnap, i);  //lifeng
                                    break;
                            }
                            else
                            {
                                Error.FrameErr = RequestOutOfRange;
                            }
                        }
                        
                        if(AppUSData->ind.MsgData[5] != 0xff)
                        {
                            Error.FrameErr = RequestOutOfRange;
                        }
                        if(Error.FrameErr == Disable)
                        {
                            if(!SubFun.SubBits.SubFunBit7_7)
                            {
                                N_US_S_MultiData.ind.MsgData[0] = AppUSData->ind.MsgData[0] + 0x40;
                                N_US_S_MultiData.ind.MsgData[1] = SubFun.SubBits.SubFunBit0_6;
                                N_US_S_MultiData.ind.MsgData[2] = (INT8U)(pSnap->NumAndStatus >> 24);
                                N_US_S_MultiData.ind.MsgData[3] = (INT8U)(pSnap->NumAndStatus >> 16);
                                N_US_S_MultiData.ind.MsgData[4] = (INT8U)(pSnap->NumAndStatus >> 8);
                                N_US_S_MultiData.ind.MsgData[5] = (INT8U)pSnap->NumAndStatus;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[6], \
                                            (INT8U *)&pSnap->SnapShotNum, sizeof(_SnapShot) - 2);
                                N_US_S_Data_FF.ind.Length = sizeof(_SnapShot);
                                N_US_S_Data_FF.ind.N_PCI = FirstFrame;
                                N_US_S_MultiData.ind.N_Result = N_OK;
                            }
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;
                    }
                    break; */
                case RepExtDataRecordNum:   //6
                    if(AppUSData->ind.Length == 6)
                    {
                        D19_6ReqRecord.DtcNum = AppUSData->ind.MsgData[2];
                        D19_6ReqRecord.DtcNum = D19_6ReqRecord.DtcNum << 8;
                        D19_6ReqRecord.DtcNum |= AppUSData->ind.MsgData[3];
                        D19_6ReqRecord.DtcNum = D19_6ReqRecord.DtcNum << 8;
                        D19_6ReqRecord.DtcNum |= AppUSData->ind.MsgData[4];
                        D19_6ReqRecord.DTCExtDataRecordNum = AppUSData->ind.MsgData[5];
                        
                        for(i = 0; i < 20; i++)
                        {
                            if((D19_6ReqRecord.DtcNum == DiagDtc[ i ].DtcNum.Num) && (dtc_map_info[ i ].Exist))
                            {
                                Error.FrameErr = Disable;
                                App_19_6Load((_19_6RetRecord *)&D19_6RetRecord, (_DTC *)&DiagDtc[ i ], \
                                             (_19_6ReqRecord *)&D19_6ReqRecord);
                                break;
                            }
                            else
                            {
                                Error.FrameErr = RequestOutOfRange;
                            }
                        }
                        
                        if(Error.FrameErr == Disable)
                        {
                            if(!SubFun.SubBits.SubFunBit7_7)
                            {
                                N_US_S_MultiData.ind.MsgData[0] = AppUSData->ind.MsgData[0] + 0x40;
                                N_US_S_MultiData.ind.MsgData[1] = SubFun.SubBits.SubFunBit0_6;
                                N_US_S_MultiData.ind.MsgData[2] = (INT8U)(D19_6RetRecord.NumAndStatus >> 24);
                                N_US_S_MultiData.ind.MsgData[3] = (INT8U)(D19_6RetRecord.NumAndStatus >> 16);
                                N_US_S_MultiData.ind.MsgData[4] = (INT8U)(D19_6RetRecord.NumAndStatus >> 8);
                                N_US_S_MultiData.ind.MsgData[5] = (INT8U)(D19_6RetRecord.NumAndStatus);
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[6], \
                                            (INT8U *)&D19_6RetRecord.Data[0], D19_6RetRecord.dlc);
                                N_US_S_Data_FF.ind.Length = D19_6RetRecord.dlc + 6;
                                N_US_S_Data_FF.ind.N_PCI = FirstFrame;
                                N_US_S_MultiData.ind.N_Result = N_OK;
                            }
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;
                    }
                    break;
                case RepSupportedDTC: //10
                    if(AppUSData->ind.Length == 2)
                    {
                        if(!SubFun.SubBits.SubFunBit7_7)
                        {
                            count = App_Load_DTCAndStatus_Mask(0, 0);
                            
                            N_US_S_MultiData.ind.MsgData[0] = AppUSData->ind.MsgData[0] + 0x40;
                            N_US_S_MultiData.ind.MsgData[1] = SubFun.SubBits.SubFunBit0_6;
                            N_US_S_MultiData.ind.MsgData[2] = DiagnoCtl.DTCByStatusMask;
                            
                            Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[3], (INT8U *)&DtcAndStatus[0], count * 4);
                            N_US_S_Data_FF.ind.Length = count * 4 + 3;
                            N_US_S_Data_FF.ind.N_PCI = FirstFrame;
                            N_US_S_MultiData.ind.N_Result = N_OK;
                        }
                    }
                    else
                    {
                        Error.FrameErr = ErrFormatLength;
                    }
                    break;
                default:
                    Error.FrameErr = SubFunctionNotSupported; //ӹ֧ܲ
            }
        }
        else
        {
            Error.FrameErr = ErrFormatLength;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_2F_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_2F_service(_N_USData *AppUSData)
{
    INT8U     InOutCtrlParameter;
    INT16U    DID;
    INT16U    MsgLen = 4;
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(DiagnoCtl.SessionType == ExtSession) //2F + DID + Ʋ + INfo
    {
        if((DiagnoCtl.AccessLock == UnLockLv1) || (DiagnoCtl.AccessLock == UnLockLv4))//
        {
            if(AppUSData->ind.Length > 1)
            {
                App_Load_DID((INT16U *)&DID, (INT8U *)&AppUSData->ind.MsgData[1]);
                
                InOutCtrlParameter = AppUSData->ind.MsgData[3]; //2F 10 01 _03..+ 1byte

                if(Error.FrameErr == Disable)
                {
                    switch(DID)
                    {
                        case DIDD001: //ٱ
                            if(InOutCtrlParameter == ReturnControlToECU) //00
                            {
                                if(AppUSData->ind.Length == 4) //2F 10 01 00
                                {
                                    DIDFlag.Bits.DID1001Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)// 03
                            {
                                if(AppUSData->ind.Length == 5) //2F 10 01 03..1Bytes
                                {
                                    DIDFlag.Bits.DID1001Valid = Enable;
                                    IOCTL_DID1001.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1002: //תٱ
                            if(InOutCtrlParameter == ReturnControlToECU)
                            {
                                if(AppUSData->ind.Length == 4)
                                {
                                    DIDFlag.Bits.DID1002Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5)
                                {
                                    DIDFlag.Bits.DID1002Valid = Enable;
                                    IOCTL_DID1002.FF_Byte = AppUSData->ind.MsgData[4];
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1003: //¶ȱ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1003Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1003Valid = Enable;
                                    IOCTL_DID1003.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1004: //ȼͱ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1004Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1004Valid = Enable;
                                    IOCTL_DID1004.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1005: //ѹ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1005Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1005Valid = Enable;
                                    IOCTL_DID1005.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1006: //б
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1006Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1006Valid = Enable;
                                    IOCTL_DID1006.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1007: //״ָ̬ʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1007Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1007Valid = Enable;
                                    IOCTL_DID1007.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1008: //໬ָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1008Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1008Valid = Enable;
                                    IOCTL_DID1008.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1009: //ͣƶָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1009Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1009Valid = Enable;
                                    IOCTL_DID1009.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;                            
                        case DID100A: //ָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100AValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100AValid = Enable;
                                    IOCTL_DID100A.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break; 
                        case DID100B: //ѹ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100BValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100BValid = Enable;
                                    IOCTL_DID100B.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;                                                       
                        case DID100C: //ȫҹָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100CValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100CValid = Enable;
                                    IOCTL_DID100B.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID100D: //ŷָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100DValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100DValid = Enable;
                                    IOCTL_DID100D.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID100E: //Զ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100EValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100EValid = Enable;
                                    IOCTL_DID100E.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID100F: //ŵָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID100FValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID100FValid = Enable;
                                    IOCTL_DID100F.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1010: //ɲ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1010Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1010Valid = Enable;
                                    IOCTL_DID1010.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1011: //ABSϱ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1011Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1011Valid = Enable;
                                    IOCTL_DID1011.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1012: //̥ѹ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1012Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1012Valid = Enable;
                                    IOCTL_DID1012.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1013: //λָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1013Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1013Valid = Enable;
                                    IOCTL_DID1013.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1014: //ʻֹ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1014Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1014Valid = Enable;
                                    IOCTL_DID1014.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1015: //ƶ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1015Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1016Valid = Enable;
                                    IOCTL_DID1015.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1017: //ȫ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1017Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1017Valid = Enable;
                                    IOCTL_DID1017.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1018: //Ѳ״ָ̬ʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1018Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1018Valid = Enable;
                                    IOCTL_DID1018.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1019: //һָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1019Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1019Valid = Enable;
                                    IOCTL_DID1019.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101A: //عָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101AValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101AValid = Enable;
                                    IOCTL_DID101A.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101B: //ˮ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101BValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101BValid = Enable;
                                    IOCTL_DID101B.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101C: //Һλ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101CValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101CValid = Enable;
                                    IOCTL_DID101C.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101D: //ǰ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101DValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101DValid = Enable;
                                    IOCTL_DID101D.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101E: //
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101EValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101EValid = Enable;
                                    IOCTL_DID101E.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID101F: //ָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID101FValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID101FValid = Enable;
                                    IOCTL_DID101F.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1023: //תָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1023Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1023Valid = Enable;
                                    IOCTL_DID1023.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1024: //תָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1024Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1024Valid = Enable;
                                    IOCTL_DID1024.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1025: //Զ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1025Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1025Valid = Enable;
                                    IOCTL_DID1025.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1027: //λõ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1027Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1027Valid = Enable;
                                    IOCTL_DID1027.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID102A: //Ԥָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID102AValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID102AValid = Enable;
                                    IOCTL_DID102A.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID102B: //ȴˮλ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID102BValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID102BValid = Enable;
                                    IOCTL_DID102B.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID102C: //ˮ¸
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID102CValid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID102CValid = Enable;
                                    IOCTL_DID102C.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1030: //ƶѹ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1030Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1030Valid = Enable;
                                    IOCTL_DID1030.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1031: //scrָʾƣɫ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1031Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1031Valid = Enable;
                                    IOCTL_DID1031.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1033: //Ӿָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1033Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1033Valid = Enable;
                                    IOCTL_DID1033.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1034: //ָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1034Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1034Valid = Enable;
                                    IOCTL_DID1034.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1035: //ָʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1035Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1035Valid = Enable;
                                    IOCTL_DID1035.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1045: //SCR ָʾƣɫ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1045Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1045Valid = Enable;
                                    IOCTL_DID1045.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;
                        case DID1046: //פ/ʱָͣʾ
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1046Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1046Valid = Enable;
                                    IOCTL_DID1046.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break; 
                        case DID1047: //ʱͣ/
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1047Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1047Valid = Enable;
                                    IOCTL_DID1047.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;  
                         case DID1048: //ECO
                            if(InOutCtrlParameter == ReturnControlToECU) 
                            {
                                if(AppUSData->ind.Length == 4) 
                                {
                                    DIDFlag.Bits.DID1048Valid = Disable;
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                            }
                            else if(InOutCtrlParameter == ShortTermAdjustment)
                            {
                                if(AppUSData->ind.Length == 5) 
                                {
                                    DIDFlag.Bits.DID1048Valid = Enable;
                                    IOCTL_DID1048.FF_Byte = AppUSData->ind.MsgData[4];                                    
                                }
                                else
                                {
                                    Error.FrameErr = ErrFormatLength;
                                }
                                MsgLen += 1;
                                Api_CopyRam((INT8U *)&N_US_S_MultiData.ind.MsgData[4], (INT8U *)&AppUSData->ind.MsgData[4], 1);
                            }
                            break;  
                         
                        default:
                            Error.FrameErr = RequestOutOfRange;
                    }
                }
            }
            else
            {
                Error.FrameErr = ErrFormatLength;//Ȳ
            }
            if(Error.FrameErr == Disable)
            {
                N_US_S_MultiData.ind.MsgData[0] = AppUSData->ind.MsgData[0] + 0x40;
                N_US_S_MultiData.ind.MsgData[1] = (INT8U)(DID >> 8);
                N_US_S_MultiData.ind.MsgData[2] = (INT8U)DID;
                N_US_S_MultiData.ind.MsgData[3] = InOutCtrlParameter;
                
                if(MsgLen >= 8)
                {
                    N_US_S_Data_FF.ind.Length = MsgLen;
                    N_US_S_Data_FF.ind.N_PCI = FirstFrame;
                }
                else
                {
                    N_US_S_MultiData.ind.Length = MsgLen;
                    N_US_S_Data_FF.ind.N_PCI = null;
                }
                N_US_S_MultiData.ind.N_Result = N_OK;
            }
        }
        else
        {
            Error.FrameErr = SecurityAccessDenied;
        }
    }
    else
    {
        Error.FrameErr = NotSuppInActiveSession;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_3E_service
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_3E_service(_N_USData *AppUSData)
{
    _SubFun SubFun;
    
    App_ErrorInfoInit((_N_USData *)AppUSData);
    
    if(AppUSData->ind.Length > 1)
    {
        SubFun.SubData = AppUSData->ind.MsgData[1];
        
        switch(SubFun.SubBits.SubFunBit0_6)
        {
            case SubZeroFun0:
                if(AppUSData->ind.Length == 0x02)
                {
                    if(!SubFun.SubBits.SubFunBit7_7)
                    {
                        N_RSPData.ind.len = 3;
                        N_RSPData.ind.MsgData[0] = N_RSPData.ind.len - 1;
                        N_RSPData.ind.MsgData[1] = AppUSData->ind.MsgData[0] + 0x40;
                        N_RSPData.ind.MsgData[2] = SubFun.SubBits.SubFunBit0_6;
                        N_RSPData.ind.N_Result = N_OK;
                    }
                    App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
                }
                else
                {
                    Error.FrameErr = ErrFormatLength;//Ȳ
                }
                break;
            default:
                Error.FrameErr = SubFunctionNotSupported; //ӹ֧ܲ
        }
    }
    else
    {
        Error.FrameErr = ErrFormatLength;//Ȳ
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_Croleft
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT32U App_Croleft(INT32U c, INT16U b)
{
    INT32U left = c << b;
    INT32U right = c >> (32 - b);
    INT32U croleftvalue = left | right;
    return croleftvalue;
}

/*-------------------------------------------------------------------------
* Function Name  : App_Croshortright
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT16U App_Croshortright(INT16U c, INT16U b)
{
    INT16U right = c >> b;
    INT16U left = c << (16 - b);
    INT16U crorightvalue = left | right;
    return crorightvalue;
}
/*-------------------------------------------------------------------------
* Function Name  : App_Mulu32
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT32U App_Mulu32(INT32U val1, INT32U val2)
{
    INT32U x, y, z, p;
    x = (val1 & NC_UDS_KEYMASK) | ((~val1) & val2);
    y = ((App_Croleft(val1, 1)) & (App_Croleft(val2, 14))) | ((App_Croleft(NC_UDS_KEYMASK, 21)) & (~(App_Croleft(val1, 30))));
    z = (App_Croleft(val1, 17)) ^ (App_Croleft(val2, 4)) ^ (App_Croleft(NC_UDS_KEYMASK, 11));
    p = x ^ y ^ z;
    return p;
}
/*-------------------------------------------------------------------------
* Function Name  : App_Uds_Calc_Key
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT32U App_Uds_Calc_Key(INT32U seed)
{
    INT32U temp;
    INT16U  index;
    INT16U  mult1;
    INT16U  mult2;
    
    if(seed == 0)
    {
        seed = NC_DEFAULT_SEED;
    }
    else
    {
        
    }
    for (index = 0x5D39, temp = 0x80000000; temp; temp >>= 1)
    {
        if (temp & seed)
        {
            index = App_Croshortright(index, 1);
            if (temp & NC_UDS_KEYMASK)
            {
                index ^= 0x74c9;
            }
        }
    }
    mult1 = (nc_uds_keymul[(index >> 2) & ((1 << 5) - 1)] ^ index);
    mult2 = (nc_uds_keymul[(index >> 8) & ((1 << 5) - 1)] ^ index);
    temp = (((INT32U)mult1) << 16) | ((INT32U)mult2);
    temp = App_Mulu32(seed, temp);
    return temp;
}

/*-------------------------------------------------------------------------
* Function Name  : App_SetSequenceTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SetSequenceTimer(INT32U Second, _DiagClock *T)
{
    T->TT_SequenceEnable = Enable;
    T->OverSequenceTime = Second;
    T->SequenceTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : App_SequenceTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_SequenceTimerOver(_DiagClock *T)
{
    if((T->SequenceTime >= T->OverSequenceTime) && (T->TT_SequenceEnable))
    {
        T->TT_SequenceEnable = Disable;
        T->SequenceTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_SetSessionTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SetSessionTimer(INT32U Second, _DiagClock *T)
{
    T->TT_SessionEnable = Enable;
    T->OverSessionTime = Second;
    T->SessionTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_TTimerOver3
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_SessionTimerOver(_DiagClock *T)
{
    if((T->SessionTime >= T->OverSessionTime) && (T->TT_SessionEnable))
    {
        T->TT_SessionEnable = Disable;
        T->SessionTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : App_SetReUnlockTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SetReUnlockTimer(INT32U Second, _DiagClock *T)
{
    T->TT_UnlockEnable = Enable;
    T->OverUnlockTime = Second;
    T->UnlockTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : App_ReUnlockTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_ReUnlockTimerOver(_DiagClock *T)
{
    if((T->UnlockTime >= T->OverUnlockTime) && (T->TT_UnlockEnable))
    {
        T->TT_UnlockEnable = Disable;
        T->UnlockTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}

