#include "protocol_class.h"
#include "user_class.h"
#include "app_service.h"
#include "defines.h"
#include "api_eeprom.h"

    #define               TotalDTCNum               11
    #define               MaxDtcNum                 11

    #define               EE_FuelOpen                0
    #define               EE_VoltHigh                1
    #define               EE_VoltLow                 2
    #define               EE_OBDErr                  3
    #define               EE_EPCErr                  4
    #define               EE_ABSErr                  5
    #define               EE_AirBag                  6
    #define               EE_TPMSErr                 7
    #define               EE_Safebelt                8
    #define               EE_BrakeErr                9
    #define               EE_BusOff                  10

    #define               Register_Len				      16
    #define               CheckFlag                 0x55

#ifdef    GLOBALS_DTC_HAND
   #define   EXTERN_DTC_HAND
#else
   #define   EXTERN_DTC_HAND    extern
#endif

#ifndef _DTC_HAND_H_
#define _DTC_HAND_H_

    extern     const          _DTC_MAP_INFO         dtc_map_info[TotalDTCNum];  //DTCϢ

    extern     volatile        _DTC                 DiagDtc[ TotalDTCNum ];     //DTC
    extern     volatile       _SnapShot             DiagSnap[ TotalDTCNum ];    //
    extern     volatile       _DTC_StatusRecord     DtcAndStatus[ TotalDTCNum ];//
    
    extern     volatile       _SaveDtcInfo          SaveDtcInfo;

    EXTERN_DTC_HAND void CheckBusoffDTC(void);

    EXTERN_DTC_HAND     void           App_DtcInfoInit(_DTC *DTC, INT32U DtcNum);
    EXTERN_DTC_HAND     void           App_Load_DTC(void);
    EXTERN_DTC_HAND     void           App_CheckDtc_Store(const _DTC_MAP_INFO *mapInfo, volatile _DTC *dtc);
    EXTERN_DTC_HAND     INT8U          App_CheckDtcStatus(INT8U mask, _DTC *Dtc);
    EXTERN_DTC_HAND     void           App_DTC_EEpromInit(void);

    //EXTERN_DTC_HAND     void           App_ReadSnapInfo(INT8U Block, INT8U  MemAdd, INT8U *Data);
    //EXTERN_DTC_HAND     void           App_WriteSnap(INT8U Block, INT8U  MemAdd, INT8U *Data);
    EXTERN_DTC_HAND     _SnapShot     *App_GetSnap(_SnapShot *p_Snap, volatile _DTC DTC[], volatile _SnapShot LocalSnap[], INT8U pos);

    EXTERN_DTC_HAND     INT16U         App_DTCCount_handle(INT8U mask);
    EXTERN_DTC_HAND     void           App_DtcBit_handle(volatile _DTC DTC[], INT8U SignalLed, volatile _SnapShot Snap[], INT8U pos);
    EXTERN_DTC_HAND     void           App_Snap_handle(_SnapShot *Snap, _DTC *DTC);
    EXTERN_DTC_HAND     void           App_StoreDTC_handle(void);//DTC
    EXTERN_DTC_HAND     void           App_StoreSnap_handle(void);//
    EXTERN_DTC_HAND     void           Diag_DTC_Check_main(void);


#endif