/*
 * app_CAN.c
 *
 *  Created on: Aug 16, 2014
 *      Author: QTC
 */

#define GLOBALS_APP_CAN
#include "defines.h"
#include "g_includes.h"
#include "dtc_handle.h"
#include "bsp_CAN.h"

/*-------------------------------------------------------------------------
 * Function Name  : App_CheckCanDrop
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void App_CheckCanDrop(void)
{
	INT8U n = 1u;

	if (g_curkeyinput == KeyOFF)
	{
		g_canMsg61444.ProceF = EMPOTY;
		g_canMsg65266.ProceF = EMPOTY;
		g_canMsg65269.ProceF = EMPOTY;
		g_canMsg65262.ProceF = EMPOTY;
		g_canMsg65279.ProceF = EMPOTY;
		g_canMsg65252.ProceF = EMPOTY;
		g_canMsg64892.ProceF = EMPOTY;
		g_canMsg65265.ProceF = EMPOTY;
		g_canMsg65263.ProceF = EMPOTY;
		g_canMsg65248.ProceF = EMPOTY;
		g_canMsg61442.ProceF = EMPOTY;
		g_canMsg61445.ProceF = EMPOTY;
		g_canMsg64923.ProceF = EMPOTY;
		g_canMsg65215.ProceF = EMPOTY;
		g_canMsg61441.ProceF = EMPOTY;
		g_canMsg60439.ProceF = EMPOTY;
		g_canMsg04119.ProceF = EMPOTY;

		g_canMsg64775_00.ProceF = EMPOTY;
		g_canMsg64775_0F.ProceF = EMPOTY;
		g_canMsg61440_00.ProceF = EMPOTY;
		g_canMsg61440_29.ProceF = EMPOTY;
		g_canMsg61440_0F.ProceF = EMPOTY;
		g_canMsg61440_10.ProceF = EMPOTY;
		g_canMsg65110_00.ProceF = EMPOTY;
		g_canMsg65110_A3.ProceF = EMPOTY;
		g_canMsg61454_51.ProceF = EMPOTY;
		g_canMsg61454_52.ProceF = EMPOTY;

		g_canMsg65226ECM.ProceF = EMPOTY;
		g_canMsg65226EPS.ProceF = EMPOTY;

		g_canMsgABSDTC_EC00.ProceF = EMPOTY;
		g_canMsgECUDTC_EC00.ProceF = EMPOTY;
		g_canMsgDCUDTC_EC00.ProceF = EMPOTY;
		g_canMsgABSDTC_EB00.ProceF = EMPOTY;
		g_canMsgECUDTC_EB00.ProceF = EMPOTY;
		g_canMsgDCUDTC_EB00.ProceF = EMPOTY;
	}

	//-- 20ms Per--//
	if (g_CanTimeOut20ms >= T_20ms)
	{
		g_CanTimeOut20ms = null;
		n = 1;

		if (bRadioTypeCn > 0)
			bRadioTypeCn--;

		//-- ת --//
		if (g_canClock.signal.Exist61444)
		{
			if (g_canClock.ID61444Cn >= n)
			{
				g_canClock.ID61444Cn -= n;
			}
			else
			{
				g_canClock.ID61444Cn = null;
			}
			if (g_canClock.ID61444Cn == null)
			{
				g_revMeter.CurBoardVal = 0;

				Disable_signal(g_canClock.signal.Exist61444);
			}
		}

		//ͺ
		if (g_canClock.signal.Exist65266)
		{
			if (g_canClock.ID65266Cn >= n)
			{
				g_canClock.ID65266Cn -= n;
			}
			else
			{
				g_canClock.ID65266Cn = null;
			}
			if (g_canClock.ID65266Cn == null)
			{
				g_fuelEco.AveFuelTime = null;
				g_fuelEco.FuelSum = null;
				g_fuelEco.Dis100Km = null;
				g_fuelEco.DispAveFuel = null;
				g_fuelEco.CalAveFuel = null;
				AveFuel_Updeta;

				g_fuelEco.SRFCTime = null;
				g_fuelEco.FuelSum1 = null;
				g_fuelEco.Dis100Km1 = null;
				g_fuelEco.DispSRFC = null;
				g_fuelEco.CalSRFC = null;
				InstFuel_Updeta;

				Disable_signal(g_canClock.signal.Exist65266);
			}
		}

		//
		if (g_canClock.signal.Exist65269)
		{
			if (g_canClock.ID65269Cn >= n)
			{
				g_canClock.ID65269Cn -= n;
			}
			else
			{
				g_canClock.ID65269Cn = null;
			}
			if (g_canClock.ID65269Cn == null)
			{
				g_revMeter.CurBoardVal = 0;

				Disable_signal(g_canClock.signal.Exist65269);
			}
		}

		//-- ˮ --//
		if (g_canClock.signal.Exist65262)
		{
			if (g_canClock.ID65262Cn >= n)
			{
				g_canClock.ID65262Cn -= n;
			}
			else
			{
				g_canClock.ID65262Cn = null;
			}
			if (g_canClock.ID65262Cn == null)
			{

				g_Init.InitTempTime = 0;
				g_tempMeter.CurBoardVal = 0;
				if (CheckStep == 2)
					g_sysFlag.Bits.TempMeterInit = Enable;
				Disable_signal(g_canClock.signal.Exist65262);
			}
		}

		//
		if (g_canClock.signal.Exist65279)
		{
			if (g_canClock.ID65279Cn >= n)
			{
				g_canClock.ID65279Cn -= n;
			}
			else
			{
				g_canClock.ID65279Cn = null;
			}
			if (g_canClock.ID65279Cn == null)
			{
				g_CanSwith.WIF = 0;
				g_CanSwith.DriverWarn = 0;
				//g_CanSwith.DriverLimited = 0;
				Disable_signal(g_canClock.signal.Exist65279);
			}
		}

		//-- Ԥ --//
		if (g_canClock.signal.Exist65252)
		{
			if (g_canClock.ID65252Cn >= n)
			{
				g_canClock.ID65252Cn -= n;
			}
			else
			{
				g_canClock.ID65252Cn = null;
			}
			if (g_canClock.ID65252Cn == null)
			{
				g_CanSwith.PreHeat = 0;
				Disable_signal(g_canClock.signal.Exist65252);
			}
		}

		//-- ŷDPF --//
		if (g_canClock.signal.Exist64892)
		{
			if (g_canClock.ID64892Cn >= n)
			{
				g_canClock.ID64892Cn -= n;
			}
			else
			{
				g_canClock.ID64892Cn = null;
			}
			if (g_canClock.ID64892Cn == null)
			{

				g_CanSwith.DPF = 0;
				g_CanSwith.DPFf = 0;
				g_CanSwith.DpfHiTemp = 0;
				g_CanSwith.DPF_Red = 0;
				g_CanSwith.InhibiteDPF = 0;
				g_CanSwith.InhibiteDPFONOFF = 0;

				Disable_signal(g_canClock.signal.Exist64892);
			}
		}

		//-- ŷŹOBD1 --//
		if (g_canClock.signal.Exist64775_00)
		{
			if (g_canClock.ID64775_00Cn >= n)
			{
				g_canClock.ID64775_00Cn -= n;
			}
			else
			{
				g_canClock.ID64775_00Cn = null;
			}
			if (g_canClock.ID64775_00Cn == null)
			{
			  g_CanSwith.OilLamp1 = 0;
				g_CanSwith.EngMIL1 = 0;
				g_CanSwith.EngFailure1 = 0;
				g_CanSwith.EngFailure4 = 0;
				g_CanSwith.STOP1 = 0;

				Disable_signal(g_canClock.signal.Exist64775_00);
			}
		}

		if (g_canClock.signal.Exist64775_0F)
		{
			if (g_canClock.ID64775_0FCn >= n)
			{
				g_canClock.ID64775_0FCn -= n;
			}
			else
			{
				g_canClock.ID64775_0FCn = null;
			}
			if (g_canClock.ID64775_0FCn == null)
			{
				g_CanSwith.EngMIL1 = 0;
				g_CanSwith.EngFailure1 = 0;
				g_CanSwith.EngFailure4 = 0;
				g_CanSwith.STOP1 = 0;

				Disable_signal(g_canClock.signal.Exist64775_0F);
			}
		}

		//-- Ѳ --//
		if (g_canClock.signal.Exist65265)
		{
			if (g_canClock.ID65265Cn >= n)
			{
				g_canClock.ID65265Cn -= n;
			}
			else
			{
				g_canClock.ID65265Cn = null;
			}
			if (g_canClock.ID65265Cn == null)
			{
				g_CanSwith.CruSysAct = 0;

				Disable_signal(g_canClock.signal.Exist65265);
			}
		}

		//-- ѹ  --//
		if (g_canClock.signal.Exist65263)
		{
			if (g_canClock.ID65263Cn >= n)
			{
				g_canClock.ID65263Cn -= n;
			}
			else
			{
				g_canClock.ID65263Cn = null;
			}
			if (g_canClock.ID65263Cn == null)
			{
				g_CanSwith.OilLamp = 0;

				Disable_signal(g_canClock.signal.Exist65263);
			}
		}

		//
		if (g_canClock.signal.Exist61440_00)
		{
			if (g_canClock.ID61440_00Cn >= n)
			{
				g_canClock.ID61440_00Cn -= n;
			}
			else
			{
				g_canClock.ID61440_00Cn = null;
			}
			if (g_canClock.ID61440_00Cn == null)
			{
				Disable_signal(g_canClock.signal.Exist61440_00);
			}
		}

		//
		if (g_canClock.signal.Exist61440_29)
		{
			if (g_canClock.ID61440_29Cn >= n)
			{
				g_canClock.ID61440_29Cn -= n;
			}
			else
			{
				g_canClock.ID61440_29Cn = null;
			}
			if (g_canClock.ID61440_29Cn == null)
			{
	

				Disable_signal(g_canClock.signal.Exist61440_29);
			}
		}

		//
		if (g_canClock.signal.Exist61440_0F)
		{
			if (g_canClock.ID61440_0FCn >= n)
			{
				g_canClock.ID61440_0FCn -= n;
			}
			else
			{
				g_canClock.ID61440_0FCn = null;
			}
			if (g_canClock.ID61440_0FCn == null)
			{
				

				Disable_signal(g_canClock.signal.Exist61440_0F);
			}
		}

		//
		if (g_canClock.signal.Exist61440_10)
		{
			if (g_canClock.ID61440_10Cn >= n)
			{
				g_canClock.ID61440_10Cn -= n;
			}
			else
			{
				g_canClock.ID61440_10Cn = null;
			}
			if (g_canClock.ID61440_10Cn == null)
			{
			

				Disable_signal(g_canClock.signal.Exist61440_10);
			}
		}

		//-- ŷŹOBD2 --//
		if (g_canClock.signal.Exist65226ECM)
		{
			if (g_canClock.ID65226CnECM >= n)
			{
				g_canClock.ID65226CnECM -= n;
			}
			else
			{
				g_canClock.ID65226CnECM = null;
			}
			if (g_canClock.ID65226CnECM == null)
			{
				g_CanSwith.EngMIL2 = 0;
				g_CanSwith.EngFailure2 = 0;
				g_CanSwith.EngFailure3 = 0;
				g_CanSwith.STOP2 = 0;

				EcmDtcTbl[0].bFMI = 0;
				EcmDtcTbl[0].dwSPN = 0;

				Disable_signal(g_canClock.signal.Exist65226ECM);
			}
		}
		if (g_canClock.signal.Exist65226EPS)
		{
			if (g_canClock.ID65226CnEPS >= n)
			{
				g_canClock.ID65226CnEPS -= n;
			}
			else
			{
				g_canClock.ID65226CnEPS = null;
			}
			if (g_canClock.ID65226CnEPS == null)
			{
				g_CanSwith.EngMIL3 = 0;
				g_CanSwith.SCR_Y = 0;
				g_CanSwith.SCR_R = 0;

				DCUDtcTbl[0].bFMI = 0;
				DCUDtcTbl[0].dwSPN = 0;

				Disable_signal(g_canClock.signal.Exist65226EPS);
			}
		}

		//
		if (g_canClock.signal.Exist65248)
		{
			if (g_canClock.ID65248Cn >= n)
			{
				g_canClock.ID65248Cn -= n;
			}
			else
			{
				g_canClock.ID65248Cn = null;
			}
			if (g_canClock.ID65248Cn == null)
			{
				

				Disable_signal(g_canClock.signal.Exist65248);
			}
		}

		//
		if (g_canClock.signal.Exist65110_00)
		{
			if (g_canClock.ID65110_00Cn >= n)
			{
				g_canClock.ID65110_00Cn -= n;
			}
			else
			{
				g_canClock.ID65110_00Cn = null;
			}
			if (g_canClock.ID65110_00Cn == null)
			{
				g_canClock.ID65110Start_00Cn = 0;
				g_adblueMeter.CurBoardVal = 0;
				g_adblueMeter.DispPosition = 0;
				g_adblueMeter.CurPosition = 0;
				g_adblueMeter.DestPosition = 0;

				Disable_signal(g_canClock.signal.Exist65110_00);
			}
		}

		//
		if (g_canClock.signal.Exist65110_A3)
		{
			if (g_canClock.ID65110_A3Cn >= n)
			{
				g_canClock.ID65110_A3Cn -= n;
			}
			else
			{
				g_canClock.ID65110_A3Cn = null;
			}
			if (g_canClock.ID65110_A3Cn == null)
			{
				g_canClock.ID65110Start_A3Cn = 0;
				g_adblueMeter.CurBoardVal = 0;
				g_adblueMeter.DispPosition = 0;
				g_adblueMeter.CurPosition = 0;
				g_adblueMeter.DestPosition = 0;

				Disable_signal(g_canClock.signal.Exist65110_A3);
			}
		}

		//-- Һ_3D --//
		if (g_canClock.signal.Exist65110_3D)
		{
			if (g_canClock.ID65110_3DCn >= n)
			{
				g_canClock.ID65110_3DCn -= n;
			}
			else
			{
				g_canClock.ID65110_3DCn = null;
			}
			if (g_canClock.ID65110_3DCn == null)
			{
				g_canClock.ID65110Start_3DCn = 0;
				g_adblueMeter.CurBoardVal = 0;
				g_adblueMeter.DispPosition = 0;
				g_adblueMeter.CurPosition = 0;
				g_adblueMeter.DestPosition = 0;

				Disable_signal(g_canClock.signal.Exist65110_3D);
			}
		}

		//
		if (g_canClock.signal.Exist61442)
		{
			if (g_canClock.ID61442Cn >= n)
			{
				g_canClock.ID61442Cn -= n;
			}
			else
			{
				g_canClock.ID61442Cn = null;
			}
			if (g_canClock.ID61442Cn == null)
			{
				Disable_signal(g_canClock.signal.Exist61442);
			}
		}

		//
		if (g_canClock.signal.Exist61445)
		{
			if (g_canClock.ID61445Cn >= n)
			{
				g_canClock.ID61445Cn -= n;
			}
			else
			{
				g_canClock.ID61445Cn = null;
			}
			if (g_canClock.ID61445Cn == null)
			{
				Disable_signal(g_canClock.signal.Exist61445);
			}
		}

		//
		if (g_canClock.signal.Exist64923)
		{
			if (g_canClock.ID64923Cn >= n)
			{
				g_canClock.ID64923Cn -= n;
			}
			else
			{
				g_canClock.ID64923Cn = null;
			}
			if (g_canClock.ID64923Cn == null)
			{
				Disable_signal(g_canClock.signal.Exist64923);
			}
		}

		//
		if (g_canClock.signal.Exist61454_51)
		{
			if (g_canClock.ID61454_51Cn >= n)
			{
				g_canClock.ID61454_51Cn -= n;
			}
			else
			{
				g_canClock.ID61454_51Cn = null;
			}
			if (g_canClock.ID61454_51Cn == null)
			{
				g_CanSwith.CruSysAct = 0;

				Disable_signal(g_canClock.signal.Exist61454_51);
			}
		}

		//
		if (g_canClock.signal.Exist61454_52)
		{
			if (g_canClock.ID61454_52Cn >= n)
			{
				g_canClock.ID61454_52Cn -= n;
			}
			else
			{
				g_canClock.ID61454_52Cn = null;
			}
			if (g_canClock.ID61454_52Cn == null)
			{
				g_CanSwith.CruSysAct = 0;

				Disable_signal(g_canClock.signal.Exist61454_52);
			}
		}

		//
		if (g_canClock.signal.Exist65215)
		{
			if (g_canClock.ID65215Cn >= n)
			{
				g_canClock.ID65215Cn -= n;
			}
			else
			{
				g_canClock.ID65215Cn = null;
			}
			if (g_canClock.ID65215Cn == null)
			{
				g_CanSwith.CruSysAct = 0;

				Disable_signal(g_canClock.signal.Exist65215);
			}
		}

		//-- ABS --//
		if (g_canClock.signal.Exist61441)
		{
			if (g_canClock.ID61441Cn >= n)
			{
				g_canClock.ID61441Cn -= n;
			}
			else
			{
				g_canClock.ID61441Cn = null;
			}
			if (g_canClock.ID61441Cn == null)
			{
				g_CanSwith.ABSLamp = 0;
				g_CanSwith.ABSLamp1 = 0;
				g_CanSwith.ASR = 0;
				g_CanSwith.ESPoff = 0;

				Disable_signal(g_canClock.signal.Exist61441);
			}
		}

		//--
		if (g_canClock.signal.Exist60439)
		{
			if (g_canClock.ID60439Cn >= n)
			{
				g_canClock.ID60439Cn -= n;
			}
			else
			{
				g_canClock.ID60439Cn = null;
			}
			if (g_canClock.ID60439Cn == null)
			{
				Disable_signal(g_LightSts.LTurnSts);
				Disable_signal(g_LightSts.RTurnSts);
				Disable_signal(g_CanSwith.HighBeam);
				Disable_signal(g_CanSwith.LowBeam);
				Disable_signal(g_CanSwith.DrDoorStae);
				Disable_signal(g_CanSwith.PssDoorStae);
				Disable_signal(g_CanSwith.RLDoorStae);
				Disable_signal(g_CanSwith.RRDoorStae);
				Disable_signal(g_CanSwith.FrontFog);
				Disable_signal(g_CanSwith.RearFog);
				Disable_signal(g_CanSwith.PosLamp);

				Disable_signal(g_canClock.signal.Exist60439);
			}
		}

		//--
		if (g_canClock.signal.Exist04119)
		{
			if (g_canClock.ID04119Cn >= n)
			{
				g_canClock.ID04119Cn -= n;
			}
			else
			{
				g_canClock.ID04119Cn = null;
			}
			if (g_canClock.ID04119Cn == null)
			{
				Disable_signal(g_canClock.signal.Exist04119);
			}
		}

		//DTC-18ECFF00 㲥
		if (g_canClock.signal.ExistECU60416)
		{
			if (g_canClock.IDECU60416Cn >= n)
			{
				g_canClock.IDECU60416Cn -= n;
			}
			else
			{
				g_canClock.IDECU60416Cn = null;
			}
			if (g_canClock.IDECU60416Cn == null)
			{
				MulCanMsg_ECM.bBuf[0] = 0;
				EcmDtcTbl[0].Err = 0;
				bEcmDtcCnt = 0;
				EPCLamp = 0;
				OBDLamp = 0;
				(void)memset(EcmDtcTbl, 0, sizeof(EcmDtcTbl));

				Disable_signal(g_canClock.signal.ExistECU60416);
			}
		}
		//DTC-18EBFF00 
		if (g_canClock.signal.ExistECU60160)
		{
			if (g_canClock.IDECU60160Cn >= n)
			{
				g_canClock.IDECU60160Cn -= n;
			}
			else
			{
				g_canClock.IDECU60160Cn = null;
			}
			if (g_canClock.IDECU60160Cn == null)
			{
				Disable_signal(g_canClock.signal.ExistECU60160);
			}
		}
		//DTC-18ECFF0B 㲥
		if (g_canClock.signal.ExistABS60416)
		{
			if (g_canClock.IDABS60416Cn >= n)
			{
				g_canClock.IDABS60416Cn -= n;
			}
			else
			{
				g_canClock.IDABS60416Cn = null;
			}
			if (g_canClock.IDABS60416Cn == null)
			{
				(void)memset(ABSDtcTbl, 0, sizeof(ABSDtcTbl));

				Disable_signal(g_canClock.signal.ExistABS60416);
			}
		}
		//DTC-18EBFF0B 
		if (g_canClock.signal.ExistABS60160)
		{
			if (g_canClock.IDABS60160Cn >= n)
			{
				g_canClock.IDABS60160Cn -= n;
			}
			else
			{
				g_canClock.IDABS60160Cn = null;
			}
			if (g_canClock.IDABS60160Cn == null)
			{
				Disable_signal(g_canClock.signal.ExistABS60160);
			}
		}
		//DTC-18ECFF3D 㲥
		if (g_canClock.signal.ExistDCU60416)
		{
			if (g_canClock.IDDCU60416Cn >= n)
			{
				g_canClock.IDDCU60416Cn -= n;
			}
			else
			{
				g_canClock.IDDCU60416Cn = null;
			}
			if (g_canClock.IDDCU60416Cn == null)
			{
				(void)memset(DCUDtcTbl, 0, sizeof(DCUDtcTbl));

				Disable_signal(g_canClock.signal.ExistDCU60416);
			}
		}
		//DTC-18EBFF3D 
		if (g_canClock.signal.ExistDCU60160)
		{
			if (g_canClock.IDDCU60160Cn >= n)
			{
				g_canClock.IDDCU60160Cn -= n;
			}
			else
			{
				g_canClock.IDDCU60160Cn = null;
			}
			if (g_canClock.IDDCU60160Cn == null)
			{
				Disable_signal(g_canClock.signal.ExistDCU60160);
			}
		}
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : Api_SetCanTimer
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void Api_SetCanTimer(INT16U Second, _Clock *T)
{
	T->TCanEnable = Enable;
	T->OverCanTime = Second;
	T->CanTime = null;
}
/*-------------------------------------------------------------------------
 * Function Name  : Api_CanTimerOver
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
INT8U Api_CanTimerOver(_Clock *T)
{
	if ((T->CanTime >= T->OverCanTime) && (T->TCanEnable))
	{
		T->TCanEnable = Disable;
		return 1;
	}
	else
	{
		return 0;
	}
}

/*-------------------------------------------------------------------------
 * Function Name  : App_SendCanMsg
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void App_SendCanMsg(void)
{
	if (g_curkeyinput == KeyON)
	{
		//IC_TCO1	0x0CFE6CEE	65132	50

		//Tachograph output shaft speed
		//Com_vTCO1Spd

		if (g_canClock.CanSendTime >= T1_100ms)
		{
			g_canClock.CanSendTime = null;

			//IC_CCVS	0x18FEF121	65265	100

			//Parking Brake Switc
			//Cruise Control Pause Switch
			//Wheel-Based Vehicle Speed
			//Cruise Control Active
			//Brake Switch
			//Clutch Switch
			//Cruise Control Set Switch
			//Cruise Control Coast (Decelerate) Switch
			//Cruise Control Resume Switch
			//Cruise Control Accelerate Switch
			//PTO Governor State

			g_txCanMsg1.dlc = 8;
			g_txCanMsg1.id = 0x18FEF121;

			g_txCanMsg1.msg[0] = 0x01;
			g_txCanMsg1.msg[1] = 0x02;
			g_txCanMsg1.msg[2] = 0x03;
			g_txCanMsg1.msg[3] = 0x04;
			g_txCanMsg1.msg[4] = 0x05;
			g_txCanMsg1.msg[5] = 0x06;
			g_txCanMsg1.msg[6] = 0x07;
			g_txCanMsg1.msg[7] = 0x08;

			g_bReturn = bsp_CANSendExtFrame((INT32U)g_txCanMsg1.id, 3, (INT8U *)g_txCanMsg1.msg, g_txCanMsg1.dlc);
		}

		//IC_DD	0x18FEFC17	65276	1000
		//Fuel Level 1

		//IC_VDHR 	0x18FEC1EE	65217	1000
		//Vehicle Distance
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : GetConnectInfo
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void GetConnectInfo(MULCANMSG *pMulCanMsg, INT8U *pCanBuf)
{
	INT16U wTemp;
	if (!pMulCanMsg->bRcvBusy)
	{
		wTemp = (((INT16U)pCanBuf[2]) << 8) | pCanBuf[1];
		if (wTemp <= MAX_MULCANDATALEN)
		{ //ڿɴķΧ.
			pMulCanMsg->bLength = pCanBuf[1];
			pMulCanMsg->bCtrByte = pCanBuf[0];
			pMulCanMsg->wPGN = (((INT16U)pCanBuf[6]) << 8) | pCanBuf[5];
			pMulCanMsg->bPackage = pCanBuf[3];
			pMulCanMsg->bRcvInfoFlg = 1;
			pMulCanMsg->bPrePckNum = 0;
		}
	}
	else
	{
		//reset MulCanMsg,ʹܹ½Ϣ
		pMulCanMsg->bRcvBusy = 0;
		pMulCanMsg->bPrePckNum = 0;
		pMulCanMsg->bRcvInfoFlg = 0;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : GetMulDTC
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
INT8U GetMulDTC(MULCANMSG *pMulCanMsg, INT8U *pCanBuf)
{
	if (pMulCanMsg->bRcvInfoFlg)
	{ //յݱ(ӹ)
		if (pMulCanMsg->wPGN == 65226)
		{ //ECM()
			if (pMulCanMsg->bCtrByte == 32)
			{ //BAM(㲥Ϣ)
				if (pMulCanMsg->bPrePckNum + 1 == pCanBuf[0])
				{							  //кŵ
					pMulCanMsg->bRcvBusy = 1; //ʼնϢ
					(void)memmove(&pMulCanMsg->bBuf[pMulCanMsg->bPrePckNum * 7],
								  &pCanBuf[1], 7); //move myRxData to MulCan.DataBuf.
					pMulCanMsg->bPrePckNum++;
					if (pMulCanMsg->bPrePckNum == pMulCanMsg->bPackage)
					{								 //һ
						pMulCanMsg->bRcvInfoFlg = 0; //Ϣ
						pMulCanMsg->bRcvBusy = 0;	 //Ϣ,ԽµϢ(pgn60416)
						pMulCanMsg->bPrePckNum = 0;
						return 1; //Ϣ
					}
				}
			}
		}
	}
	return 0;
}
/************************************************************************
  Function Name	:	UpdateDtcTbl(MULCANMSG *pMulCanMsg,DTC *pDtcTable,INT8U *pDtcCnt)
Engineer		:	bill
Date			:	2009 05 03
Parameters		:	None
Returns			:	None
Notes			:	¹,ڶĸ
 *************************************************************************/
void UpdateDtcTbl(MULCANMSG *pMulCanMsg, DTC *pDtcTable, INT8U *pDtcCnt)
{
	INT8U i;
	INT32U tmp32u_Can;
	*pDtcCnt = (INT8U)((pMulCanMsg->bLength - 2) >> 2);
	if (*pDtcCnt > DTCTBLLEN)
		*pDtcCnt = DTCTBLLEN;
	for (i = 0; i < *pDtcCnt; i++)
	{
		pDtcTable[0].Err = pMulCanMsg->bBuf[0];
		pDtcTable[i].bFMI = pMulCanMsg->bBuf[4 + i * 4] & 0x1f;
		tmp32u_Can = 0;
		//GET SPN
		tmp32u_Can |= (pMulCanMsg->bBuf[4 + i * 4] >> 5);
		tmp32u_Can <<= 8;
		tmp32u_Can |= pMulCanMsg->bBuf[3 + i * 4];
		tmp32u_Can <<= 8;
		tmp32u_Can |= pMulCanMsg->bBuf[2 + i * 4];
		pDtcTable[i].dwSPN = tmp32u_Can;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : AnalysisConnectInfo
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void AnalysisConnectInfo(void)
{
	if (g_canMsgECUDTC_EC00.ProceF)
	{
		GetConnectInfo(&MulCanMsg_ECM, g_canMsgECUDTC_EC00.Data); //㲥
		g_canMsgECUDTC_EC00.ProceF = EMPOTY;
	}
	//
	if (g_canMsgDCUDTC_EC00.ProceF)
	{
		GetConnectInfo(&MulCanMsg_DCU, g_canMsgDCUDTC_EC00.Data); //㲥
		g_canMsgDCUDTC_EC00.ProceF = EMPOTY;
	}
	//
	if (g_canMsgABSDTC_EC00.ProceF)
	{
		GetConnectInfo(&MulCanMsg_ABS, g_canMsgABSDTC_EC00.Data); //㲥
		g_canMsgABSDTC_EC00.ProceF = EMPOTY;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : AnalysisMulDTC
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void AnalysisMulDTC(void)
{
	if (g_canMsgECUDTC_EB00.ProceF)
	{
		if (GetMulDTC(&MulCanMsg_ECM, g_canMsgECUDTC_EB00.Data)) //
			UpdateDtcTbl(&MulCanMsg_ECM, EcmDtcTbl, &bEcmDtcCnt);
		g_canMsgECUDTC_EB00.ProceF = EMPOTY;
	}
	//
	if (g_canMsgDCUDTC_EB00.ProceF)
	{
		if (GetMulDTC(&MulCanMsg_DCU, g_canMsgDCUDTC_EB00.Data)) //
			UpdateDtcTbl(&MulCanMsg_DCU, DCUDtcTbl, &bDCUDtcCnt);
		g_canMsgDCUDTC_EB00.ProceF = EMPOTY;
	}
	//
	if (g_canMsgABSDTC_EB00.ProceF)
	{
		if (GetMulDTC(&MulCanMsg_ABS, g_canMsgABSDTC_EB00.Data)) //
			UpdateDtcTbl(&MulCanMsg_ABS, ABSDtcTbl, &bABSDtcCnt);
		g_canMsgABSDTC_EB00.ProceF = EMPOTY;
	}
}
/*-------------------------------------------------------------------------
 * Function Name  : CheckEcmMulDTC
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void CheckEcmMulDTC(void)
{
	AnalysisConnectInfo();
	AnalysisMulDTC();

	//ģ-ϵ()
	if ((((MulCanMsg_ECM.bBuf[0] & 0x03) == 1) || ((MulCanMsg_ECM.bBuf[0] & 0x0C) == 0X04)) && (g_canClock.signal.ExistECU60416 == 1)) //㲥ID,ܵ
	{
		EPCLamp = 1;
	}
	else
	{
		EPCLamp = 0;
	}

	if (((MulCanMsg_ECM.bBuf[0] & 0xC0) == 0x40) && (g_canClock.signal.ExistECU60416 == 1)) //㲥ID,ܵ
	{
		OBDLamp = 1;
	}
	else
	{
		OBDLamp = 0;
	}
}
