#include "defines.h"
#include "UDS_CFG.h"
#include "UDS_def.h"
#include "app_Service.h"
#include "g_includes.h"
#include "dtc_handle.h"
#include "Link_Layer.h"
volatile CAN_REV_TYPE CanFrame;

/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN_Init
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void bsp_CAN_Init(void)
{
	INT16U b = null;
	CAN1CTL0_INITRQ = Enable;

	while (!CAN1CTL1_INITAK)
		;

	CAN1CTL1 = CAN1CTL1_CANE_MASK | CAN1CTL1_BORM_MASK;
	CAN1CTL1_WUPM = Disable;
	/*
	   SYNC_SEG + (PROP_SEG + PHASE_SEG1) + (PHASE_SEG2)
	   1 Tq         4--16  Tq                  2--8  Tq
	   */

	//4M
	CAN1BTR1_TSEG_10 = Seg1_11Tq; //351page  75<= sp<=83
	CAN1BTR1_TSEG_20 = Seg2_4Tq;
	CAN1BTR1_SAMP = SAMP_1;
	CAN1BTR0_SJW = SJW_1Tq;
	CAN1BTR0_BRP = 1;

	CAN1IDAC_IDAM = IDAM_2_32Bit;
	CAN1IDAC_IDHIT = IDHIT0;

	CAN1IDAR0 = null;
	CAN1IDAR1 = null;
	CAN1IDAR2 = null;
	CAN1IDAR3 = null;
	CAN1IDAR4 = null;
	CAN1IDAR5 = null;
	CAN1IDAR6 = null;
	CAN1IDAR7 = null;

	CAN1IDMR0 = 0xFF;
	CAN1IDMR1 = 0xFF;
	CAN1IDMR2 = 0xFF;
	CAN1IDMR3 = 0xFF;
	CAN1IDMR4 = 0xFF;
	CAN1IDMR5 = 0xFF;
	CAN1IDMR6 = 0xFF;
	CAN1IDMR7 = 0xFF;
	//
	CAN1CTL0_INITRQ = Disable;
	while (CAN1CTL1_INITAK)
		;
	while (!CAN1CTL0_SYNCH)
	{
		b++;
		if (b > WaitOverTime)
		{
			break;
		}
	}

	CAN1CTL0_SLPRQ = Disable;
	CAN1RFLG_RXF = ClearFlag;
	CAN1RIER_RXFIE = Enable;  //??????
	CAN1TIER_TXEIE = Disable; //????
	CAN1RIER_WUPIE = Enable;

	CAN1CTL0_TIME = Enable; //?????
	CAN1CTL0_CSWAI = 0;		//?????????
	CAN1CTL0_WUPE = Enable;
}
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN1_Rev_isr
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
interrupt void bsp_CAN1_Rev_isr(void)
{
	//INT16U mID16;
	INT8U m_dlc;
	INT32U extend_id;
	INT8U SA;
	INT8U PS;
	INT16U MULPGN;
	CAN1RIER_RXFIE = 0; //MSCANж
	m_dlc = CAN1RXDLR_DLC;

	extend_id = bsp_GET_EXTEND_ID((INT8U *)&CAN1RXIDR0);
	extend_pgn = (INT16U)(GET_EXTPGN(extend_id));
	SA = (INT8U)(extend_id & 0x000000ff);
	PS = (INT8U)((extend_id & 0x0000ff00) >> 8);
	switch (extend_pgn)
	{
	//-- ౨ --//
	//ϻظRQST	 0x18EA0021	
	case ID_FunPGN:
		if (PS == 0xFF) //2021-4-12   //CAN ID 0x18DBFFFA   ǲΪ0xFF
		{
			if (DiagnoCtl.SessionType == SubExtSession)
			{
				App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
			}
			LK_Link_main(ID_FunPGN, &CAN1RXDSR0, (CAN1RXDLR & 0x0f));            
		}
		break;
	case ID_PhyPGN: // CAN ID 0x18DA17FA
		if (PS == 0x17)
		{

			if ((DiagnoCtl.SessionType == SubExtSession) || (DiagnoCtl.SessionType == SubProgSession))
			{
				App_SetSessionTimer(N_Session, (_DiagClock *)&DiagClock);
			}
			LK_Link_main(ID_PhyPGN, &CAN1RXDSR0, (CAN1RXDLR & 0x0f));
		}
		break;

		//-- Ӧò㱨 --//
		//ECM_EEC1 0x0CF00400 61444 10 ת
	case ID61444:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg61444.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61444Cn < 5)
					{
						g_canClock.ID61444Cn++;
					}
					if (g_canClock.ID61444Cn > 2)
					{
						g_canMsg61444.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61444.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61444);

						g_canClock.ID61444Cn = 25; //T,
					}
				}
			}
		}

		break;

		//ECM_LFE 0x18FEF200 65266 100    //ͺ
	case ID65266:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65266.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65266Cn < 5)
					{
						g_canClock.ID65266Cn++;
					}
					if (g_canClock.ID65266Cn > 2)
					{
						g_canMsg65266.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65266.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65266);

						g_canClock.ID65266Cn = 50; //T,
					}
				}
			}
		}

		break;

		//ECM_AMB 0x18FEF500 65269 1000
	case ID65269:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65269.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65269Cn < 5)
					{
						g_canClock.ID65269Cn++;
					}
					if (g_canClock.ID65269Cn > 2)
					{
						g_canMsg65269.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65269.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65269);

						g_canClock.ID65269Cn = 500; //T,
					}
				}
			}
		}

		break;

		//ECM_ET1	0x18FEEE00	65262	1000    	ˮ
	case ID65262:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65262.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65262Cn < 5)
					{
						g_canClock.ID65262Cn++;
						g_Init.InitTempTime = 0;
						if (CheckStep == 2)
							g_sysFlag.Bits.TempMeterInit = Enable;
					}
					if (g_canClock.ID65262Cn > 2)
					{
						g_canMsg65262.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65262.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65262);

						g_canClock.ID65262Cn = 500; //T,
					}
				}
			}
		}

		break;

		//ECM_WFI	0x18FEFF00	65279	10000	  ˮ
	case ID65279:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65279.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65279Cn < 5)
					{
						g_canClock.ID65279Cn++;
					}
					if (g_canClock.ID65279Cn >= 1)
					{
						g_canMsg65279.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65279.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65279);

						g_canClock.ID65279Cn = 5000; //T,10000ms
					}
				}
			}
		}

		break;

		//ECM_SHUTDN	0x18FEE400	65252	1000		 	Ԥ
	case ID65252:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65252.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65252Cn < 5)
					{
						g_canClock.ID65252Cn++;
					}
					if (g_canClock.ID65252Cn > 0)
					{
						g_canMsg65252.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65252.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65252);

						g_canClock.ID65252Cn = 500; //T
					}
				}
			}
		}

		break;

		//ECM_DPFC1	0x18FD7C00	64892	1000	   DPF
	case ID64892:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0x00)
		{
			if (g_canMsg64892.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID64892Cn < 5)
					{
						g_canClock.ID64892Cn++;
					}
					if (g_canClock.ID64892Cn > 0)
					{
						g_canMsg64892.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg64892.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist64892);

						g_canClock.ID64892Cn = 500; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

		//DLCC1_00	0x18FD0700	64775	1000	   	(OBD1)
	case ID64775:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		//DLCC1_00	0x18FD0700	64775	1000	   	(OBD1)
		if (SA == 0x00)
		{
			if (g_canMsg64775_00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID64775_00Cn < 5)
					{
						g_canClock.ID64775_00Cn++;
					}
					if (g_canClock.ID64775_00Cn > 0)
					{
						g_canMsg64775_00.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg64775_00.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist64775_00);

						g_canClock.ID64775_00Cn = 500; //T,1000ms  Drop,10s
					}
				}
			}
		}
		//DLCC1_0F 0x18FD070F	64775	1000
		else if (SA == 0x0F)
		{
			if (g_canMsg64775_0F.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID64775_0FCn < 5)
					{
						g_canClock.ID64775_0FCn++;
					}
					if (g_canClock.ID64775_0FCn > 0)
					{
						g_canMsg64775_0F.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg64775_0F.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist64775_0F);

						g_canClock.ID64775_0FCn = 500; //T,1000ms  Drop,10s
					}
				}
			}
		}

		break;

		//ECM_CCVS	0x18FEF100	65265	100
		//Ѳ
	case ID65265:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		//ECM_CCVS	0x18FEF100	65265	100
		if (SA == 0x00)
		{
			if (g_canMsg65265.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65265Cn < 5)
					{
						g_canClock.ID65265Cn++;
					}
					if (g_canClock.ID65265Cn > 2)
					{
						g_canMsg65265.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65265.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65265);

						g_canClock.ID65265Cn = 50; //T,100ms  drop,1s
					}
				}
			}
		}

		break;

		//ECM_EFL/P1	0x18FEEF00	65263	500     ѹ
	case ID65263:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65263.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65263Cn < 5)
					{
						g_canClock.ID65263Cn++;
					}
					if (g_canClock.ID65263Cn > 2)
					{
						g_canMsg65263.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65263.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65263);

						g_canClock.ID65263Cn = 250; //T,500ms  drop,5s
					}
				}
			}
		}

		break;

		//ECM_ERC1	0x18F00000	61440	100
	case ID61440:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		//ECM_ERC1	0x18F00000	61440	100
		if (SA == 0x00)
		{
			if (g_canMsg61440_00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61440_00Cn < 5)
					{
						g_canClock.ID61440_00Cn++;
					}
					if (g_canClock.ID61440_00Cn > 2)
					{
						g_canMsg61440_00.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61440_00.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61440_00);

						g_canClock.ID61440_00Cn = 50; //T,500ms  drop,5s
					}
				}
			}
		}
		//ECM_ERC1	0x18F00029/0F/10	61440	100
		else if (SA == 0x29)
		{
			if (g_canMsg61440_29.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61440_29Cn < 5)
					{
						g_canClock.ID61440_29Cn++;
					}
					if (g_canClock.ID61440_29Cn > 2)
					{
						g_canMsg61440_29.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61440_29.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61440_29);

						g_canClock.ID61440_29Cn = 50; //T,500ms  drop,5s
					}
				}
			}
		}
		//ECM_ERC1	0x18F00029/0F/10	61440	100
		else if (SA == 0x0F)
		{
			if (g_canMsg61440_0F.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61440_0FCn < 5)
					{
						g_canClock.ID61440_0FCn++;
					}
					if (g_canClock.ID61440_0FCn > 2)
					{
						g_canMsg61440_0F.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61440_0F.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61440_0F);

						g_canClock.ID61440_0FCn = 50; //T,500ms  drop,5s
					}
				}
			}
		}
		//ECM_ERC1	0x18F00029/0F/10	61440	100
		else if (SA == 0x10)
		{
			if (g_canMsg61440_10.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61440_10Cn < 5)
					{
						g_canClock.ID61440_10Cn++;
					}
					if (g_canClock.ID61440_10Cn > 2)
					{
						g_canMsg61440_10.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61440_10.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61440_10);

						g_canClock.ID61440_10Cn = 50; //T,500ms  drop,5s
					}
				}
			}
		}
		break;

		//DM1	0x18FECA00	65226	1000  //(OBD DTC)
	case ID65226:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		//DM1	0x18FECA00	65226	1000  //(OBD DTC)
		if (SA == 0x00) //OBD2
		{
			if (g_canMsg65226ECM.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65226CnECM < 5)
					{
						g_canClock.ID65226CnECM++;
					}
					if (g_canClock.ID65226CnECM > 0)
					{
						g_canMsg65226ECM.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65226ECM.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65226ECM);

						g_canClock.ID65226CnECM = 500; //T,1000ms  drop,10s
					}
				}
			}
		}
		//EPS_DM1	0x18FECA13	65226	1000
		else if (SA == 0x13)
		{
			if (g_canMsg65226EPS.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65226CnEPS < 5)
					{
						g_canClock.ID65226CnEPS++;
					}
					if (g_canClock.ID65226CnEPS > 0)
					{
						g_canMsg65226EPS.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65226EPS.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65226EPS);

						g_canClock.ID65226CnEPS = 500; //T,1000ms  drop,10s
					}
				}
			}
		}

		break;

		//ECM_VD	0x18FEE000	65248	100
	case ID65248:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65248.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65248Cn < 5)
					{
						g_canClock.ID65248Cn++;
					}
					if (g_canClock.ID65248Cn > 2)
					{
						g_canMsg65248.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65248.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65248);

						g_canClock.ID65248Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

	//ECM_AT1TI1	0x18FE5600 	65110	1000  
	case ID65110:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg65110_00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65110Start_00Cn < 2) //Recover Time 2000ms
					{
						g_canClock.ID65110Start_00Cn++;
						g_Init.InitAdblueTime = 0;
						//g_sysFlag.Bits.AdbuleMeterInit = Enable; //߻ָԿָʾ
					}
					if (g_canClock.ID65110Start_00Cn >= 2)
					{
						g_canMsg65110_00.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65110_00.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65110_00);

						g_canClock.ID65110_00Cn = 500; //T,1000ms  drop,10s
					}
				}
			}
		}
		//AT1T1	0x18FE56A3	65110	1000
		else if (SA == 0xA3)
		{
			if (g_canMsg65110_A3.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65110_A3Cn < 2) //Recover Time 2000ms
					{
						g_canClock.ID65110_A3Cn++;
						g_Init.InitAdblueTime = 0;
						//g_sysFlag.Bits.AdbuleMeterInit = Enable; //߻ָԿָʾ
					}
					if (g_canClock.ID65110_A3Cn >= 2)
					{
						g_canMsg65110_A3.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65110_A3.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65110_A3);

						g_canClock.ID65110_A3Cn = 500; //T,1000ms  drop,10s
					}
				}
			}
		}
		//AT1T1	0x18FE563D	65110	1000
		else if (SA == 0x3D)
		{
			if (g_canMsg65110_3D.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65110_3DCn < 2) //Recover Time 2000ms
					{
						g_canClock.ID65110_3DCn++;
						g_Init.InitAdblueTime = 0;
						//g_sysFlag.Bits.AdbuleMeterInit = Enable; //߻ָԿָʾ
					}
					if (g_canClock.ID65110_3DCn >= 2)
					{
						g_canMsg65110_3D.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65110_3D.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65110_3D);

						g_canClock.ID65110_3DCn = 500; //T,1000ms  drop,10s
					}
				}
			}
		}

		break;

		//AMT_ETC1	0x0CF00203	61442	10	8
	case ID61442:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg61442.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61442Cn < 5)
					{
						g_canClock.ID61442Cn++;
					}
					if (g_canClock.ID61442Cn > 2)
					{
						g_canMsg61442.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61442.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61442);

						g_canClock.ID61442Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

		//AMT-ETC2	0x18F00503	61445	100
	case ID61445:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg61445.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61445Cn < 5)
					{
						g_canClock.ID61445Cn++;
					}
					if (g_canClock.ID61445Cn > 2)
					{
						g_canMsg61445.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61445.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61445);

						g_canClock.ID61445Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

		//A1DEFI	0x18FD9BA3	64923	1000
	case ID64923:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x00)
		{
			if (g_canMsg64923.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID64923Cn < 5)
					{
						g_canClock.ID64923Cn++;
					}
					if (g_canClock.ID64923Cn > 2)
					{
						g_canMsg64923.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg64923.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist64923);

						g_canClock.ID64923Cn = 500; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

	//DCU_	0x18F00E51	61454	50
	case ID61454:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}

		if (SA == 0x51)
		{
			if (g_canMsg61454_51.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61454_51Cn < 5)
					{
						g_canClock.ID61454_51Cn++;
					}
					if (g_canClock.ID61454_51Cn > 2)
					{
						g_canMsg61454_51.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61454_51.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61454_51);

						g_canClock.ID61454_51Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		//DCU_	0x18F00F52	61455	50
		else if (SA == 0x52)
		{
			if (g_canMsg61454_52.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61454_52Cn < 5)
					{
						g_canClock.ID61454_52Cn++;
					}
					if (g_canClock.ID61454_52Cn > 2)
					{
						g_canMsg61454_52.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61454_52.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61454_52);

						g_canClock.ID61454_52Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

	//ABS_EBC2	0x18FEBF0B	65215	100
	case ID65215:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0x0B)
		{
			if (g_canMsg65215.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID65215Cn < 5)
					{
						g_canClock.ID65215Cn++;
					}
					if (g_canClock.ID65215Cn > 2)
					{
						g_canMsg65215.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg65215.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist65215);

						g_canClock.ID65215Cn = 50; //T,1000ms  drop,10s
					}
				}
			}
		}
		break;

		//ABS_EBC1	0x18F0010B	61441	100
	case ID61441:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0x0B)
		{
			if (g_canMsg61441.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID61441Cn < 3)
					{
						g_canClock.ID61441Cn++;
					}
					if (g_canClock.ID61441Cn >= 3)
					{
						g_canMsg61441.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg61441.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist61441);

						g_canClock.ID61441Cn = 50; //T,100ms  drop,1s
					}
				}
			}
		}

		break;

		//EPS	0x18101713	04119	100    //4096
	case ID04119:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0x13)
		{
			if (g_canMsg04119.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID04119Cn < 3)
					{
						g_canClock.ID04119Cn++;
					}
					if (g_canClock.ID04119Cn >= 3)
					{
						g_canMsg04119.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg04119.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist04119);

						g_canClock.ID04119Cn = 250; //T,100ms  drop,1s
					}
				}
			}
		}

		break;

		//(OBD DTC)㲥-18ECFF00-0B-3D
	case ID60416:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0)
		{
			if (g_canMsgECUDTC_EC00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgECUDTC_EC00.ProceF = MSG_FULL;
					(void)memcpy(g_canMsgECUDTC_EC00.Data, &CAN1RXDSR0, m_dlc);
					MULPGN = (((INT16U)g_canMsgECUDTC_EC00.Data[6]) << 8) | g_canMsgECUDTC_EC00.Data[5];
					if (MULPGN == 65226) //FECA
					{

						Enable_signal(g_canClock.signal.ExistECU60416);

						g_canClock.IDECU60416Cn = 500; //T,1000ms  Drop,10s
					}
				}
			}
		}
		else if (SA == 0x0B)
		{
			if (g_canMsgABSDTC_EC00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgABSDTC_EC00.ProceF = MSG_FULL;
					(void)memcpy(g_canMsgABSDTC_EC00.Data, &CAN1RXDSR0, m_dlc);
					MULPGN = (((INT16U)g_canMsgABSDTC_EC00.Data[6]) << 8) | g_canMsgABSDTC_EC00.Data[5];
					if (MULPGN == 65226) //FECA
					{

						Enable_signal(g_canClock.signal.ExistABS60416);

						g_canClock.IDABS60416Cn = 500; //T,1000ms  Drop,10s
					}
				}
			}
		}
		else if (SA == 0x3D)
		{
			if (g_canMsgDCUDTC_EC00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgDCUDTC_EC00.ProceF = MSG_FULL;
					(void)memcpy(g_canMsgDCUDTC_EC00.Data, &CAN1RXDSR0, m_dlc);
					MULPGN = (((INT16U)g_canMsgDCUDTC_EC00.Data[6]) << 8) | g_canMsgDCUDTC_EC00.Data[5];
					if (MULPGN == 65226) //FECA
					{

						Enable_signal(g_canClock.signal.ExistDCU60416);

						g_canClock.IDDCU60416Cn = 500; //T,1000ms  Drop,10s
					}
				}
			}
		}
		//BCM_ExternalLight	0x18EC1721	60439	500   //60416
		else if (SA == 0x21)
		{
			if (g_canMsg60439.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);
					if (g_canClock.ID60439Cn < 3)
					{
						g_canClock.ID60439Cn++;
					}
					if (g_canClock.ID60439Cn >= 3)
					{
						g_canMsg60439.ProceF = MSG_FULL;

						(void)memcpy(g_canMsg60439.Data, &CAN1RXDSR0, m_dlc);
						Enable_signal(g_canClock.signal.Exist60439);

						g_canClock.ID60439Cn = 250; //T,100ms  drop,1s
					}
				}
			}
		}
		else
			;
		break;

		//(OBD DTC)-18EBFF00-0B-3D
	case ID60160:
		//ϽֹNOR
		if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
			((DiagnoCtl.CommType == NOR_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
		{
			break;
		}
		if (SA == 0)
		{

			if (g_canMsgECUDTC_EB00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgECUDTC_EB00.ProceF = MSG_FULL;

					(void)memcpy(g_canMsgECUDTC_EB00.Data, &CAN1RXDSR0, m_dlc);
					Enable_signal(g_canClock.signal.ExistECU60160);

					g_canClock.IDECU60160Cn = 500; //T,1000ms  Drop,10s
				}
			}
		}
		else if (SA == 0x0B)
		{

			if (g_canMsgABSDTC_EB00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgABSDTC_EB00.ProceF = MSG_FULL;

					(void)memcpy(g_canMsgABSDTC_EB00.Data, &CAN1RXDSR0, m_dlc);
					Enable_signal(g_canClock.signal.ExistABS60160);

					g_canClock.IDABS60160Cn = 500; //T,1000ms  Drop,10s
				}
			}
		}
		else if (SA == 0x3D)
		{
			if (g_canMsgDCUDTC_EB00.ProceF == EMPOTY)
			{
				if (m_dlc == 8)
				{
					Enable_signal(g_sysFlag.Bits.NetDataKeep);

					g_canMsgDCUDTC_EB00.ProceF = MSG_FULL;

					(void)memcpy(g_canMsgDCUDTC_EB00.Data, &CAN1RXDSR0, m_dlc);
					Enable_signal(g_canClock.signal.ExistDCU60160);

					g_canClock.IDDCU60160Cn = 500; //T,1000ms  Drop,10s
				}
			}
		}
		else
			;
		break;
	default:
		break;
	}

	//ϽֹNM
	if (((DiagnoCtl.CommCtl == SubDisableRxAndTx) || (DiagnoCtl.CommCtl == SubDisableRxAndEnTx)) &&
		((DiagnoCtl.CommType == NM_Message) || (DiagnoCtl.CommType == NOR_NM_Message)))
	{
	}
	else
	{
		//NM_Receive_isr_Fun(extend_id, &CAN1RXDSR0);
	}

	///
	CAN1RFLG_RXF = 1;	//RXF־
	CAN1RIER_RXFIE = 1; //MSCAN ʹж
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN1_Tx_isr
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
interrupt void bsp_CAN1_Tx_isr(void)
{
	g_canClock.BusOffTime = T_2_0ms;
	g_canClock.BusOffCn = null;

	if (DiagDtc[EE_BusOff].PassTimes < 5)
	{
		DiagDtc[EE_BusOff].PassTimes++;
	}

	CAN1TFLG_TXE = 0x07; //
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN1_Wakeup_isr
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
interrupt void bsp_CAN1_Wakeup_isr(void)
{
	pSTBOut = LOW;
	CAN1RFLG_WUPIF = ClearFlag;

	g_sysFlag.Bits.CanWakeUp = CanWakeUpEn;
	g_sysFlag.Bits.CanState = CanOFF;
	g_sysFlag.Bits.AccKmValid = Disable;
	Api_SetCanTimer(T_8s, (_Clock *)&g_Clock);
}
#pragma CODE_SEG DEFAULT

volatile INT8U TRANSMIT_ERROR_COUNT;
volatile INT8U TRANSMIT_OLD_ERROR_COUNT;

/*-------------------------------------------------------------------------
 * Function Name  : MSCAN_SendFrame
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void MSCAN_SendFrame(INT32U id, INT8U *Buf, INT8U len)
{
	INT8U txEmptyBuf;
	INT8U i;
	CANMsg sendMsgBuf;
	INT16U cn = 0;
	INT8U index;
	//2015-3-16
	if (CAN1CTL0_SLPRQ || pSTBOut) //MACAN ˯ģʽ ?,NO
		return;
	//-------------------------------
	sendMsgBuf.dataLen = len;
	sendMsgBuf.sendID = id;
	sendMsgBuf.priority = 0;
	sendMsgBuf.IDE = 1;
	sendMsgBuf.RTR = 0;
	if (sendMsgBuf.dataLen > 8) //ݳȴ8? ,YES
		return;
	(void)memcpy(sendMsgBuf.data, Buf, sendMsgBuf.dataLen);

	if (!(CAN1TFLG & 0x07)) //3ͻûп
		return;
	CAN1TBSEL = CAN1TFLG; //ѡָеķͻ(ѡ͵)
	txEmptyBuf = CAN1TBSEL;
	//дʶID
	if (0 == sendMsgBuf.IDE)
	{
		//׼11λID
		CAN1TXIDR0 = (INT8U)(sendMsgBuf.sendID >> 3);
		CAN1TXIDR1 = (INT8U)(sendMsgBuf.sendID << 5);
		CAN1TXIDR1_SRR = sendMsgBuf.RTR;
		CAN1TXIDR1_IDE = 0;
	}
	else
	{
		//չ29λID
		CAN1TXIDR0 = (INT8U)((id & 0x1fe00000) >> 21);
		CAN1TXIDR1 = (INT8U)((id & 0x001c0000) >> 13);
		CAN1TXIDR1 |= (INT8U)((id & 0x00038000) >> 15);
		CAN1TXIDR1 |= 0x18;
		CAN1TXIDR2 = (INT8U)((id & 0x00007f80) >> 7);
		CAN1TXIDR3 = (INT8U)((id & 0x0000007f) << 1);

		//return ;
	}

	if (0 == sendMsgBuf.RTR) //ǷΪ֡
	{
		//д
		for (i = 0; i < sendMsgBuf.dataLen; i++)
			*((&CAN1TXDSR0) + i) = sendMsgBuf.data[i];
		CAN1TXDLR = sendMsgBuf.dataLen;
	}
	else
	{
		if (len > 8)
			len = 8;
		for (index = 0; index < len; index++)
		{
			*(&CAN1TXDSR0 + index) = sendMsgBuf.data[i]; //Load data to Tx buffer Data Segment Registers
		}

		CAN1TXDLR = len; /* Set Data Length Code */
	}
	//дȼ
	CAN1TXTBPR = sendMsgBuf.priority;
	//TXxб־,Ӧķͻ׼,ͳɹTXxλʾֿ
	//ͨд10
	CAN1TFLG = txEmptyBuf;
}

/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN_BusOff
 * Description    : can bus off
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void bsp_CAN_BusOff(void)
{
	CAN1MISC_BOHOLD = ClearFlag;
	CAN1TARQ_ABTRQ = CAN1TBSEL;
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN_SleepRelease
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void bsp_CAN_SleepRelease(void)
{
	CAN1CTL0_SLPRQ = Disable;
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_CAN_Sleep
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void bsp_CAN_Sleep(void)
{
	bsp_tx_msgbuf_abort();
	CAN1CTL0_SLPRQ = Enable;
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_tx_msgbuf_abort
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void bsp_tx_msgbuf_abort(void)
{
	CAN1TARQ_ABTRQ0 = Enable;
	CAN1TARQ_ABTRQ1 = Enable;
	CAN1TARQ_ABTRQ2 = Enable;
}
/*-------------------------------------------------------------------------
 * Function Name  : bsp_GET_EXTEND_ID
 * Description    :
 * Input          : None
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
INT32U bsp_GET_EXTEND_ID(INT8U *IDR0_Add)
{
	INT32U dwPGN = 0;
	INT8U *bp;

	bp = (INT8U *)&dwPGN;

	*(bp) = *(IDR0_Add);
	*(bp + 1) = *(IDR0_Add + 1);
	*(bp + 2) = *(IDR0_Add + 2);
	*(bp + 3) = *(IDR0_Add + 3);

	dwPGN = ((dwPGN & 0x7FFFF) >> 1) | ((dwPGN & 0xFFE00000) >> 3);

	return (dwPGN);
}

/*-------------------------------------------------------------------------
 * Function Name  : bsp_CANSendExtFrame
 * Description    : 
 * Input          : 
 * Output         : None
 * Return         : dwPGN
 * onther         : 
 --------------------------------------------------------------------------*/
INT8U bsp_CANSendExtFrame(INT32U id, INT8U priority, INT8U *txdata, INT8U length)
{
	INT8U txbuffer, index;
	INT16U cn = null;
	if (!CAN1TFLG) //Is Transmit Buffer full ? Full ( TXEx=0;)
		return failt;
	if (id == null)
		return failt;
	CAN1TBSEL = CAN1TFLG; /* Select lowest empty buffer */
	txbuffer = CAN1TBSEL; // Backup selected buffer
	/* Load Id to IDR Register */
	//*((unsigned long *) ((unsigned long)(&CANTXIDR0))) = id; // I appreciate this , easy and good.
	CAN1TXIDR0 = (INT8U)((id & 0x1fe00000) >> 21);
	CAN1TXIDR1 = (INT8U)((id & 0x001c0000) >> 13);
	CAN1TXIDR1 |= (INT8U)((id & 0x00038000) >> 15);
	CAN1TXIDR1 |= 0x18;
	CAN1TXIDR2 = (INT8U)((id & 0x00007f80) >> 7);
	CAN1TXIDR3 = (INT8U)((id & 0x0000007f) << 1);

	if (length > 8)
		length = 8;
	for (index = 0; index < length; index++)
	{
		*(&CAN1TXDSR0 + index) = txdata[index]; //Load data to Tx buffer Data Segment Registers
	}

	CAN1TXDLR = length;	   /* Set Data Length Code */
	CAN1TXTBPR = priority; /* Set Priority */
	CAN1TFLG = txbuffer;   /* Start transmission */
	while ((CAN1TFLG & txbuffer) != txbuffer)
	{
		//; // Wait for Transmission   completion
		cn++;
		if (cn > 5000)
			break;
	}
	return success;
}
