/*
 * MOTOR.h
 *
 *  Created on: Apr 21, 2019
 *      Author: qitiancun
 */

#ifndef _MOTOR_H_
#define _MOTOR_H_

    typedef unsigned char uint8_t;
    typedef unsigned int  uint16_t;
    typedef unsigned long uint32_t;
    
    typedef struct
    {
        uint16_t     curPosition;     
        uint16_t     destPosition;  
    }MeterPostion_t;
    

    typedef enum
    {
       direction_1 = 0,
       direction_2,
    }MoveDirection_t;
    
    typedef enum
    {
       Motor_1 = 0,
       Motor_2,
       Motor_3,
       Motor_4,
    }MotorIndex_t;
    
    typedef enum
    {
       Normal = 0,
       SelfCheck,
       MinReset,
       MaxReset,
       MaxPostion,
       MaxPostionKeep,
       MinPostion
    }workMode_t;
    
    typedef enum
    {
       UnConfig = 0,
       IO_PA,
       IO_PB,
       IO_AD0,
       IO_AD1,
       IO_H,
       IO_M,
       IO_S,
       IO_T,
       IO_P,
       IO_R,
       IO_V,
       IO_U
    }IO_Name_t;
    
    extern      volatile        MeterPostion_t     MeterPostion[4];
    
    extern      uint8_t*        bsp_MotorGetVersion(void);      /* ȡ汾 */
    
    extern      void            bsp_MotorMove_50us_main(void);  /*  VectorNumber_Vmctimovf жеãʼĬʹж */
    
    extern      uint8_t         bsp_set_meterCfg(uint8_t motorIndex,MoveDirection_t motorDir,uint16_t MaxAngle,uint16_t One_Step_Damp); 
                                                 /* 
                                                 One_Step_Damp ƽٶ ԽԽ
                                                 */
                                                 
    extern      void            bsp_SetMotorMode(uint8_t index,workMode_t Mode); /* õģʽ */
    
    extern      workMode_t      bsp_GetMotorState(uint8_t index);   /* ȡģʽ */
    
    extern      void            bsp_SetOneStepDamp(MotorIndex_t motorIndex,uint32_t One_Step_Damp); /* ÿһʱ */
    
    extern      void            MotorDriveOff(void);
   
    extern      void            Gpio_Loading(void);
    
    extern      uint8_t         SetDetectZeroPoint_IO(IO_Name_t name,MotorIndex_t Index,uint8_t port_offset);
    
    extern      void             bsp_SetMaxSpeed(MotorIndex_t Index,uint32_t speed);/*ٶ  ֵԽԽ */
      
#endif /* _MOTOR_H_ */
