 #define  GLOBALS_TP_DIAGNO
#include "defines.h"
#include "Link_Layer.h"
#include "protocol_class.h"
#include "TP_Layer.h"
#include "UDS_def.h"
#include "UDS_CFG.H"
#include "APP_Service.h"
#include "app_ServiceProc.h"



volatile       _N_USData             N_US_R_MultiData;
volatile       _N_USData             N_US_S_MultiData;//ǱⷢϢ-multi
volatile       _N_RSPData            N_RSPData;//ǱⷢϢ
volatile       _N_US_Data_FF         N_US_R_Data_FF;
volatile       _N_US_Data_FF         N_US_S_Data_FF;
volatile       _N_USSFData           N_USSFData[2];
volatile       INT16U                N_RecLen;


/*-------------------------------------------------------------------------
* Function Name  : TP_Buffer_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_Buffer_handle(void)
{
    if(LinkDataBuf[0].TransferStatus == full)
    {
        (void)memcpy((INT8U *)&LinkData, (INT8U *)&LinkDataBuf[0], sizeof(_LinkData));
        LinkDataBuf[0].TransferStatus = empoty;
    }
    else if(LinkDataBuf[1].TransferStatus == full)
    {
        (void)memcpy((INT8U *)&LinkData, (INT8U *)&LinkDataBuf[1], sizeof(_LinkData));
        LinkDataBuf[1].TransferStatus = empoty;
    }

    TP_AbnormalInResSF_handle();
    TP_AbnormalInReqFF_handle();
    TP_UnknownlPDU_handle();
    TP_AbnormalInResCF_handle();
    TP_AbnormalInReqFC_handle();
    TP_AbnormalInResFC_handle();
    TP_TooShortDLC_handle((_LinkData *)&LinkData);
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TooShortDLC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_TooShortDLC_handle(_LinkData *LK_Data)
{
    INT16U len;
    INT8U  CtrlMask;

    CtrlMask = LK_Data->Data[0] & 0xf0;
    len = LK_Data->Data[0] & 0x0F;

    if(CtrlMask == SingleFrame)
    {
        if(LK_Data->DLC <= len)
        {
            LK_Data->TransferStatus = empoty;
        }
    }
    if(CtrlMask == FirstFrame)
    {
        if(LK_Data->DLC != 8)
        {
            LK_Data->TransferStatus = empoty;
        }
    }
    if(CtrlMask == FlowControlFrame)
    {
        if(LK_Data->DLC < 3)
        {
            LK_Data->TransferStatus = empoty;
            N_US_R_MultiData.ind.N_Result = N_WRONG_SN;
        }
    }
    if(CtrlMask == ConsecutiveFrame)
    {
        if((N_US_R_MultiData.ind.Length / 7) == len)
        {
            len = len - 1;
            if((len * 7 + 5 + LK_Data->DLC) < N_US_R_MultiData.ind.Length)
            {
                LK_Data->TransferStatus = empoty;
                N_US_R_MultiData.ind.N_Result = N_WRONG_SN;
            }
        }
        else
        {
            if(LK_Data->DLC < 7)
            {
                LK_Data->TransferStatus = empoty;
                N_US_R_MultiData.ind.N_Result = N_WRONG_SN;
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_UnknownlPDU_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_AbnormalInResSF_handle(void)
{
    INT8U CtrlMask;
    if((N_US_S_MultiData.ind.N_Result == N_OK) && (N_US_S_Data_FF.ind.N_PCI) && (LinkData.TransferStatus == full))
    {
        CtrlMask = LinkData.Data[0] & 0x30;
        if(CtrlMask == FirstFrame)
        {
            LinkData.TransferStatus = empoty;
        }
        if(CtrlMask == ConsecutiveFrame)
        {
            LinkData.TransferStatus = empoty;
        }
        if(CtrlMask == SingleFrame)
        {
            LinkData.TransferStatus = empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_UnknownlPDU_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_UnknownlPDU_handle(void)
{
    INT8U CtrlMask;
    CtrlMask = LinkData.Data[0] & 0xC0;

    if(N_US_S_MultiData.ind.N_Result == N_OK)
    {
        if(CtrlMask)
        {
            LinkData.TransferStatus = empoty;
        }
    }
    if((N_US_R_MultiData.ind.N_Result == WAIT) || (N_US_R_MultiData.ind.N_Result == CTS))
    {
        if((CtrlMask) && (LinkData.TransferStatus == full))
        {
            LinkData.TransferStatus = empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInReqFF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_AbnormalInReqFF_handle(void)
{
    INT8U CtrlMask;

    CtrlMask = LinkData.Data[0] & 0xf0;

    if((CtrlMask == FirstFrame) && (LinkData.TransferStatus == full))
    {
        if(N_US_R_MultiData.ind.N_Result == CTS)
        {
            N_US_R_MultiData.ind.N_Result = STATE0;
            N_US_R_Data_FF.ind.pos = null;
            N_US_R_Data_FF.ind.N_PCI = null;
            N_US_R_Data_FF.ind.N_RecSN_L = null;
        }
        if((LinkData.Identifier == ID_FunPGN) )
        {
            LinkData.TransferStatus = empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInResCF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_AbnormalInResCF_handle(void)
{
    if(N_US_S_MultiData.ind.N_Result == N_OK)
    {
        if(((LinkData.Data[0] & 0xf0) == ConsecutiveFrame) && (LinkData.TransferStatus == full))
        {
            LinkData.TransferStatus = empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInReqFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_AbnormalInReqFC_handle(void)
{
    if(N_US_R_MultiData.ind.N_Result == CTS)
    {
        if(((LinkData.Data[0] & 0xf0) == FlowControlFrame) && (LinkData.TransferStatus == full))
        {
            LinkData.TransferStatus = empoty;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_AbnormalInResFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_AbnormalInResFC_handle(void)
{
    if(N_US_S_Data_FF.ind.N_PCI == ConsecutiveFrame)
    {
        if((LinkData.TransferStatus == full) && ((LinkData.Data[0] & 0x30) == FlowControlFrame))
        {
            LinkData.TransferStatus = empoty;
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_NormalRecFC_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_NormalRecFC_handle(void)
{
    INT8U  CtrlMask;
    INT8U  FC_State;

    CtrlMask = LinkData.Data[0] & 0xF0;

    if(N_US_S_Data_FF.ind.N_PCI == FC_WAIT)
    {
        if(CtrlMask == FlowControlFrame)
        {
            if((LinkData.Identifier == ID_FunPGN))
            {
                N_US_S_MultiData.ind.N_Result = N_TIMEOUT_Bs;
                return;
            }

            FC_State = LinkData.Data[0] & 0x0f;
            if(FC_State == 1)
            {
                N_US_S_Data_FF.ind.N_PCI = FC_WAIT;
                TP_SetBsTimer(N_Bs, (_DiagClock *)&DiagClock);
            }
            if(FC_State == 2)
            {
                N_US_S_MultiData.ind.N_Result = OVFLW;
            }
            if((FC_State >= 3) && (FC_State <= 0x0F))
            {
                N_US_S_MultiData.ind.N_Result = N_INVALID_FS;
            }
            if(FC_State == 0)
            {
                N_US_S_MultiData.ind.N_Result = N_OK;

                N_US_S_Data_FF.ind.N_PCI = ConsecutiveFrame;

                N_US_S_Data_FF.ind.N_FC_Num = null;
                N_US_S_Data_FF.ind.N_BS = LinkData.Data[1];
                N_US_S_Data_FF.ind.N_BS_CNT = null;

                //if((LinkData.Data[2] >= null) && (LinkData.Data[2] <= 0x7F))
                if(LinkData.Data[2] <= 0x7F)
                {
                    DiagnoCtl.N_STmin = LinkData.Data[2] + 1;
                }
                if((LinkData.Data[2] >= 0xF1) && (LinkData.Data[2] <= 0xF9))
                {
                    DiagnoCtl.N_STmin = 1;
                }
                //if((LinkData.Data[2] >= 0xFA) && (LinkData.Data[2] <= 0xFF))
                if(LinkData.Data[2] >= 0xFA)
                {
                    DiagnoCtl.N_STmin = 128;
                }
                DiagClock.TT_BsEnable = Disable;
                TP_SetSTminTimer(DiagnoCtl.N_STmin, (_DiagClock *)&DiagClock);
            }
        }
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_NormalSendFC_Fun
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_NormalSendFC_Fun(void)
{
    if(N_US_R_MultiData.ind.N_Result == WAIT)
    {
        N_RSPData.ind.N_Result = N_OK;
        N_RSPData.ind.len = 3;
        N_RSPData.ind.MsgData[1] = DiagnoCtl.N_REV_MAX_BS;
        if(N_US_R_MultiData.ind.Length <= MaxBuff)
        {
            N_RSPData.ind.MsgData[0] = 0x30;
            N_RSPData.ind.MsgData[2] = 0x01;
            N_US_R_MultiData.ind.N_Result = CTS;
            TP_SetCrTimer(N_Cr, (_DiagClock *)&DiagClock);
        }
        else
        {
            N_RSPData.ind.MsgData[0] = 0x32;
            N_RSPData.ind.MsgData[2] = 0x32;
            N_US_R_MultiData.ind.N_Result = STATE0;
        }
    }
    if(N_US_R_MultiData.ind.N_Result == CTS)
    {
        if(TP_CrTimerOver((_DiagClock *)&DiagClock))
        {
            N_US_R_MultiData.ind.N_Result = N_TIMEOUT_Bs;
        }
    }
}


/*-------------------------------------------------------------------------
* Function Name  : TP_ReciveSF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_ReciveSF_handle(void)
{
    INT16U len;
    if((LinkData.Data[0] & 0xf0) == SingleFrame)
    {
        len = LinkData.Data[0] & 0x0f;
        if((len > 0) && (len <= 7))
        {
            if((Exct_USData.ind.N_Result == N_OK) || (N_USSFData[0].ind.N_Result == N_OK))
            {
                N_USSFData[1].ind.Length = len;

                N_USSFData[1].ind.N_TAtype = LinkData.Identifier;
                N_USSFData[1].ind.N_PCI = SingleFrame;
                N_USSFData[1].ind.N_Result = N_OK;
                (void)App_CopyRam((INT8U *) & (N_USSFData[1].ind.MsgData[0]), (INT8U *)&LinkData.Data[1], 7);
            }
            else
            {
                N_USSFData[0].ind.Length = len;

                N_USSFData[0].ind.N_TAtype = LinkData.Identifier;
                N_USSFData[0].ind.N_PCI = SingleFrame;
                N_USSFData[0].ind.N_Result = N_OK;

                (void)App_CopyRam((INT8U *) & (N_USSFData[0].ind.MsgData[0]), (INT8U *)&LinkData.Data[1], 7);
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_ReciveMultiF_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_ReciveMultiF_handle(void)
{
    INT16U  wPos = 0;
    INT8U  SN = 0;
    INT8U   len = 0;

    if(((LinkData.Data[0] & 0xf0) == FirstFrame) && (N_US_R_MultiData.ind.N_Result == STATE0))
    {
        N_US_R_MultiData.ind.Length = LinkData.Data[0] & 0x0F;
        N_US_R_MultiData.ind.Length <<= 8;
        N_US_R_MultiData.ind.Length |= LinkData.Data[1];

        if(N_US_R_MultiData.ind.Length >= 8)
        {
            N_US_R_MultiData.ind.N_TAtype = LinkData.Identifier;

            N_US_R_Data_FF.ind.N_PCI = FirstFrame;
            N_US_R_Data_FF.ind.N_RecSN_L = 0x0001;//

            (void)App_CopyRam((INT8U *)&N_US_R_MultiData.ind.MsgData[0], (INT8U *)&LinkData.Data[2], 6);

            N_US_R_MultiData.ind.N_Result = WAIT;

            N_US_R_Data_FF.ind.N_SID = LinkData.Data[2];
        }
        else
        {
            N_US_R_Data_FF.ind.N_PCI = null;
        }
        N_RecLen = 0;
    }
    if((LinkData.Data[0] & 0xf0) == ConsecutiveFrame)
    {
        N_US_R_Data_FF.ind.N_PCI = ConsecutiveFrame;
    }
    if((N_US_R_Data_FF.ind.N_PCI == ConsecutiveFrame) && (N_US_R_MultiData.ind.N_Result == CTS))
    {
        TP_SetCrTimer(N_Cr, (_DiagClock *)&DiagClock);

        N_US_R_Data_FF.ind.N_PCI = null;

        SN = LinkData.Data[0] & 0x0F;

        wPos = (1 << SN);

        if(N_US_R_Data_FF.ind.N_RecSN_L & wPos)
        {
            N_US_R_MultiData.ind.N_Result = N_WRONG_SN;
        }
        else
        {
            N_US_R_Data_FF.ind.N_RecSN_L |= wPos;
        }

        if(N_US_R_MultiData.ind.Length <= 111)
        {
            N_RecLen = TP_CalMsgLen(N_US_R_Data_FF.ind.N_RecSN_L, 0);

            if(SN == 0)
            {
                N_US_R_MultiData.ind.N_Result = N_WRONG_SN;
            }
        }
        else
        {
            if(N_RecLen == 0)
            {
                len = TP_CalMsgLen(N_US_R_Data_FF.ind.N_RecSN_L, 0);
            }
            else
            {
                len = TP_CalMsgLen(N_US_R_Data_FF.ind.N_RecSN_L, 1);
            }
            if(N_US_R_Data_FF.ind.N_RecSN_L == 0xFFFF)
            {
                N_RecLen += len;
                len = 0;
                N_US_R_Data_FF.ind.N_RecSN_L = 0;
            }
        }

        if(SN > 0)
        {
            SN -= 1;
        }

        (void)App_CopyRam((INT8U *)&N_US_R_MultiData.ind.MsgData[ (N_RecLen  + len) - 7 ], (INT8U *)&LinkData.Data[1], 7);

        if((N_RecLen  + len) >= N_US_R_MultiData.ind.Length)
        {
            N_US_R_MultiData.ind.N_Result = N_OK;
            DiagClock.TT_CrEnable = Disable;
            N_US_R_Data_FF.ind.N_RecSN_L = 0;
            N_RecLen = 0;
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TransmitPDU                              Ǳⷢ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_TransmitPDU(void)
{
    g_txCanMsg.id = ID_ResAddr;

    if(N_US_S_MultiData.ind.N_Result == N_OK)//no use
    {
        if(N_US_S_Data_FF.ind.N_PCI == null)
        {
            g_txCanMsg.msg[0] = (INT8U)N_US_S_MultiData.ind.Length;
            (void)App_CopyRam((INT8U *)&g_txCanMsg.msg[1], (INT8U *)&N_US_S_MultiData.ind.MsgData[0], 7);

            LK_FillMsg((INT8U *)&g_txCanMsg.msg[0], N_FILL, N_US_S_MultiData.ind.Length + 1);

            MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)&g_txCanMsg.msg[0], 8);
            N_US_S_MultiData.ind.N_Result = STATE0;
        }
        else
        {
            if(N_US_S_Data_FF.ind.N_PCI == FirstFrame)
            {
                N_US_S_Data_FF.ind.N_PCI = FC_WAIT;

                g_txCanMsg.msg[0] = FirstFrame | (N_US_S_Data_FF.ind.Length >> 8);
                g_txCanMsg.msg[1] = (INT8U)N_US_S_Data_FF.ind.Length;

                (void)App_CopyRam((INT8U *)&g_txCanMsg.msg[2], (INT8U *)&N_US_S_MultiData.ind.MsgData[0], 6);

                MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)&g_txCanMsg.msg[0], 8);

                N_US_S_Data_FF.ind.N_SendSN = null;
                N_US_S_Data_FF.ind.pos = 6;
                TP_SetBsTimer(N_Bs, (_DiagClock *)&DiagClock);
            }
            if(TP_STminTimerOver((_DiagClock *)&DiagClock))
            {
                if(N_US_S_Data_FF.ind.N_PCI == ConsecutiveFrame)
                {
                    (void)App_CopyRam((INT8U *)&g_txCanMsg.msg[1], (INT8U *)&N_US_S_MultiData.ind.MsgData[ N_US_S_Data_FF.ind.pos ], 7);

                    N_US_S_Data_FF.ind.N_SendSN ++;
                    N_US_S_Data_FF.ind.N_FC_Num ++;

                    if(N_US_S_Data_FF.ind.N_BS)
                    {
                        N_US_S_Data_FF.ind.N_BS_CNT ++;
                        if(N_US_S_Data_FF.ind.N_BS_CNT >= N_US_S_Data_FF.ind.N_BS)
                        {
                            N_US_S_Data_FF.ind.N_PCI = FC_WAIT;
                            TP_SetBsTimer(N_Bs, (_DiagClock *)&DiagClock);
                        }
                    }
                    if(N_US_S_Data_FF.ind.N_SendSN > 0x0F)
                    {
                        N_US_S_Data_FF.ind.N_SendSN = 0;
                    }
                    N_US_S_Data_FF.ind.pos += 7;
                    if(N_US_S_Data_FF.ind.pos >= N_US_S_Data_FF.ind.Length)
                    {
                        N_US_S_Data_FF.ind.N_PCI = null;
                        N_US_S_MultiData.ind.N_Result = STATE0;
                        if(((N_US_S_Data_FF.ind.Length - 6) % 7) != null)
                        {
                            LK_FillMsg((INT8U *)&g_txCanMsg.msg[0], N_FILL, ((N_US_S_Data_FF.ind.Length - 6) % 7) + 1);
                        }
                    }
                    else
                    {
                        if(N_US_S_Data_FF.ind.N_BS)
                        {
                            if(N_US_S_Data_FF.ind.N_FC_Num == N_US_S_Data_FF.ind.N_BS)
                            {
                                N_US_S_Data_FF.ind.N_PCI = FC_WAIT;
                                TP_SetBsTimer(N_Bs, (_DiagClock *)&DiagClock);
                            }
                        }
                    }

                    g_txCanMsg.msg[0] = ConsecutiveFrame | N_US_S_Data_FF.ind.N_SendSN;
                    MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)&g_txCanMsg.msg[0], 8);

                    TP_SetSTminTimer(DiagnoCtl.N_STmin, (_DiagClock *)&DiagClock);
                }
            }
        }
    }
  
    //-- ȷʽ --//
    if(N_RSPData.ind.N_Result == N_OK)
    {
        N_RSPData.ind.N_Result = STATE0;//1

        (void)App_CopyRam((INT8U *)&g_txCanMsg.msg[0], (INT8U *)&N_RSPData.ind.MsgData[0], 8);

        LK_FillMsg((INT8U *)&g_txCanMsg.msg[0], N_FILL, N_RSPData.ind.len);

        MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)g_txCanMsg.msg, 8);//
    }

    TP_TransmitNegatePDU((_ErrorFrame *)&Error);//ش
}
/*-------------------------------------------------------------------------
* Function Name  : TP_TransmitNegatePDU                        Ӧ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_TransmitNegatePDU(_ErrorFrame *Err)
{
    if(Err->FrameErr)
    {
        if(N_US_R_Data_FF.ind.N_SID == Err->RespSerId)
        {
            N_US_R_Data_FF.ind.Length = null;
            N_US_R_Data_FF.ind.N_SID = null;
        }
        if(Err->N_TAtype == ID_PhyPGN)//Ѱַ--ظ
        {
            g_txCanMsg.id = ID_ResAddr;
            g_txCanMsg.msg[0] = 3;
            g_txCanMsg.msg[1] = NegativeId;   //7F
            g_txCanMsg.msg[2] = Err->RespSerId;//ID-27
            g_txCanMsg.msg[3] = Err->FrameErr; //0x35
            g_txCanMsg.msg[4] = N_FILL;       //0x55
            g_txCanMsg.msg[5] = N_FILL;       //0x55
            g_txCanMsg.msg[6] = N_FILL;       //0x55
            g_txCanMsg.msg[7] = N_FILL;       //0x55
            g_txCanMsg.dlc = 8;
            MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)g_txCanMsg.msg, 8);
        }
        if(((Err->N_TAtype == ID_FunPGN) ) && \
            (Err->FrameErr != ServiceNotSupported) && \
            (Err->FrameErr != SubFunctionNotSupported) && \
            (Err->FrameErr != RequestOutOfRange))
        {
            g_txCanMsg.id = ID_ResAddr;
            g_txCanMsg.msg[0] = 3;
            g_txCanMsg.msg[1] = NegativeId;
            g_txCanMsg.msg[2] = Err->RespSerId;
            g_txCanMsg.msg[3] = Err->FrameErr;
            g_txCanMsg.msg[4] = N_FILL;
            g_txCanMsg.msg[5] = N_FILL;
            g_txCanMsg.msg[6] = N_FILL;
            g_txCanMsg.msg[7] = N_FILL;
            g_txCanMsg.dlc = 8;
            MSCAN_SendFrame((INT32U)g_txCanMsg.id, (INT8U *)g_txCanMsg.msg, 8);
        }
        Err->FrameErr = Disable;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : TP_CalMsgLen
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U TP_CalMsgLen(INT16U BIT_DATA, INT8U SnLoop)
{
    INT16U wTemp;
    INT8U len;
    INT8U i;
    len = 0;
    wTemp = BIT_DATA;
    for(i = 0; i <= 15; i++)
    {
        if(wTemp & 0x0001)
        {
            len += 7;
        }
        wTemp = wTemp >> 1;
    }
    if(SnLoop == 0)
    {
        len -= 1;
    }

    return len;
}

/*-------------------------------------------------------------------------
* Function Name  : TP_SetCrTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_SetCrTimer(INT32U Second, _DiagClock *T)
{
    T->TT_CrEnable = Enable;
    T->OverCrTime = Second;
    T->CrTime = null;
}

/*-------------------------------------------------------------------------
* Function Name  : Api_TTimerOver2
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U TP_CrTimerOver(_DiagClock *T)
{
    if((T->CrTime >= T->OverCrTime) && (T->TT_CrEnable))
    {
        T->TT_CrEnable = Disable;
        T->CrTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_SetSTminTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_SetSTminTimer(INT32U Second, _DiagClock *T)
{
    T->TT_STminEnable = Enable;
    T->OverSTminTime = Second;
    T->STminTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : TP_STminTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U TP_STminTimerOver(_DiagClock *T)
{
    if((T->STminTime >= T->OverSTminTime) && (T->TT_STminEnable))
    {
        T->TT_STminEnable = Disable;
        T->STminTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : TP_SetBsTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void TP_SetBsTimer(INT32U Second, _DiagClock *T)
{
    T->TT_BsEnable = Enable;
    T->OverBsTime = Second;
    T->BsTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : TP_BsTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U TP_BsTimerOver(_DiagClock *T)
{
    if((T->BsTime >= T->OverBsTime) && (T->TT_BsEnable))
    {
        T->TT_BsEnable = Disable;
        T->BsTime = null;
        return 1;
    }
    else
    {
        return 0;
    }
}