#define	 GLOBALS_DTC_HAND
#include "dtc_handle.h"
#include "app_Service.h"
#include "user_def.h"
#include "../bsp_Headers/bsp_CAN.h"
#include "uds_def.h"
#include "g_includes.h"

volatile       _DTC_StatusRecord     DtcAndStatus[ 11 ];//ȡDTC
volatile       _DTC                  DiagDtc[ 11 ]; //DTCϢ
volatile       _SaveDtcInfo          SaveDtcInfo;

#define DTCBASEADDR 128
#define SNAPBASEADDR 432

//
const _DTC_MAP_INFO dtc_map_info[11] =
{
    //DtcNum  /DtcIndex   /Exist                         /DtcAddr  /SnapPageAddr
    0x910013, EE_FuelOpen, 	1, EEPROM_BLOCK_DTC_COUNTER1, 0x00, 0, 0x00,
    0x910117, EE_VoltHigh, 	1, EEPROM_BLOCK_DTC_COUNTER1, 0x10, 0, 0x00,
    0x910216, EE_VoltLow,   1, EEPROM_BLOCK_DTC_COUNTER1, 0x20, 0, 0x00,
    0x910313, EE_OBDErr , 	1, EEPROM_BLOCK_DTC_COUNTER1, 0x30, 0, 0x00,
    0x910413, EE_EPCErr,  	1, EEPROM_BLOCK_DTC_COUNTER1, 0x40, 0, 0x00,
    0x910513, EE_ABSErr,  	1, EEPROM_BLOCK_DTC_COUNTER1, 0x50, 0, 0x00,
    0x910613, EE_AirBag,    1, EEPROM_BLOCK_DTC_COUNTER1, 0x60, 0, 0x00,
    0x910713, EE_TPMSErr,  	1, EEPROM_BLOCK_DTC_COUNTER1, 0x70, 0, 0x00,
    0x910813, EE_Safebelt, 	1, EEPROM_BLOCK_DTC_COUNTER1, 0x80, 0, 0x00,
    0x910913, EE_BrakeErr, 	1, EEPROM_BLOCK_DTC_COUNTER1, 0x90, 0, 0x00,
    0xD10188, EE_BusOff,  	1, EEPROM_BLOCK_DTC_COUNTER1, 0xA0, 0, 0x00,  
};
/*-------------------------------------------------------------------------
*	Function Name	 : CheckBusoffDTC
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void CheckBusoffDTC(void)
{
    if((CAN0RFLG_TSTAT == 0x03) || (CAN0RFLG_RSTAT == 0x03))
    {
        DiagDtc[ EE_BusOff ].PassTimes = 0;
        if(g_canClock.BusOffTime == null)
        {
            if(g_canClock.BusOffCn < 255)
            {
                g_canClock.BusOffCn ++;
            }
            if(g_canClock.BusOffCn >= 1)
            {
                g_canClock.BusOffTime = T1_100ms;
            }
            if(g_canClock.BusOffCn >= 2)
            {
                DiagDtc[ EE_BusOff ].ErrorTimes = 10;
            }
            CAN0MISC_BOHOLD = ClearFlag;
            CAN0TARQ_ABTRQ = CAN0TBSEL;
            
            g_canClock.CanDataTime = T_96ms;
            g_canClock.CanKeepTime = T_1s;
        }
        else
        {
            CAN0TARQ_ABTRQ = 0x07;
            g_canClock.CanDataTime = null;
            g_canClock.CanKeepTime = null;
        }
        if(g_canClock.BusOffTime > null)
        {
            g_canClock.BusOffTime --;
        }
    }
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_Load_DTC
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_Load_DTC(void)
{
    INT8U	 check = null;
    INT8U	 i;
    INT8U	 len;
    _DTC	 DtcRead;

    len	=	sizeof(dtc_map_info) / sizeof(_DTC_MAP_INFO);

    for(i	=	0; i	<	len; i++)
    {
        //liuzhuzd
        (void)bsp_IIC_ReadPage(dtc_map_info[i].DtcBlock, dtc_map_info[i].DtcAddr, (INT8U *)&DtcRead, sizeof(_DTC));
        //Read_NdataFr_EEPROM(dtc_map_info[i].DtcBlock, dtc_map_info[i].DtcAddr, (INT8U*)&DtcRead, sizeof(_DTC));
        check	=	Api_CreateCRCCheckSum((INT8U *)&DtcRead, Register_Len - 2);
        if(check ==	DtcRead.bCheckSun)
        {
            if(DtcRead.DtcNum.Num	== dtc_map_info[ i ].DtcNum)
            {
                Api_CopyRam((INT8U *)&DiagDtc[	dtc_map_info[	i	].DtcIndex ], (INT8U *)&DtcRead, sizeof(_DTC));
            }
        }
    }
}

extern INT16U AD_CheckKL30;
//extern _CanClock g_canClock;
extern INT16U AD_ExtTemprature;
extern INT16U AD_Fuel;
extern INT16U AD_Steering;
/*-------------------------------------------------------------------------
*	Function Name	 : Diag_DTC_Check_main
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void Diag_DTC_Check_main(void)
{
    INT8U  i;
    INT8U  len;

    len = sizeof(dtc_map_info) / sizeof(_DTC_MAP_INFO);

    if(DiagnoCtl.DTCSettingType == DtcSetOn)
    {
        if(((DiagnoCtl.CommCtl == SubEnableRxAndTx) || (DiagnoCtl.CommCtl == SubEnableRxAndDisTx)) &&
                ((g_adcResult.AdcValue > V_7v) && (g_adcResult.AdcValue <= V_16v)))//2020-10-08 ѹ8V7V(Ĺ)
        {
            //------------------------- busoff -----------------------------------
            if(g_canClock.BusOffCn)
            {
                if(g_canClock.BusOffCn >= 2)
                {
                    DiagDtc[ EE_BusOff ].ErrorTimes = 10;
                }
                DiagDtc[ EE_BusOff ].PassTimes = 0;
            }
            else if(DiagDtc[ EE_BusOff ].PassTimes >= 3)
            {
                DiagDtc[ EE_BusOff ].ErrorTimes = 0;                                                  
            }   
        }
        //ȼͱ·
        if(g_FuelState == FuelSensorOpenCircuit)
        {
            DiagDtc[ EE_FuelOpen ].ErrorTimes = 10;
            DiagDtc[ EE_FuelOpen ].PassTimes  = 0;
        }
        else 
        {
            DiagDtc[ EE_FuelOpen ].PassTimes  = 5;
            DiagDtc[ EE_FuelOpen ].ErrorTimes = 0;
        }        
        //ѹ
        if (g_adcResult.AdcValue < V_7v)   //2020-10-08 ѹ8V7V(Ĺ)
        {
            DiagDtc[ EE_VoltLow ].ErrorTimes = 10;
            DiagDtc[ EE_VoltLow ].PassTimes = 0;
        }
        else if ((g_adcResult.AdcValue > V_8v))  
        {
            DiagDtc[ EE_VoltLow ].PassTimes = 5;
            DiagDtc[ EE_VoltLow ].ErrorTimes = 0;
        }
        //ѹ
        if (g_adcResult.AdcValue > V_16v)   
        {
            DiagDtc[ EE_VoltHigh ].ErrorTimes = 10;
            DiagDtc[ EE_VoltHigh ].PassTimes = 0;
        }
        else if ((g_adcResult.AdcValue < V_15_5v))  
        {
            DiagDtc[ EE_VoltHigh ].PassTimes = 5;
            DiagDtc[ EE_VoltHigh ].ErrorTimes = 0;
        }
       //ŷŹOBD

            DiagDtc[ EE_OBDErr ].PassTimes = 5;
            DiagDtc[ EE_OBDErr ].ErrorTimes = 0;
        
        //EPCָʾƹ

            DiagDtc[ EE_EPCErr ].PassTimes = 5;
            DiagDtc[ EE_EPCErr ].ErrorTimes = 0;
         
        //ABS

            DiagDtc[ EE_ABSErr ].PassTimes = 5;
            DiagDtc[ EE_ABSErr ].ErrorTimes = 0;
        
        //ȫ

            DiagDtc[ EE_AirBag ].PassTimes = 5;
            DiagDtc[ EE_AirBag ].ErrorTimes = 0;
        
        //̥ѹ

            DiagDtc[ EE_TPMSErr ].PassTimes = 5;
            DiagDtc[ EE_TPMSErr ].ErrorTimes = 0;
        
        //ȫ

            DiagDtc[ EE_Safebelt ].PassTimes = 5;
            DiagDtc[ EE_Safebelt ].ErrorTimes = 0;
        
        //ƶ

            DiagDtc[ EE_BrakeErr ].PassTimes = 5;
            DiagDtc[ EE_BrakeErr ].ErrorTimes = 0;
                
     
        for(i	=	0; i	<	len; i++)
        {
            if(dtc_map_info[ i ].Exist)
            {
                App_DtcBit_handle(DiagDtc, FALSE, DiagSnap, i);
            }
        }
    }

}

/*-------------------------------------------------------------------------
*	Function Name	 : App_DTCCount_handle
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
INT16U App_DTCCount_handle(INT8U mask)
{
    INT8U	count	=	null;
    INT8U	 i;
    INT8U	 len;

    len	=	sizeof(dtc_map_info) / sizeof(_DTC_MAP_INFO);

    for(i	=	0; i	<	len; i++)
    {
        if(dtc_map_info[ i ].Exist)
        {
            count	+= App_CheckDtcStatus(mask, (_DTC *)&DiagDtc[	i	]);
        }
    }

    return count;
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_DtcBit_handle
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_DtcBit_handle(volatile _DTC DTC[], INT8U SignalLed, volatile _SnapShot Snap[], INT8U pos)
{
    if(g_curkeyinput == 1)
    {
        if(DiagnoCtl.tDiagStart >= T_0_9s)
        {
            if(DTC[pos].ErrorTimes >= 10)
            {
                if((DTC[pos].Status.Bits.PendingDTC	== 0)	&& (DTC[pos].FaultPendingCntStar ==	0))
                {
                    DTC[pos].FaultPendCount	=	1;
                    DTC[pos].FaultPendingCntStar = 2;
                }
                                                           //09
                DTC[pos].Status.Bits.TestFailedThisOprCyc	=	0;				//bit1
                DTC[pos].Status.Bits.PendingDTC						=	0;				//bit2
                DTC[pos].Status.Bits.ConfirmedDTC					=	1;				//bit3
                DTC[pos].Status.Bits.TestNotCompLastClr		=	0;				//bit4
                DTC[pos].Status.Bits.TestFailedLastClr		=	0;				//bit5
                DTC[pos].Status.Bits.TestNotCompThisCyc		=	0;				//bit6

                if(DTC[pos].Status.Bits.TestFailed ==	0)
                {
                    if(DTC[pos].FaultOccurCount	<	255)
                    {
                        DTC[pos].FaultOccurCount ++;
                    }
                    DTC[pos].Status.Bits.TestFailed						=	1;				//bit0
                    App_Snap_handle((_SnapShot *)&Snap[pos], (_DTC *)&DTC[pos]);
                }

                DTC[pos].DTCAgingCount = 0;
                DTC[pos].DTCAgingCntStar = 0;
            }
            if(DTC[pos].PassTimes	>= 5)
            {
                DTC[pos].Status.Bits.TestNotCompLastClr   = 0;  //08
                DTC[pos].Status.Bits.TestNotCompThisCyc		=	0;
                DTC[pos].Status.Bits.TestFailed						=	0;				//bit0
            }
        }
        else
        {
            DTC[pos].PassTimes = 0;
            DTC[pos].ErrorTimes = 0;
            DTC[pos].Status.Bits.TestNotCompThisCyc   = 1;
            DTC[pos].Status.Bits.TestFailed           = 0;        //bit0
        }
        if(DTC[pos].Status.Bits.TestFailed)
        {
            DTC[pos].Status.Bits.WarnIndicatorReq	=	SignalLed;
        }
        else
        {
            DTC[pos].Status.Bits.WarnIndicatorReq	=	0;
        }
    }
    if(g_curkeyinput ==	KeyOFF)
    {
        if(DTC[pos].Status.Bits.TestNotCompThisCyc ==	0)//TEST COMPLETE
        {
            DTC[pos].Status.Bits.TestNotCompThisCyc	=	1;
            if(DTC[pos].Status.Bits.TestFailedThisOprCyc ==	0) //this	opt	cycle	test ok
            {
                DTC[pos].Status.Bits.PendingDTC	=	0;
                if(DTC[pos].FaultPendCount)
                {
                    DTC[pos].FaultPendCount	 = 0;
                    DTC[pos].FaultPendingCntStar = 0;
                    DTC[pos].DTCAgingCntStar = 1;
                }
                if(DTC[pos].DTCAgingCntStar	== 1)
                {
                    DTC[pos].DTCAgingCount ++;
                }
            }
            else
            {
                if(DTC[pos].FaultPendingCntStar	== 1)
                {
                    if(DTC[pos].FaultPendCount < 255)
                    {
                        DTC[pos].FaultPendCount	++;
                    }
                }
                if(DTC[pos].FaultPendingCntStar	== 2)
                {
                    DTC[pos].FaultPendingCntStar = 1;
                }
            }
        }
    }

    if(DTC[pos].DTCAgingCount	>= 40)
    {
        DTC[pos].DTCAgingCount = null;
        DTC[pos].FaultOccurCount = null;
        DTC[pos].FaultPendCount	=	null;

        DTC[pos].DTCAgingCntStar = 0;
        DTC[pos].FaultPendingCntStar = 0;

        if(DTC[pos].Status.Bits.ConfirmedDTC)
        {
            DTC[pos].Status.Bits.ConfirmedDTC	=	0;

            if(DTC[pos].DTCAgedCount < 255)
            {
                DTC[pos].DTCAgedCount	++;
            }
        }
        App_CheckDtc_Store(&dtc_map_info[ pos ], (_DTC *)&DiagDtc[ pos ]);
    }
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_GetSnap
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
 _SnapShot *App_GetSnap(_SnapShot *SnapBuf, volatile _DTC DTC[], volatile _SnapShot LocalSnap[], INT8U pos)
{
    INT8U	 check;
     _SnapShot	*RetSnap;

    check	=	Api_CreateCRCCheckSum((INT8U *)&LocalSnap[pos], sizeof(_SnapShot) - 2);

    if((LocalSnap[pos].bCheckSun ==	check) &&	(LocalSnap[pos].SnapShotNum	== 1))
    {
        RetSnap	=(_SnapShot	*)&LocalSnap[pos];
    }
    else
    {
        //App_ReadSnapInfo(dtc_map_info[ pos ].SnapBlock, dtc_map_info[ pos ].SnapAddr, (INT8U *)SnapBuf);
        check	=	Api_CreateCRCCheckSum((INT8U *)SnapBuf, sizeof(_SnapShot) - 2);

        if((SnapBuf->bCheckSun ==	check) &&	(SnapBuf->SnapShotNum	== 1))
        {
            RetSnap	=	SnapBuf;
        }
        else
        {
            SnapBuf->NumAndStatus	=	DTC[pos].DtcNum.Num;
            SnapBuf->NumAndStatus	=	SnapBuf->NumAndStatus	<< 8;
            SnapBuf->NumAndStatus	|= DTC[pos].Status.Flag;
            SnapBuf->SnapShotNum = 1;
            SnapBuf->SnapShotNumIde	=	4;

            SnapBuf->TimestampIdeH = 0xf1;
            SnapBuf->TimestampIdeL = 0x20;
            SnapBuf->TimeYear = 2017;//tm.Time_Year;
            SnapBuf->TimeYear = 3;//tm.Time_Month;
            SnapBuf->TimeYear = 25;//tm.Time_Date;
            SnapBuf->TimeYear = 14;//tm.Time_Hour;
            SnapBuf->TimeYear = 0;//tm.Time_Min;
            SnapBuf->TimeYear = 0;//tm.Time_Sec;

            SnapBuf->ODOIdeH	=	0xf1;
            SnapBuf->ODOIdeL	=	0x21;
            SnapBuf->ODOByte2	=	((g_accKm.LongAccKm / 10) >> 16) & 0xff;
            SnapBuf->ODOByte1	=	((g_accKm.LongAccKm / 10) >> 8) & 0xff;
            SnapBuf->ODOByte0	=	(g_accKm.LongAccKm / 10) & 0xff;


            SnapBuf->VoltIdeH	=	0xf1;
            SnapBuf->VoltIdeL	=	0x22;
            SnapBuf->Volt = (INT8U)(ACC / 10);

            SnapBuf->IGNIdeH = 0xf1;
            SnapBuf->IGNIdeL = 0x23;


            SnapBuf->bFlag = 0x01;
            SnapBuf->bCheckSun = Api_CreateCRCCheckSum((INT8U *)SnapBuf, sizeof(_SnapShot)	-	2);

            RetSnap	=	SnapBuf;
        }
    }
    return RetSnap;
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_Snap_handle
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_Snap_handle(_SnapShot *Snap, _DTC *DTC)
{

    if((DTC->Status.Bits.PendingDTC) || (DTC->Status.Bits.ConfirmedDTC))
    {
        Snap->NumAndStatus = DTC->DtcNum.Num;
        Snap->NumAndStatus = Snap->NumAndStatus	<< 8;
        Snap->NumAndStatus |=	DTC->Status.Flag;
        Snap->SnapShotNum	=	1;
        Snap->SnapShotNumIde = 4;

        Snap->TimestampIdeH = 0xf1;
        Snap->TimestampIdeL = 0x20;
        Snap->TimeYear = 2017;//tm.Time_Year;
        Snap->TimeYear = 3;//tm.Time_Month;
        Snap->TimeYear = 25;//tm.Time_Date;
        Snap->TimeYear = 14;//tm.Time_Hour;
        Snap->TimeYear = 0;//tm.Time_Min;
        Snap->TimeYear = 0;//tm.Time_Sec;

        Snap->ODOIdeH	=	0xf1;
        Snap->ODOIdeL	=	0x21;
        Snap->ODOByte2	=	((g_accKm.LongAccKm / 10) >> 16) & 0xff;
        Snap->ODOByte1	=	((g_accKm.LongAccKm / 10) >> 8) & 0xff;
        Snap->ODOByte0	=	(g_accKm.LongAccKm / 10) & 0xff;


        Snap->VoltIdeH	=	0xf1;
        Snap->VoltIdeL	=	0x22;
        Snap->Volt = (INT8U)(ACC / 10);

        Snap->IGNIdeH = 0xf1;
        Snap->IGNIdeL = 0x23;


        Snap->bFlag	=	0x01;
        Snap->bCheckSun	=	Api_CreateCRCCheckSum((INT8U *)Snap, sizeof(_SnapShot)	-	2);
    }
}

/*-------------------------------------------------------------------------
*	Function Name	 : App_ErrorInfoInit
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_DtcInfoInit(_DTC *DTC, INT32U	DtcNum)
{
    DTC->bFlag = CheckFlag;
    DTC->DtcNum.Num = DtcNum;

    DTC->Status.Bits.TestFailed           = 0;        //bit0
    DTC->Status.Bits.TestFailedThisOprCyc = 0;        //bit1
    DTC->Status.Bits.PendingDTC           = 0;        //bit2
    DTC->Status.Bits.ConfirmedDTC         = 0;        //bit3
    DTC->Status.Bits.TestNotCompLastClr   = 1;        //bit4
    DTC->Status.Bits.TestFailedLastClr    = 0;        //bit5
    DTC->Status.Bits.TestNotCompThisCyc   = 1;        //bit6
    DTC->Status.Bits.WarnIndicatorReq     = 0;

    DTC->FaultOccurCount = null;
    DTC->FaultPendCount = null;
    DTC->DTCAgingCount = null;
    DTC->DTCAgedCount = null;

    DTC->FaultPendingCntStar = 0;
    DTC->DTCAgingCntStar = 0;

    DTC->PassTimes = 0;
    DTC->ErrorTimes = 0;
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_DTC_EEpromInit
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_DTC_EEpromInit(void)
{
    INT8U	check;
    INT8U	i;

    for(i	=	0; i	<	TotalDTCNum; i++)
    {
        App_DtcInfoInit((_DTC *)&DiagDtc[ i ], dtc_map_info[ i ].DtcNum);
    }
    App_Load_DTC();

    check	=	Api_CreateCRCCheckSum((INT8U *)&sid_27_Info, Register_Len - 2);
    if(check ==	sid_27_Info.bCheckSun)
    {
        DiagnoCtl.AccessCount	=	sid_27_Info.SAFC;
    }
    else
    {
        DiagnoCtl.AccessCount	=	null;
    }
}

/*-------------------------------------------------------------------------
*	Function Name	 : App_CheckDtcStatus
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
INT8U	App_CheckDtcStatus(INT8U mask, _DTC	*Dtc)
{
    if(g_curkeyinput ==	KeyON)
    {
        if(Dtc->Status.Flag	&	mask & DiagnoCtl.DTCByStatusMask)//Ϊ0x09
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
    else
    {
        if(Dtc->Status.Flag	&	mask & DiagnoCtl.DTCByStatusMask & 0x08)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
}

/*-------------------------------------------------------------------------
*	Function Name	 : App_CheckDtc_Store                                 DTC
*	Description		 :                                                16Byte/per
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_CheckDtc_Store(const _DTC_MAP_INFO	*mapInfo, volatile _DTC *dtc)
{
    if(mapInfo->Exist)
    {
        dtc->bFlag = 0x55;
        dtc->bCheckSun = Api_CreateCRCCheckSum((INT8U *)dtc, Register_Len - 2);

        g_bReturn = bsp_IIC_WritePage(mapInfo->DtcBlock, mapInfo->DtcAddr, (INT8U *)dtc, Register_Len);
    }
}
/*-------------------------------------------------------------------------
*	Function Name	 : App_StoreDTC_handle
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_StoreDTC_handle(void)
{
    INT8U	wtemp[16]	=	{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    if(DiagClock.E2_WriteTime	>= 5)
    {
        DiagClock.E2_WriteTime = null;

        if(SaveDtcInfo.EE_WriteDtcSel	== StoreDTC_EE) //洢
        {
                               //ַ                                       //Ϣ
            App_CheckDtc_Store(&dtc_map_info[ SaveDtcInfo.DtcStep ], (_DTC *)&DiagDtc[	SaveDtcInfo.DtcStep	]);

            SaveDtcInfo.DtcStep	++;

            if(SaveDtcInfo.DtcStep >=	MaxDtcNum)
            {
                SaveDtcInfo.EE_WriteDtcSel = Disable;
                SaveDtcInfo.DtcStep	=	null;
            }
        }
        else if(SaveDtcInfo.EE_WriteDtcSel ==	ClearDTC_EE)//
        {
            g_bReturn	=	bsp_IIC_WritePage(dtc_map_info[	SaveDtcInfo.DtcStep	].DtcBlock, dtc_map_info[	SaveDtcInfo.DtcStep	].DtcAddr,	(INT8U *)&wtemp, sizeof(_DTC));
            SaveDtcInfo.DtcStep	++;

            if(SaveDtcInfo.DtcStep >=	MaxDtcNum)
            {
                SaveDtcInfo.EE_WriteDtcSel = Disable;
                SaveDtcInfo.DtcStep	=	null;
            }
        }
    }
}

/*-------------------------------------------------------------------------
*	Function Name	 : App_StoreSnap_handle                              
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void App_StoreSnap_handle(void)
{
   //--  --//
}
/*-------------------------------------------------------------------------
*	Function Name	 : bsp_Delay2                             
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void bsp_Delay2(INT32U time)
{
    INT32U i;

    for(i = 0; i <= time; i++)
    {
        asm NOP;
        _FEED_COP();
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_WriteSnap                                    
* Description    :                                                
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void App_WriteSnap(INT8U Block, INT8U  MemAdd, INT8U *Data)
//{
   //--  --//
//}
/*-------------------------------------------------------------------------
*	Function Name	 : App_ReadSnapInfo
*	Description		 :
*	Input					 :
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
//void App_ReadSnapInfo(INT8U Block, INT8U	 MemAdd, INT8U *Data)
//{
   //--  --//
//}
