/*
 * api_CAN.c
 *
 *  Created on: Aug 8, 2014
 *      Author: QTC
 */

#define GLOBALS_API_CAN
#include "defines.h"
#include "g_includes.h"
/*-------------------------------------------------------------------------
 * Function Name  : App_ReceiveCanMsg
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void App_ReceiveCanMsg(void)
{
	INT32U ECMDtc_Can;
	INT32U ABSDtc_Can;
	INT32U DCUDtc_Can;

	INT32U wTemp = null;
	INT16U Can_Power_H;
	INT16U Can_Power_L;
	INT16U Can_Power;

	//--------- Meter Signal ---------//
	//0x0CF00400  ת  Engine_speed
	if (g_canMsg61444.ProceF == MSG_FULL)
	{
		g_revMeter.CurBoardVal = ((INT16U)g_canMsg61444.Data[4]) << 8;
		g_revMeter.CurBoardVal = g_revMeter.CurBoardVal | ((INT16U)g_canMsg61444.Data[3]);

		if (g_revMeter.CurBoardVal == 0xffff)
		{
			g_revMeter.CurBoardVal = 0;
		}
		else
		{
			g_revMeter.CurBoardVal = g_revMeter.CurBoardVal >> 3;
		}

		g_canMsg61444.ProceF = EMPOTY;
	}

	//0x18FEF200 ͺ
	if (g_canMsg65266.ProceF == MSG_FULL)
	{
		//T,100ms   unit,L/h    --convert uL    Engine_fuel_rate   "Engine Fuel Rate ȼ (Сʱͺ)"
		wTemp = g_canMsg65266.Data[1];
		wTemp = (wTemp << 8) | g_canMsg65266.Data[0];
		Sum_FuelConsumption = Sum_FuelConsumption + (wTemp * 50 / 36);
		FuelConsumption = FuelConsumption + (wTemp * 50 / 36);

		//Engine Instantaneous Fuel Economy    "Engine Instantaneous Fuel Economy ȼ;ԣ˲ʱͺģ"  1/512    2 16   16

		//FlEco "Engine Average Fuel Economy ƽȼ;ԣƽͺģ"  1/512    4 32    16

		g_canMsg65266.ProceF = EMPOTY;
	}
	//0x18FEF500	65269
	if (g_canMsg65269.ProceF == MSG_FULL)
	{
		//"Cab Interior Temperature"  "Cab Interior Temperature ʻ¶ " 1 8 16 0.0313 -273

		//Ambient_Air_Temperature"  Temperature of air surrounding vehicle.¶" 3 24 16 0.0313 -273

		//Road Surface Temperature "Road Surface Temperature ·¶" 6 48 16  0.0313 -273

		g_canMsg65269.ProceF = EMPOTY;
	}

	//0x18FEEE00 ˮ
	if (g_canMsg65262.ProceF == MSG_FULL)
	{
		//ˮ Engine_colant_temperature
		if (g_canMsg65262.Data[0] != 255)
		{
			g_tempMeter.CurBoardVal = g_canMsg65262.Data[0];

			if (g_tempMeter.CurBoardVal > 40)
			{
				g_tempMeter.CurBoardVal = g_tempMeter.CurBoardVal - 40;
			}
			else
			{
				g_tempMeter.CurBoardVal = 0;
			}
		}

		//Engine Fuel Temperature 1 ȼ¶  1	8	8  1	-40
		if (g_canMsg65262.Data[1] != 255)
		{
			;
		}

		//Engine Oil Temperature 1 ¶ 2	16	16  0.03125	-273
		if (0)
		{
			;
		}

		g_canMsg65262.ProceF = EMPOTY;
	}

	//0x18FEFF00
	if (g_canMsg65279.ProceF == MSG_FULL)
	{
		//ˮ
		if ((g_canMsg65279.Data[0] & 0x03) == 0x01)
		{
			g_CanSwith.WIF = 1;
		}
		else
		{
			g_CanSwith.WIF = 0;
		}

		//ʻԱ()
		if ((g_canMsg65279.Data[1] & 0x07) == 0x01)
		{
			g_CanSwith.DriverWarn = S_on;
		}
		else if ((g_canMsg65279.Data[1] & 0x07) == 0x04)
		{
			g_CanSwith.DriverWarn = S_Flash;
		}
		else
		{
			g_CanSwith.DriverWarn = S_off;
		}

		//Com_stOperinduSev "Com_stOperinduSev   ŷյϵͳ"  1  13  3
		if ((g_canMsg65279.Data[1] & 0xE0) == 0x01)
		{
		}
		else
		{
		}

		g_canMsg65279.ProceF = EMPOTY;
	}

	//0x18FEE400  65252
	if (g_canMsg65252.ProceF == MSG_FULL)
	{
		//Ԥ
		if ((g_canMsg65252.Data[3] & 0x03) == 0x01)
		{
			g_CanSwith.PreHeat = 1;
		}
		else
		{
			g_CanSwith.PreHeat = 0;
		}

		//Engine Protection System has Shutdown Engine  "Engine Protection System has Shutdown Engine ϵͳʹͣ" 4 32 2

		g_canMsg65252.ProceF = EMPOTY;
	}

	//0x18FD7C00 64892
	if (g_canMsg64892.ProceF == MSG_FULL)
	{
		//DPFָʾ
		if ((g_canMsg64892.Data[0] & 0x07) == 1)
		{
			g_CanSwith.DPF = 1;
			g_CanSwith.DPFf = 0;
			g_CanSwith.DPF_Red = 0;
		}
		else if ((g_canMsg64892.Data[0] & 0x07) == 4)
		{
			g_CanSwith.DPFf = 1;
			g_CanSwith.DPF = 0;
			g_CanSwith.DPF_Red = 0;
		}
		else if ((g_canMsg64892.Data[0] & 0x07) == 2)
		{
			g_CanSwith.DPF_Red = 1;
			g_CanSwith.DPF = 0;
			g_CanSwith.DPFf = 0;
		}
		else
		{
			g_CanSwith.DPF = 0;
			g_CanSwith.DPFf = 0;
			g_CanSwith.DPF_Red = 0;
		}

		//¼ӽֹDPFָʾ
		if ((g_canMsg64892.Data[2] & 0x03) == 0x01)
		{
			g_CanSwith.InhibiteDPF = 1;
		}
		else
		{
			g_CanSwith.InhibiteDPF = 0;
		}

		//DPFֹ
		//if ((g_canMsg64892.Data[2] & 0x0C) == 0x01)
		//{
		//	g_CanSwith.InhibiteDPFONOFF = 1;
		//}
		//else
		//{
		//	g_CanSwith.InhibiteDPFONOFF = 0;
		//}

		//¶ȸָʾ
		if ((g_canMsg64892.Data[6] & 0x1c) == 0x04)
		{
			g_CanSwith.DpfHiTemp = 1;
		}
		else
		{
			g_CanSwith.DpfHiTemp = 0;
		}

		g_canMsg64892.ProceF = EMPOTY;
	}

	//64775  0x18FD0700
	if (g_canMsg64775_00.ProceF == MSG_FULL)
	{
		//EPC1 Engine Red Stop Lamp Command	Engine Red Stop Lamp Command	Intel	0	4	2	Unsigned
		if ((g_canMsg64775_00.Data[0] & 0x30) == 0x10)
		{
			g_CanSwith.EngFailure1 = 1;
		}
		else
		{
			g_CanSwith.EngFailure1 = 0;
		}

		//ŷŹOBD1  MIL	OBD Malfunction Indicator Lamp Command	Intel	0	6	2
		if ((g_canMsg64775_00.Data[0] & 0xC0) == 0x40)
		{
			g_CanSwith.EngMIL1 = 1;
		}
		else
		{
			g_CanSwith.EngMIL1 = 0;
		}

		//Engine Oil Pressure Low Lamp	"Engine Oil Pressure Low Lamp Command  ѹ͵"	Intel	1	12	2
		if ((g_canMsg64775_00.Data[1] & 0x30) == 0x10)
		{
			g_CanSwith.OilLamp1 = 1;
		}
		else
		{
			g_CanSwith.OilLamp1 = 0;
		}

		g_canMsg64775_00.ProceF = EMPOTY;
	}

	//0x18FD070F   64775
	if (g_canMsg64775_0F.ProceF == MSG_FULL)
	{
		g_canMsg64775_0F.ProceF = EMPOTY;
	}

	//0x18F0000F	61440
	if (g_canMsg61440_0F.ProceF == MSG_FULL)
	{
		g_canMsg61440_0F.ProceF = EMPOTY;
	}

	//ECM_ERC1	0x18F00000	61440	100	8
	if (g_canMsg61440_00.ProceF == MSG_FULL)
	{

		g_canMsg61440_00.ProceF = EMPOTY;
	}

	//ECM_ERC1	0x18F00029/0F/10	61440	100	8
	if (g_canMsg61440_29.ProceF == MSG_FULL)
	{
		g_canMsg61440_29.ProceF = EMPOTY;
	}

	if (g_canMsg61440_10.ProceF == MSG_FULL)
	{
		g_canMsg61440_10.ProceF = EMPOTY;
	}

	//ECM_CCVS	0x18FEF100	65265	100	8
	if (g_canMsg65265.ProceF == MSG_FULL)
	{
		//ѲЧλ
		if ((g_canMsg65265.Data[3] & 0x03) == 0x01)
		{
			g_CanSwith.CruSysAct = 1;
		}
		else
		{
			g_CanSwith.CruSysAct = 0;
		}

		//Ѳֵ
		bCruiseSpeedCur = g_canMsg65265.Data[5];
		bCruiseSpeedCur = bCruiseSpeedCur + (bCruiseSpeedCur * 3) / 100 + 2;

		g_canMsg65265.ProceF = EMPOTY;
	}

	//ECM_EFL/P1	0x18FEEF00	65263	500	8
	if (g_canMsg65263.ProceF == MSG_FULL)
	{
		if (ConfigItem.EngConfig == 0x00)
		{
			if (g_canMsg65263.Data[3] < P_55kpa)
			{
				g_CanSwith.OilLamp = 1;
			}
			else if (g_canMsg65263.Data[3] > P_80kpa)
			{
				g_CanSwith.OilLamp = 0;
			}
		}
		else if (ConfigItem.EngConfig == 0x01)
		{
			if (g_canMsg65263.Data[3] < P_60kpa)
			{
				g_CanSwith.OilLamp = 1;
			}
			else if (g_canMsg65263.Data[3] > P_80kpa)
			{
				g_CanSwith.OilLamp = 0;
			}
		}
		else
		{
			g_CanSwith.OilLamp = 0;
		}

		g_canMsg65263.ProceF = EMPOTY;
	}

	//DM1	0x18FECA00	65226	1000	8
	if (g_canMsg65226ECM.ProceF == MSG_FULL)
	{
		//ŷŹOBD2
		if ((g_canMsg65226ECM.Data[0] & 0xC0) == 0x40)
		{
			g_CanSwith.EngMIL2 = 1;
		}
		else
		{
			g_CanSwith.EngMIL2 = 0;
		}
		//EPC2
		if ((g_canMsg65226ECM.Data[0] & 0x0C) == 0x04)
		{
			g_CanSwith.EngFailure2 = 1;
		}
		else
		{
			g_CanSwith.EngFailure2 = 0;
		}

		if ((g_canMsg65226ECM.Data[0] & 0x03) == 0x01) //2020/05/11ӵģͺ0XA:ȫƶͺ0XBȫҺƶByte1/bit1-2
		{
			g_CanSwith.EngFailure3 = 1;
		}
		else
		{
			g_CanSwith.EngFailure3 = 0;
		}

		//STOP2
		if ((g_canMsg65226ECM.Data[0] & 0x30) == 0x10)
		{
			g_CanSwith.STOP2 = 1;
		}
		else
		{
			g_CanSwith.STOP2 = 0;
		}

		EcmDtcTbl[0].bFMI = g_canMsg65226ECM.Data[4] & 0x1f;
		ECMDtc_Can = 0;
		//GET SPN
		ECMDtc_Can |= (g_canMsg65226ECM.Data[4] >> 5);
		ECMDtc_Can <<= 8;
		ECMDtc_Can |= g_canMsg65226ECM.Data[3];
		ECMDtc_Can <<= 8;
		ECMDtc_Can |= g_canMsg65226ECM.Data[2];
		EcmDtcTbl[0].dwSPN = ECMDtc_Can;

		g_canMsg65226ECM.ProceF = EMPOTY;
	}

	//EPS_DM1	0x18FECA13	65226	1000	8
	if (g_canMsg65226EPS.ProceF == MSG_FULL)
	{

		g_canMsg65226EPS.ProceF = EMPOTY;
	}

	//ECM_VD	0x18FEE000	65248	100	8
	if (g_canMsg65248.ProceF == MSG_FULL)
	{

		g_canMsg65248.ProceF = EMPOTY;
	}

	//ECM_IC1	0x18FEF600	65270	500	8
	if (g_canMsg65248.ProceF == MSG_FULL)
	{

		g_canMsg65248.ProceF = EMPOTY;
	}

	//ECM_AT1TI1	0x18FE5600 	65110	1000	8  //Һ_00
	if (g_canMsg65110_00.ProceF == MSG_FULL)
	{
		if (ConfigItem.AdblueConfig == 0)
		{
			g_adblueMeter.CurBoardVal = ((INT16U)g_canMsg65110_00.Data[0]) * 4;
		}

		g_canMsg65110_00.ProceF = EMPOTY;
	}

	//Һ_A3
	if (g_canMsg65110_A3.ProceF == MSG_FULL)
	{
		if (ConfigItem.AdblueConfig == 1)
		{
			g_adblueMeter.CurBoardVal = ((INT16U)g_canMsg65110_A3.Data[0]) * 4;
		}

		g_canMsg65110_A3.ProceF = EMPOTY;
	}

	//AT1T1	0x18FE563D	65110	1000	8
	if (g_canMsg65110_3D.ProceF == MSG_FULL)
	{

		g_canMsg65110_3D.ProceF = EMPOTY;
	}

	//AMT_ETC1	0x0CF00203	61442	10	8
	if (g_canMsg61442.ProceF == MSG_FULL)
	{

		g_canMsg61442.ProceF = EMPOTY;
	}

	//AMT-ETC2	0x18F00503	61445	100	8
	if (g_canMsg61445.ProceF == MSG_FULL)
	{

		g_canMsg61445.ProceF = EMPOTY;
	}

	//A1DEFI	0x18FD9BA3	64923	1000	8
	if (g_canMsg64923.ProceF == MSG_FULL)
	{

		g_canMsg64923.ProceF = EMPOTY;
	}

	//DCU_	0x18F00E51	61454	50	8
	if (g_canMsg61454_51.ProceF == MSG_FULL)
	{

		g_canMsg61454_51.ProceF = EMPOTY;
	}

	//DCU_	0x18F00F52	61455	50
	if (g_canMsg61454_52.ProceF == MSG_FULL)
	{

		g_canMsg61454_52.ProceF = EMPOTY;
	}

	//ABS_EBC2	0x18FEBF0B	65215	100	8
	if (g_canMsg65215.ProceF == MSG_FULL)
	{

		g_canMsg65215.ProceF = EMPOTY;
	}

	//ABS_EBC1	0x18F0010B	61441	100	8
	if (g_canMsg61441.ProceF == MSG_FULL)
	{
		//ABS 1
		if ((g_canMsg61441.Data[0] & 0x30) == 0x10)
		{
			g_CanSwith.ABSLamp1 = 1;
		}
		else
		{
			g_CanSwith.ABSLamp1 = 0;
		}
		//ABS 0
		if ((g_canMsg61441.Data[5] & 0x30) == 0x10)
		{
			g_CanSwith.ABSLamp = 1;
		}
		else
		{
			g_CanSwith.ABSLamp = 0;
		}
		/*
		//ASR
		if ((g_canMsg61441.Data[5] & 0xC0) == 0x40)
		{
			g_CanSwith.ASR = 1;
		}
		else
		{
			g_CanSwith.ASR = 0;
		}
		*/
		g_canMsg61441.ProceF = EMPOTY;
	}

	//EPS	0x18101713	4119	100	8
	if (g_canMsg04119.ProceF == MSG_FULL)
	{
		//ESPر
		if ((g_canMsg04119.Data[0] & 0x03) == 0x01)
		{
			g_CanSwith.ESPoff = 1;
		}
		else
		{
			g_CanSwith.ESPoff = 0;
		}
		g_canMsg04119.ProceF = EMPOTY;
	}

	//-- ̥ѹ --//
	App_ReceiveCanTireMsg();
}
/*-------------------------------------------------------------------------
 * Function Name  : App_ReceiveCanTireMsg
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void App_ReceiveCanTireMsg(void)
{
	/*
	if(g_canMsg65268.ProceF == MSG_FULL)
	{
		//TPMSϵͳ
		if((g_canMsg65268.Data[7] & 0x01) == 0x01)
		{
			g_CanSwith.TpmsFault = 1;
		}
		else
		{
			g_CanSwith.TpmsFault = 0;
		}
		//
		if((g_canMsg65268.Data[7] & 0x02) == 0x02)
		{
			g_CanSwith.TpmsLowBat = 1;
		}
		else
		{
			g_CanSwith.TpmsLowBat = 0;
		}
		//
		g_CanSwith.TempThreshold = (g_canMsg65268.Data[7]>>3) & 0x03;      
		//
		g_CanSwith.PressThreshold = (g_canMsg65268.Data[7]>>5) & 0x07;

		g_canMsg65268.ProceF = EMPOTY;
	}
	*/
}
/*-------------------------------------------------------------------------
 * Function Name  : App_K30ReceiveCanMsg
 * Description    :
 * Input          :
 * Output         : None
 * Return         : None
 * onther         :
 --------------------------------------------------------------------------*/
void App_K30ReceiveCanMsg(void)
{
	if (g_canMsg60439.ProceF == MSG_FULL)
	{
		//ת
		if ((g_canMsg60439.Data[0] & 0x18u) == 0x08u)
		{
			g_LightSts.RTurnSts = 1u;
		}
		else if ((g_canMsg60439.Data[0] & 0x18u) == 0x10u)
		{
			g_LightSts.RTurnSts = 2u;
		}
		else if ((g_canMsg60439.Data[0] & 0x18u) == 0x18u)
		{
			g_LightSts.RTurnSts = 3u;
		}
		else
		{
			g_LightSts.RTurnSts = 0u;
		}

		//ת
		if ((g_canMsg60439.Data[0] & 0x60u) == 0x20u)
		{
			g_LightSts.LTurnSts = 1u;
		}
		else if ((g_canMsg60439.Data[0] & 0x60u) == 0x40u)
		{
			g_LightSts.LTurnSts = 2u;
		}
		else if ((g_canMsg60439.Data[0] & 0x60u) == 0x60u)
		{
			g_LightSts.LTurnSts = 3u;
		}
		else
		{
			g_LightSts.LTurnSts = 0u;
		}

		//Σյ
		//if ((g_canMsg60439.Data[0] & 0x80u) == 0x80u)
		//{
		//	g_CanSwith.Hazard_Lights = 1u;
		//}
		//else
		//{
		//	g_CanSwith.Hazard_Lights = 0u;
		//}

		//Զ
		if ((g_canMsg60439.Data[1] & 0x02u) == 0x02u)
		{
			g_CanSwith.HighBeam = 1u;
		}
		else
		{
			g_CanSwith.HighBeam = 0u;
		}

		//
		if ((g_canMsg60439.Data[1] & 0x08u) == 0x08u)
		{
			g_CanSwith.LowBeam = 1u;
		}
		else
		{
			g_CanSwith.LowBeam = 0u;
		}

		//ǰſ
		if ((g_canMsg60439.Data[1] & 0x20u) == 0x20u)
		{
			g_CanSwith.DrDoorStae = 1u;
		}
		else
		{
			g_CanSwith.DrDoorStae = 0u;
		}

		//ǰſ
		if ((g_canMsg60439.Data[2] & 0x01u) == 0x01u)
		{
			g_CanSwith.PssDoorStae = 1u;
		}
		else
		{
			g_CanSwith.PssDoorStae = 0u;
		}

		//ſ
		if ((g_canMsg60439.Data[2] & 0x04u) == 0x04u)
		{
			g_CanSwith.RLDoorStae = 1u;
		}
		else
		{
			g_CanSwith.RLDoorStae = 0u;
		}

		//Һſ
		if ((g_canMsg60439.Data[2] & 0x10u) == 0x10u)
		{
			g_CanSwith.RRDoorStae = 1u;
		}
		else
		{
			g_CanSwith.RRDoorStae = 0u;
		}

		//ǰ
		if ((g_canMsg60439.Data[2] & 0x40u) == 0x40u)
		{
			g_CanSwith.FrontFog = 1u;
		}
		else
		{
			g_CanSwith.FrontFog = 0u;
		}

		//
		if ((g_canMsg60439.Data[3] & 0x01u) == 0x01u)
		{
			g_CanSwith.RearFog = 1u;
		}
		else
		{
			g_CanSwith.RearFog = 0u;
		}
		//λõ
		if ((g_canMsg60439.Data[3] & 0x04u) == 0x04u)
		{
			g_CanSwith.PosLamp = 1u;
		}
		else
		{
			g_CanSwith.PosLamp = 0u;
		}

		//
		if ((g_canMsg60439.Data[3] & 0x10u) == 0x10u)
		{
			g_CanSwith.RadioFre = 1u;
		}
		else
		{
			g_CanSwith.RadioFre = 0u;
		}

		//KEY IN
		if ((g_canMsg60439.Data[3] & 0x40u) == 0x40u)
		{
			//g_CanSwith.RadioFre = 1u;
		}
		else
		{
			//g_CanSwith.RadioFre = 0u;
		}

		//Կλ
		if ((g_canMsg60439.Data[4] & 0x03u) == 0x01u)
		{
			//g_CanSwith.RadioFre = 1u;
		}
		else
		{
			//g_CanSwith.RadioFre = 0u;
		}

		g_canMsg60439.ProceF = EMPOTY;
	}
}
