

#define  GLOBALS_API_MOTOR
#include "defines.h"
#include "g_includes.h"



/*-------------------------------------------------------------------------
* Function Name  : bsp_VehMotorDriv
* Description    :
* Input          : Position *Meter
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_VehMotorDriv(_MeterPos *Meter)
{
    if(Meter->Time > null)
        Meter->Time--;
    if(Meter->Time == null)
    {
        if(Meter->DestPosition > Meter->CurPosition)
        {
            Meter->Time = 2000 / (Meter->DestPosition - Meter->CurPosition) + Meter->StartTime;
            Meter->Dir = clockwise;
        }
        else if(Meter->DestPosition < Meter->CurPosition)
        {
            Meter->Time = 2000 / (Meter->CurPosition - Meter->DestPosition) + Meter->StartTime;
            Meter->Dir = widdershins;
        }
        else
        {
            Meter->StartTime = 6;
            Meter->Dir = keep_local;
        }

        if(Meter->Time <= 2)
            Meter->Time = 2;

        if(Meter->MotorFirstReset)
        {
            Meter->Dir = widdershins;
            if(Meter->CurPosition > 4000)
            {
                Meter->Time = 3;
            }
            else if((Meter->CurPosition > 3700) && (Meter->CurPosition <= 4000))
            {
                Meter->Time = 2;
            }
            else if((Meter->CurPosition > 1000) && (Meter->CurPosition <= 3700))
            {
                Meter->Time = 2;
            }
            else
            {
                Meter->Time = 1;
            }
        }
        else if(Meter->MotorReset)
        {
            Meter->Dir = widdershins;
            Meter->Time = 3;
        }

        if(Meter->DestPosition > Meter->CurPosition)
        {
            if(Meter->Time >= 1000)
                Meter->Time = 1000;
        }
        else
        {
            if(Meter->CurBoardVal)
            {
                if(Meter->Time >= 450) Meter->Time = 450;
            }
            else
            {
                if(Meter->Time >= 160) Meter->Time = 160;
            }
        }

        if(g_sysFlag.Bits.AdjEnable)
        {
            Meter->Time = 8;
        }

        if(Meter->Dir == clockwise)
        {
            if(Meter->bPhase == null)
                Meter->bPhase = 24;


            Meter->bPhase--;
            MCDC2  = SinTalbe[Meter->bPhase];
            MCDC3  = CosTalbe[Meter->bPhase];

            if(Meter->CurPosition < Meter->DestPosition)
            {
                Meter->CurPosition++;
            }
            if(Meter->StartTime)
            {
                Meter->StartTime --;
            }
        }

        if(Meter->Dir == widdershins)
        {
            if(Meter->bPhase == 24)      //0->23
                Meter->bPhase = null;


            MCDC2  = SinTalbe[Meter->bPhase];
            MCDC3  = CosTalbe[Meter->bPhase];
            Meter->bPhase ++;
            if(Meter->CurPosition > Meter->DestPosition)
            {
                Meter->CurPosition--;
            }
            if(Meter->StartTime)
            {
                Meter->StartTime --;
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_RevMotorDriv
* Description    :
* Input          : Position *Meter
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_RevMotorDriv(_MeterPos *Meter)
{
    if(Meter->Time > null)
        Meter->Time--;
    if(Meter->Time == null)
    {
        if(Meter->DestPosition > Meter->CurPosition)
        {
            Meter->Time = 2000 / (Meter->DestPosition - Meter->CurPosition) + Meter->StartTime;
            Meter->Dir = clockwise;
        }
        else if(Meter->DestPosition < Meter->CurPosition)
        {
            Meter->Time = 2000 / (Meter->CurPosition - Meter->DestPosition) + Meter->StartTime;
            Meter->Dir = widdershins;
        }
        else
        {
            Meter->StartTime = 6;
            Meter->Dir = keep_local;
        }

        if(Meter->Time <= 2)
            Meter->Time = 2;

        if(Meter->MotorFirstReset)
        {
            Meter->Dir = widdershins;
            if(Meter->CurPosition > 4000)
            {
                Meter->Time = 3;
            }
            else if((Meter->CurPosition > 3700) && (Meter->CurPosition <= 4000))
            {
                Meter->Time = 2;
            }
            else if((Meter->CurPosition > 1000) && (Meter->CurPosition <= 3700))
            {
                Meter->Time = 2;
            }
            else
            {
                Meter->Time = 1;
            }
        }
        else if(Meter->MotorReset)
        {
            Meter->Dir = widdershins;
            Meter->Time = 2;
        }

        if(Meter->DestPosition > Meter->CurPosition)
        {
            if(Meter->Time >= 1000)
                Meter->Time = 1000;
        }
        else
        {
            if(Meter->CurBoardVal)
            {
                if(Meter->Time >= 450) Meter->Time = 450;
            }
            else
            {
                if(Meter->Time >= 160) Meter->Time = 160;
            }
        }

        if(g_sysFlag.Bits.AdjEnable)
        {
            Meter->Time = 8;
        }

        if(Meter->Dir == clockwise)
        {
            if(Meter->bPhase == null)
                Meter->bPhase = 24;


            Meter->bPhase--;
            MCDC0 = SinTalbe[Meter->bPhase];
            MCDC1 = CosTalbe[Meter->bPhase];

            if(Meter->CurPosition < Meter->DestPosition)
            {
                Meter->CurPosition++;
            }
            if(Meter->StartTime)
            {
                Meter->StartTime --;
            }
        }

        if(Meter->Dir == widdershins)
        {
            if(Meter->bPhase == 24)      //0->23
                Meter->bPhase = null;


            MCDC0 = SinTalbe[Meter->bPhase];
            MCDC1 = CosTalbe[Meter->bPhase];
            Meter->bPhase ++;
            if(Meter->CurPosition > Meter->DestPosition)
            {
                Meter->CurPosition--;
            }
            if(Meter->StartTime)
            {
                Meter->StartTime --;
            }
        }
    }
}


/*-------------------------------------------------------------------------
* Function Name  : Api_SetMotorTimer
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_SetMotorTimer(INT16U Second, _Clock *T)
{
    T->TMotorEnable = Enable;
    T->OverMotorTime = Second;
    T->MotorTime = null;
}
/*-------------------------------------------------------------------------
* Function Name  : Api_BaseTimerOver
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U Api_MotorTimerOver(_Clock *T)
{
    if((T->MotorTime >= T->OverMotorTime) && (T->TMotorEnable))
    {
        T->TMotorEnable = Disable;
        return 1;
    }
    else
    {
        return 0;
    }
}