#ifndef  __API_FLASH_H
#define __API_FLASH_H



/* Error codes */
#define Ok          			0
#define ERASED      			1
#define NON_ERASED  			2
#define MISALIGNED_ADDRESS  	3
#define ACCESS_ERROR        	4
#define VERIFICATION_FAILED 	5
#define LENGTH_OUT_OF_RANGE 	6


#define DFLASH_FirstAddress 	0x100000                    //0x004400 (HY64)
#define DFLASH_APPvAddress 	    0x100000+256                //=0xA77A表示应用程序无效                   


#define APP_LOGICAL_ADDRESS         0xC000      //APP应用程序的 STARTUP 地址
#define BOOT_LOGICAL_ADDRESS         0xFC00      //APP应用程序的 STARTUP 地址



INT32U Local2Global(INT32U address);
INT32U Global2Local(INT32U address);
INT8U GET_Global_sector_PRG(INT32U address);
INT8U D_P_FLASH_Erase_Verify_Section(INT8U mTYPE, INT32U address, INT16U number_of_words);
INT8U D_P_FLASH_Program(INT8U mTYPE, INT32U  address, INT16U *ptr, INT8U number_of_words);
INT8U  D_P_FLASH_N_Program(INT8U mTYPE, INT32U  address, INT16U *ptr, INT8U number_of_words);
INT8U  PP_FLASH_N_Program(INT32U  address, INT8U *ptr, INT8U number_of_bytes);
INT8U  D_P_FLASH_Erase_Sector(INT8U mTYPE, INT32U  address);
INT16U DFLASH_Read_Word(INT32U  address);
void WRITE_BZ_inDFLAH2Sector(INT16U bz);
INT16U GetResetAddr_Word(void);
INT32U PFlash_Read (INT32U ADDR32);
INT32U PFlash_Near_Read (INT32U ADDR32);

#endif

