/*
* gui_Menu3rd.c
*
*  Created on: Aug 11, 2014
*      Author: QTC
*/


#define  GLOBALS_GUI_Menu3rd
#include "defines.h"
#include "g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoEnter_disp       3˵-Ϣλ-"ȷ/ȡ"
* Description    :                                            Ϣͬ
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoEnter_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        if(SetMeuMsg.OldMenu2Item == 1)
        {
            //--С̸λ
            Api_DrawImg2Icon(11, 14, Set_Menu3_XJLCFW_Title_Word2_x11_y14);
        }
        else if(SetMeuMsg.OldMenu2Item == 2)
        {
            //--̳ͺĸλ
            Api_DrawImg2Icon(8, 15, Set_Menu3_DCYHFW_Title_Word2_x08_y15);
        }
        else if(SetMeuMsg.OldMenu2Item == 3)
        {
            //--ƽͺĸλ
            Api_DrawImg2Icon(5, 13, Set_Menu3_PJYHFW_Title_Word2_x5_y13);
        }
        //--ȷ
        Api_DrawImg2Icon(98, 57, Set_Menu3_XJLCFW_01_Word2_x98_y57);
        //--ȡ
        Api_DrawImg2Icon(101, 94, Set_Menu3_XJLCFW_02_Word2_x101_y94);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        if(SetMeuMsg.OldMenu2Item == 1)
        {
            //С̸λ           Restablecer  viaje
            Api_DrawLetterIcon1(50, 14, "Restablecer", CharLetter3);
            Api_DrawLetterIcon1(154, 14, "viaje", CharLetter3);
        }
        else if(SetMeuMsg.OldMenu2Item == 2)
        {
            //̳ͺĸλ     Restablecer  Consumo de distancia corta
            Api_DrawLetterIcon1(8, 14, "Restablecer", CharLetter1);
            Api_DrawLetterIcon1(78, 14, "Consumo", CharLetter1);
            Api_DrawLetterIcon1(137, 14, "de", CharLetter1);
            Api_DrawLetterIcon1(153, 14, "distancia", CharLetter1);
            Api_DrawLetterIcon1(209, 14, "corta", CharLetter1);
        }
        else if(SetMeuMsg.OldMenu2Item == 3)
        {
            //ƽͺĸλ    Restablecer  Consumo promedio
            Api_DrawLetterIcon1(9, 14, "Restablecer", CharLetter2);
            Api_DrawLetterIcon1(95, 14, "consumo", CharLetter2);
            Api_DrawLetterIcon1(163, 14, "promedio", CharLetter2);
        }
        //ȷ   Confirmar
        Api_DrawLetterIcon(86, 57, "Confirmar", CharLetter2);
        
        //ȡ   Cancelar
        Api_DrawLetterIcon(89, 94, "Cancelar", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        if(SetMeuMsg.OldMenu2Item == 1)
        {
            //С̸λ      Tripmeter reset
            Api_DrawLetterIcon(53, 14, "Tripmeter", CharLetter3);
            Api_DrawLetterIcon(145, 14, "reset", CharLetter3);
        }
        else if(SetMeuMsg.OldMenu2Item == 2)
        {
            //̳ͺĸλ     Reset AFC(short range)
            Api_DrawLetterIcon(23, 14, "Reset", CharLetter3);
            Api_DrawIcon(77, 14, AFC);
            Api_DrawLetterIcon(115, 14, "(short", CharLetter3);
                               Api_DrawLetterIcon(171, 14, "range)", CharLetter3);
            
        }
        else if(SetMeuMsg.OldMenu2Item == 3)
        {
            //ƽͺĸλ    Reset AFC
            
            Api_DrawLetterIcon(70, 14, "Reset", CharLetter3);
            Api_DrawIcon(127, 14, AFC);
        }
        //ȷ   Confirm
        Api_DrawLetterIcon(93, 59, "Confirm", CharLetter2);
        
        //ȡ   Cancle
        Api_DrawLetterIcon(96, 95, "Cancle", CharLetter2);
    }
    else
    {
        if(SetMeuMsg.OldMenu2Item == 1)
        {
            Api_DrawImgIcon(40, 9, touxiaojilichengfuwei);
        }
        else if(SetMeuMsg.OldMenu2Item == 2)
        {
            Api_DrawImg2Icon(40, 9, touduanchengyouhaofuwei);
        }
        else if(SetMeuMsg.OldMenu2Item == 3)
        {
            Api_DrawImg2Icon(40, 9, toupingjunyouhaofuwei);
        }
        //ȷ
        Api_DrawImg2Icon(94, 55, queren);
        //ȡ
        Api_DrawImg2Icon(94, 91, quxiao);
    }
    SetMeuMsg.Menu3Item = 1;
    SetMeuMsg.OldMenu3Item = 0;
    SetMeuMsg.MenuCoordinate2 = 47;
    SetMeuMsg.MenuCoordinate3 = 47;    
    SetMeuMsg. Menu2ItemFlag = 1;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoEnterDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoEnterDo(void)
{
    if(SetMeuMsg.OldMenu3Item != SetMeuMsg.Menu3Item)
    {
        //巽
        Api_DrawImg2Icon(14, SetMeuMsg.MenuCoordinate3, Clrfangkuan);
        Api_DrawImg2Icon(222, SetMeuMsg.MenuCoordinate3, Clrfangkuan);
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate3 + 2), (SetMeuMsg.MenuCoordinate3 + 4));
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate3 + 36), (SetMeuMsg.MenuCoordinate3 + 38));
        
        //ʾ
        Api_DrawIcon(14, SetMeuMsg.MenuCoordinate2, fangkuangzuo);
        Api_DrawIcon(222, SetMeuMsg.MenuCoordinate2, fangkuangyou);
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate2 + 3));
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate2 + 37));
    }
    SetMeuMsg.OldMenu3Item = SetMeuMsg.Menu3Item;
    Gui_Tirp_Disp();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCodeEnter_disp
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCodeEnter_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.OldMenu2Item == 1)
    {
        Api_DrawLetterIcon(104,13,"A]BS", CharLetter2);
        SetMeuMsg.OldSPN[0] = ABSDtcTbl[0].dwSPN + 10;
        SetMeuMsg.OldFMI[0] = ABSDtcTbl[0].bFMI + 10;
        SetMeuMsg.OldSPN[1] = ABSDtcTbl[1].dwSPN + 10;
        SetMeuMsg.OldFMI[1] = ABSDtcTbl[1].bFMI + 10;
        SetMeuMsg.OldSPN[2] = ABSDtcTbl[2].dwSPN + 10;
        SetMeuMsg.OldFMI[2] = ABSDtcTbl[2].bFMI + 10;
        SetMeuMsg.OldSPN[3] = ABSDtcTbl[3].dwSPN + 10;
        SetMeuMsg.OldFMI[3] = ABSDtcTbl[3].bFMI + 10;
        
    }
    else if(SetMeuMsg.OldMenu2Item == 2)
    {
        Api_DrawLetterIcon(104,13,"ECU", CharLetter2);
        SetMeuMsg.OldSPN[0] = EcmDtcTbl[0].dwSPN + 10;
        SetMeuMsg.OldFMI[0] = EcmDtcTbl[0].bFMI + 10;
        SetMeuMsg.OldSPN[1] = EcmDtcTbl[1].dwSPN + 10;
        SetMeuMsg.OldFMI[1] = EcmDtcTbl[1].bFMI + 10;
        SetMeuMsg.OldSPN[2] = EcmDtcTbl[2].dwSPN + 10;
        SetMeuMsg.OldFMI[2] = EcmDtcTbl[2].bFMI + 10;
        SetMeuMsg.OldSPN[3] = EcmDtcTbl[3].dwSPN + 10;
        SetMeuMsg.OldFMI[3] = EcmDtcTbl[3].bFMI + 10;
    }
    else if(SetMeuMsg.OldMenu2Item == 3)
    {
        Api_DrawLetterIcon(104,13,"DCU", CharLetter2);
        SetMeuMsg.OldSPN[0] = DCUDtcTbl[0].dwSPN + 10;
        SetMeuMsg.OldFMI[0] = DCUDtcTbl[0].bFMI + 10;
        SetMeuMsg.OldSPN[1] = DCUDtcTbl[1].dwSPN + 10;
        SetMeuMsg.OldFMI[1] = DCUDtcTbl[1].bFMI + 10;
        SetMeuMsg.OldSPN[2] = DCUDtcTbl[2].dwSPN + 10;
        SetMeuMsg.OldFMI[2] = DCUDtcTbl[2].bFMI + 10;
        SetMeuMsg.OldSPN[3] = DCUDtcTbl[3].dwSPN + 10;
        SetMeuMsg.OldFMI[3] = DCUDtcTbl[3].bFMI + 10;
    }
    Api_DrawLetterIcon(33,78,"S]PN", CharLetter2);
    Api_DrawLetterIcon(175,78,"FM]L", CharLetter2);
    Api_ClearIcon(203, 221, 78, 94);
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCodeEnterDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCodeEnterDo(void)
{
    if(SetMeuMsg.OldMenu2Item == 1)
    {
        Gui_ErrCode_Disp(ABSDtcTbl[0].dwSPN, ABSDtcTbl[0].bFMI, 0);
        Gui_ErrCode_Disp(ABSDtcTbl[1].dwSPN, ABSDtcTbl[1].bFMI, 1);
        Gui_ErrCode_Disp(ABSDtcTbl[2].dwSPN, ABSDtcTbl[2].bFMI, 2);
        Gui_ErrCode_Disp(ABSDtcTbl[3].dwSPN, ABSDtcTbl[3].bFMI, 3); 
    }
    else if(SetMeuMsg.OldMenu2Item == 2)
    {
        Gui_ErrCode_Disp(EcmDtcTbl[0].dwSPN, EcmDtcTbl[0].bFMI, 0);
        Gui_ErrCode_Disp(EcmDtcTbl[1].dwSPN, EcmDtcTbl[1].bFMI, 1);
        Gui_ErrCode_Disp(EcmDtcTbl[2].dwSPN, EcmDtcTbl[2].bFMI, 2);
        Gui_ErrCode_Disp(EcmDtcTbl[3].dwSPN, EcmDtcTbl[3].bFMI, 3);  
    }
    else if(SetMeuMsg.OldMenu2Item == 3)
    {
        Gui_ErrCode_Disp(DCUDtcTbl[0].dwSPN, DCUDtcTbl[0].bFMI, 0);
        Gui_ErrCode_Disp(DCUDtcTbl[1].dwSPN, DCUDtcTbl[1].bFMI, 1);
        Gui_ErrCode_Disp(DCUDtcTbl[2].dwSPN, DCUDtcTbl[2].bFMI, 2);
        Gui_ErrCode_Disp(DCUDtcTbl[3].dwSPN, DCUDtcTbl[3].bFMI, 3);   
    }  
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCode_Disp
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCode_Disp(INT32U Spn, INT8U Fmi, INT8U Num)
{
    
    INT8U len;
    INT32U wTemp;
    
    
    wTemp = Spn;
    DispText.Text[5] = (wTemp / 100000) % 10;
    DispText.Text[4] = (wTemp / 10000) % 10;
    DispText.Text[3] = (wTemp / 1000) % 10;
    DispText.Text[2] = (wTemp / 100) % 10;
    DispText.Text[1] = (wTemp / 10) % 10;
    DispText.Text[0] =  wTemp % 10;
    
    len = App_CalDataLen(wTemp);
    if(SetMeuMsg.OldSPN[Num] != Spn)
    {
        switch(len)
        {
            case 6:
                Api_DrawIcon(108, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 6], 14));
            case 5:
                Api_DrawIcon(94, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 5], 14));
            case 4:
                Api_DrawIcon(80, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 4], 14));
            case 3:
                Api_DrawIcon(66, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 3], 14));
            case 2:
                Api_DrawIcon(52, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 2], 14));
            case 1:
                Api_DrawIcon(38, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 1], 14));
            default:
                ;
        }
        switch(len + 1)
        {
            case 1:
                Api_DrawImgIcon(38, 110 + (Num * 32), Api_Value_Get(10, 14));
            case 2:
                Api_DrawImgIcon(52, 110 + (Num * 32), Api_Value_Get(10, 14));
            case 3:
                Api_DrawImgIcon(66, 110 + (Num * 32), Api_Value_Get(10, 14));
            case 4:
                Api_DrawImgIcon(80, 110 + (Num * 32), Api_Value_Get(10, 14));
            case 5:
                Api_DrawImgIcon(94, 110 + (Num * 32), Api_Value_Get(10, 14));
            case 6:
                Api_DrawImgIcon(108, 110 + (Num * 32), Api_Value_Get(10, 14));
            default:
                ;
        }
        
    }
    
    wTemp = Fmi;
    DispText.Text[1] = ((INT8U)wTemp / 10) % 10;
    DispText.Text[0] =  (INT8U)wTemp % 10;
    len = App_CalDataLen(wTemp);
    if(SetMeuMsg.OldFMI[Num] != Fmi)
    {
        
        
        switch(len)
        {
                
            case 2:
                Api_DrawIcon(191, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 2], 14));
            case 1:
                Api_DrawIcon(177, 110 + (Num * 32), Api_Value_Get(DispText.Text[len - 1], 14));
            default:
                ;
        }
        switch(len + 1)
        {
            case 2:
                Api_DrawImgIcon(191, 110 + (Num * 32), Api_Value_Get(10, 14));
                
            default:
                ;
        }
    }
    SetMeuMsg.OldSPN[Num] = Spn;
    SetMeuMsg.OldFMI[Num] = Fmi;
    
    
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui3rd_TimeEnter
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui3rd_TimeEnter(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    // Api_ClearIcon(6, 236, 5, 38);
    g_Clock.Minute1s = g_Clock.Minutes ;
    g_Clock.Hour1s = g_Clock.Hours ;
    g_Clock.OldMinutes = g_Clock.Minute1s + 10;
    g_Clock.OldHours = g_Clock.Hour1s + 10;
    bCompletTime = 0;
    if(SetMeuMsg.Language == Arabic)
    {
        //ʾʱ
        Api_DrawImg2Icon(44, 13, Set_Menu2_XSSJSZ_Title_Word2_x44_y13);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //ʾʱ    Tiempo
        Api_DrawLetterIcon(95, 14, "Tiempo", CharLetter3);
    }
    else if(SetMeuMsg.Language == English)
    {
        //ʾʱ     Date&Time
        Api_DrawLetterIcon(76, 14, "Date&Time", CharLetter3);
    }
    else
    {
        //ʾʱ
        Api_DrawImgIcon(40, 9, touxianshishijianshezhi);
    }
    //if((g_canClock.signal.Exist65254_EE) || (g_canClock.signal.Exist65254_F2))
    if(0)
    {
        Api_DrawIcon(50, 84, shijianshezhikuangzuo);
        Api_DrawIcon(105, 84, shijianshezhikuangyou);
        Api_DrawYLine(54, 105, 90);
        Api_DrawYLine(54, 105, 139);
        if(SetMeuMsg.Language == Arabic)
        {
            //ͬʱGPSɵ
            Api_DrawImg2Icon(58, 184, Set_Menu3_XSSJSZ_01_UP_Word2_x58_y184);
            Api_DrawImg2Icon(31, 216, Set_Menu3_XSSJSZ_01_Down_Word2_x31_y216);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            //ͬʱGPSɵ      Sincronizacion de tiempo GPS    Poner no ajustable
            Api_DrawLetterIcon(10, 181, "Sincronizaci<n", CharLetter2);
            Api_DrawLetterIcon(124, 181, "de", CharLetter2);
            Api_DrawLetterIcon(146, 181, "tiempo", CharLetter2);
            Api_DrawLetterIcon(200, 181, "GPS", CharLetter2);
            Api_DrawLetterIcon(54, 212, "Poner", CharLetter2);
            Api_DrawLetterIcon(103, 212, "no", CharLetter2);
            Api_DrawLetterIcon(126, 212, "ajustable", CharLetter2);
        }
        else if(SetMeuMsg.Language == English)
        {
            //ͬʱGPSɵ     GPS time synchronizing unable to set
            Api_DrawLetterIcon(34, 181, "GPS", CharLetter2);
            Api_DrawLetterIcon(72, 181, "time", CharLetter2);
            Api_DrawLetterIcon(108, 181, "synchronizing", CharLetter2);
            Api_DrawLetterIcon(76, 209, "unable", CharLetter2);
            Api_DrawLetterIcon(128, 209, "to", CharLetter2);
            Api_DrawLetterIcon(147, 209, "set", CharLetter2);
        }
        else
        {
            //ͬʱGPSɵ
            Api_DrawImgIcon(53, 190, tongbuGPS);
        }
        Gui3rd_TimeSet_Disp();
    }
    else
    {
        if(SetMeuMsg.Language == Arabic)
        {
            //ת趨ʱ䣬ok
            Api_DrawImg2Icon(46, 184, Set_Menu3_XSSJSZ_02_UP_Word2_x46_y184);
            Api_DrawImg2Icon(23, 214, Set_Menu3_XSSJSZ_02_Down_Word2_x23_y216);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            //ת趨ʱ䣬ok    Poner tiempo      Pulse boton OK para guardar
            Api_DrawLetterIcon(60, 181, "Poner", CharLetter2);
            Api_DrawLetterIcon(113, 181, "tiempo", CharLetter2);
            Api_DrawLetterIcon(15, 212, "Pulse", CharLetter2);
            Api_DrawLetterIcon(60, 212, "bot<n", CharLetter2);
            Api_DrawLetterIcon(105, 212, "OK", CharLetter2);
            Api_DrawLetterIcon(133, 212, "para", CharLetter2);
            Api_DrawLetterIcon(171, 212, "guardar", CharLetter2);
        }
        else if(SetMeuMsg.Language == English)
        {
            //ת趨ʱ䣬ok    Rotat to set     Press OK to save
            Api_DrawLetterIcon(75, 181, "Rotat", CharLetter2);
            Api_DrawLetterIcon(122, 181, "to", CharLetter2);
            Api_DrawLetterIcon(141, 181, "set", CharLetter2);
            Api_DrawLetterIcon(57, 209, "Press", CharLetter2);
            Api_DrawLetterIcon(106, 209, "OK", CharLetter2);
            Api_DrawLetterIcon(133, 209, "to", CharLetter2);
            Api_DrawLetterIcon(152, 209, "save", CharLetter2);
        }
        else
        {
            //ת趨ʱ䣬ok
            //ת趨
            Api_DrawImg2Icon(35, 188, zuoyouxuanshezhi);
            //ʱ
            Api_DrawImgIcon(164, 188, caidan2ji_shijian);
            //趨ok
            Api_DrawImg2Icon(28, 217, shedinghouanok);
        }
    }
    Api_DrawImgIcon(116, 107, shuzi26_maohao);
    SetMeuMsg.Menu3Item = 1;
    SetMeuMsg.OldMenu3Item = 0;
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui3rd_TimeDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui3rd_TimeDo(void)
{
    //if((!g_canClock.signal.Exist65254_EE) && (!g_canClock.signal.Exist65254_F2))
    if(0)  
    {
        if(SetMeuMsg.OldMenu3Item != SetMeuMsg.Menu3Item)
        {
            if(SetMeuMsg.Menu3Item == 1)
            {
                Api_DrawIcon(130, 84, shijianshezhikuangClr);
                Api_DrawIcon(180, 84, shijianshezhikuangClr);
                Api_ClearIcon(134, 180, 89, 91);
                Api_ClearIcon(134, 180, 138, 141);
                //
                Api_DrawIcon(50, 84, shijianshezhikuangzuo);
                Api_DrawIcon(105, 84, shijianshezhikuangyou);
                Api_DrawYLine(54, 105, 90);
                Api_DrawYLine(54, 105, 139);
                
            }
            if(SetMeuMsg.Menu3Item == 2)
            {
                Api_DrawIcon(50, 84, shijianshezhikuangClr);
                Api_DrawIcon(105, 84, shijianshezhikuangClr);
                Api_ClearIcon(54, 105, 89, 91);
                Api_ClearIcon(54, 105, 138, 141);
                //
                Api_DrawIcon(130, 84, shijianshezhikuangzuo);
                Api_DrawIcon(180, 84, shijianshezhikuangyou);
                Api_DrawYLine(134, 180, 90);
                Api_DrawYLine(134, 180, 139);
            }
        }
        Gui3rd_TimeSet_Disp();
        SetMeuMsg.OldMenu3Item = SetMeuMsg.Menu3Item;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_TimeSet_Disp
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui3rd_TimeSet_Disp(void)
{
    INT8U bTemp;

    if(g_Clock.OldHours != g_Clock.Hour1s)
    {
        
        bTemp = g_Clock.Hour1s;
        DispText.Text[2] = (bTemp / 10) % 10;
        DispText.Text[3] =  bTemp % 10;
        Api_DrawImg2Icon(57, 100, Api_Value_Get(DispText.Text[2], 34));
        Api_DrawImg2Icon(79, 100, Api_Value_Get(DispText.Text[3], 34));
    }
    
    if(g_Clock.OldMinutes != g_Clock.Minute1s)
    {
        
        bTemp = g_Clock.Minute1s;
        DispText.Text[2] = (bTemp / 10) % 10;
        DispText.Text[3] =  bTemp % 10;
        Api_DrawImg2Icon(137, 100, Api_Value_Get(DispText.Text[2], 34));
        Api_DrawImg2Icon(159, 100, Api_Value_Get(DispText.Text[3], 34));
    }
    
    g_Clock.OldHours = g_Clock.Hour1s;
    g_Clock.OldMinutes = g_Clock.Minute1s; 
}
/*-------------------------------------------------------------------------
* Function Name  : Gui3rd_TimeExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui3rd_TimeExit(void)
{
    Api_ClearIcon(6, 240, 5, 38);//(xLarge) 
    Api_ClearIcon(6, 236, 43, 255);
    if(bCompletTime == 1)
    {
        bCompletTime = 0;
        g_Clock.Minutes = g_Clock.Minute1s ;
        g_Clock.Hours = g_Clock.Hour1s ;
    }
}
