/*
* gui_Display.c
*
*  Created on: Aug 11, 2014
*      Author: QTC
*/

#define GLOBALS_GUI_DISP
#include "defines.h"
#include "g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Gui_MotorFirstReset
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_MotorFirstReset(void)
{
    bsp_SetMotorMode(Motor_1, MaxReset);
    bsp_SetMotorMode(Motor_2, MaxReset);
}

/*-------------------------------------------------------------------------
* Function Name  : GUI_MotorOffReset
* Description    : λ
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_MotorOffReset(void)
{
    //bsp_SetMotorMode(Motor_1, MinPostion);
    //bsp_SetMotorMode(Motor_2, MinPostion);
    while ((MeterPostion[Motor_1].curPosition != 0) || (MeterPostion[Motor_2].curPosition != 0))
    {
        bsp_WDOG_Feed();
    
        MeterPostion[Motor_1].destPosition = 0;
        MeterPostion[Motor_2].destPosition = 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_Logo_Disp
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_Logo_Disp(void)
{
    Api_DrawImgIcon(49, 139, logo);
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_LCD_Display
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_LCD_Display(void)
{
    if (g_Init.InitLogoTime >= T_2_5s)
    {
        if (g_ClearWin1 == 1)
        {
            bsp_ClearFullWindow(null);
            Api_ClearIcon(0, 240, 0, 320);
            //
            Api_DrawYLine(0, 240, 41);
            Api_DrawYLine(0, 240, 260);

            //trip
            Api_DrawImgIcon(11, 271, Trip);
            Api_DrawImg2Icon(11, 295, ODO);
            Api_DrawImg2Icon(210, 295, km1);
            Api_DrawImg2Icon(210, 271, km1);

            g_ClearWin1 = 0;
        }

        //ͼ
        if (bMenuSwFlag)
        {
            if (MenuOptTab[bCurMenuIDX].Enter)
            {
                MenuOptTab[bCurMenuIDX].Enter();
            }
        }

        //̬ʾ
        if (MenuOptTab[bCurMenuIDX].Do)
        {
            MenuOptTab[bCurMenuIDX].Do();
        }

        bMenuSwFlag = (bCurMenuIDX != bNextMenuIDX) ? 1 : 0;

        //˳
        if (bMenuSwFlag)
        {
            if (MenuOptTab[bCurMenuIDX].Exit)
            {
                MenuOptTab[bCurMenuIDX].Exit();
            }
        }

        //
        bCurMenuIDX = bNextMenuIDX;

        //
        Gui_Gas1_Disp_Manage();
        Gui_Gas2_Disp_Manage();
        Gui_Adblue_Disp_Manage();
        //
        Gui_ODO_Disp();
        Gui_Tirp_Disp();
        Gui_Gears_disp();
    }

    Gui_Temp_Disp();
    Gui_Fuel_Disp();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_IODD0AEnable
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_IODD0AEnable(void)
{
    g_ClearWin1 = 1;
    bMenuSwFlag = 1;
    Time_Updeta;
    InstFuel_Updeta;
    AveFuel_Updeta;
    Adblue_Updeta;
    Gas2_Updeta;
    Gas1_Updeta;
    bUpDataFlag = 1;
    ODO_Updeta;
    Trip_Updeta;
    bsp_ClearFullWindow(null);
}