#ifdef        GLOBALS_SER_DIAGNO
    #define   EXTERN_SER_DIAGNO
    
#else
    #define   EXTERN_SER_DIAGNO     extern
#endif

#ifndef SER_DIAGNO_H_
#define SER_DIAGNO_H_

#include "protocol_class.h"

    //64Bytes
    typedef struct
    {
        INT8U D_F190[17]; //ʶ
        INT8U D_F192[11]; //ӦECUӲ
        INT8U D_F199[4];  //
        INT8U D_F19D[4];  //װʱ
        INT8U D_F1A8[20]; //Ϣ
        INT8U D_5000[4];  //ܼ
        INT8U D_FCAA[2];  //PPK
        INT8U bFlag;
        INT8U bCheckSum;
    } DIAG_2E_DATA;

    //-- IO --//
    #define DIDD001 0xD001
    #define DID1002 0x1002
    #define DID1003 0x1003
    #define DID1004 0x1004
    #define DID1005 0x1005
    #define DID1006 0x1006
    #define DID1007 0x1007
    #define DID1008 0x1008
    #define DID1009 0x1009
    #define DID100A 0x100A
    #define DID100B 0x100B
    #define DID100C 0x100C
    #define DID100D 0x100D
    #define DID100E 0x100E
    #define DID100F 0x100F
    #define DID1010 0x1010
    #define DID1011 0x1011
    #define DID1012 0x1012
    #define DID1013 0x1013
    #define DID1014 0x1014
    #define DID1015 0x1015
    #define DID1016 0x1016
    #define DID1017 0x1017
    #define DID1018 0x1018
    #define DID1019 0x1019
    #define DID101A 0x101A
    #define DID101B 0x101B
    #define DID101C 0x101C
    #define DID101D 0x101D
    #define DID101E 0x101E
    #define DID101F 0x101F
    #define DID1020 0x1020
    #define DID1021 0x1021
    #define DID1022 0x1022
    #define DID1023 0x1023
    #define DID1024 0x1024
    #define DID1025 0x1025
    #define DID1026 0x1026
    #define DID1027 0x1027
    #define DID1028 0x1028
    #define DID1029 0x1029
    #define DID102A 0x102A
    #define DID102B 0x102B
    #define DID102C 0x102C
    #define DID102D 0x102D
    #define DID102E 0x102E
    #define DID102F 0x102F
    #define DID1030 0x1030
    #define DID1031 0x1031
    #define DID1032 0x1032
    #define DID1033 0x1033
    #define DID1034 0x1034
    #define DID1035 0x1035
    #define DID1045 0x1045
    
    #define DID1046 0x1046    
    #define DID1047 0x1047      
    #define DID1048 0x1048       
    typedef struct
    {
        INT8U FF_Byte;
    } _IOCTL_Data;

    typedef union
    {
        struct
        {
            INT8U     DID1001Valid    : 1;
            INT8U     DID1002Valid    : 1;
            INT8U     DID1003Valid    : 1;
            INT8U     DID1004Valid    : 1;
            INT8U     DID1005Valid    : 1;
            INT8U     DID1006Valid    : 1;
            INT8U     DID1007Valid    : 1;
            INT8U     DID1008Valid    : 1;

            INT8U     DID1009Valid    : 1;
            INT8U     DID100AValid    : 1;
            INT8U     DID100BValid    : 1;
            INT8U     DID100CValid    : 1;
            INT8U     DID100DValid    : 1;
            INT8U     DID100EValid    : 1;
            INT8U     DID100FValid    : 1;
            INT8U     DID1010Valid    : 1;
            
            INT8U     DID1011Valid    : 1;
            INT8U     DID1012Valid    : 1;
            INT8U     DID1013Valid    : 1;
            INT8U     DID1014Valid    : 1;
            INT8U     DID1015Valid    : 1;
            INT8U     DID1016Valid    : 1;
            INT8U     DID1017Valid    : 1;
            INT8U     DID1018Valid    : 1;
            
            INT8U     DID1019Valid    : 1;
            INT8U     DID101AValid    : 1;
            INT8U     DID101BValid    : 1;
            INT8U     DID101CValid    : 1;
            INT8U     DID101DValid    : 1;
            INT8U     DID101EValid    : 1;
            INT8U     DID101FValid    : 1;
            INT8U     DID1020Valid    : 1; 
            
            INT8U     DID1021Valid    : 1;
            INT8U     DID1022Valid    : 1;
            INT8U     DID1023Valid    : 1;
            INT8U     DID1024Valid    : 1;
            INT8U     DID1025Valid    : 1;
            INT8U     DID1026Valid    : 1;
            INT8U     DID1027Valid    : 1;
            INT8U     DID1028Valid    : 1; 
        
            INT8U     DID1029Valid    : 1;
            INT8U     DID102AValid    : 1;
            INT8U     DID102BValid    : 1;
            INT8U     DID102CValid    : 1;
            INT8U     DID102DValid    : 1;
            INT8U     DID102EValid    : 1;
            INT8U     DID102FValid    : 1;
            INT8U     DID1030Valid    : 1;
            
            INT8U     DID1031Valid    : 1;
            INT8U     DID1032Valid    : 1;
            INT8U     DID1033Valid    : 1;
            INT8U     DID1034Valid    : 1;
            INT8U     DID1035Valid    : 1;
            INT8U     DID1045Valid    : 1;
            INT8U     DID1046Valid    : 1;           
            INT8U     DID1047Valid    : 1;  
              
 
            INT8U     DID1048Valid    : 1;  
            INT8U     DID1049Valid    : 1;                       
            INT8U     Reserved        : 6;                                                           
        } Bits;
        INT8U Flag[8];
    } _DIDValid;
   
    typedef struct
    {
        INT8U State[5];
        INT8U Mask[5];
    } _Power;
    #define 	DIDF190    0xF190
    #define 	DIDF189    0xF189
    #define 	DIDF18B    0xF18B
    #define 	DIDF186    0xF186
    #define 	DIDF199    0xF199
    #define 	DIDF192    0xF192
    #define 	DIDF193    0xF193
    #define 	DIDF194    0xF194
    #define 	DIDF195    0xF195
    #define 	DIDF18A    0xF18A
    #define   DIDF191    0xF191
    #define   DIDF187    0xF187
    #define   DIDF188    0xF188
    #define   DIDF18C    0xF18C
    #define   DIDF197    0xF197
    #define   DIDF19D    0xF19D
    #define   DIDF1FA    0xF1FA
    #define   DIDFCAA    0xFCAA
    #define   DIDF1A8    0xF1A8
    #define   DID5000    0x5000
    #define   DID5101    0x5101
    
    typedef struct
    {
        INT8U  Year;
        INT8U  Month;
        INT8U  Day;
    } _Date;

    typedef struct
    {
        _Date    PrgDate;   //F1B2 Vehicle Manufacturing Date
        INT8U    VIN[27];
    } _ProgFingerPrint;

    typedef struct
    {
        INT8U    Checkflag;
        INT8U    MECounter; //F1A0 Manufacturers Enable Counter;

        _Date    VehDate;   //F1B2 Vehicle Manufacturing Date
        _Date    EcuCodingDate;
        INT8U    CodingData[12];
        INT8U    MileageOfIPC[3];

        INT8U    Node1;
        INT8U    Node2;
        INT8U    Node3;
        INT8U    Node4;

        INT8U FingerPrintNum;
        _ProgFingerPrint FingerPrint[5];

        INT8U    VIN[17];
        INT8U    ECUPartNumAndVer[6];
        INT8U    RepairShopCode[10];
        INT8U    SeriNum[20];  //F18C ECUDDo?
        INT8U    CheckSun;
    } _ProductInfo;


    //-- Ϣ --//28byte
    typedef struct
    {
        INT32U       NumAndStatus; //1
        INT8U        SnapShotNum;
        INT8U        SnapShotNumIde;
        INT8U       TimestampIdeH;  //0xf120
        INT8U       TimestampIdeL;  //0xf120
        INT16U        TimeYear;
        INT8U        TimeMonth;
        INT8U        TimeDay;
        INT8U        TimeHour;
        INT8U        TimeMin;
        INT8U        TimeSec;
        INT8U       ODOIdeH;        //0xf121
        INT8U       ODOIdeL;        //0xf121
        INT8U        ODOByte2;
        INT8U        ODOByte1;
        INT8U        ODOByte0;
        INT8U       VoltIdeH;       //0xf122
        INT8U       VoltIdeL;       //0xf122
        INT8U        Volt;        //0~25.4
        INT8U       IGNIdeH;        //0xf123
        INT8U       IGNIdeL;        //0xf123
        INT8U        IGNSt;     //0:off 1:acc 2:on 3:start
        INT8U        bFlag;
        INT8U        bCheckSun;
    } _SnapShot;



    typedef struct
    {
        INT8U       Checkflag;
        INT8U       ProgSel;
        INT8U       SessionType;
        INT8U       Reserved0;
        INT8U       Reserved1;
        INT8U       Reserved2;
        INT8U       Reserved3;
        INT8U       Reserved4;
        INT8U       Reserved5;
        INT8U       Reserved6;
        INT8U       Reserved7;
        INT8U       Reserved8;
        INT8U       Reserved9;
        INT8U       Reserved10;
        INT8U       Reserved11;
        INT8U       bCheckSun;
    } _BootReg;

    extern  volatile    _BootReg                g_bootReg;
    
    //-- IO --//
    extern _DIDValid DIDFlag;  
    
    extern _IOCTL_Data IOCTL_DID1001;
    extern _IOCTL_Data IOCTL_DID1002;
    extern _IOCTL_Data IOCTL_DID1003;
    extern _IOCTL_Data IOCTL_DID1004;
    extern _IOCTL_Data IOCTL_DID1005;
    extern _IOCTL_Data IOCTL_DID1006;
    extern _IOCTL_Data IOCTL_DID1007;
    extern _IOCTL_Data IOCTL_DID1008;
    extern _IOCTL_Data IOCTL_DID1009;
    extern _IOCTL_Data IOCTL_DID100A;
    extern _IOCTL_Data IOCTL_DID100B;
    extern _IOCTL_Data IOCTL_DID100C;
    extern _IOCTL_Data IOCTL_DID100D;
    extern _IOCTL_Data IOCTL_DID100E;
    extern _IOCTL_Data IOCTL_DID100F;
    extern _IOCTL_Data IOCTL_DID1010;
    extern _IOCTL_Data IOCTL_DID1011;
    extern _IOCTL_Data IOCTL_DID1012;
    extern _IOCTL_Data IOCTL_DID1013;
    extern _IOCTL_Data IOCTL_DID1014;
    extern _IOCTL_Data IOCTL_DID1015;
    extern _IOCTL_Data IOCTL_DID1016;
    extern _IOCTL_Data IOCTL_DID1017;
    extern _IOCTL_Data IOCTL_DID1018;
    extern _IOCTL_Data IOCTL_DID1019;
    extern _IOCTL_Data IOCTL_DID101A;
    extern _IOCTL_Data IOCTL_DID101B;
    extern _IOCTL_Data IOCTL_DID101C;
    extern _IOCTL_Data IOCTL_DID101D;
    extern _IOCTL_Data IOCTL_DID101E;
    extern _IOCTL_Data IOCTL_DID101F;
    extern _IOCTL_Data IOCTL_DID1020;
    extern _IOCTL_Data IOCTL_DID1021;
    extern _IOCTL_Data IOCTL_DID1022;
    extern _IOCTL_Data IOCTL_DID1023;
    extern _IOCTL_Data IOCTL_DID1024;
    extern _IOCTL_Data IOCTL_DID1025;
    extern _IOCTL_Data IOCTL_DID1026;
    extern _IOCTL_Data IOCTL_DID1027;
    extern _IOCTL_Data IOCTL_DID1028;
    extern _IOCTL_Data IOCTL_DID1029;
    extern _IOCTL_Data IOCTL_DID102A;
    extern _IOCTL_Data IOCTL_DID102B;
    extern _IOCTL_Data IOCTL_DID102C;
    extern _IOCTL_Data IOCTL_DID1030;
    extern _IOCTL_Data IOCTL_DID1031;
    extern _IOCTL_Data IOCTL_DID1032;
    extern _IOCTL_Data IOCTL_DID1033;
    extern _IOCTL_Data IOCTL_DID1034;
    extern _IOCTL_Data IOCTL_DID1035;
    extern _IOCTL_Data IOCTL_DID1045;
    extern _IOCTL_Data IOCTL_DID1046;    
    extern _IOCTL_Data IOCTL_DID1047;       
    extern _IOCTL_Data IOCTL_DID1048;      
    
    #define NC_DEFAULT_SEED  0xa548fd85 /* default seed used if result from random generator is 0 */
    #define NC_UDS_KEYMASK   0x213acdba
    //#pragma section @@CNST CNSTROM
    EXTERN_SER_DIAGNO unsigned int nc_uds_keymul[32];


    extern     volatile       _N_USData             Exct_USData;
    extern     volatile       _DiagnoCtl            DiagnoCtl;
    extern     volatile       INT32U                Seed;
    extern     volatile       _DiagClock            DiagClock;
    extern     volatile       _ErrorFrame           Error;
    extern     volatile       _DiagFlag             DiagFlag;
    extern     volatile       INT32U                CrcCheckSum;
    extern     volatile       INT32U                JACseed[2] ;
    extern     volatile       INT32U                ECUNum[4] ;
    extern     volatile       INT32U                ECUNum2[4] ;

    ///
    extern     INT32U         App_Croleft(INT32U c, INT16U b);
    extern     INT16U         App_Croshortright(INT16U c, INT16U b);
    extern     INT32U         App_Mulu32(INT32U val1, INT32U val2);
    extern     INT32U         App_Uds_Calc_Key(INT32U seed);

    extern     void           App_SetSequenceTimer(INT32U Second, _DiagClock *T);
    extern     INT8U          App_SequenceTimerOver(_DiagClock *T);

    extern     void           App_SetSessionTimer(INT32U Second, _DiagClock *T);
    extern     INT8U          App_SessionTimerOver(_DiagClock *T);

    extern     void           App_SetReUnlockTimer(INT32U Second, _DiagClock *T);
    extern     INT8U          App_ReUnlockTimerOver(_DiagClock *T);

    extern     void           App_10_service(_N_USData *AppUSData);//Ựģʽ
    extern     void           App_11_service(_N_USData *AppUSData);//λģʽ
    extern     void           App_14_service(_N_USData *AppUSData);//-(DTC)
    extern     void           App_19_service(_N_USData *AppUSData);//-(DTC)
    extern     void           App_22_service(_N_USData *AppUSData);//
    extern     void           App_27_service(_N_USData *AppUSData);//
    extern     void           App_28_service(_N_USData *AppUSData);//RxTx 
    extern     void           App_2E_service(_N_USData *AppUSData);//д
    extern     void           App_2F_service(_N_USData *AppUSData);//IO
    extern     void           App_31_service(_N_USData *AppUSData);//Boot
    extern     void           App_34_service(_N_USData *AppUSData);//Boot
    extern     void           App_36_service(_N_USData *AppUSData);//Boot
    extern     void           App_37_service(_N_USData *AppUSData);//Boot
    extern     void           App_3E_service(_N_USData *AppUSData);//Boot
    extern     void           App_85_service(_N_USData *AppUSData);//-(DTC)

    extern     void           DiagnosisInit_main(void);
    extern     void           Diagnosis_main(void);

#endif /* SER_DIAGNO_H_ */
