#ifndef  __NETWORKLAYER_H
#define __NETWORKLAYER_H

#define NETWORK_LAYER_BUFF_LEN 255

#define VALID 1
#define INVALID 2

#define CanSingleFrame 0x00
#define CanMulFrame_First 0x10
#define CanMulFrame_Sequence 0x20
#define CanFlowControl 0x30

#define FlowControlContinue 1
#define FlowControlOverflow 0


enum
{
    NetStatus_Wait,
    NetStatus_MulFrameSend,
    NetStatus_MulFrameRecv,
};

typedef struct
{
    INT8U Status;				// wait send recv
    INT8U RecvDataStatus;		//状态 0 invalud  1 valid
    INT8U SendDataStatus;		//状态 0 invalud  1 valid
    INT8U RecvMulFrame_First;	//状态 0 invalud  1 valid
    INT8U RecvMulFrameLen;	//多帧总长度
    INT8U RecvMulFrameNum;	// recv frame total num

    INT8U SendMulFrameSw;	//多帧发送定时器开关
    INT8U SendvMulFrameLen; //多帧已发送长度
    INT8U SendMulFrameNum;	// send frame total num
    INT8U SendMulFrameCnt;	//cur send frame num
    INT8U SendMulFrameInterval;	//多帧发送间隔时间
    INT8U SendMulFrameIntervalCnt;
    INT8U RecvMulFrameTimeoutCnt;
    INT8U SendMulFrameTimeoutCnt;
    INT8U RxTx_Len;		    //发送或接收的数据的长度
    INT8U RxTx_Buff[NETWORK_LAYER_BUFF_LEN];     //200  50
} NetLayerParameter;

extern NetLayerParameter NetLayer;
extern CANMsg MyCanTxMsg;

void RecvMulFrameTimeout_Prg(void);
void CANSendPack(INT8U *buff, INT8U len);
void SendFlowControlPack(INT8U mTYPE);
void NetLayer_RX_PRG(void);
void  NetLayer_Tx_Prg(void);
void SendMulFrameTimeout_Prg(void);
void SendMulFrame_Prg(void);
void SendMulFrameInterval_Prg(void);

#endif

