/*
* app_DataProcess.c
*
*  Created on: Aug 16, 2014
*      Author: QTC
*/

#define GLOBALS_APP_PROCESS
#include "defines.h"
#include "g_includes.h"
#include "APP_Service.h"
extern DIAG_2E_DATA Diag2eData;

/*-------------------------------------------------------------------------
* Function Name  : App_ChcekSleep
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_ChcekSleep(void)
{
    Api_GetAdcResult();

    //ϵ
    if (g_curkeyinput == KeyON)
    {
        g_SleepInfo.pwrleep = 0;
    }
    else
    {
        g_SleepInfo.pwrleep = 1;
    }

    // /תָʾλõָʾԶơơǰ/ơ
    if (((ConfigItem.RTurnConfig == 0x01u) && (g_LightSts.RTurnSts == 1u)) ||
        ((ConfigItem.RTurnConfig == 0x00u) && (g_LED.pTrunLTime >= T_20ms)) ||
        ((ConfigItem.LTurnConfig == 0x01u) && (g_LightSts.LTurnSts == 1u)) ||
        ((ConfigItem.LTurnConfig == 0x00u) && (g_LED.pTrunRTime >= T_20ms)) ||
        ((ConfigItem.HighBeamConfig == 0x01u) && (g_CanSwith.HighBeam == 1u)) ||
        ((ConfigItem.HighBeamConfig == 0x00u) && (g_LED.HighBeamTime >= T_0_1s)) ||
        ((ConfigItem.LowBeamConfig == 0x01u) && (g_CanSwith.LowBeam == 1u)) ||
        ((ConfigItem.LowBeamConfig == 0x00u) && (g_LED.LowBeamTime >= T_0_1s)) ||
        ((ConfigItem.FrontFogConfig == 0x01u) && (g_CanSwith.FrontFog == 1u)) ||
        ((ConfigItem.FrontFogConfig == 0x00u) && (g_LED.FrontFogTime >= T_0_1s)) ||
        ((ConfigItem.RearFogConfig == 0x01u) && (g_CanSwith.RearFog == 1u)) ||
        ((ConfigItem.RearFogConfig == 0x00u) && (g_LED.RearFogTime >= T_0_1s)) ||
        ((ConfigItem.PosLampConfig == 0x01u) && (g_CanSwith.PosLamp == 1u)) ||
        ((ConfigItem.PosLampConfig == 0x00u) && (g_LED.pPosLampTime >= T_0_1s)))
    {
        g_SleepInfo.dispsleep = 0;
    }
    else
    {
        g_SleepInfo.dispsleep = 1;
    }

    //ߵ͵
    //if (((pTransHiGearIn == HIGH) && (g_LED.pTransHiGearTime >= T_0_3s)) ||((pTransLowGearIn == HIGH) && (g_LED.pTransLowGearTime >= T_0_3s)))
    if (0)
    {
        g_SleepInfo.TransGearSleep = 0;
    }
    else
    {
        g_SleepInfo.TransGearSleep = 1;
    }

    //ſ
    if (ConfigItem.OpenDoorConfig == 0x01u)
    {
        if ((g_CanSwith.DrDoorStae) || (g_CanSwith.PssDoorStae) || (g_CanSwith.RLDoorStae) || (g_CanSwith.RRDoorStae))
        {
            g_SleepInfo.doorleep = 0;
        }
        else
        {
            g_SleepInfo.doorleep = 1;
        }
    }
    else
    {
        if (g_LED.pDoorOpenTime >= T_0_3s)
        {
            g_SleepInfo.doorleep = 0;
        }
        else
        {
            g_SleepInfo.doorleep = 1;
        }
    }

    //can
    if ((CAN0CTL0_SLPRQ) && (CAN0CTL1_SLPAK))
    {
        g_SleepInfo.bussleep = 1;
        bSendFlag = 0;
        APPSendMsgInit = 0;
    }
    else
    {
        g_SleepInfo.bussleep = 0;
    }

    //״̬
    if ((g_SleepInfo.pwrleep == 0) || (g_SleepInfo.dispsleep == 0) || (g_SleepInfo.TransGearSleep == 0) ||
        (g_SleepInfo.doorleep == 0) || (g_SleepInfo.bussleep == 0) || (g_pBeep->Prio != DisAlr))
    {
        g_SleepInfo.syssleep = 0;
    }
    else
    {
        g_SleepInfo.syssleep = 1;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SleepProc
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SleepProc(void)
{
    INT8U i = 0;

    //
    if (g_SleepInfo.syssleep)
    {
        //ֱ߻Ѻ
        if (!g_SleepInfo.sleepOut)
        {
            Enable_signal(g_SleepInfo.sleepOut);

            //-- Sleep_Flag --//
            Enable_signal(g_sysFlag.Bits.OffClearWin);
            Enable_signal(g_sysFlag.Bits.OffDorDisClrWin);
            g_CanSwith.ClrScreenDoor = 1;

            //-- mcu --//
            bsp_Sys_OFF();

            //-- off --//
            for (i = 0; i < TotalPicWarn; i++)
            {
                _FEED_COP();
                bDSTable[i] = 0;
            }
            for (i = 0; i < TotalPicWarn; i++)
            {
                _FEED_COP();
                wDS_LcdQueue[i] = 0;
            }
            for (i = 0; i < TotalPicWarn; i++)
            {
                _FEED_COP();
                bDSTableShowTime[i] = 0;
            }
            bCurDsPos = 255;
            bLcdDsCnt = 0;

            //-- DB8379 --//
            Enable_signal(g_validFlag.Bits.BD8379Init);
            DB8379_WriteData(OFF);
            DB8379_CLK_P = 0;
            DB8379_LE_P = 0;
            DB8379_RST_P = 0;
            DB8379_OE_P = 1;
            DB8379_SIN_P = 0;
            OldBD83790A = BD83790A;
            OldBD83790B = BD83790B;

            //-- can --//
            pSTBOut = HIGH; //

            //-- IIC --//
            SDA = HIGH;
            SCL = HIGH;

            //-- lcd --//
            bsp_ClearFullWindow(null);
            bsp_PowerSave();

            //-- Light --//
            Api_LcdLightOFFCtl();
            Api_MeterLightOFFCtl();

            //-- Power --//
            //pVehOut = OFF;  //
            //pGas5vOut = LOW;//
            LINE_5V_OUT = HIGH; //
        }

        //_asm
        //{
        //    ANDCC #0x7f;
        //    STOP;
        //}
    }
    else
    {
        //ߺĻѳʼ
        if (g_SleepInfo.sleepOut)
        {
            Disable_signal(g_SleepInfo.sleepOut);
            bsp_Sys_ON();
            bsp_TFT_Init();
            DB8379_Init();
            /*          
            //-- can --//CAN,Ϊ˽CANת 
            pSTBOut = LOW; 
            //Ǵת 
            VCC5V0_SPEAKER=LOW;
            Power_Up();  
   */
        }

        //--------- ſź ----------//
        if (g_SleepInfo.doorleep == 0)
        {
            if (g_sysFlag.Bits.OffDorDisClrWin)
            {
                Disable_signal(g_sysFlag.Bits.OffDorDisClrWin);
                Enable_signal(g_sysFlag.Bits.OffClearWin);

                //clear
                bsp_ClearFullWindow(null);
                //
                Api_DrawYLine(0, 240, 41);
                Api_DrawYLine(0, 240, 260);
                Api_DrawImgIcon(11, 271, Trip);
                Api_DrawImg2Icon(11, 295, ODO);
                Api_DrawImg2Icon(210, 295, km1);
                Api_DrawImg2Icon(210, 271, km1);
                //update
                Time_Updeta;
                ODO_Updeta;
                Trip_Updeta;
            }

            //ʾſDo
            if ((bDSTable[PicDoorOpen] & DS0_MASK) == 1)
            {
                if (SetMeuMsg.Language == Spanish)
                {
                    Gui_FaultSpanish_Disp();
                }
                else
                {
                    Gui_Fault_Disp();
                }
            }
            Gui_Time_Disp();
            Gui_ODO_Disp();
            Gui_Tirp_Disp();
        }
        //------ ſź ---------//
        else
        {
            if (g_sysFlag.Bits.OffClearWin)
            {
                Disable_signal(g_sysFlag.Bits.OffClearWin);
                Enable_signal(g_sysFlag.Bits.OffDorDisClrWin);

                //clear
                bsp_ClearFullWindow(null);
                g_CanSwith.ClrScreenDoor = 1;

                //-- off --//
                for (i = 0; i < TotalPicWarn; i++)
                {
                    _FEED_COP();
                    bDSTable[i] = 0;
                }
                for (i = 0; i < TotalPicWarn; i++)
                {
                    _FEED_COP();
                    wDS_LcdQueue[i] = 0;
                }
                for (i = 0; i < TotalPicWarn; i++)
                {
                    _FEED_COP();
                    bDSTableShowTime[i] = 0;
                }
                bCurDsPos = 255;
                bLcdDsCnt = 0;
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalAccKm
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void App_CalAccKm(_MeterPos *M)
void App_CalAccKm(void)
{
    INT8U check;
    INT8U AccKm_Clear_Once_Flag[4];
    if ((g_accTime > null) && (g_sysFlag.Bits.AccSaveState))
    {
        if ((Radio.VehRadio > null) && (Radio.VehRadio < 65535))
        {
            if ((AccPulse * 10) > (Radio.VehRadio)) //ʮ֮һʾˢ
            {
                if (AccPulse > (Radio.VehRadio) / 10)
                {
                    AccPulse -= (Radio.VehRadio) / 10;
                }
                if (AccPulse > (Radio.VehRadio) / 10)
                {
                    AccPulse = null;
                }
                g_accKm.ShortAccKm++;
                g_accKm.LongAccKm++;
                RamShortAccKmA++;
                ODO_Updeta;
                Trip_Updeta;

                g_accKm.Dis100Km++;
                g_fuelEco.Dis100Km++;
                g_fuelEco.Dis100Km1++;
            }

            if (g_accKm.ShortAccKm > 9999)
            {
                g_accKm.ShortAccKm = null;
            }
            if (g_accKm.LongAccKm > 9999999)
            {
                g_accKm.LongAccKm = null;
            }
            if (RamShortAccKmA > 9999)
            {
                RamShortAccKmA = null;
            }
            if (g_accKm.LongAccKm > g_oldAccKm.LongAccKm)
            {
                if ((g_oldAccKm.LongAccKm + 10) > g_accKm.LongAccKm)
                {
                    if ((g_accKm.LongAccKm % 2) == null)
                    {
                        Api_WriteAccReg();
                    }

                    if ((g_accKm.ShortAccKm % 15) == null)
                    {
                        g_accKm.Checkflag = CheckFlag;
                        g_accKm.bCheckSun = Api_CreateCRCCheckSum((INT8U *)&g_accKm, Register_Len - 2);
                        g_bReturn = bsp_IIC_WritePage(0xa0, EEBAKACC, (INT8U *)&g_accKm, Register_Len);
                    }
                }
            }
            if (g_accKm.LongAccKm < g_oldAccKm.LongAccKm)
            {
                check = Api_CreateCRCCheckSum((INT8U *)&g_oldAccKm, sizeof(_Register) - 2);
                if (check == g_oldAccKm.bCheckSun)
                {
                    if ((g_accKm.LongAccKm + 10) > g_oldAccKm.LongAccKm)
                    {
                        Api_CopyRam((INT8U *)&g_accKm, (INT8U *)&g_oldAccKm, sizeof(_Register));
                    }
                }
            }
        }
    }

    //Ϊ
    if ((g_vehMeter.CurPosition >= g_vehMeterInfo.DashStep[g_vehMeterInfo.bVirtualVal - 1]) &&
        (g_revMeter.CurPosition >= g_revMeterInfo.DashStep[g_revMeterInfo.bVirtualVal - 1]) &&
        (Key_type == 1) && (G_Button.OK_PushTime >= T_2s) && (CheckStep == 2))
    {

        if (g_accKmClrStep == null) //2020-10-08(Ĺ)
        {
            AccKm_Clear_Once_Flag[0] = 0x00;
            AccKm_Clear_Once_Flag[1] = 0x00;
            AccKm_Clear_Once_Flag[2] = 0x00;
            AccKm_Clear_Once_Flag[3] = 0x00;
            g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK7, 0, (INT8U *)&AccKm_Clear_Once_Flag[0], 4);
            bsp_Delay(6000);
            g_sysFlag.Bits.ClearODO = 1;
        }
        if (g_sysFlag.Bits.ClearODO)
        {
            ODO_Updeta;
            Trip_Updeta;
            RamShortAccKmA = null;
            Api_ClearAccStock();
        }
    }

    //ãֻһΣ2000//2020-10-08(Ĺ)
    if ((g_vehMeter.CurBoardVal == 0) && (g_revMeter.CurBoardVal == 0) && (Key_type == 1) && (G_Button.OK_PushTime >= 20 * T_1s) && (CheckStep == 2) && (g_accKm.LongAccKm < 20000))
    {
        bsp_WDOG_Feed();
        (void)bsp_IIC_ReadPage(EEPROM_BLOCK7, 0, (INT8U *)&AccKm_Clear_Once_Flag[0], 4);
        bsp_WDOG_Feed();
        if ((AccKm_Clear_Once_Flag[0] != 0x11) || (AccKm_Clear_Once_Flag[1] != 0x22) || (AccKm_Clear_Once_Flag[2] != 0x33) || (AccKm_Clear_Once_Flag[3] != 0x44))
        {

            ODO_Updeta;
            Trip_Updeta;
            RamShortAccKmA = null;
            //g_accKmClrStep=0;
            Api_ClearAccStock();
            if (g_accKmClrStep == null)
            {

                g_AFC_INIT.CurODO = 0; //ȼ
                InitAFC(&g_AFC_INIT);

                AccKm_Clear_Once_Flag[0] = 0x11;
                AccKm_Clear_Once_Flag[1] = 0x22;
                AccKm_Clear_Once_Flag[2] = 0x33;
                AccKm_Clear_Once_Flag[3] = 0x44;
                (void)bsp_IIC_WritePage(EEPROM_BLOCK7, 0, (INT8U *)&AccKm_Clear_Once_Flag[0], 4);
            }
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_Swap
* Description    : 
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Swap(INT16U *pData1, INT16U *pData2)
{
    INT16U psw;
    if ((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SortNByte
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SortNByte(INT16U *SortData, INT8U len)
{
    INT8U n = 0, m;
    for (; n < len - 1; n++)
    {
        for (m = n + 1; m < len; m++)
        {
            App_Swap((SortData + n), (SortData + m));
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SwapWord
* Description    : 
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SwapWord(INT32U *pData1, INT32U *pData2)
{
    INT32U psw;
    if ((*pData1) > (*pData2))
    {
        psw = (*pData2);
        (*pData2) = (*pData1);
        (*pData1) = psw;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_SortNWord
* Description    : 
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_SortNWord(INT32U *SortData, INT8U len)
{
    INT8U n = 0, m;
    for (; n < len - 1; n++)
    {
        for (m = n + 1; m < len; m++)
        {
            App_SwapWord((SortData + n), (SortData + m));
        }
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalDataLen
* Description    : ݳ
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U App_CalDataLen(INT32U data)
{
    INT8U len = 1;
    if (data / 10 > null)
        len = 2;
    if (data / 100 > null)
        len = 3;
    if (data / 1000 > null)
        len = 4;
    if (data / 10000 > null)
        len = 5;
    if (data / 100000 > null)
        len = 6;
    return len;
}
/*--------------------------------------------------------------------------
* Function Name  : App_FindSector
* Description    :
* Input          : INT16U val,INT8U virlen,EE_MeterType *MParam
* Output         : None
* Return         : INT16U
* onther         :
--------------------------------------------------------------------------*/
INT8U App_FindSector(INT16U val, _EE_MeterInfo *MParam)
{
    INT8U i, Order, SectorID = null;
    if (MParam->Resistor[0] > MParam->Resistor[MParam->bVirtualVal - 1])
    {
        Order = 0;
    }
    else
    {
        Order = 1;
    }
    for (i = 0; i < MParam->bVirtualVal - 1; i++)
    {
        if (Order == 1)
        {
            if (val >= MParam->Resistor[i])
            {
                SectorID++;
            }
        }
        if (Order == 0)
        {
            if (val <= MParam->Resistor[i])
            {
                SectorID++;
            }
        }
    }
    return SectorID;
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalMicroStep
* Description    : ӦߵĲ
* Input          : INT16U ADVAL,DashBoardPoint MParam
* Output         : None
* Return         : INT16U
* onther         : 㵱ǰADֵӦߵλ 
--------------------------------------------------------------------------*/
INT16U App_CalMicroStep(INT32U ADVAL, _EE_MeterInfo *MParam)
{
    INT8U SectorID = null;   //ID
    INT32U PerCentum = null; //ADVALռڿADİٷ*100
    INT32U StepCn = null;
    INT8U ASCF = null; //־λ

    /*:Чֽ5
    10    20    50    60    75
    |     |     |     |     |
    1   2   3   4
    */

    if ((MParam->bVirtualVal < 2) || (MParam->bVirtualVal > 10)) //ЧֵǷ
    {
        return null;
    }
    if (MParam->Resistor[1] > MParam->Resistor[0]) //
    {
        ASCF = 1;
    }
    if (MParam->Resistor[1] < MParam->Resistor[0]) //½
    {
        ASCF = 2;
    }
    if (ASCF == 1)
    {
        if (ADVAL >= MParam->Resistor[MParam->bVirtualVal - 1])
        {
            ADVAL = MParam->Resistor[MParam->bVirtualVal - 1];
        }
        if (ADVAL <= MParam->Resistor[0])
        {
            ADVAL = MParam->Resistor[0];
        }
    }
    if (ASCF == 2)
    {
        if (ADVAL <= MParam->Resistor[MParam->bVirtualVal - 1])
        {
            ADVAL = MParam->Resistor[MParam->bVirtualVal - 1];
        }
        if (ADVAL >= MParam->Resistor[0])
        {
            ADVAL = MParam->Resistor[0];
        }
    }
    SectorID = App_FindSector((INT16U)ADVAL, MParam);
    if (SectorID > (MParam->bVirtualVal - 1))
    {
        return null;
    }
    switch (SectorID)
    {
    case 1:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[0]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[1] - MParam->Resistor[0]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[0] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[0] - MParam->Resistor[1]);
        }
        StepCn = (MParam->DashStep[1] - MParam->DashStep[0]) * PerCentum / 100 + MParam->DashStep[0];
        break;
    }
    case 2:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[1]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[2] - MParam->Resistor[1]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[1] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[1] - MParam->Resistor[2]);
        }
        StepCn = (MParam->DashStep[2] - MParam->DashStep[1]) * PerCentum / 100 + MParam->DashStep[1];
        break;
    }
    case 3:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[2]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[3] - MParam->Resistor[2]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[2] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[2] - MParam->Resistor[3]);
        }
        StepCn = (MParam->DashStep[3] - MParam->DashStep[2]) * PerCentum / 100 + MParam->DashStep[2];
        break;
    }
    case 4:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[3]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[4] - MParam->Resistor[3]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[3] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[3] - MParam->Resistor[4]);
        }
        StepCn = (MParam->DashStep[4] - MParam->DashStep[3]) * PerCentum / 100 + MParam->DashStep[3];
        break;
    }
    case 5:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[4]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[5] - MParam->Resistor[4]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[4] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[4] - MParam->Resistor[5]);
        }
        StepCn = (MParam->DashStep[5] - MParam->DashStep[4]) * PerCentum / 100 + MParam->DashStep[4];
        break;
    }
    case 6:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[5]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[6] - MParam->Resistor[5]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[5] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[5] - MParam->Resistor[6]);
        }
        StepCn = (MParam->DashStep[6] - MParam->DashStep[5]) * PerCentum / 100 + MParam->DashStep[5];
        break;
    }
    case 7:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[6]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[7] - MParam->Resistor[6]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[6] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[6] - MParam->Resistor[7]);
        }
        StepCn = (MParam->DashStep[7] - MParam->DashStep[6]) * PerCentum / 100 + MParam->DashStep[6];
        break;
    }
    case 8:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[7]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[8] - MParam->Resistor[7]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[7] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[7] - MParam->Resistor[8]);
        }
        StepCn = (MParam->DashStep[8] - MParam->DashStep[7]) * PerCentum / 100 + MParam->DashStep[7];
        break;
    }
    case 9:
    {
        if (ASCF == 1)
        {
            PerCentum = ((ADVAL - MParam->Resistor[8]) * 100);
            PerCentum = PerCentum / (MParam->Resistor[9] - MParam->Resistor[8]);
        }
        if (ASCF == 2)
        {
            PerCentum = ((MParam->Resistor[8] - ADVAL) * 100);
            PerCentum = PerCentum / (MParam->Resistor[8] - MParam->Resistor[9]);
        }
        StepCn = (MParam->DashStep[9] - MParam->DashStep[8]) * PerCentum / 100 + MParam->DashStep[8];
        break;
    }
    }
    return (INT16U)(StepCn);
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalFre
* Description    : Ƶʼ
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CalFre(_FreType *Veh)
{
    if (CurVehCnt.dw32 > 0xffff0000)
    {
        CurVehCnt.dw32 = null;
    }
    if (Veh->Cycl > VehFreLimit)
    {
        if (g_vehMeter.CurBoardVal > 40)
        {
            Veh->Cycle[Veh->pCycle] = Veh->Cycl;
            Veh->pCycle++;
            if (Veh->pCycle >= 8)
            {
                Veh->pCycle = null;
                App_SortNWord((INT32U *)Veh->Cycle, 8);
                VehCycl = (Veh->Cycle[2] + Veh->Cycle[3] + Veh->Cycle[4] + Veh->Cycle[5]) / 4;

                w2 = TPM0Clock;
                w2 *= 10;
                if (VehCycl > VehFreLimit)
                {
                    Veh->CurFre = (INT16U)(w2 / VehCycl);
                }
                if ((Veh->CurFre % 10) > 5)
                {
                    Veh->CurFre = (Veh->CurFre + 10) / 10;
                }
                else
                {
                    Veh->CurFre = Veh->CurFre / 10;
                }
            }
        }
        else if ((g_vehMeter.CurBoardVal > 20) && (g_vehMeter.CurBoardVal <= 40))
        {
            Veh->Cycle[Veh->pCycle] = Veh->Cycl;
            Veh->pCycle++;
            if (Veh->pCycle >= 4)
            {
                Veh->pCycle = null;
                App_SortNWord((INT32U *)Veh->Cycle, 4);
                VehCycl = (Veh->Cycle[1] + Veh->Cycle[2]) / 2;
                w2 = TPM0Clock;
                w2 *= 10;
                if (VehCycl > VehFreLimit)
                {
                    Veh->CurFre = (INT16U)(w2 / VehCycl);
                }
                if ((Veh->CurFre % 10) > 5)
                {
                    Veh->CurFre = (Veh->CurFre + 10) / 10;
                }
                else
                {
                    Veh->CurFre = Veh->CurFre / 10;
                }
            }
        }
        else if ((g_vehMeter.CurBoardVal > 10) && (g_vehMeter.CurBoardVal <= 20))
        {
            Veh->Cycle[Veh->pCycle] = Veh->Cycl;
            Veh->pCycle++;
            if (Veh->pCycle >= 2)
            {
                Veh->pCycle = null;
                VehCycl = (Veh->Cycle[0] + Veh->Cycle[1]) / 2;
                w2 = TPM0Clock;
                w2 *= 10;
                if (VehCycl > VehFreLimit)
                {
                    Veh->CurFre = (INT16U)(w2 / VehCycl);
                }
                if ((Veh->CurFre % 10) > 5)
                {
                    Veh->CurFre = (Veh->CurFre + 10) / 10;
                }
                else
                {
                    Veh->CurFre = Veh->CurFre / 10;
                }
            }
        }
        else
        {
            Veh->Cycle[0] = Veh->Cycl;
            VehCycl = Veh->Cycle[0];
            w2 = TPM0Clock;
            w2 *= 10;
            if (VehCycl > VehFreLimit)
            {
                Veh->CurFre = (INT16U)(w2 / VehCycl);
            }
            if ((Veh->CurFre % 10) > 5)
            {
                Veh->CurFre = (Veh->CurFre + 10) / 10;
            }
            else
            {
                Veh->CurFre = Veh->CurFre / 10;
            }
        }
        if (Veh->CurFre <= Veh->Frequency)
        {
            Veh->Frequency = Veh->CurFre;
        }
        else if (Veh->CurFre < (Veh->Frequency + 180))
        {
            Veh->Frequency = Veh->CurFre;
        }
        API_SetTimer0(T_1_0s, (_Clock *)&g_Clock);
        Veh->Cycl = null;
    }

    if (API_TimerOver0((_Clock *)&g_Clock))
    {
        Veh->Frequency = null;
        Veh->CyclH = null;
        Veh->CyclL = null;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : App_CalBorad
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CalBorad(void)
{
    workMode_t MotorState[4] = {0, 0, 0, 0};
    //-- Լ --//
    if (CheckStep == 0)
    {
        MotorState[0] = bsp_GetMotorState(Motor_1);
        MotorState[1] = bsp_GetMotorState(Motor_2);

        if ((MotorState[0] == Normal) && (MotorState[1] == Normal))
        {
            bsp_SetMotorMode(Motor_1, MinReset);
            bsp_SetMotorMode(Motor_2, MinReset);

            CheckStep = 1;
        }
    }
    else if (CheckStep == 1)
    {
        MotorState[0] = bsp_GetMotorState(Motor_1);
        MotorState[1] = bsp_GetMotorState(Motor_2);

        if ((MotorState[0] == Normal) && (MotorState[1] == Normal))
        {
            CheckStep = 2;
            g_sysFlag.Bits.TempMeterInit = Enable;
            g_Init.InitTempTime = 0;
        }
    }
    else if (CheckStep == 2)
    {
        //-- Meter --//
        App_CalVehBoard();
        App_CalRevBoard();
        App_CalTempBoard();
        App_CalgasBoard();
        App_CalAdblueBoard();
        App_CoolWaterBoard();
    }

    //-- Fuel --//
    App_CalFuelBoard();

    //LOGO
    g_curLightFlag = 1;
    //if ((g_adcResult.AdcValue > V_16v) && (g_30LOGOFlag == 0))
    if (g_30LOGOFlag == 0x0u)
    {
        g_30LOGOFlag = 1;
        Gui_Logo_Disp();
    }
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalVehBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CalVehBoard(void)
{
    INT32U w_Temp;

    if (DIDFlag.Bits.DID1006Valid == Enable) //б
    {
        if (IOCTL_DID1006.FF_Byte == 1)
        {
            g_vehMeter.DestPosition = 2400;
        }
        else if (IOCTL_DID1006.FF_Byte == 2)
        {
            g_vehMeter.DestPosition = 1210;
        }
        else
        {
            g_vehMeter.DestPosition = 0;
        }
    }
    else if (DIDFlag.Bits.DID1001Valid == Enable)
    {
        if (IOCTL_DID1001.FF_Byte == 1)
        {
            g_vehMeter.DestPosition = 2400;
        }
        else if (IOCTL_DID1001.FF_Byte == 2)
        {
            g_vehMeter.DestPosition = 1210;
        }
        else
        {
            g_vehMeter.DestPosition = 0;
        }
    }
    else
    {
        App_CalVehSpdFromCap((_MeterPos *)&g_vehMeter, (_FreType *)&VehFre); //ʵʳ
        if (g_vehMeter.CurBoardVal > 160)
        {
            g_vehMeter.CurBoardVal = 160;
        }
        if (g_vehMeter.CurBoardVal > 5)
        {
            g_vehMeter.BoardVal = g_vehMeter.CurBoardVal + (g_vehMeter.CurBoardVal * 3) / 100 + 2; //ָʾ
        }
        else
        {
            g_vehMeter.BoardVal = g_vehMeter.CurBoardVal;
        }
        MeterPostion[Motor_2].destPosition = App_CalMicroStep((INT32U)g_vehMeter.BoardVal, (_EE_MeterInfo *)&g_vehMeterInfo);
    }

    //-- Ecu-out --//
    /*
    if (g_vehMeter.BoardVal)
    {
        w_Temp = 22000;

        EcuDuty = w_Temp / (g_vehMeter.BoardVal) / 4; //f = 2v
        if (((220000 / (g_vehMeter.BoardVal) / 4) % 10) > 5)
        {
            EcuDuty += 1;
        }
    }
    else
    {
        EcuDuty = 0xffffffff;

        //Ƶ
    }
    */
}
/*------------------------------------------------------------------------
* Function Name  : App_CalVehSpdFromCap
* Description    : ټ
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_CalVehSpdFromCap(_MeterPos *Meter, _FreType *Veh)
{
    INT32U CalVehSpd = null, VehSpd = null;
    two_int8u EveVehSpd;

    static INT8U div = 1, divcn = null;

    w2 = Veh->Frequency;
    g_adcResult.VehEven[g_adcResult.pVeh] = (INT16U)((w2 * 3600) / (Radio.VehRadio));

    if (g_adcResult.pVeh >= ADEveLen - 1)
    {
        g_adcResult.pVeh = null;
    }
    else
    {
        g_adcResult.pVeh++;
    }
    App_SortNByte((INT16U *)g_adcResult.VehEven, ADEveLen - 1);
    CalVehSpd = g_adcResult.VehEven[3];
    EveVehSpd.di = (INT16U)CalVehSpd;
    if (EveVehSpd.di > Meter->CurBoardVal)
    {
        VehSpd = EveVehSpd.di16.d8H;
        VehSpd /= ADEveLen - 1;
        CalVehSpd = Meter->CurBoardVal;
        CalVehSpd = CalVehSpd * VehSpd;
        CalVehSpd += EveVehSpd.di;
        VehSpd++;
        CalVehSpd /= VehSpd;
    }

    if (CalVehSpd <= 2)
    {
        divcn++;
        if (divcn > 200)
        {
            divcn = null;
            if (div < 5)
            {
                div++;
            }
        }
        CalVehSpd = CalVehSpd / div;
    }

    if (CalVehSpd > 3)
    {
        div = 1;
        divcn = null;
    }
    if (CalVehSpd > 10)
    {
        CalVehSpd += 1;
    }
    Meter->CurBoardVal = (INT16U)CalVehSpd;
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalRevBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CalRevBoard(void)
{
    if (DIDFlag.Bits.DID1006Valid == Enable) //б
    {
        if (IOCTL_DID1006.FF_Byte == 1)
        {
            g_revMeter.DestPosition = 2445;
        }
        else if (IOCTL_DID1006.FF_Byte == 2)
        {
            g_revMeter.DestPosition = 1232;
        }
        else
        {
            g_revMeter.DestPosition = 0;
        }
    }
    else if (DIDFlag.Bits.DID1002Valid == Enable)
    {
        if (IOCTL_DID1002.FF_Byte == 1)
        {
            g_revMeter.DestPosition = 2445;
        }
        else if (IOCTL_DID1002.FF_Byte == 2)
        {
            g_revMeter.DestPosition = 1232;
        }
        else
        {
            g_revMeter.DestPosition = 0;
        }
    }
    else
    {
        MeterPostion[Motor_1].destPosition = App_CalMicroStep((INT32U)g_revMeter.CurBoardVal, (_EE_MeterInfo *)&g_revMeterInfo);
    }
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalFuelBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CalTempBoard(void)
{
    if (DIDFlag.Bits.DID1006Valid == Enable) //б
    {
        if (IOCTL_DID1006.FF_Byte == 1)
        {
            g_tempMeter.DestPosition = 160;
        }
        else if (IOCTL_DID1006.FF_Byte == 2)
        {
            g_tempMeter.DestPosition = 80;
        }
        else
        {
            g_tempMeter.DestPosition = 0;
        }

        g_Init.InitTempTime = null;
        if (CheckStep == 2)
            Enable_signal(g_sysFlag.Bits.TempMeterInit);
    }
    else if (DIDFlag.Bits.DID1003Valid == Enable)
    {
        if (IOCTL_DID1003.FF_Byte == 1)
        {
            g_tempMeter.DestPosition = 160;
        }
        else if (IOCTL_DID1003.FF_Byte == 2)
        {
            g_tempMeter.DestPosition = 80;
        }
        else
        {
            g_tempMeter.DestPosition = 0;
        }

        g_Init.InitTempTime = null;
        if (CheckStep == 2)
            Enable_signal(g_sysFlag.Bits.TempMeterInit);
    }
    else
    {
        g_tempMeter.DestPosition = App_CalMicroStep((INT32U)g_tempMeter.CurBoardVal, (_EE_MeterInfo *)&g_tempMeterInfo);
    }
}
/*------------------------------------------------------------------------
* Function Name  : App_CalGsPrs1FromCap
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void  App_CalGsPrs1FromCap(_MeterPos *Meter, _AdcResult *Ade)
void App_CalGsPrs1FromCap(_AdcResult *Ade)
{
    INT32U wTemp = null;

    wTemp = Ade->Gas1Even[4];
    g_gas1Meter.CurBoardVal = (INT16U)((wTemp * 500) / 1024);
}
/*------------------------------------------------------------------------
* Function Name  : App_CalGsPrs2FromCap
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
//void  App_CalGsPrs2FromCap(_MeterPos *Meter, _AdcResult *Ade)
void App_CalGsPrs2FromCap(_AdcResult *Ade)
{
    INT32U wTemp = null;

    wTemp = Ade->Gas2Even[4];
    g_gas2Meter.CurBoardVal = (INT16U)((wTemp * 500) / 1024);
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalgasBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CalgasBoard(void)
{
    if (DIDFlag.Bits.DID1006Valid == Enable) //б
    {
        if (IOCTL_DID1006.FF_Byte == 1)
        {
            g_gas1Meter.DestPosition = 240;
            g_gas2Meter.DestPosition = 240;
        }
        else if (IOCTL_DID1006.FF_Byte == 2)
        {
            g_gas1Meter.DestPosition = 120;
            g_gas2Meter.DestPosition = 120;
        }
        else
        {
            g_gas1Meter.DestPosition = 0;
            g_gas2Meter.DestPosition = 0;
        }

        g_Init.InitGas1Time = null;
        g_Init.InitGas2Time = null;
        Enable_signal(g_sysFlag.Bits.Gas1MeterInit);
        Enable_signal(g_sysFlag.Bits.Gas2MeterInit);
    }
    else if (DIDFlag.Bits.DID1005Valid == Enable)
    {
        if (IOCTL_DID1005.FF_Byte == 1)
        {
            g_gas1Meter.DestPosition = 240;
            g_gas2Meter.DestPosition = 240;
        }
        else if (IOCTL_DID1005.FF_Byte == 2)
        {
            g_gas1Meter.DestPosition = 120;
            g_gas2Meter.DestPosition = 120;
        }
        else
        {
            g_gas1Meter.DestPosition = 0;
            g_gas2Meter.DestPosition = 0;
        }

        g_Init.InitGas1Time = null;
        g_Init.InitGas2Time = null;
        Enable_signal(g_sysFlag.Bits.Gas1MeterInit);
        Enable_signal(g_sysFlag.Bits.Gas2MeterInit);
    }
    else
    {
        //1һΣΪĿ곧ҵıһ,
        if (Gas_Timer >= T_1s)
        {
            //App_CalGsPrs1FromCap((_MeterPos *)&g_gas1Meter, (_AdcResult *)& g_adcResult);
            App_CalGsPrs1FromCap((_AdcResult *)&g_adcResult);
            //App_CalGsPrs2FromCap((_MeterPos *)&g_gas2Meter, (_AdcResult *)& g_adcResult);
            App_CalGsPrs2FromCap((_AdcResult *)&g_adcResult);
            g_gas1Meter.DestPosition = App_CalMicroStep((INT32U)g_gas1Meter.CurBoardVal, (_EE_MeterInfo *)&g_gasMeterInfo);
            g_gas2Meter.DestPosition = App_CalMicroStep((INT32U)g_gas2Meter.CurBoardVal, (_EE_MeterInfo *)&g_gasMeterInfo);
            Gas_Timer = 0;
        }
    }
}
/*--------------------------------------------------------------------------
* Function Name  : App_CalAdblueBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CalAdblueBoard(void)
{
    g_adblueMeter.DestPosition = App_CalMicroStep((INT32U)g_adblueMeter.CurBoardVal, (_EE_MeterInfo *)&g_adblueMeterInfo);
}
/*--------------------------------------------------------------------------
* Function Name  : App_CoolWaterBoard
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         : qitiancun
--------------------------------------------------------------------------*/
void App_CoolWaterBoard(void)
{
    INT32U temp;
    //INT32U  temp1;
    //INT32U  Vcc;
    INT32U RL;
    temp = (g_adcResult.CoolLiquidEven[3] + g_adcResult.CoolLiquidEven[4] + g_adcResult.CoolLiquidEven[5]) / 3;
    temp += 5;
    if (temp > 1023)
    {
        temp = 1023;
    }
    RL = (temp * 300) / (1024 - temp);

    g_RCoolWater = (INT16U)RL;
}
