

#ifndef PROTOCOL_H_
#define PROTOCOL_H_
#include "defines.h"

#define            MaxBuff        266

typedef enum
{
    STATE0 = 1, N_OK, CTS, WAIT, OVFLW, N_TIMEOUT_Bs, N_ERROR, N_INVALID_FS, N_WRONG_SN
} Enum_Result;


typedef enum
{
    empoty, full
} TransSt;

typedef struct
{
    INT16U       Identifier;//Fun--PGN--
    INT8U        DLC;
    INT8U        Data[8];
    TransSt    TransferStatus;
} _LinkData;

typedef struct
{
    struct
    {
        INT16U  pos;
        INT16U  Length;
        INT16U  N_FC_Num;
        INT16U  N_RecSN_L;
        INT8U   N_SendSN;
        INT8U   N_BS_CNT;
        INT8U   N_BS;
        INT8U   N_SA;
        INT8U   N_TA;
        INT8U   N_PCI;
        INT8U   N_SID;
    } ind;
} _N_US_Data_FF;

typedef struct
{
    struct
    {
        INT16U  N_TAtype;
        INT16U  Length;
        INT8U   N_SA;
        INT8U   N_TA;
        INT8U   N_AE;
        INT8U   N_PCI;
        INT8U   MsgData[8];
        Enum_Result N_Result;
    } ind;
} _N_USSFData;

//-- Ϣ --//
typedef struct
{
    struct
    {
        INT16U  N_TAtype;//PGN  55808--0xDA00
        INT16U  Length; //ֽڳ
        INT8U   N_SA;
        INT8U   N_TA;
        INT8U   N_AE;
        INT8U   N_PCI;
        INT8U   MsgData[MaxBuff];//ֽϢ
        Enum_Result N_Result;
    } ind;
} _N_USData;

typedef struct
{
    struct
    {
        INT8U   len;
        INT8U   MsgData[8];
        INT8U   N_Result;
    } ind;
} _N_RSPData;

//-- ӹ --//
typedef union
{
    struct
    {
        INT8U    SubFunBit0_6 : 7;//ӹ
        INT8U    SubFunBit7_7 : 1;
    } SubBits;
    INT8U SubData;
} _SubFun;

//-- ϵǰ״̬ --//
typedef struct
{
    INT8U    SessionType; //Ựģʽ
    INT8U    AccessLock;  //ȫ
    INT8U    AccessCount;
    INT8U    key[4];      //Կ
    INT8U    SubFunction;
    INT8U    w27_Sequence;
    INT8U    A5_Sequence;
    INT8U    DTCSettingType;
    INT8U    tDiagStart;
    INT8U    tDiagKL30ONStart;
    INT8U    N_STmin;
    INT8U    N_REV_MAX_BS;
    INT8U    CommType;
    INT8U    CommCtl;
    INT8U    DTCByStatusMask;
} _DiagnoCtl;

typedef struct
{
    INT16U   N_TAtype; //PGN--55808--DA00
    INT8U    FrameErr; //
    INT8U    RespSerId;
} _ErrorFrame;

typedef struct
{
    INT32U   OverBsTime;
    INT32U   BsTime;

    INT32U   OverSTminTime;
    INT32U   STminTime;

    INT32U   OverCrTime;
    INT32U   CrTime;

    INT32U   OverSessionTime;
    INT32U   SessionTime;

    INT32U   OverSequenceTime;
    INT32U   SequenceTime;

    INT32U   OverUnlockTime;
    INT32U   UnlockTime;

    INT8U    TT_BsEnable;

    INT8U    TT_STminEnable;

    INT8U    TT_CrEnable;

    INT8U    TT_SessionEnable;

    INT8U    TT_SequenceEnable;

    INT8U    TT_UnlockEnable;

    INT8U    E2_WriteTime;

} _DiagClock;

typedef union
{
    struct
    {
        INT8U     Reserved1: 1;
        INT8U     Reserved2: 1;
        INT8U     Reserved3: 1;
        INT8U     Reserved4: 1;
        INT8U     Reserved5: 1;
        INT8U     Reserved6: 1;
        INT8U     Reserved7: 1;
        INT8U     DiagWriteEn: 1;
    } FlagBits;
    INT8U Flag;
} _DiagFlag;

typedef union
{
    struct
    {
        INT8U  TestFailed : 1;
        INT8U  TestFailedThisOprCyc : 1;
        INT8U  PendingDTC : 1;
        INT8U  ConfirmedDTC : 1;
        INT8U  TestNotCompLastClr : 1;
        INT8U  TestFailedLastClr : 1;
        INT8U  TestNotCompThisCyc : 1;
        INT8U  WarnIndicatorReq : 1;
    } Bits;
    INT8U Flag;
} _StatusOfDTC;

typedef union
{
    struct
    {
        INT8U        DtcNumL;
        INT8U        DtcNumM;
        INT8U        DtcNumH;
        INT8U        Reserved0;
    } Bytes;
    INT32U Num;
} _NumOfDTC;

//-- DTC num --//
typedef struct
{
    INT8U        DTCHighByte;
    INT8U        DTCMiddleByte;
    INT8U        DTCLowByte;
    INT8U        statusOfDTC;
} _DTC_StatusRecord;

//-- DTCϢ --//16byte
typedef struct
{
    _NumOfDTC     DtcNum;
    INT8U         Addr;
    INT8U         bFlag;
    _StatusOfDTC  Status;
    INT8U         FaultOccurCount;
    INT8U         FaultPendCount;
    INT8U         DTCAgingCount;
    INT8U         DTCAgedCount;
    INT8U         ErrorTimes;
    INT8U         DTCAgingCntStar;
    INT8U         FaultPendingCntStar;
    INT8U         PassTimes;
    INT8U         bCheckSun;
} _DTC;

typedef struct
{
    INT8U    EE_WriteDtcSel;
    INT8U    DtcStep;
    INT8U    EE_WriteSnapSel;
    INT8U    SnapStep;
} _SaveDtcInfo;


typedef struct
{
    INT8U       Checkflag;
    INT8U       SAFC;
    INT8U       Reserved0;
    INT8U       Reserved1;
    INT8U       Reserved2;
    INT8U       Reserved3;
    INT8U       Reserved4;
    INT8U       Reserved5;
    INT8U       Reserved6;
    INT8U       Reserved7;
    INT8U       Reserved8;
    INT8U       Reserved9;
    INT8U       Reserved10;
    INT8U       Reserved11;
    INT8U       Reserved12;
    INT8U       bCheckSun;       //
} _SID_27_INFO;

typedef struct
{
    INT32U       DtcNum;
    INT8U        DTCExtDataRecordNum;
} _19_6ReqRecord;

typedef struct
{
    INT32U       NumAndStatus;
    INT8U        dlc;
    INT8U        Data[8];
} _19_6RetRecord;


#endif /* PROTOCOL_H_ */
