/*
 * app_System.c
 *
 *  Created on: Aug 11, 2014
 *      Author: QTC
 */

#define GLOBALS_APP_SYS
#include "../app_Headers/g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : App_Paramer_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Paramer_Init(void)
{

    bEnterMenuSwFlag = 0;
    bSetMenuSwFlag = 0;
    g_adcResult.FuelCn = null;
    //radar
    RadarCheck.Check = 0;
    RararData.Data = 0;
    bRadarFlag = 0;
    bRadarNu = 0;
    bRadCheckNu = 0;
    bRadarDropCn = 50;
    RadarRRCn = 0;
    RadarRMCn = 0;
    RadarRLCn = 0;
    //
    g_revDelay = 3000;
    g_vehDelay = 3000;
    //
    EcuDuty = null;
    EcuTime = null;
    //
    bRadioAbandonCn = 40;
    bSetRedLightAbandonCn = 40;
    //
    bWaterAlarmCn = 30;
    bWaterReAlarmCn = 30;
    //
    Dis_Num = 0;
    g_canClock.BusOffTime = null;
    g_canClock.CanKeepTime = null;
    g_canClock.CanDataCn = null;

    //Enable_signal(g_canClock.signal.ExistF004);

    // g_canClock.IDF004Cn       = 200;  //10ms
    // g_canClock.IDFE56Cn       = 200;  //10ms
    g_Init.InitLedCheckTime = 0;
    g_Init.InitLedCheckOBDTime = 0;
    g_canMsgFE56.ProceF == EMPTY;
    if (G_Button.MainMenu != 4)
    {

        G_Button.MainMenu = 1;
        g_ClearWin1 = 1;
    }
    g_ClearWin2 = 0;
    g_ClearWin3 = 0;
    //g_ClearWin4 = 0;
    g_Clearalarm = 0;

    g_VehDis = 1;
    G_Button.SET_TIME = 0;

    Enable_signal(g_sysFlag.Bits.SysOffEn);
    Enable_signal(g_sysFlag.Bits.AccKmValid);
    Enable_signal(g_sysFlag.Bits.BeepProcEn);
    Disable_signal(g_sysFlag.Bits.TempMeterInit);
    Disable_signal(g_sysFlag.Bits.FuelMeterInit);
    Disable_signal(g_sysFlag.Bits.AdjEnable);
    Disable_signal(g_sysFlag.Bits.PowerLvi);
    if (!g_sysFlag.Bits.WakeUpState)
    {
        Enable_signal(g_sysFlag.Bits.CanWakeUp);
    }

    //motor
    g_vehMeter.Dir = keep_local;
    g_vehMeter.DestPosition = null;
    g_vehMeter.CurPosition = null;
    g_vehMeter.CurBoardVal = null;
    g_vehMeter.OldBoardVal = null;
    g_vehMeter.CalTime = null;
    g_vehMeter.MoveEn = Disable;

    g_revMeter.Dir = keep_local;
    g_revMeter.DestPosition = null;
    g_revMeter.CurPosition = null;
    g_revMeter.CurBoardVal = null;
    g_revMeter.MoveEn = Disable;

    g_gas1Meter.Dir = keep_local;
    g_gas1Meter.DestPosition = null;
    g_gas1Meter.CurPosition = null;
    g_gas1Meter.CurBoardVal = null;
    g_gas1Meter.MoveEn = Disable;

    g_gas2Meter.Dir = keep_local;
    g_gas2Meter.DestPosition = null;
    g_gas2Meter.CurPosition = null;
    g_gas2Meter.CurBoardVal = null;
    g_gas2Meter.MoveEn = Disable;

    g_fuelMeter.Dir = keep_local;
    g_fuelMeter.CurPosition = null;
    g_fuelMeter.Time = null;

    g_tempMeter.CurBoardVal = 40;
    g_tempMeter.CurPosition = null;
    g_tempMeter.DestPosition = null;
    g_tempMeter.Time = null;

    g_fuelEco.CurFuel = null;
    g_fuelEco.InstFuel = null;
    g_fuelEco.FlashTime = T_1s;
    g_fuelEco.AveTime = T_15s;
    g_fuelEco.pInst = null;
    g_fuelEco.BuffFull = null;
    g_fuelEco.Dir = keep_local;

    g_lcdVeh.BoardVal = null;
    g_lcdVeh.CurBoardVal = null;
    g_lcdVeh.Time = null;

    g_nopBeep.Prio = DisAlr;
    g_nopBeep.OnTime = null;
    g_nopBeep.OffTime = null;
    g_nopBeep.BeepTime = null;
    g_nopBeep.BeepCn = null;
    g_nopBeep.CurBeepCn = null;

    //if(g_pBeep->Prio == null)
    {
        g_pBeep = &g_nopBeep;
    }

    g_Init.InitFuelTime = null;
    g_Init.InitTempTime = null;
    g_Init.InitAdblueTime = null;
    g_Init.InitLogoTime = null;
    g_Init.InitFuelCn = null;
    g_Init.BmpID = 0;

    g_runStep = SYS_INIT_TASK;

    g_accTime = null;
    g_accVeh = null;
    g_accKmClrStep = null;

    Api_Set10msTimer(T1_10ms, (_Clock *)&g_Clock);

    Api_SetBaseTimer(T_100ms, (_Clock *)&g_Clock);
    Gui_Offset_Init();
    bDSTable[ID_FUELLOW] &= (~(DS0_MASK | DS1_MASK)); //clear DS0 & DS1
    bDSTable[ID_ADBLUE] &= (~(DS0_MASK | DS1_MASK));  //clear DS0 & DS1
    ////////////////////glz--20170107
    CanMinuteTime = 0;
    bCurMenuIDX = 0;
    bNextMenuIDX = 0;
    bMenuSwFlag = 1;
}

/*-------------------------------------------------------------------------
* Function Name  : App_State_OFF
* Description    : ״̬ر
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_State_OFF(void)
{
}
/*-------------------------------------------------------------------------
* Function Name  : App_StarUpInfo
* Description    : ʼϢ
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_StarUpInfo(void)
{
    pSTBout = LOW;

    Enable_signal(g_sysFlag.Bits.NetCtlKeep);
    Enable_signal(g_sysFlag.Bits.BeepProcEn);
    Disable_signal(g_sysFlag.Bits.PowerLvi);
    Disable_signal(g_sysFlag.Bits.BeepOn);

    Api_SetBaseTimer(T_100ms, (_Clock *)&g_Clock);
    Api_SetCanTimer(T_8s, (_Clock *)&g_Clock);

    g_fuelMeter.CurBoardVal = null;
    g_fuelMeter.OldBoardVal = null;

    Disable_signal(g_vehMeter.MakeZero);
    Disable_signal(g_revMeter.MakeZero);
    Disable_signal(g_gas1Meter.MakeZero);
    Disable_signal(g_gas2Meter.MakeZero);

    g_OverSpeed = 120;

    g_fuelMeter.OldPosition = null;

    Gui_MenuInit();
    Gui_Offset_Init();

    g_runStep = SYS_INIT_TASK;

    pABSout = LEDOFF;
    pOilout = LEDOFF;
    pFuelOut = LEDOFF;
    pTempOut = LEDOFF;
}

/*-------------------------------------------------------------------------
* Function Name  : App_Load_Data
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Load_Data(void)
{

    bsp_IIC_ReadPage(0xa2, EE_REVREDLED_ADDR, (INT8U *)&Rev_RedLight, 8);
    g_chksun = Api_CreateCRCCheckSum((INT8U *)&Rev_RedLight, 6);
    if ((Rev_RedLight.bCheckFlag != 0x55) || (g_chksun != Rev_RedLight.bCheckSun))
    {
        Rev_RedLight.RevRedLight = 3200;
        Rev_RedLight.bSetAdblue = 0;
        Rev_RedLight.bSetCheck = 0;
    }

    //
    bsp_IIC_ReadPage(0xa2, EE_RADIO_ADDR, (INT8U *)&Radio, 10);
    g_chksun = Api_CreateCRCCheckSum((INT8U *)&Radio, 8);
    if ((Radio.bCheckFlag != 0x55) || (g_chksun != Radio.bCheckSun))
    {
        Radio.RevRadio = 2;
        Radio.VehRadio = 520;
        Radio.VehC3Radio = 1;
        Radio.VehNum = 8;
    }

    Api_ReadMeterInfo(0xa0, EE_VEH_ADDR, (INT8U *)&g_vehMeterInfo);
    g_chksun = Api_CreateCheckSun((INT8U *)&g_vehMeterInfo.Resistor[0], g_vehMeterInfo.bFlag, 33);

    if ((g_vehMeterInfo.bFlag != 0x55) || (g_vehMeterInfo.bCheckSun != g_chksun))
    {
        g_vehMeterInfo.bVirtualVal = 8;
        g_vehMeterInfo.Resistor[0] = 0;
        g_vehMeterInfo.Resistor[1] = 20;
        g_vehMeterInfo.Resistor[2] = 40;
        g_vehMeterInfo.Resistor[3] = 60;
        g_vehMeterInfo.Resistor[4] = 80;
        g_vehMeterInfo.Resistor[5] = 100;
        g_vehMeterInfo.Resistor[6] = 120;
        g_vehMeterInfo.Resistor[7] = 140;

        g_vehMeterInfo.DashStep[0] = 0;
        g_vehMeterInfo.DashStep[1] = 360;  //20
        g_vehMeterInfo.DashStep[2] = 735;  //40
        g_vehMeterInfo.DashStep[3] = 1085; //60
        g_vehMeterInfo.DashStep[4] = 1445; //80
        g_vehMeterInfo.DashStep[5] = 1805; //100
        g_vehMeterInfo.DashStep[6] = 2165; //120
        g_vehMeterInfo.DashStep[7] = 2525; // 140
    }

    g_vehLcdInfo.bVirtualVal = g_vehMeterInfo.bVirtualVal;
    g_vehLcdInfo.Resistor[0] = g_vehMeterInfo.Resistor[0] * 10;
    g_vehLcdInfo.Resistor[1] = g_vehMeterInfo.Resistor[1] * 10;
    g_vehLcdInfo.Resistor[2] = g_vehMeterInfo.Resistor[2] * 10;
    g_vehLcdInfo.Resistor[3] = g_vehMeterInfo.Resistor[3] * 10;
    g_vehLcdInfo.Resistor[4] = g_vehMeterInfo.Resistor[4] * 10;
    g_vehLcdInfo.Resistor[5] = g_vehMeterInfo.Resistor[5] * 10;
    g_vehLcdInfo.Resistor[6] = g_vehMeterInfo.Resistor[6] * 10;
    g_vehLcdInfo.Resistor[7] = g_vehMeterInfo.Resistor[7] * 10;

    g_vehLcdInfo.DashStep[0] = g_vehMeterInfo.DashStep[0];
    g_vehLcdInfo.DashStep[1] = g_vehMeterInfo.DashStep[1];
    g_vehLcdInfo.DashStep[2] = g_vehMeterInfo.DashStep[2];
    g_vehLcdInfo.DashStep[3] = g_vehMeterInfo.DashStep[3];
    g_vehLcdInfo.DashStep[4] = g_vehMeterInfo.DashStep[4];
    g_vehLcdInfo.DashStep[5] = g_vehMeterInfo.DashStep[5];
    g_vehLcdInfo.DashStep[6] = g_vehMeterInfo.DashStep[6];
    g_vehLcdInfo.DashStep[7] = g_vehMeterInfo.DashStep[7];

    //
    Api_ReadMeterInfo(0xa0, EE_REV_ADDR, (INT8U *)&g_revMeterInfo);
    g_chksun = Api_CreateCheckSun((INT8U *)&g_revMeterInfo.Resistor[0], g_revMeterInfo.bFlag, 33);

    if ((g_revMeterInfo.bFlag != 0x55) || (g_revMeterInfo.bCheckSun != g_chksun))
    {
        g_revMeterInfo.bVirtualVal = 5;
        g_revMeterInfo.Resistor[0] = 0;
        g_revMeterInfo.Resistor[1] = 500;
        g_revMeterInfo.Resistor[2] = 1000;
        g_revMeterInfo.Resistor[3] = 3000;
        g_revMeterInfo.Resistor[4] = 5000;
        g_revMeterInfo.Resistor[5] = 0;
        g_revMeterInfo.Resistor[6] = 0;
        g_revMeterInfo.Resistor[7] = 0;

        g_revMeterInfo.DashStep[0] = 0;
        g_revMeterInfo.DashStep[1] = 256;  //
        g_revMeterInfo.DashStep[2] = 476;  //
        g_revMeterInfo.DashStep[3] = 1356; //
        g_revMeterInfo.DashStep[4] = 2236; //
        g_revMeterInfo.DashStep[5] = 0;    //
        g_revMeterInfo.DashStep[6] = 0;    //
        g_revMeterInfo.DashStep[7] = 0;    //
    }

    //
    g_gas1MeterInfo.bVirtualVal = 7;

    g_gas1MeterInfo.Resistor[0] = 102; //0
    g_gas1MeterInfo.Resistor[1] = 239; //2
    g_gas1MeterInfo.Resistor[2] = 374; //4
    g_gas1MeterInfo.Resistor[3] = 512; //6
    g_gas1MeterInfo.Resistor[4] = 649; //8
    g_gas1MeterInfo.Resistor[5] = 784; //10
    g_gas1MeterInfo.Resistor[6] = 921; //12
    g_gas1MeterInfo.Resistor[7] = 0;

    g_gas1MeterInfo.DashStep[0] = 0;
    g_gas1MeterInfo.DashStep[1] = 240;  //
    g_gas1MeterInfo.DashStep[2] = 480;  //
    g_gas1MeterInfo.DashStep[3] = 720;  //
    g_gas1MeterInfo.DashStep[4] = 960;  //
    g_gas1MeterInfo.DashStep[5] = 1200; //
    g_gas1MeterInfo.DashStep[6] = 1440; //
    g_gas1MeterInfo.DashStep[7] = 0;    //

    //
    g_gas2MeterInfo.bVirtualVal = 7;

    g_gas2MeterInfo.Resistor[0] = 102; //0
    g_gas2MeterInfo.Resistor[1] = 239; //2
    g_gas2MeterInfo.Resistor[2] = 374; //4
    g_gas2MeterInfo.Resistor[3] = 512; //6
    g_gas2MeterInfo.Resistor[4] = 649; //8
    g_gas2MeterInfo.Resistor[5] = 784; //10
    g_gas2MeterInfo.Resistor[6] = 921; //12
    g_gas2MeterInfo.Resistor[7] = 0;

    g_gas2MeterInfo.DashStep[0] = 0;
    g_gas2MeterInfo.DashStep[1] = 240;  //
    g_gas2MeterInfo.DashStep[2] = 480;  //
    g_gas2MeterInfo.DashStep[3] = 720;  //
    g_gas2MeterInfo.DashStep[4] = 960;  //
    g_gas2MeterInfo.DashStep[5] = 1200; //
    g_gas2MeterInfo.DashStep[6] = 1440; //
    g_gas2MeterInfo.DashStep[7] = 0;    //
    //////
    g_tempMeterInfo.bVirtualVal = 6;

    g_tempMeterInfo.Resistor[0] = 226;
    g_tempMeterInfo.Resistor[1] = 169;
    g_tempMeterInfo.Resistor[2] = 112;
    g_tempMeterInfo.Resistor[3] = 55;
    g_tempMeterInfo.Resistor[4] = 40;
    g_tempMeterInfo.Resistor[5] = 26; //
    g_tempMeterInfo.Resistor[6] = 0;  //
    g_tempMeterInfo.Resistor[7] = 0;  //

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 100;
    g_tempMeterInfo.DashStep[4] = 120;
    g_tempMeterInfo.DashStep[5] = 141;
    g_tempMeterInfo.DashStep[6] = 0;
    g_tempMeterInfo.DashStep[7] = 0;
    /////
    //////
    g_tempcanMeterInfo.bVirtualVal = 6;

    g_tempcanMeterInfo.Resistor[0] = 50;
    g_tempcanMeterInfo.Resistor[1] = 70;
    g_tempcanMeterInfo.Resistor[2] = 80;
    g_tempcanMeterInfo.Resistor[3] = 100;
    g_tempcanMeterInfo.Resistor[4] = 110;
    g_tempcanMeterInfo.Resistor[5] = 115; //
    g_tempcanMeterInfo.Resistor[6] = 0;   //
    g_tempcanMeterInfo.Resistor[7] = 0;   //

    g_tempcanMeterInfo.DashStep[0] = 0;
    g_tempcanMeterInfo.DashStep[1] = 35;
    g_tempcanMeterInfo.DashStep[2] = 52;
    g_tempcanMeterInfo.DashStep[3] = 100;
    g_tempcanMeterInfo.DashStep[4] = 120;
    g_tempcanMeterInfo.DashStep[5] = 141;
    g_tempcanMeterInfo.DashStep[6] = 0;
    g_tempcanMeterInfo.DashStep[7] = 0;
    /////
    g_fuelMeterInfo.bVirtualVal = 5;
    g_fuelMeterInfo.Resistor[0] = 1100;
    g_fuelMeterInfo.Resistor[1] = 715;
    g_fuelMeterInfo.Resistor[2] = 325;
    g_fuelMeterInfo.Resistor[3] = 175;
    g_fuelMeterInfo.Resistor[4] = 30;
    g_fuelMeterInfo.Resistor[5] = 0;
    g_fuelMeterInfo.Resistor[6] = 0;
    g_fuelMeterInfo.Resistor[7] = 0;

    g_fuelMeterInfo.DashStep[0] = 0;
    g_fuelMeterInfo.DashStep[1] = 20;
    g_fuelMeterInfo.DashStep[2] = 70;
    g_fuelMeterInfo.DashStep[3] = 100;
    g_fuelMeterInfo.DashStep[4] = 141;
    g_fuelMeterInfo.DashStep[5] = 0;
    g_fuelMeterInfo.DashStep[6] = 0;
    g_fuelMeterInfo.DashStep[7] = 0;

    g_fuelEcoParamer.bVirtualVal = 4;

    g_fuelEcoParamer.Resistor[0] = 0;
    g_fuelEcoParamer.Resistor[1] = 100;
    g_fuelEcoParamer.Resistor[2] = 500;
    g_fuelEcoParamer.Resistor[3] = 1000;

    g_fuelEcoParamer.DashStep[0] = 0;
    g_fuelEcoParamer.DashStep[1] = 3;
    g_fuelEcoParamer.DashStep[2] = 24;
    g_fuelEcoParamer.DashStep[3] = 48;

    w = TPM0Clock;
    w1 = g_vehMeterInfo.Resistor[g_vehMeterInfo.bVirtualVal - 1];
    VehFreLimit = w / (w1 * Radio.VehRadio * Radio.VehNum / 3600) / 4;
    w = TPM1Clock;
    w1 = g_revMeterInfo.Resistor[g_revMeterInfo.bVirtualVal - 1];
    RevFreLimit = w / (w1 * Radio.RevRadio / 60) / 4;
    Rev_Limit = App_CalMicroStep((INT32U)Rev_RedLight.RevRedLight, (_EE_MeterInfo *)&g_revMeterInfo);
}
