
#ifdef        GLOBALS_BSP_IIC
#define   EXTERN_BSP_IIC
#else
#define   EXTERN_BSP_IIC     extern
#endif

#ifndef BSP_IIC_H_
#define BSP_IIC_H_

    //-- 8Block*256 --//
    #define  EEPROM_BLOCK0 0xA0 //Acckm
    #define  EEPROM_BLOCK1 0xA2 //2E
    #define  EEPROM_BLOCK2 0xA4 //DTC
    #define  EEPROM_BLOCK3 0xA6 //DTC
    #define  EEPROM_BLOCK4 0xA8 
    #define  EEPROM_BLOCK5 0xAA
    #define  EEPROM_BLOCK6 0xAC
    #define  EEPROM_BLOCK7 0xAE

    #define                 IIC_WaitOverTime                  8500
    #define     	          RunErr                	          0
    #define     	          RunComplete            	          1
    #define     	          ACK                	              0
    #define     	          NACK            	                1

    #define                 SCL                               PTP_PTP2

    #define                 SDA                               PTP_PTP3
    #define                 SDADIR                            DDRP_DDRP3


    EXTERN_BSP_IIC		void            bsp_IIC_delay(void);
    EXTERN_BSP_IIC		void            bsp_IIC_Start(void);
    EXTERN_BSP_IIC		void            bsp_IIC_Stop(void);
    EXTERN_BSP_IIC		void            bsp_IIC_ACK(void);
    EXTERN_BSP_IIC		void            bsp_IIC_NACK(void);
    EXTERN_BSP_IIC		INT8U           bsp_IIC_WaitAck(void);
    EXTERN_BSP_IIC		INT8U           bsp_IIC_SendByte(INT8U Data);
    EXTERN_BSP_IIC    INT8U           bsp_IIC_WritePage(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data, INT8U len);
    EXTERN_BSP_IIC    INT8U           bsp_IIC_ReadByte(void);
    EXTERN_BSP_IIC    INT8U           bsp_IIC_ReadPage(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data, INT8U len);

#endif /* BSP_IIC_H_ */
