#define GLOBALS_API_SYS
#include "defines.h"
#include "g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : bsp_Clk_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Clk_Init(void)
{
    INT32U    dwTime = 0;
    
    PLLCTL_CME = 1;
    PLLCTL_SCME = 0;
    
    SYNR       = 0x43;               //óϵ
    REFDV      = 0x80;               //÷Ƶϵ  2Ƶ
    POSTDIV    = 0x00;               //÷Ƶ
    
    COPCTL     = 0x47;            //Ź
    
    while(!CRGFLG_LOCK)              //ȴȶ
    {
        dwTime++;
        _FEED_COP();
        if(dwTime > 10000)
        {
            dwTime = null;
            break;
        }
    }
    
    CLKSEL_PLLSEL = Enable;              //1 System clocks are derived from PLLCLK (fBUS = fPLL / 2).
    
    CLKSEL_PSTP  = Enable;               //ֹͣģʽ
    
    PLLCTL_PRE     = 1;                  //1 RTI continues running during Pseudo Stop Mode.
    PLLCTL_PCE     = 1;                  //1 COP continues running during Pseudo Stop Mode
    
    CLKSEL_RTIWAI = 0;                   //RTI WAITģʽ
    
    CLKSEL_COPWAI  = 0;                  //0 COP keeps running in Wait Mode.
    CLKSEL_PLLWAI  = 0;                  //0 IPLL keeps running in Wait Mode.
    
    VREGHTCL      = Disable;              //¶ȱֹ
    //ж
    CRGINT_SCMIE  = Disable;              //Osc
    CRGINT_LOCKIE = Disable;              //Lock
    //RTI
    RTICTL_RTDEC  = 1;                    //ʮ
    RTICTL_RTR    = 0x5F;                 //200*10^3  4M:0x53;
    
    CRGINT_RTIE   = Enable;               //RTI
    VREGCTRL_LVIE = Disable;               //LV
    IRQCR         = Disable;              //IRQ
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Sys_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Sys_Init(void)
{
    DisableInterrupts;
    bsp_Clk_Init();
    EnableInterrupts;
    bsp_GPIO_Init();
    bsp_MeterConfig();
    bsp_ADC_Init();
    Api_PWM_Init();
    bsp_CAN_Init();
    bsp_TIMER0_Init(TPM_DIV1);
    bsp_TIMER1_Init(TPM_DIV1);
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Sys_ON
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Sys_ON(void)
{ 
    bsp_Clk_Init();
    bsp_GPIO_Init();
	  bsp_MeterConfig();
    bsp_TIMER0_Init(TPM_DIV1);
    bsp_TIMER1_Init(TPM_DIV1);   
}
/*-------------------------------------------------------------------------
* Function Name  : bsp_Sys_OFF
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void bsp_Sys_OFF(void)
{
    MCCTL1_MCTOIE  = Disable;
    /*
    MCCC0_MCOM          = 0;
    MCCC0_MCAM          = 0;
    MCCC0_CD            = 0;
    MCCC1_MCOM          = 0;
    MCCC1_MCAM          = 0;
    MCCC1_CD            = 0;
    
    MCCC2_MCOM          = 0;
    MCCC2_MCAM          = 0;
    MCCC2_CD            = 0;
    MCCC3_MCOM          = 0;
    MCCC3_MCAM          = 0;
    MCCC3_CD            = 0;
    
    MCCC4_MCOM          = 0;
    MCCC4_MCAM          = 0;
    MCCC4_CD            = 0;
    MCCC5_MCOM          = 0;
    MCCC5_MCAM          = 0;
    MCCC5_CD            = 0;
    
    MCCC6_MCOM          = 0;
    MCCC6_MCAM          = 0;
    MCCC6_CD            = 0;
    MCCC7_MCOM          = 0;
    MCCC7_MCAM          = 0;
    MCCC7_CD            = 0;
    
    
    
    PTU_PTU0 = LOW;
    PTU_PTU1 = LOW;
    PTU_PTU2 = LOW;
    PTU_PTU3 = LOW;
    
    PTU_PTU4 = LOW;
    PTU_PTU5 = LOW;
    PTU_PTU6 = LOW;
    PTU_PTU7 = LOW;
    */
    MotorDriveOff();
    
    PER1AD = 0x00;
    
    PER0AD = 0x00;
    
    PERU   = 0x00;
    
    PERR   = 0x00;
    
    PERV   = 0x00;
    
    PERH   = 0x00;
    
    PERS   = 0x00;
    
    PERP   = 0x00;
    
    PERT   = 0x00;
    
    PERM   = 0x00;
    
    //DisableInterrupts;//2020-11-26 TYҪ
    TIM0_TSCR2_TOI   = 0; 
    TIM1_TSCR2_TOI   = 0; 
    TIM0_TFLG2_TOF = ClearFlag;
    TIM1_TFLG2_TOF = ClearFlag;   //2020-11-26 TYҪ
   
    TIM0_TSCR1_TEN   = Disable;
    TIM1_TSCR1_TEN   = Disable;  
}
/*-------------------------------------------------------------------------
* Function Name  : CheckOSC
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void CheckOSC(void)
{
    //ڲRC𵴣³ʼʱ
	  if((_CRGFLG.Bits.SCM == 1) || (CLKSEL_PLLSEL  == Disable))  
	  {
        DisableInterrupts;
      	bsp_Clk_Init();
      	EnableInterrupts;
	  }
}