/*
* APP_System.c
*
*  Created on: Aug 11, 2014
*      Author: QTC
*/

#define GLOBALS_APP_System
#include "defines.h"
#include "g_includes.h"
#include "app_Service.h"

/*-------------------------------------------------------------------------
* Function Name  : App_Paramer_Init
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Paramer_Init(void)
{
  INT8U i;

  //-- ʼ --//
  if ((ConfigItem.GasConfig == 1) && ((ConfigItem.AdblueConfig == 0) || (ConfigItem.AdblueConfig == 1)))
  {
    g_Style = 1; //ѹ + adblue
  }
  else if ((ConfigItem.GasConfig == 0) && ((ConfigItem.AdblueConfig == 0) || (ConfigItem.AdblueConfig == 1)))
  {
    g_Style = 2; //adblue
  }
  else if ((ConfigItem.GasConfig == 1) && ((ConfigItem.AdblueConfig != 0) && (ConfigItem.AdblueConfig != 1)))
  {
    g_Style = 3; //ѹ
  }
  else
  {
    g_Style = 0; //ֻ"ͺ"
  }

  if (g_Style == 1)
  {
    //ѹ + adblue
    if (bCurMenuIDX >= _MN_DSP_SCREEN1_1) //סϴKL15λ
    {
      bCurMenuIDX = _MN_DSP_SCREEN1;
      bNextMenuIDX = _MN_DSP_SCREEN1;
    }
    bMenuSwFlag = 1;
  }
  else
  {
    //ѹ/adblue
    if ((bCurMenuIDX != _MN_DSP_SCREEN1_1) && (bCurMenuIDX != _MN_DSP_SCREEN3_1) && (bCurMenuIDX != _MN_DSP_SCREEN2_1)) //סϴKL15λ
    {
      bCurMenuIDX = _MN_DSP_SCREEN1_1;
      bNextMenuIDX = _MN_DSP_SCREEN1_1;
    }
    bMenuSwFlag = 1;
  }

  //-- 汾Ϣ --//
  SetMeuMsg.PartsNumber = 3820100;
  SetMeuMsg.PartsNumber1 = 6060;
  SetMeuMsg.HardwareVersion = 3;
  SetMeuMsg.SoftWareVersion = 314;

  //
  if (ConfigItem.EngConfig == 0)
  {
    ConfigItem.FuelCosumConfig = 6; //0.695L
  }
  else if (ConfigItem.EngConfig == 1)
  {
    ConfigItem.FuelCosumConfig = 6; //0.66L
  }
  else if (ConfigItem.EngConfig == 2)
  {
    ConfigItem.FuelCosumConfig = 7; //0.7975L
  }
  else if (ConfigItem.EngConfig == 3)
  {
    ConfigItem.FuelCosumConfig = 7; //0.765L
  }
  else if (ConfigItem.EngConfig == 4)
  {
    ConfigItem.FuelCosumConfig = 10; //1.055L
  }
  else if (ConfigItem.EngConfig == 5)
  {
    ConfigItem.FuelCosumConfig = 10; //1.04L
  }
  else if (ConfigItem.EngConfig == 9)
  {
    ConfigItem.FuelCosumConfig = 7; //0.765L
  }
  else if (ConfigItem.EngConfig == 10)
  {
    ConfigItem.FuelCosumConfig = 7; //0.7975L
  }
  else if (ConfigItem.EngConfig == 11)
  {
    ConfigItem.FuelCosumConfig = 6; //0.66L
  }
  else if (ConfigItem.EngConfig == 12)
  {
    ConfigItem.FuelCosumConfig = 7; //0.765L
  }
  else
  {
    ConfigItem.FuelCosumConfig = 7; //default: 0.7975L
  }

  //-- Can --//
  //Enable_signal(g_canClock.signal.Exist65310);   //ȫ     (ߵ)
  //Enable_signal(g_canClock.signal.Exist64775_00);   //OBD1         (ߵ)
  //Enable_signal(g_canClock.signal.Exist65226ECM);//OBD2         (ߵ)
  //Enable_signal(g_canClock.signal.Exist65226DCU);//OBD3         (ߵ)
  //Enable_signal(g_canClock.signal.Exist65268);   //TPMSϵͳ (ߵ)

  //g_canClock.ID65310Cn       = 100 + T_Can3_5s;//T,200ms   drop,2s
  //g_canClock.ID65042Cn       = 100 + T_Can3_5s;//T,200ms   drop,2s
  g_canClock.ID64775_00Cn = 500 + T_Can3_5s; //T,1000ms
  g_canClock.ID65226CnECM = 500 + T_Can3_5s; //T,1000ms
  //g_canClock.ID65226CnDCU    = 500 + T_Can3_5s;//T,1000ms
  //g_canClock.ID65268Cn       = 100 + T_Can3_5s;//T,200ms   drop,2s

  g_CanSwith.VDCFullyOpert = 1;
  g_CanSwith.VDCLampStatus = 0;
  g_canClock.ID65110Start_00Cn = 0;
  g_canClock.ID65110Start_3DCn = 0;

  //-- led --//
  g_LED.pMILOffTime1 = T_3_5s;
  g_LED.pMILOffTime2 = T_3_5s;
  g_LED.pMILOffTime3 = T_3_5s;

  //-- Cruise --//
  bCruiseClrScreen1 = 0;
  bCruiseClrScreen = 1;
  g_ClearCruise = 1;
  bCruiseSpeedLast = 0xffff;

  g_sysFlag.Bits.BeepProcEn = Enable;
  CheckStep = 0;
  EcuDuty = 0xffffffff;

  //--  --//
  DTC_OBDErrFlag = Disable;
  DTC_EPCErrFlag = Disable;
  DTC_ABSErrFlag = Disable;
  DTC_AirBagFlag = Disable;
  DTC_TPMSErrFlag = Disable;
  DTC_SafebeltFlag = Disable;
  DTC_BrakeErrFlag = Disable;
  EELoadFlag.bits.bit0 = Disable;
  g_EEaccKmClrStep = Disable;
  g_sysFlag.Bits.EEAccSaveState = Disable;

  g_Clock.TempFaultTimes = 0;
  g_Clock.TempReleaseTimes = 0;
  g_CanSwith.ClrScreenDoor = 1;
  Disable_signal(g_sysFlag.Bits.TempLedEn);
  g_ClearWin1 = 1;
  if (!g_sysFlag.Bits.WakeUpState)
  {
    Enable_signal(g_sysFlag.Bits.CanWakeUp);
  }

  //-- Meter --//
  g_Init.InitFuelTime = null;
  g_Init.InitTempTime = null;
  g_Init.InitGas1Time = null;
  g_Init.InitGas2Time = null;
  g_Init.InitAdblueTime = null;
  Enable_signal(g_sysFlag.Bits.SysOffEn);
  Enable_signal(g_sysFlag.Bits.AccKmValid);
  Enable_signal(g_sysFlag.Bits.BeepProcEn);
  Disable_signal(g_sysFlag.Bits.TempMeterInit);
  Enable_signal(g_sysFlag.Bits.Gas1MeterInit);
  Enable_signal(g_sysFlag.Bits.Gas2MeterInit);
  Enable_signal(g_sysFlag.Bits.AdbuleMeterInit);
  Disable_signal(g_sysFlag.Bits.AdjEnable);

  Disable_signal(g_sysFlag.Bits.ClearODO); //2020-10-08 Ĺ
  //-- Motor --//
  g_vehMeter.Dir = keep_local;
  g_vehMeter.DestPosition = null;
  g_vehMeter.CurPosition = null;
  g_vehMeter.CurBoardVal = null;
  g_vehMeter.OldBoardVal = null;
  g_vehMeter.MoveEn = Disable;

  g_revMeter.Dir = keep_local;
  g_revMeter.DestPosition = null;
  g_revMeter.CurPosition = null;
  g_revMeter.CurBoardVal = null;
  g_revMeter.MoveEn = Disable;

  g_tempMeter.Dir = keep_local;
  g_tempMeter.DestPosition = null;
  g_tempMeter.CurPosition = null;
  g_tempMeter.CurBoardVal = null;
  g_tempMeter.MoveEn = Disable;
  g_tempMeter.DispPosition = null;

  g_gas1Meter.Dir = keep_local;
  g_gas1Meter.DestPosition = null;
  g_gas1Meter.CurPosition = null;
  g_gas1Meter.CurBoardVal = null;
  g_gas1Meter.MoveEn = Disable;
  g_gas1Meter.DispPosition = null;
  g_gas2Meter.Dir = keep_local;
  g_gas2Meter.DestPosition = null;
  g_gas2Meter.CurPosition = null;
  g_gas2Meter.CurBoardVal = null;
  g_gas2Meter.MoveEn = Disable;
  g_gas2Meter.DispPosition = null;

  g_adblueMeter.Dir = keep_local;
  g_adblueMeter.DestPosition = null;
  g_adblueMeter.CurPosition = null;
  g_adblueMeter.CurBoardVal = null;
  g_adblueMeter.MoveEn = Disable;
  g_adblueMeter.DispPosition = null;

  //-- Start --//
  g_LED.pStartTime = null;
  g_LED.pStopTime = T_3_5s;
  g_Init.InitLogoTime = null;
  g_runStep = SYS_INIT_TASK;
  g_accTime = null;
  g_baseTime = null;
  g_accVeh = null;
  g_accKmClrStep = null;
  ODO_Updeta;
  Trip_Updeta;
  InstFuel_Updeta;
  AveFuel_Updeta;
  DirKm_Updeta;
  Gas1_Updeta;
  Gas2_Updeta;
  Adblue_Updeta;
  Time_Updeta;
  bUpDataGears = 2;
  bOldGears = bUpDataGears + 1;
  Enable_signal(g_sysFlag.Bits.LowModeInit);

  //-- alarm --//
  for (i = 0; i < TotalPicWarn; i++)
  {
    bDSTable[i] = 0;
  }
  bDSTableShowTime[PicDrSafeBelt] = 0;
  bDSTableShowTime[PicExHaustBrake] = 0;
  bDSTableShowTime[PicPowerTakeoff] = 0;
  bDSTableShowTime[PicOverSpeed] = 0;
  bCurDsPos = 255;
  bLcdDsCnt = 0;

  //-- Beep --//
  for (i = 0; i < 21; i++)
  {
    g_Beep[i].Prio = DisAlr;
    g_Beep[i].OnTime = null;
    g_Beep[i].OffTime = null;
    g_Beep[i].BeepTime = null;
    g_Beep[i].BeepCn = null;
    g_Beep[i].BeepOK = null;
    g_Beep[i].BeepInit = null;
    g_Beep[i].CurBeepCn = null;
  }
  g_pBeep->BeepTime = null;
  Enable_signal(g_sysFlag.Bits.BeepProcEn);
  g_nopBeep.Prio = DisAlr;
  g_nopBeep.OnTime = null;
  g_nopBeep.OffTime = null;
  g_nopBeep.BeepTime = null;
  g_nopBeep.OnceFlag = null;
  g_nopBeep.BeepOK = null;
  g_nopBeep.BeepCn = null;
  g_nopBeep.CurBeepCn = null;
  g_pBeep = &g_nopBeep;

  //-- Key --//
  RotateKeyMenu.Rotary1Old = pKeyRIn;
  RotateKeyMenu.RotateState = 255;
  bOldMenuIDX = 0;

  //-- FuelEco --//
  g_fuelEco.VehNullTime = 0;
  //if(g_fuelEco.KeyOffTime > T_2_0hour)
  if (g_fuelEco.KeyOffTime > 14400)
  {
    g_fuelEco.SRFCTime = null;
    g_fuelEco.FuelSum1 = null;
    g_fuelEco.Dis100Km1 = null;
    g_fuelEco.DispSRFC = null;
    g_fuelEco.CalSRFC = null;
    InstFuel_Updeta;
  }
  g_fuelEco.KeyOffTime = null;

  //-- Other --//
  g_Clock.CoolLevelNTimes = 0;
  g_Clock.CoolLevelYTimes = 0;
  g_Clock.CoolLevelYTimes1 = 0;
  g_CanSwith.TpmsDrop = 0;
  g_Init.InitBeepTime = 0;
  bUpDataFlag = 1;
  ClrAveFuel1 = 1;
  ClrAveFuel = 1;
  g_FuelAlarm = Disable;
  bSendFlag = 0;
  APPSendMsgInit = 0;
  g_30LOGOFlag = 0;
  WriteleFlag2E = 0;

  g_CanSwith.OldDriverBelt = 0;
  g_CanSwith.OldPsngrBelt = 0;
  g_SetMenuState = 0;

  Gas_Timer = 0;
}
/*-------------------------------------------------------------------------
* Function Name  : App_State_OFF
* Description    : ״̬ر
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_State_OFF(void)
{
  INT8U i;

  //-- Meter --//
  g_fuelMeter.DispPosition = 0;
  g_fuelMeter.CurBoardVal = 1;
  g_vehMeter.BoardVal = null;
  g_vehMeter.CurBoardVal = null;
  g_vehMeter.DestPosition = null;
  g_revMeter.CurBoardVal = null;
  g_revMeter.DestPosition = null;
  g_tempMeter.CurBoardVal = null;
  g_tempMeter.DestPosition = null;
  g_gas1Meter.CurBoardVal = null;
  g_gas1Meter.DestPosition = null;
  g_gas2Meter.CurBoardVal = null;
  g_gas2Meter.DestPosition = null;

  //-- Can Clear All --//
  g_CanSwith.CabLock = 0;

  g_CanSwith.ABSLamp = 0;
  g_CanSwith.ABSLamp1 = 0;

  g_CanSwith.VacuumCylinder = 0;
  g_CanSwith.OilLamp = 0;
  g_CanSwith.OilLamp1 = 0;
  g_CanSwith.ExhaustBrake = 0;
  g_CanSwith.DriverBelt = 0;
  g_CanSwith.SCR_Y = 0;
  g_CanSwith.SCR_R = 0;
  g_CanSwith.ASR = 0;
  g_CanSwith.RearDefogger = 0;
  g_CanSwith.HillHolder = 0;
  g_CanSwith.VDCLampStatus = 0;
  g_CanSwith.OutFlashFlag = 0;
  g_CanSwith.ESPoff = 0;
  g_CanSwith.DPF = 0;
  g_CanSwith.InhibiteDPF = 0; //2020/05/12
  g_CanSwith.DpfHiTemp = 0;
  g_CanSwith.PreHeat = 0;
  g_CanSwith.EngMIL1 = 0;
  g_CanSwith.EngMIL2 = 0;
  g_CanSwith.EngMIL3 = 0;
  g_CanSwith.EngFailure1 = 0;
  g_CanSwith.EngFailure2 = 0;
  g_CanSwith.EngFailure3 = 0;
  g_CanSwith.EngFailure4 = 0;
  g_CanSwith.STOP1 = 0;
  g_CanSwith.STOP2 = 0;
  g_CanSwith.VDCFullyOpert = 1;
  g_CanSwith.VDCLampStatus = 0;
  g_CanSwith.WIF = 0;
  g_CanSwith.DriverWarn = 0;
  g_CanSwith.ParkErr = 0;
  g_CanSwith.AutoHoldAct = 0;
  g_CanSwith.AutoHoldWork = 0;
  g_CanSwith.ECO = 0;
  g_CanSwith.CanPowerOver = 0;

  g_CanSwith.DPF_Red = 0; //2020/08/04
  //-- Time Clr --//
  g_LED.pABESTime = 0;
  g_LED.CheckLightsTime = 0;
  g_LED.pStartTime = 0;
  g_LED.pOverSpeedTime = 0;
  g_LED.BrakeSysFaultTimes = 0;
  g_LED.ABSFaultTimes = 0;
  g_LED.EpsFailedTimes = 0;
  g_LED.CalibratedStTimes = 0;
  g_LED.pBrakeTime = null;
  g_LED.pParkTime = null;
  g_LED.pBrakeABSTime = null;
  g_LED.pSafeBelt1Time = null;
  g_LED.pWIFTime = null;
  g_LED.pRTime = null;
  g_LED.pNTime = null;
  g_LED.pMILOnTime1 = null;
  g_LED.pMILOnTime2 = null;
  g_LED.pMILOnTime3 = null;
  g_LED.pMILOffTime1 = null;
  g_LED.pMILOffTime2 = null;
  g_LED.pMILOffTime3 = null;
  g_LED.pOilTime = null;
  g_LED.pTFTOilTime = null;
  g_LED.pMirrDefostTime = null;
  g_LED.pHillHolderTime = null;
  g_LED.pCabLockTime = null;
  g_LED.pExhaustBrakTime = null;
  g_LED.pBrakeShoeTime = null;
  g_LED.pAirFilterTime = null;
  g_LED.pPowerTakeoffTime = null;
  g_LED.pDiffLockTime = null; //سŵָʾ
  g_CanSwith.LDWSstate = null;
  g_CanSwith.AmberState_E8 = null;
  g_CanSwith.LDWScloseLCD = null;
  g_CanSwith.LDWSopenLCD = null;
  g_CanSwith.AmberState_2A = null;
  g_CanSwith.TpmsFault = null;
  g_CanSwith.TpmsLowBat = null;
  g_CanSwith.TempThreshold = null;
  g_CanSwith.PressThreshold = null;

  //-- Led OFF--//
  //BD83790B &=  ~BD8379_D10;//off-Ÿ
  //BD83790B &=  ~BD8379_D11;//off-ƶƬĥ
  //BD83790B &=  ~BD8379_D0;//off-פ/ʱͣ
  //BD83790B &=  ~BD8379_D1;//off-ʱͣ/
  //DB8379_WriteData(ON);//Do Led off

  //-- Beep --//
  g_Init.InitBeepTime = T_3_0s;
  RadarBuzzerFre1 = 0;
  RadarBuzzerFlag = 0;
  bUpDataGears = 2;

  //-- off --//
  for (i = 0; i < TotalPicWarn; i++)
  {
    _FEED_COP();
    bDSTable[i] = 0;
  }
  for (i = 0; i < TotalPicWarn; i++)
  {
    _FEED_COP();
    wDS_LcdQueue[i] = 0;
  }
  for (i = 0; i < TotalPicWarn; i++)
  {
    _FEED_COP();
    bDSTableShowTime[i] = 0;
  }
  bCurDsPos = 255;
  bLcdDsCnt = 0;
  g_CanSwith.ClrScreenDoor = 1;

  //-- Sleep_Flag --//
  Disable_signal(g_SleepInfo.sleepOut);
  Enable_signal(g_sysFlag.Bits.OffClearWin);
  Enable_signal(g_sysFlag.Bits.OffDorDisClrWin);

  //-- DTC --//
  DTC_OBDErrFlag = Disable;
  DTC_EPCErrFlag = Disable;
  DTC_ABSErrFlag = Disable;
  DTC_AirBagFlag = Disable;
  DTC_TPMSErrFlag = Disable;
  DTC_SafebeltFlag = Disable;
  DTC_BrakeErrFlag = Disable;

  //-- Other --//
  g_accTime = null;
  EcuDuty = 0xffffffff;
  RadarBuzzerFlag = 0;
  g_30LOGOFlag = 0;
  Enable_signal(g_sysFlag.Bits.LowModeInit);
  g_validFlag.Bits.BD8379Init = Enable;
  g_LED.pStartTime = null;
  g_LED.pStopTime = T_3_5s;
}
/*-------------------------------------------------------------------------
* Function Name  : App_State_OFF_Run
* Description    : ״̬ر
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_State_OFF_Run(void)
{
  //--  --//
}
/*-------------------------------------------------------------------------
* Function Name  : App_StarUpInfo
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_StarUpInfo(void)
{
  g_30LOGOFlag = 0;
  pSTBOut = LOW;
  WriteleFlag2E = 0;
  Enable_signal(g_validFlag.Bits.OffUpFuelSts);
  Enable_signal(g_sysFlag.Bits.NetCtlKeep);
  Enable_signal(g_sysFlag.Bits.BeepProcEn);

  Api_SetCanTimer(T_8s, (_Clock *)&g_Clock);

  Enable_signal(g_sysFlag.Bits.AdbuleMeterInit);

  Disable_signal(g_vehMeter.MakeZero);
  Disable_signal(g_revMeter.MakeZero);
  g_runStep = SYS_INIT_TASK;

  g_sysFlag.Bits.CanWakeUp = CanWakeUpEn;
  g_sysFlag.Bits.CanState = CanOFF;

  Enable_signal(g_sysFlag.Bits.SysOffEn);
  Enable_signal(g_sysFlag.Bits.LowModeInit);

  g_nopBeep.Prio = DisAlr;
  g_nopBeep.OnTime = null;
  g_nopBeep.OffTime = null;
  g_nopBeep.BeepTime = null;
  g_nopBeep.BeepCn = null;
  g_nopBeep.CurBeepCn = null;
  EcuDuty = 0xffffffff;

  SetMeuMsg.BackLightLevel = 4;
  if (g_pBeep->Prio != DisAlr)
  {
    g_pBeep = &g_nopBeep;
  }
  RotateKeyMenu.Rotary1Old = pKeyRIn;
  RotateKeyMenu.RotateState = 255;
  g_fuelEco.FuelSum = 0;
  g_fuelEco.Dis100Km = 0;
  g_fuelEco.FuelSum1 = 0;
  g_fuelEco.Dis100Km1 = 0;
  g_fuelEco.DispAveFuel = 0;
  g_fuelEco.DispSRFC = 0;
  RamShortAccKmA = 0;
  SetMeuMsg.Language = 1;
  bSendFlag = 0;
  APPSendMsgInit = 0;

  //-- Diagnose --//
  ECUNum[0] = 0x11;
  ECUNum[1] = 0x22;
  ECUNum[2] = 0x33;
  ECUNum[3] = 0x44;
}
/*-------------------------------------------------------------------------
* Function Name  : App_StarUpInfo1
* Description    : 
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_StarUpInfo1(void)
{
  //-- DB8379 --//
  BD83790A = 0;
  BD83790B = 0;
  DB8379_Init();
}
/*-------------------------------------------------------------------------
* Function Name  : App_Load_Data
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_Load_Data(void)
{
  //-- Radio --//
  Radio.RevRadio = 2;
  Radio.VehC3Radio = 2; //f = 2v
  Radio.VehNum = 8;

  //-- veh --//
  g_vehMeterInfo.bVirtualVal = 8;

  g_vehMeterInfo.Resistor[0] = 0;
  g_vehMeterInfo.Resistor[1] = 20;
  g_vehMeterInfo.Resistor[2] = 40;
  g_vehMeterInfo.Resistor[3] = 60;
  g_vehMeterInfo.Resistor[4] = 80;
  g_vehMeterInfo.Resistor[5] = 100;
  g_vehMeterInfo.Resistor[6] = 140;
  g_vehMeterInfo.Resistor[7] = 180;

  g_vehMeterInfo.DashStep[0] = 0;
  g_vehMeterInfo.DashStep[1] = 320;
  g_vehMeterInfo.DashStep[2] = 636;
  g_vehMeterInfo.DashStep[3] = 960;
  g_vehMeterInfo.DashStep[4] = 1284;
  g_vehMeterInfo.DashStep[5] = 1596;
  g_vehMeterInfo.DashStep[6] = 2244;
  g_vehMeterInfo.DashStep[7] = 2880;

  //-- Rev --//
  g_revMeterInfo.bVirtualVal = 8;

  g_revMeterInfo.Resistor[0] = 0;
  g_revMeterInfo.Resistor[1] = 500;
  g_revMeterInfo.Resistor[2] = 1000;
  g_revMeterInfo.Resistor[3] = 1500;
  g_revMeterInfo.Resistor[4] = 2000;
  g_revMeterInfo.Resistor[5] = 2500;
  g_revMeterInfo.Resistor[6] = 3000;
  g_revMeterInfo.Resistor[7] = 4000;

  g_revMeterInfo.DashStep[0] = 0;
  g_revMeterInfo.DashStep[1] = 360;
  g_revMeterInfo.DashStep[2] = 720;
  g_revMeterInfo.DashStep[3] = 1080;
  g_revMeterInfo.DashStep[4] = 1400;
  g_revMeterInfo.DashStep[5] = 1800;
  g_revMeterInfo.DashStep[6] = 2160;
  g_revMeterInfo.DashStep[7] = 2880;

  //-- Temp --//
  if (ConfigItem.TempConfig == 0) //Ϊ100
  {
    g_tempMeterInfo.bVirtualVal = 7;

    g_tempMeterInfo.Resistor[0] = 0;
    g_tempMeterInfo.Resistor[1] = 50; //50degC
    g_tempMeterInfo.Resistor[2] = 70;
    g_tempMeterInfo.Resistor[3] = 80;
    g_tempMeterInfo.Resistor[4] = 95;
    g_tempMeterInfo.Resistor[5] = 97;
    g_tempMeterInfo.Resistor[6] = 100;
    g_tempMeterInfo.Resistor[7] = 0;

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 80;
    g_tempMeterInfo.DashStep[4] = 100;
    g_tempMeterInfo.DashStep[5] = 120;
    g_tempMeterInfo.DashStep[6] = 160;
    g_tempMeterInfo.DashStep[7] = 0;
  }
  else if (ConfigItem.TempConfig == 1) //Ϊ105
  {
    g_tempMeterInfo.bVirtualVal = 7;

    g_tempMeterInfo.Resistor[0] = 0;
    g_tempMeterInfo.Resistor[1] = 50; //50degC
    g_tempMeterInfo.Resistor[2] = 70;
    g_tempMeterInfo.Resistor[3] = 80;
    g_tempMeterInfo.Resistor[4] = 100;
    g_tempMeterInfo.Resistor[5] = 102;
    g_tempMeterInfo.Resistor[6] = 105;
    g_tempMeterInfo.Resistor[7] = 0;

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 80;
    g_tempMeterInfo.DashStep[4] = 100;
    g_tempMeterInfo.DashStep[5] = 120;
    g_tempMeterInfo.DashStep[6] = 160;
    g_tempMeterInfo.DashStep[7] = 0;
  }
  else if (ConfigItem.TempConfig == 2) //Ϊ105
  {
    g_tempMeterInfo.bVirtualVal = 8;

    g_tempMeterInfo.Resistor[0] = 0;
    g_tempMeterInfo.Resistor[1] = 50; //50degC
    g_tempMeterInfo.Resistor[2] = 70;
    g_tempMeterInfo.Resistor[3] = 80;
    g_tempMeterInfo.Resistor[4] = 100;
    g_tempMeterInfo.Resistor[5] = 102;
    g_tempMeterInfo.Resistor[6] = 104;
    g_tempMeterInfo.Resistor[7] = 105;

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 80;
    g_tempMeterInfo.DashStep[4] = 100;
    g_tempMeterInfo.DashStep[5] = 120;
    g_tempMeterInfo.DashStep[6] = 140;
    g_tempMeterInfo.DashStep[7] = 160;
  }
  else if (ConfigItem.TempConfig == 3) //Ϊ110
  {
    g_tempMeterInfo.bVirtualVal = 8;

    g_tempMeterInfo.Resistor[0] = 0;
    g_tempMeterInfo.Resistor[1] = 50; //50degC
    g_tempMeterInfo.Resistor[2] = 70;
    g_tempMeterInfo.Resistor[3] = 80;
    g_tempMeterInfo.Resistor[4] = 102;
    g_tempMeterInfo.Resistor[5] = 105;
    g_tempMeterInfo.Resistor[6] = 108;
    g_tempMeterInfo.Resistor[7] = 110;

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 80;
    g_tempMeterInfo.DashStep[4] = 100;
    g_tempMeterInfo.DashStep[5] = 120;
    g_tempMeterInfo.DashStep[6] = 140;
    g_tempMeterInfo.DashStep[7] = 160;
  }
  else if (ConfigItem.TempConfig == 4) //Ϊ120
  {
    g_tempMeterInfo.bVirtualVal = 7;

    g_tempMeterInfo.Resistor[0] = 0;
    g_tempMeterInfo.Resistor[1] = 50; //50degC
    g_tempMeterInfo.Resistor[2] = 70;
    g_tempMeterInfo.Resistor[3] = 80;
    g_tempMeterInfo.Resistor[4] = 100;
    g_tempMeterInfo.Resistor[5] = 102;
    g_tempMeterInfo.Resistor[6] = 120;
    g_tempMeterInfo.Resistor[7] = 0;

    g_tempMeterInfo.DashStep[0] = 0;
    g_tempMeterInfo.DashStep[1] = 20;
    g_tempMeterInfo.DashStep[2] = 60;
    g_tempMeterInfo.DashStep[3] = 80;
    g_tempMeterInfo.DashStep[4] = 100;
    g_tempMeterInfo.DashStep[5] = 120;
    g_tempMeterInfo.DashStep[6] = 160;
    g_tempMeterInfo.DashStep[7] = 0;
  }
  else
  {
    ;
  }

  //-- gas --//
  g_gasMeterInfo.bVirtualVal = 9;

  g_gasMeterInfo.Resistor[0] = 0;
  g_gasMeterInfo.Resistor[1] = 65; //0.66v
  g_gasMeterInfo.Resistor[2] = 83;
  g_gasMeterInfo.Resistor[3] = 183;
  g_gasMeterInfo.Resistor[4] = 283;
  g_gasMeterInfo.Resistor[5] = 327;
  g_gasMeterInfo.Resistor[6] = 350;
  g_gasMeterInfo.Resistor[7] = 417;
  g_gasMeterInfo.Resistor[8] = 450;

  g_gasMeterInfo.DashStep[0] = 0;
  g_gasMeterInfo.DashStep[1] = 20;
  g_gasMeterInfo.DashStep[2] = 40;
  g_gasMeterInfo.DashStep[3] = 100;
  g_gasMeterInfo.DashStep[4] = 160;
  g_gasMeterInfo.DashStep[5] = 180;
  g_gasMeterInfo.DashStep[6] = 200;
  g_gasMeterInfo.DashStep[7] = 240;
  g_gasMeterInfo.DashStep[8] = 260;

  //-- adblue --//
  g_adblueMeterInfo.bVirtualVal = 8;

  g_adblueMeterInfo.Resistor[0] = 0;
  g_adblueMeterInfo.Resistor[1] = 50;  //5%
  g_adblueMeterInfo.Resistor[2] = 104; //10.4%
  g_adblueMeterInfo.Resistor[3] = 304;
  g_adblueMeterInfo.Resistor[4] = 504;
  g_adblueMeterInfo.Resistor[5] = 704;
  g_adblueMeterInfo.Resistor[6] = 804;
  g_adblueMeterInfo.Resistor[7] = 904;

  g_adblueMeterInfo.DashStep[0] = 0;
  g_adblueMeterInfo.DashStep[1] = 20;
  g_adblueMeterInfo.DashStep[2] = 40;
  g_adblueMeterInfo.DashStep[3] = 80;
  g_adblueMeterInfo.DashStep[4] = 120;
  g_adblueMeterInfo.DashStep[5] = 160;
  g_adblueMeterInfo.DashStep[6] = 180;
  g_adblueMeterInfo.DashStep[7] = 200;

  //
  w_Veh = TPM1Clock;
  w_Veh1 = g_vehMeterInfo.Resistor[g_vehMeterInfo.bVirtualVal - 1];
  VehFreLimit = (INT16U)(w_Veh / (w_Veh1 * Radio.VehRadio / 3600) / 4);
}