#ifndef  __APPLICATIONLAYER_H
#define __APPLICATIONLAYER_H


#define GetStatus 0xaa
enum
{
    GetStatus_SessionStatus,
    GetStatus_SecurityStatus,
    GetStatus_KeyStatus,
    GetResetAddr,
};




#define DiagnosticSessionControl 0x10
#define ECU_Reset 0x11
#define SecurityAccess 0x27
#define CommunicationControl 0x28
#define TesterPresent 0x3e
#define Control_DTC_Setting 0x85
#define ReadDataByIdentifier 0x22
#define WriteDataByIdentifier 0x2e
#define RoutineControl 0x31
#define RequestDownload 0x34
#define TransferData 0x36
#define TransferExit 0x37
#define InputOutPutControlByIdentifier 0x2f

#define CAL_KEY_VALID 1
#define CAL_KEY_INVALID 0

#define ROUTINE_DOWNLOAD_FLASH 0
#define ROUTINE_Verify_FLASH 1
#define ROUTINE_Verify_APP 2


enum
{
    SESSION_DEFAULT,
    SESSION_EXTENDED_DIAGNOSTIC,
    SESSION_PROGRAMMING,
};

enum
{
    SECURITY_LOCK,
    SECURITY_UNLOCK,
};

typedef struct
{
    INT8U SessionStatus;// = SESSION_DEFAULT;
    INT8U SecurityStatus;// = SECURITY_LOCK;
    INT8U CalKey_Status;
    INT16U Security16_KEY;
    INT8U RoutineStatus;	//0 down  1 up
    INT8U RecvDataCnt;
    INT8U RecvDataLen;
    INT8U SessionTimeoutSw;
    INT8U SessionTimeoutCnt;
} AppLayerParameter;

extern AppLayerParameter AppLayer;
extern INT16U RANDOM_TIME;
extern INT32U RAND_D32;

void SessionTimeoutCnt_PRG(void);
void SERVER_10H_Presponse(void);
void SERVER_ALL_Nresponse(INT8U code);
void Comm2EH_Prespons_PRG(void);
INT16U calcKey(INT16U seed);
void GJ_SEED_MODE_QR_KEY(INT8U *pSEED);
void AppLayer_Rx_PRG(void);

#endif

