#include "defines.h"

NetLayerParameter NetLayer;
CANMsg MyCanTxMsg;

//===============================================
//++++++++++20MS++++++++++++++++++++++++
//
//多帧接收时的超时计时器计时程序
//===============================================
void RecvMulFrameTimeout_Prg(void)
{
    if (NetLayer.Status == NetStatus_MulFrameRecv)  	//网络层处于多帧接收状态?,yes
    {
        if (++NetLayer.RecvMulFrameTimeoutCnt >= 250)  		//5s?,yes
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.RecvDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
        }
    }
}

//===============================================
//++++++++++20MS++++++++++++++++++++++++
//
//多帧发送时的超时计时器计时程序
//===============================================
void SendMulFrameTimeout_Prg(void)	//DUOZHEN_SEND_CSTIME_PRG
{
    if (NetLayer.Status == NetStatus_MulFrameSend)  	//网络层处于多帧发送状态 ?,yes
    {
        NetLayer.SendMulFrameTimeoutCnt++;
        if (NetLayer.SendMulFrameTimeoutCnt >= 250)	 	//5s?,yes
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.SendDataStatus = INVALID;
        }
    }
}

//==================================================
//服务器CAN发送,只发送1次,不返回发送成功与否的信息
//==================================================
void CANSendPack(INT8U *buff, INT8U len)
{
    MyCanTxMsg.sendID = cnICM_TX;
    MyCanTxMsg.IDE = 0;
    MyCanTxMsg.RTR = 0;
    MyCanTxMsg.dataLen = len;
    MyCanTxMsg.priority = 2;
    memcpy(MyCanTxMsg.data, buff, len);

    MSCAN_SendFrame(&MyCanTxMsg);
}

//========================================
//服务器发送流控
//========================================
void SendFlowControlPack(INT8U mTYPE)
{
    INT8U data[8] = {0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA};

    if (mTYPE == FlowControlOverflow)
    {
        data[0] = 0x32;   		//发溢出流控
        data[1] = 0x00;
        data[2] = 0x00;
    }
    else if (mTYPE == FlowControlContinue)
    {
        data[0] = 0x30; 	        //继续发送
        data[1] = 0x00;           //连续帧一直发送完成,不再等待新的流控
        data[2] = 0x01;           //1MS          0x0A  连续帧发送的时间间隔=10MS
    }

    CANSendPack(data, 8);
}

//===============================================
//网络层接收程序
//===============================================
void NetLayer_RX_PRG(void)
{
    INT8U m8;
    INT16U m16, m16_1;
    INT8U CanData[8];

    if (CanFrame.REVF)  		//收到CAN数据?,YES
    {
        CanFrame.BUSY = 1;
        memcpy(CanData, CanFrame.BUFF, 8);
        CanFrame.REVF = 0;
        CanFrame.BUSY = 0;
    }
    else
    {
        return;
    }
    //解析数据
    switch (CanData[0] & 0xF0)
    {
    case CanSingleFrame:	//单帧
        if (NetLayer.Status == NetStatus_Wait)  	//网络层在待命状态
        {
            if ((0 < (CanData[0] & 0x0F)) && ((CanData[0] & 0x0F) < 8))  		//单帧数据长度合法?,YES
            {
                NetLayer.RxTx_Len = CanData[0] & 0x0F;
                memcpy(NetLayer.RxTx_Buff, &CanData[1], NetLayer.RxTx_Len);
                NetLayer.RecvDataStatus = VALID;	//=1网络层通知应用层它收到了完整的一帧数据
            }
        }
        break;
    case CanMulFrame_First:	//多帧中的首帧
        if (NetLayer.Status != NetStatus_Wait)
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            if (NetLayer.Status == NetStatus_MulFrameSend)
            {
                NetLayer.SendDataStatus = INVALID;
            }
            else
            {
                NetLayer.RecvDataStatus = INVALID;
            }
            break;
        }

        m16 = ((CanData[0] & 0x0F) << 8) | ((INT16U)CanData[1]);
        if (m16 < 7)    				//多帧数据长度小于8 ?,YES
        {
            break;
        }

        if (m16 > NETWORK_LAYER_BUFF_LEN)  	//多帧数据长度大于接收缓冲区 ?,YES
        {
            SendFlowControlPack(FlowControlOverflow);
            break;
        }

        //首帧合法
        memset(NetLayer.RxTx_Buff, 0, 128);
        NetLayer.RecvMulFrame_First = VALID;		//=1网络层通知应用层它收到了多帧数据中的首帧
        NetLayer.RecvMulFrameLen = m16;		//存放多帧要接收数据的总长度
        NetLayer.RxTx_Len = 6;			//首帧长度为6
        memcpy(NetLayer.RxTx_Buff, &CanData[2], 6);
        NetLayer.Status = NetStatus_MulFrameRecv;		//表示网络层处于多帧接收状态
        NetLayer.RecvMulFrameNum = 1;			//置将要接收的连续帧的帧号
        //回复正常的流控
        SendFlowControlPack(FlowControlContinue);
        NetLayer.RecvMulFrameTimeoutCnt = 0;		//清多帧接收时的超时计时器

        break;
    case CanMulFrame_Sequence:	//多帧中的连续帧
        if (NetLayer.Status == NetStatus_Wait)
            break;
        if (NetLayer.Status == NetStatus_MulFrameSend)
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.SendDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
            break;
        }

        //网络层处于多帧接收状态
        if ((CanData[0] & 0x0F) != NetLayer.RecvMulFrameNum)  	//连续帧号正确?,NO
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.RecvDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
            break;
        }

        m8 = NetLayer.RecvMulFrameLen - NetLayer.RxTx_Len;
        if (m8 > 7)    			//还没有接收的数据的长度>7
        {
            memcpy(&NetLayer.RxTx_Buff[NetLayer.RxTx_Len], &CanData[1], 7);
            NetLayer.RxTx_Len += 7;    //已接收的数据的长度+7
            NetLayer.RecvMulFrameNum = (NetLayer.RecvMulFrameNum + 1) % 0x10;
            NetLayer.RecvMulFrameTimeoutCnt = 0;		//清多帧接收时的超时计时器
            SendFlowControlPack(FlowControlContinue);
        }
        else
        {
            //接收多帧中的最后一帧数据
            memcpy(&NetLayer.RxTx_Buff[NetLayer.RxTx_Len], &CanData[1], m8);
            NetLayer.RxTx_Len += m8;    //已接收的数据的长度+7
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.RecvDataStatus = VALID;	//=1网络层通知应用层它收到了一帧错误数据
        }
        break;
    case CanFlowControl:	//流控
        if (NetLayer.Status == NetStatus_MulFrameRecv)
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.RecvDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
            break;
        }
        //网络层处于多帧发送状态
        NetLayer.SendMulFrameTimeoutCnt = 0;		//清多帧发送时的超时计时器
        if ((CanData[0] & 0x0F) == 2)  				//溢出吗?,YES
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.SendDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
            break;
        }

        if ((CanData[0] & 0x0F) == 0)  					//继续发送(CTS)
        {
            NetLayer.SendMulFrameNum = CanData[1];
            NetLayer.SendMulFrameInterval = CanData[2];
            if ((0xF1 <= NetLayer.SendMulFrameInterval) && (NetLayer.SendMulFrameInterval <= 0xF9))
            {
                NetLayer.SendMulFrameInterval = 3; 		//6MS
            }
            else
            {
                if (NetLayer.SendMulFrameInterval <= 0x7F)
                {
                    if (NetLayer.SendMulFrameInterval <= 6)
                        NetLayer.SendMulFrameInterval = 3; 		//6MS
                    else
                        NetLayer.SendMulFrameInterval /= 2;
                }
                else
                {
                    NetLayer.SendMulFrameInterval = 63; 		//126MS=2*63MS
                }
            }
            NetLayer.SendMulFrameCnt = 0;
            SendMulFrame_Prg();	//服务器发连续帧
        }
        break;
    default:	//收到非法数据
        if (NetLayer.Status != NetStatus_Wait)
        {
            NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
            NetLayer.RecvDataStatus = INVALID;	//=1网络层通知应用层它收到了一帧错误数据
        }
        break;
    }
}

//=====================================================
//网络层发送程序
//
//入口:RxTx_Len
//     ISO_RXTX_BUFF[50]
//=====================================================
void  NetLayer_Tx_Prg(void)		//ISO15765_2_TX_PRG
{
    INT8U sddata[8];

    if (NetLayer.RxTx_Len < 8)  			//待发送的数据长度小于8 ?,YES
    {
        //使用单帧发送
        memset(sddata, 0xaa, 8); 	//给发送区的8个单元填充0xAA
        sddata[0] = NetLayer.RxTx_Len;
        memcpy(&sddata[1], NetLayer.RxTx_Buff, NetLayer.RxTx_Len);
        CANSendPack(sddata, 8);
        NetLayer.SendDataStatus = VALID; 			//网络层通知应用层它发出了完整的一帧数据
        return;
    }

    //使用多帧发送,先发送首帧
    sddata[0] = 0x10;
    sddata[1] = NetLayer.RxTx_Len;
    memcpy(&sddata[2], NetLayer.RxTx_Buff, 6);
    CANSendPack(sddata, 8);
    NetLayer.Status = NetStatus_MulFrameSend;		//表示网络层处于多帧发送状态
    NetLayer.SendMulFrameCnt = 1;			//置将要发送的连续帧的帧号
    NetLayer.SendvMulFrameLen = 6;
    NetLayer.SendMulFrameTimeoutCnt = 0;		//清多帧发送时的超时计时器
    NetLayer.SendMulFrameSw = 0;
    NetLayer.SendMulFrameIntervalCnt = 0;
}

//========================================
//网络层发连续帧
//========================================
void SendMulFrame_Prg(void)  //SEVER_SEND_LXZ_PRG
{
    INT8U m8;
    INT8U sddata[8];

    m8 = NetLayer.RxTx_Len - NetLayer.SendvMulFrameLen;		//计算还没有发出的数据的个数
    if (m8 <= 7)
    {
        //发最后一帧数据
        memset(sddata, 0xaa, 8); 	//给发送区的8个单元填充0xAA
        sddata[0] = 0x20 | NetLayer.SendMulFrameCnt;
        memcpy(&sddata[1], &NetLayer.RxTx_Buff[NetLayer.SendvMulFrameLen], m8);
        CANSendPack(sddata, 8);
        NetLayer.Status = NetStatus_Wait; 	//置网络层处于普通状态(待命状态)
        NetLayer.SendDataStatus = VALID;
    }
    else
    {
        sddata[0] = 0x20 | NetLayer.SendMulFrameCnt;
        memcpy(&sddata[1], &NetLayer.RxTx_Buff[NetLayer.SendvMulFrameLen], 7);
        CANSendPack(sddata, 8);
        NetLayer.SendMulFrameTimeoutCnt = 0;				//清多帧发送时的超时计时器
        NetLayer.SendMulFrameCnt++;					//连续帧号+1
        if (NetLayer.SendMulFrameCnt == 0x10)
            NetLayer.SendMulFrameCnt = 0;
        NetLayer.SendvMulFrameLen = NetLayer.SendvMulFrameLen + 7;
        NetLayer.SendMulFrameCnt++;
        if (NetLayer.SendMulFrameCnt == NetLayer.SendMulFrameNum)  		//发了BS个数目的连续帧?,YES
        {
            NetLayer.SendMulFrameSw = 0;
            NetLayer.SendMulFrameIntervalCnt = 0;
        }
        else
        {
            NetLayer.SendMulFrameSw = 1;				//开连续帧的间隔时间定时器
            NetLayer.SendMulFrameIntervalCnt = 0;
        }
    }
}

//==================================================
//++++++++++++++++2MS+++++++++++++++
//
//连续帧间隔定时器
//==================================================
void SendMulFrameInterval_Prg(void)  //LXZ_JG_TIME_PRG
{
    if (NetLayer.Status == NetStatus_MulFrameSend)  	//网络层处于多帧发送状态 ?,yes
    {
        if (NetLayer.SendMulFrameSw)  			//定时器开?,YES
        {
            NetLayer.SendMulFrameTimeoutCnt = 0;
            NetLayer.SendMulFrameIntervalCnt++;
            if (NetLayer.SendMulFrameIntervalCnt >= NetLayer.SendMulFrameInterval)
            {
                NetLayer.SendMulFrameIntervalCnt = 0;
                NetLayer.SendMulFrameSw = 0;
                SendMulFrame_Prg();	//服务器发连续帧
            }
        }
    }
}