#ifndef __ALLDEFINES_H
    #define __ALLDEFINES_H


    typedef unsigned char INT8U;
    typedef unsigned int INT16U;
    typedef unsigned long INT32U;
    typedef signed   char  INT8S;
    ////////////////////////// --.h-- ///////////////////////////////////////////
    #include <hidef.h>                                                 /* common defines and macros */
    #include "derivative.h"                                         /* derivative-specific definitions */
    #include "mc9s12xhy256.h"
    
    #include <string.h>
    
    #include "../bsp_Headers/bsp_CAN.h"
    #include "API_FLASH.h"
    #include "bsp_System.h"
    #include "API_SCI.h"
    #include "ApplicationLayer.h"
    //#include "defines.h"
    
    #include "derivative.h"
    #include "NetworkLayer.h"
    
    INT8U Api_CreateCRCCheckSum(INT8U *p , INT8U Nub);
    
    
    #define     BusClock                 32000000
    #define     TPM0Clock                BusClock/1
    #define     TPM1Clock                BusClock/1
   
    //--Alarm--//    
    #define     DS_MASK                  0x03
    #define     DS0_MASK	               0x01
    #define     DS1_MASK          	     0x02
    #define 	  LCD_MASK	               0x04 //ǸÿѾ뵽Һ
    #define     INVALID_PRIO             0xff
    
    #define     OUTPUT                   1
    #define     INPUT                    0
    
    #define     HIGH                     1
    #define     LOW                      0
    
    #define     null                     0
    #define     ClearFlag                1
   
    #define     Enable                   1
    #define     Disable                  0

    #define     Active                   1
    #define     Inactive                 0
    
    #define     HIGH                     1
    #define     LOW                      0
    
    #define     ON                       1
    #define     OFF                      0
    
    #define     LightOn                  1
    #define     LightOff                 0 
    
    #define     KeyON                    1
    #define     KeyOFF                   0
    #define     KeyLow                   2
    #define     KeyHi                    3
    
    #define     LEDON                    0
    #define     LEDOFF                   1     

    #define     IDEL                     0
    #define     MASK                     1
    #define     NOMASK                   0
    #define     OUT                      1
    #define     IN                       0
    #define     EN                       1
    #define     DIS                      0
    #define     ACT                      1
    #define     NOACT                    0
    #define     CLEARFLAG_W1             1
    
    #define     ACC_ON                   0
    #define     ACC_OFF                  1
    
    #define     BLANK                    0
    //
    #define     Up                       1
    #define     Down                     2
    
    //-- TASK --//
    #define         SYS_INIT_TASK               1
    #define         CAN_TASK                    2
    #define         SCI_TASK                    3
    #define         GUI_TASK                    4
    #define         STORE_TASK                  5
    #define         CALCULATE_TASK              6
    #define         LETTER_LEN                  60
    //
    #define     	  RunComplete            	    1
    #define         Enable_signal(signal)       signal = Enable
    #define         Disable_signal(signal)      signal = Disable
    #define	        SETBIT(p,b)              	  p|=(1<<b)	//
    
    //-- Updeta --//
    #define                 Trip_Updeta         g_winUpdeta.bits.Trip_Up = 1
    #define                 Trip_UpdetaClr      g_winUpdeta.bits.Trip_Up = 0
    #define                 ODO_Updeta          g_winUpdeta.bits.ODO_Up = 1
    #define                 ODO_UpdetaClr       g_winUpdeta.bits.ODO_Up = 0
    #define                 InstFuel_Updeta     g_winUpdeta.bits.InstFuelUp = 1
    #define                 InstFuel_UpdetaClr  g_winUpdeta.bits.InstFuelUp = 0
    #define                 AveFuel_Updeta      g_winUpdeta.bits.AveFuelUp = 1
    #define                 AveFuel_UpdetaClr   g_winUpdeta.bits.AveFuelUp = 0
    #define                 DirKm_Updeta        g_winUpdeta.bits.DirKmUp = 1
    #define                 DirKm_UpdetaClr     g_winUpdeta.bits.DirKmUp = 0
    #define                 Time_Updeta         g_winUpdeta.bits.Time_Up = 1
    #define                 Time_UpdetaClr      g_winUpdeta.bits.Time_Up = 0
    #define                 Gas1_Updeta         g_winUpdeta.bits.Gas1_Up = 1
    #define                 Gas1_UpdetaClr      g_winUpdeta.bits.Gas1_Up = 0
    #define                 Gas2_Updeta         g_winUpdeta.bits.Gas2_Up = 1
    #define                 Gas2_UpdetaClr      g_winUpdeta.bits.Gas2_Up = 0
    #define                 Adblue_Updeta       g_winUpdeta.bits.Adblue_Up = 1
    #define                 Adblue_UpdetaClr    g_winUpdeta.bits.Adblue_Up = 0
    //
    
    typedef union
    {
        struct
        {
            INT8U     Key_state         : 2;
            INT8U     NM_state          : 1;
            INT8U     Door_state        : 1;
            INT8U     CAN_state         : 1;
            INT8U     Uart_state        : 1;
            INT8U     UDS_state         : 1;
            INT8U     IMAX_power        : 1;
            INT8U     BL_power          : 1;
            INT8U     LCD_power         : 1;
            
        } Meag;
    } S_OS_STATE;
    
    extern S_OS_STATE OS_STATE;

    //
    #define         nop()   			{asm NOP;}
    #define         stop()   			{asm STOP;}
    #define	        _CLRBIT(p,b)        p&=~(1<<b)	//0 pӦĵb BITλ (pֻΪ8BIT)
    #define	        _SETBIT(p,b)     	p|=(1<<b)	//1 pӦĵb BITλ (pֻΪ8BIT)
    #define         _bit_is_set(p,b)	p&(1<<b)
    #define	        CLRBIT(p,b)        	p&=~(1<<b)    	//0 pӦĵb BITλ (pΪ16BIT)
    #define	        SETBIT(p,b)     	p|=(1<<b)	           //1 pӦĵb BITλ (pΪ16BIT)
    #define         bit_is_clear(p,b)	!(p&(1<<b))
    #define         bit_1_set(p,b)		((p>>b)&0x01)
    #define         bit_2_set(p,b)       ((p>>b)&0x03)
    #define         bit_3_set(p,b)       ((p>>b)&0x07)
    #define         bit_4_set(p,b)       ((p>>b)&0x0F)
    #define         bit_5_set(p,b)       ((p>>b)&0x1F)
    #define         bit_6_set(p,b)       ((p>>b)&0x3F)
    #define         bit_7_set(p,b)       ((p>>b)&0x7F)
    #define			cli()				DisableInterrupts
    #define			sei()				EnableInterrupts
    #define			wdt_reset()	 		__RESET_WATCHDOG()
    
    //-- ѹ --//
    #define     P_60kpa                        15
    #define     P_68kpa                        17
    #define     P_80kpa                        20
    #define     P_88kpa                        22
    #define     P_100kpa                       25
            
    //-- can drop --//
    #define     T_Can3_5s                      175
    
    #define          BpStop                      0  
    #define          BpOn                        1  
    #define          BpOver                      2  
       
    #define          ID_Turn                     0     
            
#endif
