/*
* gui_Menu2nd.c
*
*  Created on: Aug 11, 2014
*      Author: QTC
*/


#define  GLOBALS_GUI_Menu2nd
#include "defines.h"
#include "g_includes.h"

/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoClr_disp                 2˵-гϢλ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoClr_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--гϢλ
        Api_DrawImg2Icon(10, 12, Set_Menu2_XCXXFW_Title_Word2_x10_y12);
        //--01_2˵_01гϢλ_01_С̸λ
        Api_DrawImg2Icon(18, 59, Set_Menu2_XCXXFW_01_Word2_x18_y59);
        //--01_2˵_01гϢλ_02_̳ͺĸλ
        Api_DrawImg2Icon(18, 99, Set_Menu2_XCXXFW_02_Word2_x18_y99);
        //--01_2˵_01гϢλ_03_ƽͺĸλ
        Api_DrawImg2Icon(22, 136, Set_Menu2_XCXXFW_03_Word2_x22_y136);
        //--01_2˵_01гϢλ_04_˳
        Api_DrawImg2Icon(107, 170, Set_Menu1_10_Word2_x109_y208);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //гϢλ    Restablecer computadora de viaje
        Api_DrawLetterIcon1(7, 14, "Restablecer", CharLetter2);
        Api_DrawLetterIcon1(93, 14, "computadora", CharLetter2);
        Api_DrawLetterIcon1(180, 14, "de", CharLetter2);
        Api_DrawLetterIcon1(201, 14, "viaje", CharLetter2);
        //01_2˵_01гϢλ_01_С̸λ     Restablecer  viaje
        Api_DrawLetterIcon1(71, 57, "Restablecer", CharLetter1);
        Api_DrawLetterIcon1(145, 57, "viaje", CharLetter1);
        
        //01_2˵_01гϢλ_02_̳ͺĸλ     Restablecer  Consumo de distancia corta
        Api_DrawIcon(23, 102, xibanya_duchengyouhaofuwei);
        
        //01_2˵_01гϢλ_03_ƽͺĸλ     Restablecer  Consumo promedio
        
        Api_DrawLetterIcon1(28, 131, "Restablecer", CharLetter1);
        Api_DrawLetterIcon1(101, 131, "consumo", CharLetter1);
        Api_DrawLetterIcon1(163, 132, "promedio", CharLetter1);
        
        
        //01_2˵_01гϢλ_04_˳      Salir
        Api_DrawLetterIcon(109, 169, "Salir", CharLetter1);
    }
    else if(SetMeuMsg.Language == English)
    {
        //гϢλ    Board computer reset
        Api_DrawLetterIcon(26, 14, "Board", CharLetter3);
        Api_DrawLetterIcon(85, 14, "computer", CharLetter3);
        Api_DrawLetterIcon(173, 14, "reset", CharLetter3);
        //01_2˵_01гϢλ_01_С̸λ     Tripmeter reset
        Api_DrawLetterIcon(58, 59, "Tripmeter", CharLetter2);
        Api_DrawLetterIcon(142, 59, "reset", CharLetter2);
        
        //01_2˵_01гϢλ_02_̳ͺĸλ     Reset AFC(short range)
        Api_DrawLetterIcon(33, 95, "Reset", CharLetter2);
        Api_DrawLetterIcon(85, 95, "AFC(short", CharLetter2);
                           Api_DrawLetterIcon(171, 95, "range)", CharLetter2);
        
        //01_2˵_01гϢλ_03_ƽͺĸλ     Reset AFC
        Api_DrawLetterIcon(76, 132, "Reset", CharLetter2);
        Api_DrawLetterIcon(129, 132, "AFC", CharLetter2);
        
        //01_2˵_01гϢλ_04_˳      Back
        Api_DrawLetterIcon(103, 168, "Back", CharLetter2);
    }
    else
    {
        Api_DrawImgIcon(42, 9, touxingchexinxifuwei);
            //01_2˵_01гϢλ_01_С̸λ
        Api_DrawImgIcon(45, 56, xiaojilichengfuwei);
        //01_2˵_01гϢλ_02_̳ͺĸλ
        Api_DrawIcon(45, 93, duanchengyouhaofuwei);
        //01_2˵_01гϢλ_03_ƽͺĸλ
        Api_DrawImgIcon(45, 129, pingjunyouhaofuwei);
        //01_2˵_01гϢλ_04_˳
        Api_DrawImgIcon(95, 166, tuichu);
    }
    if(SetMeuMsg.Menu2ItemFlag == 0)
    {
        SetMeuMsg.Menu2Item = 1;
        SetMeuMsg.MenuCoordinate = 47;
        SetMeuMsg.MenuCoordinate1 = 47;
    }
    SetMeuMsg.OldMenu2Item = 0;
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoClrDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoClrDo(void)
{
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        
        Api_DrawImg2Icon(14, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_DrawImg2Icon(222, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 2), (SetMeuMsg.MenuCoordinate1 + 4));
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 36), (SetMeuMsg.MenuCoordinate1 + 38));
        Api_DrawIcon(14, SetMeuMsg.MenuCoordinate, fangkuangzuo);
        Api_DrawIcon(222, SetMeuMsg.MenuCoordinate, fangkuangyou);
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 3));
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 37));
        
    }
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VehInfoClrExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VehInfoClrExit(void)
{
//----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_OverSpeed_disp                 2˵--ٱ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_OverSpeed_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--ٱ
        Api_DrawImg2Icon(31, 11, Set_Menu2_CSBJSZ_Title_Word2_x31_y11);
        //--01_2˵_02ٱ
        Api_DrawImg2Icon(14, 175, Set_Menu2_CSBJSZ_01_Word2_x14_y175);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //ٱ      Alarma de sobrevelocidad
        Api_DrawLetterIcon1(16, 14, "Alarma", CharLetter3);
        Api_DrawLetterIcon1(79, 14, "de", CharLetter3);
        Api_DrawLetterIcon1(104, 14, "sobrevelocidad", CharLetter3);
        //01_2˵_02ٱ     Poner velocidad  Pulse OK para guardar
        Api_DrawLetterIcon(60, 181, "Poner", CharLetter2);
        Api_DrawLetterIcon(113, 181, "velocidad", CharLetter2);
        Api_DrawLetterIcon(37, 212, "Pulse", CharLetter2);
        Api_DrawLetterIcon(82, 212, "OK", CharLetter2);
        Api_DrawLetterIcon(110, 212, "para", CharLetter2);
        Api_DrawLetterIcon(148, 212, "guardar", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        //ٱ   Overspeed alarm setting
        Api_DrawLetterIcon(15, 14, "Overspeed", CharLetter3);
        Api_DrawLetterIcon(115, 14, "alarm", CharLetter3);
        Api_DrawLetterIcon(169, 14, "setting", CharLetter3);
        //01_2˵_02ٱ     Rotat to set   Press OK to save
        Api_DrawLetterIcon(76, 181, "Rotat", CharLetter2);
        Api_DrawLetterIcon(122, 181, "to", CharLetter2);
        Api_DrawLetterIcon(141, 181, "set", CharLetter2);
        Api_DrawLetterIcon(57, 209, "Press", CharLetter2);
        Api_DrawLetterIcon(106, 209, "OK", CharLetter2);
        Api_DrawLetterIcon(133, 209, "to", CharLetter2);
        Api_DrawLetterIcon(152, 209, "save", CharLetter2);
    }
    else
    {
        //ٱ
        Api_DrawImg2Icon(41, 9, touchaosubaojingshezhi);
        //01_2˵_02ٱ
        //ת趨
        Api_DrawImg2Icon(35, 188, zuoyouxuanshezhi);
        //ٶ
        Api_DrawImg2Icon(164, 189, caidan2ji_sudu);
        //趨ok
        Api_DrawImg2Icon(28, 217, shedinghouanok);
    }
    //
    Api_DrawImgIcon(54, 88, chesubaojingkaung);
    Api_DrawImg2Icon(140, 110, kmh);
    if(SetMeuMsg.Language == Arabic)
        SetMeuMsg.OverSpeed = 120;
    SetMeuMsg.Menu2Item = SetMeuMsg.OverSpeed;
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item + 10;
    bCompletOverSpeed=0;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_OverSpeedExit              
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_OverSpeedDo(void)
{
    Gui_SpeedSet_Disp();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_SpeedSet_Disp
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_SpeedSet_Disp(void)
{
    INT16U wTemp;
    INT8U len;
    
    wTemp = SetMeuMsg.Menu2Item;
    
    
    DispText.Text[1] = (wTemp / 100) % 10;
    DispText.Text[2] = (wTemp / 10) % 10;
    DispText.Text[3] =  wTemp % 10;
    
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        len = App_CalDataLen(wTemp);
        if(len == 1)
            len++;
        switch(len)
        {
                
            case 3:
                Api_DrawImg2Icon(59, 99, Api_Value_Get(DispText.Text[1], 34));
            case 2:
                Api_DrawImg2Icon(81, 99, Api_Value_Get(DispText.Text[2], 34));
            case 1:
                Api_DrawImg2Icon(103, 99, Api_Value_Get(DispText.Text[3], 34));
            default:
                ;
        }
        switch(len + 1)
        {
            case 3:
                Api_DrawImg2Icon(59, 99, Api_Value_Get(10, 34));
                
            default:
                ;
        }
    }
    
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item; 
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_OverSpeedExit                
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_OverSpeedExit(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);

    if(bCompletOverSpeed==1)
    {
        bCompletOverSpeed=0;
        SetMeuMsg.OverSpeed = SetMeuMsg.Menu2Item;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_ErrInfoEnter         2˵-Ϣ鿴-"alarm"
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_ErrInfoEnter(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_03_Ϣ鿴
        Api_DrawImg2Icon(30, 11, Set_Menu2_GZXXCK_Title_Word2_x30_y11);
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_03_Ϣ鿴    Informacion de averia
        Api_DrawLetterIcon(24,14,"Informaci<n", CharLetter3);
        Api_DrawLetterIcon(132,14,"de", CharLetter3);
        Api_DrawLetterIcon(160,14,"aver>a", CharLetter3);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_03_Ϣ鿴   Warning information
        Api_DrawLetterIcon(35, 14, "Warning", CharLetter3);
        Api_DrawLetterIcon(114, 14, "information", CharLetter3);
    }
    else
    {
        //01_2˵_03_Ϣ鿴
        Api_DrawImgIcon(41, 9, touguzhangxinxichakan);
    }
    //ok
    Api_DrawImgIcon(184, 232, ok);
    
    //Ϣ鿴ʱҪϵǰʾλãʹùϢԴȼߵʾ
    bCurDsPos = 0;
    bDSUpdateFlag = 1;
    bFaultFree=1;
    bFaultFree1=1;
    
    //Enterʱλ
    if((wDS_LcdQueue[bCurDsPos]) == (PicDoorOpen))
    {
        g_CanSwith.ClrScreenDoor = 1;
    }
    else
    {
        g_CanSwith.ClrScreenDoor = 0;
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_ErrInfoDo                 
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_ErrInfoDo(void)
{
    if(SetMeuMsg.Language == Spanish)
    {
        Gui_FaultSpanish_Disp();
    }
    else
    {
        Gui_Fault_Disp();
    }
    Gui_ODO_Disp();
    Gui_Tirp_Disp();
    Gui_Gears_disp();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_ErrInfoExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_ErrInfoExit(void)
{
    Api_ClearIcon(2, 240, 43, 255);//м   
    Api_ClearIcon(6, 240, 5, 38);//
    
    bCurDsPos = 255;//ָ
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCodeShow_disp                2˵-ϴ鿴
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCodeShow_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_03_ϴ鿴
        Api_DrawImg2Icon(53,11,Set_Menu2_GZDMCK_Title_Word2_x53_y11);
        //--01_2˵_04ϴ鿴_58_ABSϴ
        Api_DrawImg2Icon(56,59,Set_Menu2_GZDMCK_01_Word2_x56_y59);
        //--01_2˵_04ϴ鿴_58_ECUϴ
        Api_DrawImg2Icon(57,96,Set_Menu2_GZDMCK_02_Word2_x57_y96);
        //--01_2˵_04ϴ鿴_58_DCUϴ
        Api_DrawImg2Icon(56,134,Set_Menu2_GZDMCK_03_Word2_x56_y134);
        //--01_2˵_ϴ鿴_˳
        Api_DrawImg2Icon(100,168,Set_Menu2_GZDMCK_04_Word2_x100_y168);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_03_Ϣ鿴     Codigo de averia
        Api_DrawLetterIcon1(52,14,"C<digo", CharLetter3);
        Api_DrawLetterIcon1(114,14,"de", CharLetter3);
        Api_DrawLetterIcon1(140,14,"aver>a", CharLetter3);
        //01_2˵_04ϴ鿴_58_ABSϴ    Codigo de averia de  ABS
        Api_DrawLetterIcon(31,57,"C<digo", CharLetter2);
        Api_DrawLetterIcon(87,57,"de", CharLetter2);
        Api_DrawLetterIcon(109,57,"aver>a", CharLetter2);
        Api_DrawLetterIcon(155,57,"de", CharLetter2);
        Api_DrawLetterIcon(177,57,"ABS", CharLetter2);
        
        //01_2˵_04ϴ鿴_58_ECUϴ    Codigo de averia de  ECU
        Api_DrawLetterIcon(31,94,"C<digo", CharLetter2);
        Api_DrawLetterIcon(87,94,"de", CharLetter2);
        Api_DrawLetterIcon(109,94,"aver>a", CharLetter2);
        Api_DrawLetterIcon(155,94,"de", CharLetter2);
        Api_DrawLetterIcon(177,94,"ECU", CharLetter2);
        
        //01_2˵_04ϴ鿴_58_DCUϴ    Codigo de averia de  DCU
        Api_DrawLetterIcon(31,131,"C<digo", CharLetter2);
        Api_DrawLetterIcon(87,131,"de", CharLetter2);
        Api_DrawLetterIcon(109,131,"aver>a", CharLetter2);
        Api_DrawLetterIcon(155,131,"de", CharLetter2);
        Api_DrawLetterIcon(177,131,"DCU", CharLetter2);
        
        //˳          Salir
        Api_DrawLetterIcon(105,169,"Salir", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_03_Ϣ鿴     DTC
        
        Api_DrawLetterIcon(104,10,"DTC", CharLetter2);
        //01_2˵_04ϴ鿴_58_ABSϴ    ABS DTC code
        Api_DrawLetterIcon(62,59,"ABS", CharLetter2);
        Api_DrawLetterIcon(104,59,"DTC", CharLetter2);
        Api_DrawLetterIcon(145,59,"code", CharLetter2);
        
        //01_2˵_04ϴ鿴_58_ECUϴ    ECU DTC code
        Api_DrawLetterIcon(62,95,"ECU", CharLetter2);
        Api_DrawLetterIcon(104,95,"DTC", CharLetter2);
        Api_DrawLetterIcon(145,95,"code", CharLetter2);
        
        //01_2˵_04ϴ鿴_58_DCUϴ    DCU DTC code
        Api_DrawLetterIcon(62,132,"DCU", CharLetter2);
        Api_DrawLetterIcon(104,132,"DTC", CharLetter2);
        Api_DrawLetterIcon(145,132,"code", CharLetter2);
        
        //01_2˵_01гϢλ_04_˳   Back
        Api_DrawLetterIcon(103,168,"Back", CharLetter2);
    }
    else
    {
        //01_2˵_03_Ϣ鿴
        Api_DrawImg2Icon(41, 9, touguzhangdaimachakan);
        //01_2˵_04ϴ鿴_58_ABSϴ
        Api_DrawImg2Icon(45, 56, ABSguzhangdaima);
        //01_2˵_04ϴ鿴_58_ECUϴ
        Api_DrawImg2Icon(45, 93, ECUguzhangdaima);
        //01_2˵_04ϴ鿴_58_DCUϴ
        Api_DrawImg2Icon(45, 129, DCUguzhangdaima);
        //01_2˵_01гϢλ_04_˳
        Api_DrawImgIcon(95, 166, tuichu);
    }
    
    SetMeuMsg.Menu2Item = 1;
    SetMeuMsg.OldMenu2Item = 0;
    SetMeuMsg.MenuCoordinate = 47;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCodeShowDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCodeShowDo(void)
{
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        
        Api_DrawImg2Icon(14, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_DrawImg2Icon(222, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 2), (SetMeuMsg.MenuCoordinate1 + 4));
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 36), (SetMeuMsg.MenuCoordinate1 + 38));
        Api_DrawIcon(14, SetMeuMsg.MenuCoordinate, fangkuangzuo);
        Api_DrawIcon(222, SetMeuMsg.MenuCoordinate, fangkuangyou);
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 3));
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 37));
        
    }
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_ErrCodeShowExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_ErrCodeShowExit(void)
{
//----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_TimeSetEnter                     2˵-ʱ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_TimeSetEnter(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_05ʾʱ
        Api_DrawImg2Icon(44, 13, Set_Menu2_XSSJSZ_Title_Word2_x44_y13);
        //--
        Api_DrawImg2Icon(95, 55, Set_Menu2_XSSJSZ_01_Word2_x102_y59);
        //--01_2˵_01гϢλ_04_˳
        Api_DrawImg2Icon(100, 88, Set_Menu2_XSSJSZ_02_Word2_x99_y92);
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_05ʾʱ    Tiempo
        Api_DrawLetterIcon(95, 14, "Tiempo", CharLetter3);
        //01_2˵_01гϢλ_04_    Ajustar
        Api_DrawLetterIcon(97, 57, "Ajustar", CharLetter2);
        
        //01_2˵_01гϢλ_04_˳    Salir
        Api_DrawLetterIcon(105, 94, "Salir", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_05ʾʱ   Date&Time
        Api_DrawLetterIcon(76, 14, "Date&Time", CharLetter3);
        //01_2˵_01гϢλ_04_    Set
        Api_DrawLetterIcon(109, 59, "Set", CharLetter2);
        
        //01_2˵_01гϢλ_04_˳    Back
        Api_DrawLetterIcon(102, 95, "Back", CharLetter2);
    }
    else
    {
        //01_2˵_05ʾʱ
        Api_DrawImgIcon(41, 9, touxianshishijianshezhi);
        //
        Api_DrawImgIcon(95, 55, shezhi);
        //01_2˵_01гϢλ_04_˳
        Api_DrawImgIcon(94, 92, shijiantuichu);
    }
    SetMeuMsg.Menu2Item = 1;
    SetMeuMsg.OldMenu2Item = 0;
    SetMeuMsg.MenuCoordinate = 47;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_TimeSetDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_TimeSetDo(void)
{
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        Api_DrawImg2Icon(14, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_DrawImg2Icon(222, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 2), (SetMeuMsg.MenuCoordinate1 + 4));
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 36), (SetMeuMsg.MenuCoordinate1 + 38));
        Api_DrawIcon(14, SetMeuMsg.MenuCoordinate, fangkuangzuo);
        Api_DrawIcon(222, SetMeuMsg.MenuCoordinate, fangkuangyou);
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 3));
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 37));
    }
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui2nd_TimeSetExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui2nd_TimeSetExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_LanguageSet_disp     2˵--"/Ӣ//arb"
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_LanguageSet_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_05ʾ
        Api_DrawImg2Icon(37, 11, Set_Menu2_XSYYSZ_Title_Word2_x37_y11);
        //--
        Api_DrawImg2Icon(95, 58, Set_Menu2_XSYYSZ_01_Word2_x95_y58);
        //--Ӣ
        Api_DrawImg2Icon(87, 95, Set_Menu2_XSYYSZ_02_Word2_x87_y95);
        //--
        Api_DrawImg2Icon(89, 132, Set_Menu2_XSYYSZ_03_Word2_x89_y132);
        //--
        Api_DrawImg2Icon(97, 170, Set_Menu2_XSYYSZ_04_Word2_x97_y170);
        //--˳
        Api_DrawImg2Icon(105, 204, Set_Menu2_GZDMCK_04_Word2_x100_y168);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_05ʾ      Lenguaje
        Api_DrawLetterIcon(85, 14, "Lenguaje", CharLetter3);
        //    Mandarin
        Api_DrawLetterIcon(90, 57, "Mandar>n", CharLetter2);
        
        //Ӣ        lngles
        Api_DrawLetterIcon(102, 94, "lngl,s", CharLetter2);
        
        //    Espanol
        Api_DrawLetterIcon(93, 131, "Espa.ol", CharLetter2);
        
        //    Arabe
        Api_DrawLetterIcon(100, 169, "Arabe", CharLetter2);
        
        //˳        Salir
        Api_DrawLetterIcon(106, 206, "Salir", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_05ʾ    Language
        Api_DrawLetterIcon(80, 14, "Language", CharLetter3);
        //    Chinese
        Api_DrawLetterIcon(92, 59, "Chinese", CharLetter2);
        
        //Ӣ        English
        Api_DrawLetterIcon(95, 95, "English", CharLetter2);
        
        //    Spanish
        Api_DrawLetterIcon(92, 132, "Spanish", CharLetter2);
        
        //    Arabic
        Api_DrawLetterIcon(97, 168, "Arabic", CharLetter2);
        
        //˳        Back
        Api_DrawLetterIcon(103, 205, "Back", CharLetter2);
    }
    else
    {
        //01_2˵_05ʾ
        Api_DrawImgIcon(41, 9, touxianshiyuyanshezhi);
        //
        Api_DrawImgIcon(70, 55, jiantizhongwen);
        //Ӣ
        Api_DrawImgIcon(70, 93, yingyu);
        //
        Api_DrawImgIcon(70, 130, xibanyayu);
        //
        Api_DrawImgIcon(70, 167, alaboyu);
        //˳
        Api_DrawImgIcon(94, 204, tuichu);
    }
    SetMeuMsg.Menu2Item = 1;
    SetMeuMsg.OldMenu2Item = 0;
    SetMeuMsg.MenuCoordinate = 47;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_LanguageSetDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_LanguageSetDo(void)
{
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        
        Api_DrawImg2Icon(14, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_DrawImg2Icon(222, SetMeuMsg.MenuCoordinate1, Clrfangkuan);
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 2), (SetMeuMsg.MenuCoordinate1 + 4));
        Api_ClearIcon(18, 222, (SetMeuMsg.MenuCoordinate1 + 36), (SetMeuMsg.MenuCoordinate1 + 38));
        Api_DrawIcon(14, SetMeuMsg.MenuCoordinate, fangkuangzuo);
        Api_DrawIcon(222, SetMeuMsg.MenuCoordinate, fangkuangyou);
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 3));
        Api_DrawYLine(18, 222, (SetMeuMsg.MenuCoordinate + 37));
        
    }
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_LanguageSetExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_LanguageSetExit(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    
    if(SetMeuMsg.Menu2Item != 5)
    {
        
        if(g_Clock.ExitSet < T_5_0s)
            SetMeuMsg.Language = SetMeuMsg.Menu2Item;
        
    }
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_BackLightAdjust_disp                2˵-
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_BackLightAdjust_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    SetMeuMsg.Menu2Item = SetMeuMsg.BackLightLevel;
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item + 2;
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_ȵ
        Api_DrawImg2Icon(9, 9, Set_Menu2_BGLDTJ_Title_Word2_x9_y9);
        
        if(g_CanSwith.LittleLamp)
        {
            //--ת趨⣬ok˳
            Api_DrawImg2Icon(25, 183, Set_Menu2_BGLDTJ_01_UP_Word2_x25_y183);
            Api_DrawImg2Icon(23, 216, Set_Menu2_BGLDTJ_01_Down_Word2_x23_y216);
            
        }
        else
        {
            //--λõδ򿪣ⲻɵ
            Api_DrawImg2Icon(40, 184, Set_Menu2_BGLDTJ_02_UP_Word2_x40_y184);
            Api_DrawImg2Icon(20, 216, Set_Menu2_BGLDTJ_02_Down_Word2_x20_y216);
            // Gui_BackLight_Disp();
            Api_DrawImgIcon(197, 84, jindutiao3);
            Api_DrawImgIcon(197, 111, jindutiao2);
            Api_DrawImgIcon(177, 91, jindutiao2);
            Api_DrawImgIcon(177, 111, jindutiao2);
            Api_DrawImgIcon(156, 98, jindutiao2);
            Api_DrawImgIcon(156, 119, jindutiao1);
            Api_DrawImgIcon(136, 104, jindutiao3);
            Api_DrawImgIcon(115, 111, jindutiao2);
            Api_DrawImgIcon(95, 119, jindutiao1);
        }
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_ȵ       Brillo de la retroiluminacion
        Api_DrawLetterIcon1(24, 14, "Brillo", CharLetter3);
        Api_DrawLetterIcon1(64, 14, "de", CharLetter3);
        Api_DrawLetterIcon1(88, 14, "la", CharLetter3);
        Api_DrawLetterIcon1(104, 14, "retroiluminaci<n", CharLetter3);
        if(g_CanSwith.LittleLamp)
        {
            //ת趨⣬ok˳      Poner iluminacion   Pulse OK para guardar
            Api_DrawLetterIcon(53, 181, "Poner", CharLetter2);
            Api_DrawLetterIcon(108, 181, "iluminaci<n", CharLetter2);
            Api_DrawLetterIcon(37, 212, "Pulse", CharLetter2);
            Api_DrawLetterIcon(82, 212, "OK", CharLetter2);
            Api_DrawLetterIcon(110, 212, "para", CharLetter2);
            Api_DrawLetterIcon(148, 212, "guardar", CharLetter2);
        }
        else
        {
            //λõδ򿪣ⲻɵ    no abre la lampara de posicion      no puede adjustar la luz enves
            Api_DrawLetterIcon(14, 181, "no", CharLetter2);
            Api_DrawLetterIcon(35, 181, "abre", CharLetter2);
            Api_DrawLetterIcon(71, 181, "la", CharLetter2);
            Api_DrawLetterIcon(87, 181, "lampara", CharLetter2);
            Api_DrawLetterIcon(148, 181, "de", CharLetter2);
            Api_DrawLetterIcon(170, 181, "posicion", CharLetter2);
            Api_DrawLetterIcon(18, 212, "no", CharLetter2);
            Api_DrawLetterIcon(39, 212, "puede", CharLetter2);
            Api_DrawLetterIcon1(87, 212, "adjustar", CharLetter2);
            Api_DrawLetterIcon(146, 212, "la", CharLetter2);
            Api_DrawLetterIcon(162, 212, "luz", CharLetter2);
            Api_DrawLetterIcon(184, 212, "enves", CharLetter2);
            Api_DrawImgIcon(197, 84, jindutiao3);
            Api_DrawImgIcon(197, 111, jindutiao2);
            Api_DrawImgIcon(177, 91, jindutiao2);
            Api_DrawImgIcon(177, 111, jindutiao2);
            Api_DrawImgIcon(156, 98, jindutiao2);
            Api_DrawImgIcon(156, 119, jindutiao1);
            Api_DrawImgIcon(136, 104, jindutiao3);
            Api_DrawImgIcon(115, 111, jindutiao2);
            Api_DrawImgIcon(95, 119, jindutiao1);
        }
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_ȵ    Brightness
        Api_DrawLetterIcon(79, 14, "Brightness", CharLetter3);
        if(g_CanSwith.LittleLamp)
        {
            //ת趨⣬ok˳      Rotat to set    Press OK to save
            Api_DrawLetterIcon(75, 181, "Rotat", CharLetter2);
            Api_DrawLetterIcon(122, 181, "to", CharLetter2);
            Api_DrawLetterIcon(141, 181, "set", CharLetter2);
            Api_DrawLetterIcon(57, 209, "Press", CharLetter2);
            Api_DrawLetterIcon(106, 209, "OK", CharLetter2);
            Api_DrawLetterIcon(133, 209, "to", CharLetter2);
            Api_DrawLetterIcon(152, 209, "save", CharLetter2);
        }
        else
        {
            //λõδ򿪣ⲻɵ    Position lamp turn off backlight is unadjustable
            Api_DrawLetterIcon(40, 181, "Position", CharLetter2);
            Api_DrawLetterIcon(107, 181, "lamp", CharLetter2);
            Api_DrawLetterIcon(147, 181, "turn", CharLetter2);
            Api_DrawLetterIcon(180, 181, "off", CharLetter2);
            Api_DrawLetterIcon(28, 209, "backlight", CharLetter2);
            Api_DrawLetterIcon(102, 209, "is", CharLetter2);
            Api_DrawLetterIcon(121, 209, "unadjustable", CharLetter2);
            Api_DrawImgIcon(197, 84, jindutiao3);
            Api_DrawImgIcon(197, 111, jindutiao2);
            Api_DrawImgIcon(177, 91, jindutiao2);
            Api_DrawImgIcon(177, 111, jindutiao2);
            Api_DrawImgIcon(156, 98, jindutiao2);
            Api_DrawImgIcon(156, 119, jindutiao1);
            Api_DrawImgIcon(136, 104, jindutiao3);
            Api_DrawImgIcon(115, 111, jindutiao2);
            Api_DrawImgIcon(95, 119, jindutiao1);
        }
    }
    else
    {
        //01_2˵_ȵ
        Api_DrawImgIcon(40, 9, toubeiguangliangdutiaojie);
        
        if(g_CanSwith.LittleLamp)
        {
            
            //ת趨⣬ok˳
            //ת趨
            Api_DrawImg2Icon(35, 188, zuoyouxuanshezhi);
            //
            Api_DrawImg2Icon(164, 189, caidan2ji_beiguang);
            //趨ok
            Api_DrawImg2Icon(28, 217, shedinghouanok);
            
        }
        else
        {
            //λõδ򿪣ⲻɵ
            Api_DrawImg2Icon(55, 191, weizhidengweidakai);
            Api_DrawImgIcon(197, 84, jindutiao3);
            Api_DrawImgIcon(197, 111, jindutiao2);
            Api_DrawImgIcon(177, 91, jindutiao2);
            Api_DrawImgIcon(177, 111, jindutiao2);
            Api_DrawImgIcon(156, 98, jindutiao2);
            Api_DrawImgIcon(156, 119, jindutiao1);
            Api_DrawImgIcon(136, 104, jindutiao3);
            Api_DrawImgIcon(115, 111, jindutiao2);
            Api_DrawImgIcon(95, 119, jindutiao1);
        }
    }
    //ͼ
    Api_DrawImg2Icon(30, 86, beiguangtubiao);
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_SetBackLightDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_SetBackLightDo(void)
{
    /*if(g_CanSwith.LittleLamp)
    {
        Gui_BackLight_Disp();
    } */
    
    if(g_CanSwith.LittleLamp)
    {
        Gui_BackLight_Disp();
        if(g_CanSwith.LittleLampAdj)
        {
            
            Api_ClearIcon(10, 236, 180, 255);
            if(SetMeuMsg.Language == Arabic)
            {
                //--ת趨⣬ok˳
                Api_DrawImg2Icon(25, 183, Set_Menu2_BGLDTJ_01_UP_Word2_x25_y183);
                Api_DrawImg2Icon(23, 216, Set_Menu2_BGLDTJ_01_Down_Word2_x23_y216);
                
            }
            else if(SetMeuMsg.Language == Spanish)
            {
                //ת趨⣬ok˳      Poner iluminacion   Pulse OK para guardar
                Api_DrawLetterIcon(53, 181, "Poner", CharLetter2);
                Api_DrawLetterIcon(108, 181, "iluminaci<n", CharLetter2);
                Api_DrawLetterIcon(37, 212, "Pulse", CharLetter2);
                Api_DrawLetterIcon(82, 212, "OK", CharLetter2);
                Api_DrawLetterIcon(110, 212, "para", CharLetter2);
                Api_DrawLetterIcon(148, 212, "guardar", CharLetter2);
            }
            else if(SetMeuMsg.Language == English)
            {
                //ת趨⣬ok˳      Rotat to set    Press OK to save
                Api_DrawLetterIcon(75, 181, "Rotat", CharLetter2);
                Api_DrawLetterIcon(122, 181, "to", CharLetter2);
                Api_DrawLetterIcon(141, 181, "set", CharLetter2);
                Api_DrawLetterIcon(57, 209, "Press", CharLetter2);
                Api_DrawLetterIcon(106, 209, "OK", CharLetter2);
                Api_DrawLetterIcon(133, 209, "to", CharLetter2);
                Api_DrawLetterIcon(152, 209, "save", CharLetter2);
            }
            else
            {
                //ת趨⣬ok˳
                //ת趨
                Api_DrawImg2Icon(35, 188, zuoyouxuanshezhi);
                //
                Api_DrawImg2Icon(164, 189, caidan2ji_beiguang);
                //趨ok
                Api_DrawImg2Icon(28, 217, shedinghouanok);
            }
            g_CanSwith.LittleLampAdj = 0;
            
        }
        SetMeuMsg.BackLightLevel = SetMeuMsg.Menu2Item ;
    }
    else
    {
        if(g_CanSwith.LittleLampNonAdj)
        {
            Api_ClearIcon(10, 236, 180, 255);
            g_CanSwith.LittleLampNonAdj = 0;
            if(SetMeuMsg.Language == Arabic)
            {
                //--λõδ򿪣ⲻɵ
                Api_DrawImg2Icon(40, 184, Set_Menu2_BGLDTJ_02_UP_Word2_x40_y184);
                Api_DrawImg2Icon(20, 216, Set_Menu2_BGLDTJ_02_Down_Word2_x20_y216);
                
            }
            else if(SetMeuMsg.Language == Spanish)
            {
                //λõδ򿪣ⲻɵ    no abre la lampara de posicion      no puede adjustar la luz enves
                Api_DrawLetterIcon(14, 181, "no", CharLetter2);
                Api_DrawLetterIcon(35, 181, "abre", CharLetter2);
                Api_DrawLetterIcon(71, 181, "la", CharLetter2);
                Api_DrawLetterIcon(87, 181, "lampara", CharLetter2);
                Api_DrawLetterIcon(148, 181, "de", CharLetter2);
                Api_DrawLetterIcon(170, 181, "posicion", CharLetter2);
                Api_DrawLetterIcon(18, 212, "no", CharLetter2);
                Api_DrawLetterIcon(39, 212, "puede", CharLetter2);
                Api_DrawLetterIcon1(87, 212, "adjustar", CharLetter2);
                Api_DrawLetterIcon(146, 212, "la", CharLetter2);
                Api_DrawLetterIcon(162, 212, "luz", CharLetter2);
                Api_DrawLetterIcon(184, 212, "enves", CharLetter2);
            }
            else if(SetMeuMsg.Language == English)
            {
                //λõδ򿪣ⲻɵ    Position lamp turn off backlight is unadjustable
                Api_DrawLetterIcon(40, 181, "Position", CharLetter2);
                Api_DrawLetterIcon(107, 181, "lamp", CharLetter2);
                Api_DrawLetterIcon(147, 181, "turn", CharLetter2);
                Api_DrawLetterIcon(180, 181, "off", CharLetter2);
                Api_DrawLetterIcon(28, 209, "backlight", CharLetter2);
                Api_DrawLetterIcon(102, 209, "is", CharLetter2);
                Api_DrawLetterIcon(121, 209, "unadjustable", CharLetter2);
            }
            else
            {
                //λõδ򿪣ⲻɵ
                Api_DrawImg2Icon(55, 191, weizhidengweidakai);
            }
            Api_DrawImgIcon(197, 84, jindutiao3);
            Api_DrawImgIcon(197, 111, jindutiao2);
            Api_DrawImgIcon(177, 91, jindutiao2);
            Api_DrawImgIcon(177, 111, jindutiao2);
            Api_DrawImgIcon(156, 98, jindutiao2);
            Api_DrawImgIcon(156, 119, jindutiao1);
            Api_DrawImgIcon(136, 104, jindutiao3);
            Api_DrawImgIcon(115, 111, jindutiao2);
            Api_DrawImgIcon(95, 119, jindutiao1);
        }
        
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_BackLight_Disp
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_BackLight_Disp(void)
{
    
    
    //bTemp = SetMeuMsg.Menu2Item-1 ;
    
    if(SetMeuMsg.OldMenu2Item != SetMeuMsg.Menu2Item)
    {
        
        switch(SetMeuMsg.Menu2Item)
        {
            case 6:
                Api_DrawImgIcon(197, 84, jindutiao3);
                Api_DrawImgIcon(197, 111, jindutiao2);
            case 5:
                Api_DrawImgIcon(177, 91, jindutiao2);
                Api_DrawImgIcon(177, 111, jindutiao2);
            case 4:
                Api_DrawImgIcon(156, 98, jindutiao2);
                Api_DrawImgIcon(156, 119, jindutiao1);
            case 3:
                Api_DrawImgIcon(136, 104, jindutiao3);
            case 2:
                Api_DrawImgIcon(115, 111, jindutiao2);
            case 1:
                Api_DrawImgIcon(95, 119, jindutiao1);
            default:
                ;
        }
        switch(SetMeuMsg.Menu2Item + 1)
        {
            case 1:
                Api_DrawImgIcon(94, 112, beiguangkuang1);
            case 2:
                Api_DrawImgIcon(114, 104, beiguangkuang2);
            case 3:
                Api_DrawImgIcon(135, 104, beiguangkuang3);
            case 4:
                Api_DrawImgIcon(155, 96, beiguangkuang4);
            case 5:
                Api_DrawImgIcon(176, 89, beiguangkuang5);
            case 6:
                Api_DrawImgIcon(196, 80, beiguangkuang6);
            default:
                ;
        }
    }
    SetMeuMsg.OldMenu2Item = SetMeuMsg.Menu2Item;
}


/*-------------------------------------------------------------------------
* Function Name  : Gui_SetBackLightExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_SetBackLightExit(void)
{
    Api_ClearIcon(2, 240, 43, 255);
    Api_ClearIcon(6, 240, 5, 38);

    if(g_CanSwith.LittleLamp)
        SetMeuMsg.BackLightLevel = SetMeuMsg.Menu2Item - 1;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_KValueSet_disp                 2˵-Kֵ鿴-"PPK"
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_KValueSet_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    SetMeuMsg.KValueSet = Radio.VehRadio;
    SetMeuMsg.OldKValueSet = SetMeuMsg.KValueSet + 10;
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_İKֵϢ鿴
        Api_DrawImg2Icon(23, 11, Set_Menu2_KZXXCK_Title_Word2_x23_y11);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        Api_DrawLetterIcon(85, 14, "Valor", CharLetter3);
        Api_DrawLetterIcon(140, 14, "K", CharLetter3);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_İKֵϢ鿴     K Vaule
        Api_DrawLetterIcon(89, 14, "K", CharLetter3);
        Api_DrawLetterIcon(105, 14, "Value", CharLetter3);
    }
    else
    {
        Api_DrawImgIcon(40, 9, toukzhixinxichakan);
    }
    Api_DrawImg2Icon(96, 111, PPK);
    Api_DrawImgIcon(184, 232, ok);
    Gui_KValue_Disp();  
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_KValue_Disp
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_KValue_Disp(void)
{
    INT16U wTemp;
    INT8U  len;
    
    wTemp = SetMeuMsg.KValueSet;
    
    DispText.Text[1] = (wTemp / 10000) % 10;
    DispText.Text[2] = (wTemp / 1000) % 10;
    DispText.Text[3] = (wTemp / 100) % 10;
    DispText.Text[4] = (wTemp / 10) % 10;
    DispText.Text[5] =  wTemp % 10;
    
    if(SetMeuMsg.OldKValueSet != SetMeuMsg.KValueSet)
    {
        
        len = App_CalDataLen(SetMeuMsg.KValueSet);
        switch(len)
        {
                
            case 5:
                Api_DrawIcon(83, 146, Api_Value_Get(DispText.Text[1], 14));
            case 4:
                Api_DrawIcon(97, 146, Api_Value_Get(DispText.Text[2], 14));
            case 3:
                Api_DrawIcon(111, 146, Api_Value_Get(DispText.Text[3], 14));
            case 2:
                Api_DrawIcon(125, 146, Api_Value_Get(DispText.Text[4], 14));
            case 1:
                Api_DrawIcon(139, 146, Api_Value_Get(DispText.Text[5], 14));
            default:
                ;
        }
        switch(len + 1)
        {
            case 2:
                Api_DrawImgIcon(125, 146, Api_Value_Get(10, 14));
            case 3:
                Api_DrawImgIcon(111, 146, Api_Value_Get(10, 14));
            case 4:
                Api_DrawImgIcon(97, 146, Api_Value_Get(10, 14));
            case 5:
                Api_DrawImgIcon(83, 146, Api_Value_Get(10, 14));
            default:
                ;
        }
        
        
    }
    
    SetMeuMsg.OldKValueSet = SetMeuMsg.KValueSet; 
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_KValueSetDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_KValueSetDo(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_KValueSetExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_KValueSetExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VersionShow_disp                    2˵-汾鿴
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VersionShow_disp(void)
{
    Api_ClearIcon(6, 236, 43, 255);
    Api_ClearIcon(6, 236, 5, 38);
    Api_DrawImgIcon(184, 232, ok);
    Gui_Version_Disp();
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_Version_Disp           2˵-汾鿴-"㲿ͼ"
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_Version_Disp(void)
{
    INT8U len = null;
    INT32U wTemp;
    if(SetMeuMsg.Language == Arabic)
    {
        //--01_2˵_汾Ϣ
        Api_DrawImg2Icon(17, 11, Set_Menu2_BBXXCK_Title_Word2_x17_y11);
        //--㲿ͼ
        Api_DrawImg2Icon(49, 65, Set_Menu2_BBXXCK_01_Word2_x49_y65);
        //--Ӳ汾
        Api_DrawImg2Icon(15, 162, alab_yingjianbanben);
        //--汾
        Api_DrawImg2Icon(16, 198, alab_ruanjianbanben);
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        //01_2˵_汾Ϣ     Version
        Api_DrawLetterIcon(90, 14, "Versi<n", CharLetter3);
        //㲿ͼ   codigo  de repuesto
        Api_DrawLetterIcon(35, 75, "c<digo", CharLetter3);
        Api_DrawLetterIcon(101, 75, "de", CharLetter3);
        Api_DrawLetterIcon(130, 75, "repuesto", CharLetter3);
        //Ӳ汾      Version de hardware
        Api_DrawLetterIcon(10, 165, "Versi<n", CharLetter2);
        Api_DrawLetterIcon(70, 165, "de", CharLetter2);
        Api_DrawLetterIcon(91, 165, "hardware", CharLetter2);
        //汾    Version de software
        Api_DrawLetterIcon(10, 195, "Versi<n", CharLetter2);
        Api_DrawLetterIcon(70, 195, "de", CharLetter2);
        Api_DrawLetterIcon(91, 195, "software", CharLetter2);
    }
    else if(SetMeuMsg.Language == English)
    {
        //01_2˵_汾Ϣ   Version information view
        Api_DrawLetterIcon(15, 14, "Version", CharLetter3);
        Api_DrawLetterIcon(86, 14, "information", CharLetter3);
        Api_DrawLetterIcon(187, 14, "view", CharLetter3);
        //Ӳ汾      HW ver.
        Api_DrawImgIcon(33, 170, yingwen_banbenH);
        Api_DrawImg2Icon(45, 170, yingwen_Wver);
        //汾     SW ver.
        Api_DrawIcon(33, 200, yingwen_banbenS);
        Api_DrawImg2Icon(45, 200, yingwen_Wver);
        //㲿ͼ    Part No.
        Api_DrawImg2Icon(77, 69, yingwen_banbenxixi);
    }
    else
    {
        Api_DrawImgIcon(40, 9, toubanbenxinxichakan);
        Api_DrawImg2Icon(58, 66, lingbujaintuhao);
        Api_DrawImg2Icon(24, 193, ruanjianbanben);
        Api_DrawImg2Icon(24, 162, yingjianbanben);
    }
    wTemp = SetMeuMsg.PartsNumber;
    DispText.Text[0] = (wTemp / 1000000) % 10;
    DispText.Text[1] = (wTemp / 100000) % 10;
    DispText.Text[2] = (wTemp / 10000) % 10;
    DispText.Text[3] = (wTemp / 1000) % 10;
    DispText.Text[4] = (wTemp / 100) % 10;
    DispText.Text[5] = (wTemp / 10) % 10;
    DispText.Text[6] =  wTemp % 10;
    Api_DrawIcon(35-8, 108, Api_Value_Get(DispText.Text[0], 14));
    Api_DrawIcon(49-8, 108, Api_Value_Get(DispText.Text[1], 14));
    Api_DrawIcon(63-8, 108, Api_Value_Get(DispText.Text[2], 14));
    Api_DrawIcon(77-8, 108, Api_Value_Get(DispText.Text[3], 14));
    Api_DrawIcon(91-8, 108, Api_Value_Get(DispText.Text[4], 14));
    Api_DrawIcon(105-8, 108, Api_Value_Get(DispText.Text[5], 14));
    Api_DrawIcon(119-8, 108, Api_Value_Get(DispText.Text[6], 14));
/*
    #if defined(PN_E50FT)  
        Api_DrawIcon(133, 105,E50FT);
    #elif defined(PN_E50BTXA)  
        Api_DrawIcon(130, 110,E50BTXA);
    #elif defined(PN_E50BTXZ)  
        Api_DrawIcon(130, 110,E50BTXZ);   
    #elif defined(PN_D7110A)  
        Api_DrawIcon(130, 110,D7110A);
     #elif defined(PN_B50D0C)  
        Api_DrawIcon(130, 110,B50D0);
               
    #endif   
*/
//㲿ͼ     //B5030XA 
    Api_DrawIcon(133-8, 109,B_CHAR);
    Api_DrawIcon(147-8, 108, Api_Value_Get(5, 14));    
    Api_DrawIcon(161-8, 108, Api_Value_Get(0, 14)); 
    Api_DrawIcon(175-8, 108, Api_Value_Get(3, 14));     
    Api_DrawIcon(189-8, 108, Api_Value_Get(0, 14));     
    Api_DrawIcon(203-8, 109,X_CHAR);    
    Api_DrawIcon(218-8, 109,A_CHAR);                  
    //Ӳ汾
    Api_DrawImg2Icon(161, 162, shuzi_v);
    wTemp = SetMeuMsg.HardwareVersion;
    DispText.Text[5] = (wTemp / 10) % 10;
    DispText.Text[6] =  wTemp % 10;

    Api_DrawIcon(192, 162, Api_Value_Get(DispText.Text[5], 14));
    Api_DrawIcon(214, 162, Api_Value_Get(DispText.Text[6], 14));

    //汾
    Api_DrawImg2Icon(161, 193, shuzi_v);
    wTemp = SetMeuMsg.SoftWareVersion; 
    DispText.Text[4] = (wTemp / 100) % 10;
    DispText.Text[5] = (wTemp / 10) % 10;
    DispText.Text[6] =  wTemp % 10;

    Api_DrawIcon(180, 193, Api_Value_Get(DispText.Text[4], 14));
    Api_DrawIcon(202, 193, Api_Value_Get(DispText.Text[5], 14));
    Api_DrawIcon(216, 193, Api_Value_Get(DispText.Text[6], 14));
    Api_DrawIcon(195, 209, White_34_dian);  
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VersionShowDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VersionShowDo(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_VersionShowExit
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_VersionShowExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Dp_ReTurn                                     
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  Dp_ReTurn(void)
{
    Api_ClearIcon(6, 236, 5, 38);//
    Api_ClearIcon(6, 236, 43, 255);//м
    
    g_SetMenuState = 0;
    
     NextMenu(bMainMenuIDX);//ֵ
    
    Time_Updeta;
    InstFuel_Updeta;
    Time_Updeta;
    AveFuel_Updeta;
    Adblue_Updeta;
    Gas2_Updeta;
    Gas1_Updeta;
    Time_Updeta;
    
    bUpDataFlag = 1;
}
/*-------------------------------------------------------------------------
* Function Name  : Dp_ReTurnClr
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  Dp_ReTurnClr(void)
{
    Api_ClearIcon(6, 240, 5, 38);//(xLarge)   
    Api_ClearIcon(2, 240, 43, 255);//м(xLarge)    
}
/*-------------------------------------------------------------------------
* Function Name  : Dp_ReTurnClrH
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void  Dp_ReTurnClrH(void)
{
    Api_ClearIcon(6, 236, 43, 255);//м    
}