/*
* gui_Home2nd.c
*
*	Created	on:	Aug	11,	2014
*			Author:	QTC
*/


#define	 GLOBALS_GUI_Home2nd
#include "defines.h"
#include "g_includes.h"


/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_InstFuelAbuEnter               ̳ͺ + Adblue
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_InstFuelAbuEnter(void)
{
    //Adblue
    if(bUpDataFlag == 1)
    {
        bUpDataFlag = 0;
        Api_DrawImg2Icon(7, 57, Adblue);
        Api_DrawImgIcon(51, 65, Adblue_di);
    }

    if(g_VehMenuState == 1)
    {
        Api_ClearIcon(6, 236, 120, 255);
        g_VehMenuState = 0;
    }
    //̳ͺ
    if(SetMeuMsg.Language == Arabic)
    {
        Api_DrawImg2Icon(27, 162, alab_duanchengyouhaowenzi);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        Api_ClearIcon(20, 220, 130, 190);
        //̳ͺ     Consumo  de  distancia  corta
        Api_DrawLetterIcon(58, 136, "Consumo", CharLetter3);
        Api_DrawLetterIcon(153, 136, "de", CharLetter3);
        Api_DrawLetterIcon(53, 165, "distancia", CharLetter3);
        Api_DrawLetterIcon(142, 165, "corta", CharLetter3);
    }
    else if(SetMeuMsg.Language == English)
    {
        Api_ClearIcon(40, 220, 130, 190);
        //̳ͺ Short-range fuel consumption
        Api_DrawLetterIcon(46, 136, "Short-range", CharLetter);
        Api_DrawLetterIcon(162, 136, "fuel", CharLetter);
        Api_DrawLetterIcon(62, 165, "consumption", CharLetter);
    }
    else
    {
        Api_DrawImg2Icon(69, 163, duanchengyouhao);
        
    }
    Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
    
    if(g_Style == 0)
    {
        Api_DrawImg2Icon(146, 168, duanchengyouhaodanwei);
    }
    else
    {
        Api_DrawImg2Icon(145, 217, duanchengyouhaodanwei);
    }
    
    g_SetMenuState = 0;
    InstFuel_Updeta;
    
    Adblue_Updeta;
    bOldMenuIDX=0;
}
/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_InstFuelAbuDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_InstFuelAbuDo(void)
{
    Gui_ODO_Disp();
    Gui_Tirp_Disp();
    Gui_Time_Disp();
    Gui_Adblue_Disp();
    Gui_InstFuel_Disp();
    Gui_Gears_disp();
}
/*-------------------------------------------------------------------------
*	Function Name	 : Gui_InstFuel_Disp
*	Description		 :
*	Input					 : None
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void Gui_InstFuel_Disp(void)
{
    INT8U	 len;
    INT32U m_Temp;
    
    if(g_fuelEco.OldDispSRFC != g_fuelEco.DispSRFC)
    {
        InstFuel_Updeta;
    }
    if(g_fuelEco.DispSRFC > null)
    {
        if(g_winUpdeta.bits.InstFuelUp)
        {
            InstFuel_UpdetaClr;
            m_Temp = g_fuelEco.DispSRFC;
            len = 	App_CalDataLen(m_Temp);
            DispText.Text[0] = (m_Temp / 100)	% 10;
            DispText.Text[1] = (m_Temp / 10) % 10;
            DispText.Text[2] = m_Temp % 10;
            
            if(len == 1)  len++;
                
            if(g_Style == 0)
            {
                switch(len)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 153, Api_Value_Get(DispText.Text[0], 34));
                    case 2:
                        Api_DrawImg2Icon(83, 153, Api_Value_Get(DispText.Text[1], 34));
                    case 1:
                        Api_DrawImg2Icon(116, 153, Api_Value_Get(DispText.Text[2], 34));
                    default:
                        ;
                }
                switch(len + 1)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 153, Api_Value_Get(10, 34));
                    default:
                        ;
                }
                
                Api_DrawIcon(107, 177, White_34_dian);
            }
            else
            {
                switch(len)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 203, Api_Value_Get(DispText.Text[0], 34));
                    case 2:
                        Api_DrawImg2Icon(83, 203, Api_Value_Get(DispText.Text[1], 34));
                    case 1:
                        Api_DrawImg2Icon(116, 203, Api_Value_Get(DispText.Text[2], 34));
                    default:
                        ;
                }
                switch(len + 1)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 203, Api_Value_Get(10, 34));
                    default:
                        ;
                }
                
                Api_DrawIcon(107, 227, White_34_dian);
            }
        }
        ClrAveFuel=1;
        
    }
    else
    {
        if(g_winUpdeta.bits.InstFuelUp)
        {
            InstFuel_UpdetaClr;
            if(g_Style == 0)
            {
                if( ClrAveFuel==1)
                {
                    ClrAveFuel=0;
                    Api_DrawImg2Icon(61, 153, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(83, 153, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(116, 153, Api_Value_Get(10, 34));
                }
                Api_DrawImgIcon(61, 160, SetMap_);
                Api_DrawImgIcon(83, 160, SetMap_);
                Api_DrawImgIcon(116, 160, SetMap_);
                Api_DrawIcon(107, 177, White_34_dian);
            }
            else
            {
                if( ClrAveFuel==1)
                {
                    ClrAveFuel=0;
                    Api_DrawImg2Icon(61, 203, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(83, 203, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(116, 203, Api_Value_Get(10, 34));
                }
                Api_DrawImgIcon(61, 210, SetMap_);
                Api_DrawImgIcon(83, 210, SetMap_);
                Api_DrawImgIcon(116, 210, SetMap_);
                Api_DrawIcon(107, 227, White_34_dian);
            }
        }
    }
    g_fuelEco.OldDispSRFC = g_fuelEco.DispSRFC;
 
}
/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_InstFuelAbuExit               
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_InstFuelAbuExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_AvgFuelAbuEnter                ƽͺ + Adblue
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_AvgFuelAbuEnter(void)
{
    if(bClrTireFlag==1)
    {
        Api_ClearIcon(6, 236, 43, 255);
        bClrTireFlag=0;
    }
    //Adblue
    if(bUpDataFlag == 1)
    {
        bUpDataFlag = 0;
        Api_DrawImg2Icon(7, 57, Adblue);
        Api_DrawImgIcon(51, 65, Adblue_di);
    }

    if(g_VehMenuState == 1)
    {
        g_VehMenuState = 0;
        Api_ClearIcon(6, 236, 120, 255);
    }
    g_SetMenuState = 0;
    //ƽͺ
    if(SetMeuMsg.Language == Arabic)
    {
        Api_DrawImgIcon(27, 162, alab_pingjunyouhaowenzi);
        
    }
    else if(SetMeuMsg.Language == Spanish)
    {
        Api_ClearIcon(20, 220, 130, 190);
        //ƽͺ        Consumo  promedio
        Api_DrawLetterIcon(30, 165, "Consumo", CharLetter3);
        Api_DrawLetterIcon(125, 165, "promedio", CharLetter3);
    }
    else if(SetMeuMsg.Language == English)
    {
        Api_ClearIcon(40, 220, 130, 190);
        //ƽͺ Average fuel consumption
        Api_DrawLetterIcon(61, 136, "Average", CharLetter);
        Api_DrawLetterIcon(146, 136, "fuel", CharLetter);
        Api_DrawLetterIcon(62, 165, "consumption", CharLetter);
    }
    else
    {
        Api_DrawImg2Icon(69, 163, pingjunyouhao);
    }
    Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
    
    Api_DrawImg2Icon(145, 217, duanchengyouhaodanwei);
    AveFuel_Updeta;

    Adblue_Updeta;
    bOldMenuIDX=0;
    
}
/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_AvgFuelAbuDo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_AvgFuelAbuDo(void)
{
    Gui_ODO_Disp();
    Gui_Tirp_Disp();
    Gui_Time_Disp();
    Gui_Adblue_Disp();
    Gui_Gears_disp();
    Gui_AveFuel_Disp();
}
/*-------------------------------------------------------------------------
*	Function Name	 : Gui_AveFuel_Disp
*	Description		 :
*	Input					 : None
*	Output				 : None
*	Return				 : None
*	onther				 :
--------------------------------------------------------------------------*/
void Gui_AveFuel_Disp(void)
{
    INT8U	 len;
    INT32U m_Temp;
    
    if(g_fuelEco.OldAveFuel != g_fuelEco.DispAveFuel)
    {
        AveFuel_Updeta;
    }
    if(g_fuelEco.DispAveFuel > null)
    {
        if(g_winUpdeta.bits.AveFuelUp)
        {
            AveFuel_UpdetaClr;
            m_Temp = g_fuelEco.DispAveFuel;
            len = 	App_CalDataLen(m_Temp);
            DispText.Text[0] = (m_Temp / 100)	% 10;
            DispText.Text[1] = (m_Temp / 10) % 10;
            DispText.Text[2] = m_Temp % 10;
            
            if(len == 1)  len++;
                
            if(g_Style == 0)
            {
                switch(len)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 153, Api_Value_Get(DispText.Text[0], 34));
                    case 2:
                        Api_DrawImg2Icon(83, 153, Api_Value_Get(DispText.Text[1], 34));
                    case 1:
                        Api_DrawImg2Icon(116, 153, Api_Value_Get(DispText.Text[2], 34));
                    default:
                        ;
                }
                switch(len + 1)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 153, Api_Value_Get(10, 34));
                    default:
                        ;
                }
                
                Api_DrawIcon(107, 177, White_34_dian);
            }
            else
            {
                switch(len)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 203, Api_Value_Get(DispText.Text[0], 34));
                    case 2:
                        Api_DrawImg2Icon(83, 203, Api_Value_Get(DispText.Text[1], 34));
                    case 1:
                        Api_DrawImg2Icon(116, 203, Api_Value_Get(DispText.Text[2], 34));
                    default:
                        ;
                }
                switch(len + 1)
                {
                    case 3:
                        Api_DrawImg2Icon(61, 203, Api_Value_Get(10, 34));
                    default:
                        ;
                }
                
                Api_DrawIcon(107, 227, White_34_dian);
            }
        }
        
        ClrAveFuel=1;
    }
    else
    {
        if(g_winUpdeta.bits.AveFuelUp)
        {
            
            AveFuel_UpdetaClr;
            if(g_Style == 0)
            {
                if( ClrAveFuel==1)
                {
                    ClrAveFuel=0;
                    Api_DrawImg2Icon(61, 153, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(83, 153, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(116, 153, Api_Value_Get(10, 34));
                }
                Api_DrawImgIcon(61, 160, SetMap_);
                Api_DrawImgIcon(83, 160, SetMap_);
                Api_DrawImgIcon(116, 160, SetMap_);
                Api_DrawIcon(107, 177, White_34_dian);
            }
            else
            {
                if( ClrAveFuel==1)
                {
                    ClrAveFuel=0;
                    Api_DrawImg2Icon(61, 203, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(83, 203, Api_Value_Get(10, 34));
                    Api_DrawImg2Icon(116, 203, Api_Value_Get(10, 34));
                }
                Api_DrawImgIcon(61, 210, SetMap_);
                Api_DrawImgIcon(83, 210, SetMap_);
                Api_DrawImgIcon(116, 210, SetMap_);
                Api_DrawIcon(107, 227, White_34_dian);
            }  
        }   
    }
    g_fuelEco.OldAveFuel = g_fuelEco.DispAveFuel;
    
}
/*-------------------------------------------------------------------------
* Function Name  : GuiH2nd_AvgFuelAbuExit               
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void GuiH2nd_AvgFuelAbuExit(void)
{
    //----//
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_Screen1_disp                  ̳ͺ + Adblue/ѹ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_Screen1_disp(void)
{
    
    if(bClrTireFlag==1)
    {
        Api_ClearIcon(6, 236, 43, 255);
        bClrTireFlag=0;
    }
    
    //Һ
    if(g_Style == 2)
    {
        //Adblue
        if(bUpDataFlag == 1)
        {
            bUpDataFlag = 0;
            Api_DrawImg2Icon(7, 57, Adblue);
            Api_DrawImgIcon(51, 65, Adblue_di);
        }

        //̳ͺ
        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImg2Icon(27, 162, alab_duanchengyouhaowenzi);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(20, 220, 130, 190);
            //̳ͺ     Consumo  de  distancia  corta
            Api_DrawLetterIcon(58, 136, "Consumo", CharLetter3);
            Api_DrawLetterIcon(153, 136, "de", CharLetter3);
            Api_DrawLetterIcon(53, 165, "distancia", CharLetter3);
            Api_DrawLetterIcon(142, 165, "corta", CharLetter3);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(30, 220, 130, 190);
            //̳ͺ Short-range fuel consumption
            Api_DrawLetterIcon(46, 136, "Short-range", CharLetter);
            Api_DrawLetterIcon(162, 136, "fuel", CharLetter);
            Api_DrawLetterIcon(62, 165, "consumption", CharLetter);
        }
        else
        {
            Api_DrawImg2Icon(69, 163, duanchengyouhao);
            
        }
        Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
    
        Adblue_Updeta;
        
        
    }
    //ѹ
    else if(g_Style == 3)
    {
        if(bUpDataFlag == 1)
        {
            bUpDataFlag = 0;
            Api_DrawImg2Icon(8, 55, gas1);
            Api_DrawImg2Icon(8, 106, gas2);
            Api_DrawImgIcon(54, 60, qiya_di);
            Api_DrawImgIcon(54, 111, qiya_di);
        }
        //̳ͺ

        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImg2Icon(27, 168, alab_duanchengyouhaowenzi);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(10, 230, 160, 190);
            //̳ͺ     Consumo  de  distancia  corta
            Api_DrawLetterIcon(13, 166, "Consumo", CharLetter2);
            Api_DrawLetterIcon(91, 166, "de", CharLetter2);
            Api_DrawLetterIcon(115, 166, "distancia", CharLetter2);
            Api_DrawLetterIcon(190, 166, "corta", CharLetter2);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(10, 220, 160, 190);
            //̳ͺ Short-range fuel consumption
            Api_DrawLetterIcon(15, 166, "Short-range", CharLetter1);
            Api_DrawLetterIcon(104, 166, "fuel", CharLetter1);
            Api_DrawLetterIcon(136, 166, "consumption", CharLetter1);
        }
        else
        {
            Api_DrawImg2Icon(69, 163, duanchengyouhao);
        }
        Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
    
        Gas2_Updeta;
        Gas1_Updeta;
    }
    //öû
    else
    {

        //̳ͺ
        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImg2Icon(27, 113, alab_duanchengyouhaowenzi);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(25, 220, 80, 140);
            //̳ͺ     Consumo  de  distancia  corta
            Api_DrawLetterIcon(58, 87, "Consumo", CharLetter3);
            Api_DrawLetterIcon(153, 87, "de", CharLetter3);
            Api_DrawLetterIcon(53, 116, "distancia", CharLetter3);
            Api_DrawLetterIcon(142, 116, "corta", CharLetter3);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(40, 220, 80, 140);
            //̳ͺ Short-range fuel consumption
            Api_DrawLetterIcon(46, 87, "Short-range", CharLetter);
            Api_DrawLetterIcon(162, 87, "fuel", CharLetter);
            Api_DrawLetterIcon(62, 116, "consumption", CharLetter);
        }
        else
        {
            Api_DrawImg2Icon(69, 112, duanchengyouhao);
        }
        Api_DrawImgIcon(16, 153, duanchengyouhaotubiao);
    
        
    }

    if(g_Style == 0)
    {
        Api_DrawImg2Icon(146, 168, duanchengyouhaodanwei);
    }
    else
    {
        Api_DrawImg2Icon(145, 217, duanchengyouhaodanwei);
    }

    
    
    InstFuel_Updeta;
    bOldMenuIDX=0;
    
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_RealScreen1_disp
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_RealScreen1_disp(void)
{
    if(g_Style == 2)
    {
        Gui_Adblue_Disp();
    }
    else if(g_Style == 3)
    {
        Gui_Gas1_Disp();
        Gui_Gas2_Disp();
    }
    
    Gui_ODO_Disp();
    Gui_Tirp_Disp();
    Gui_Time_Disp();
    Gui_Gears_disp();
    Gui_InstFuel_Disp();  
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_Screen2_disp                  ƽͺ + Adblue/ѹ
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_Screen2_disp(void)
{ 
    if(bClrTireFlag==1)
    {
        Api_ClearIcon(6, 236, 43, 255);
        bClrTireFlag=0;
    }
    if(g_Style == 2)
    {
        //Adblue
        if(bUpDataFlag == 1)
        {
            bUpDataFlag = 0;
            Api_DrawImg2Icon(7, 57, Adblue);
            Api_DrawImgIcon(51, 65, Adblue_di);
        }

        //ƽͺ
        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImgIcon(27, 162, alab_pingjunyouhaowenzi);  
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(20, 220, 130, 190);
            //ƽͺ        Consumo  promedio
            Api_DrawLetterIcon(30, 165, "Consumo", CharLetter3);
            Api_DrawLetterIcon(125, 165, "promedio", CharLetter3);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(30, 220, 130, 190);
            //ƽͺ Average fuel consumption
            Api_DrawLetterIcon(61, 136, "Average", CharLetter);
            Api_DrawLetterIcon(146, 136, "fuel", CharLetter);
            Api_DrawLetterIcon(62, 165, "consumption", CharLetter);
        }
        else
        {
            Api_DrawImg2Icon(69, 163, pingjunyouhao);
        }
        Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
        Api_DrawImg2Icon(145, 217, duanchengyouhaodanwei);
    
        Adblue_Updeta;
        
    }
    else if(g_Style == 3)
    {
        if(bUpDataFlag == 1)
        {
            bUpDataFlag = 0;
            Api_DrawImg2Icon(8, 55, gas1);
            Api_DrawImg2Icon(8, 106, gas2);
            Api_DrawImgIcon(54, 60, qiya_di);
            Api_DrawImgIcon(54, 111, qiya_di);
        }

        //ƽͺ
        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImgIcon(27, 168, alab_pingjunyouhaowenzi);
            
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(10, 230, 160, 190);
            //ƽͺ        Consumo  promedio
            Api_DrawLetterIcon(46, 166, "Consumo", CharLetter2);
            Api_DrawLetterIcon(124, 166, "promedio", CharLetter2);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(10, 220, 160, 190);
            //ƽͺ Average fuel consumption
            Api_DrawLetterIcon(28, 166, "Average", CharLetter1);
            Api_DrawLetterIcon(91, 166, "fuel", CharLetter1);
            Api_DrawLetterIcon(123, 166, "consumption", CharLetter1);
        }
        else
        {
            Api_DrawImg2Icon(69, 163, pingjunyouhao);
        }
        
        Api_DrawImgIcon(16, 204, duanchengyouhaotubiao);
        Api_DrawImg2Icon(145, 217, duanchengyouhaodanwei);
    
        Gas2_Updeta;
        Gas1_Updeta;
    }
    else
    {

        //ƽͺ
        if(SetMeuMsg.Language == Arabic)
        {
            Api_DrawImgIcon(27, 113, alab_pingjunyouhaowenzi);
        }
        else if(SetMeuMsg.Language == Spanish)
        {
            Api_ClearIcon(25, 220, 80, 140);
            //ƽͺ      Consumo  promedio
            Api_DrawLetterIcon(30, 115, "Consumo", CharLetter3);
            Api_DrawLetterIcon(125, 115, "promedio", CharLetter3);
        }
        else if(SetMeuMsg.Language == English)
        {
            Api_ClearIcon(40, 220, 80, 140);
            
            //ƽͺ Average fuel consumption
            Api_DrawLetterIcon(61, 86, "Average", CharLetter);
            Api_DrawLetterIcon(146, 86, "fuel", CharLetter);
            Api_DrawLetterIcon(62, 116, "consumption", CharLetter);
        }
        else
        {
            Api_DrawImg2Icon(69, 112, pingjunyouhao);
        }
        Api_DrawImgIcon(16, 153, duanchengyouhaotubiao);
        Api_DrawImg2Icon(146, 168, duanchengyouhaodanwei);
    
        
    }
    AveFuel_Updeta;
    bOldMenuIDX=0;
}
/*-------------------------------------------------------------------------
* Function Name  : Gui_RealScreen2_disp
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Gui_RealScreen2_disp(void)
{
    if(g_Style == 2)
    {
        Gui_Adblue_Disp();
    }
    else if(g_Style == 3)
    {
        Gui_Gas1_Disp();
        Gui_Gas2_Disp();
    }
    
    Gui_ODO_Disp();
    Gui_Tirp_Disp();
    Gui_Time_Disp();
    Gui_Gears_disp();
    Gui_AveFuel_Disp();
}
