

#define  GLOBALS_API_EE
#include "defines.h"
#include "g_includes.h"
#include "app_service.h"
extern DIAG_2E_DATA Diag2eData;

/*-------------------------------------------------------------------------
* Function Name  : Api_CopyRam
* Description    : ran copy
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_CopyRam(INT8U *Dp, INT8U *Sp, INT8U Nub)
{
    INT8U b;
    
    for(b = 0; b < Nub; b++)
    {
        *Dp++  = *Sp++;
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Api_CreateCRCCheckSum
* Description    : ????
* Input          : INT8U *p ,INT8U Nub
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
INT8U Api_CreateCRCCheckSum(INT8U *p , INT8U Nub)
{
    INT8U bCheckSun;
    INT8U i;
    bCheckSun = null;
    while(Nub--)
    {
        bCheckSun ^= *p++;
        for(i = 0; i < 8; i++)
        {
            if(bCheckSun & 0x01)
            {
                bCheckSun = (bCheckSun >> 1) ^ 0x8C;
            }
            else
            bCheckSun >>= 1;
        }
    }
    return(bCheckSun);
}

/*-------------------------------------------------------------------------
* Function Name  : Api_ReadAccKm
* Description    :
* Input          : None
* Output         : INT8U
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_ReadAccKm(void)
{
    INT8U   check1 = null;
    INT8U   check2 = null;
    
    g_AccAddr.CurEEAccddr = EEACC_START;
    bsp_WDOG_Feed();
    
    for(; g_AccAddr.CurEEAccddr < EEACC_END;)
    {
        (void)bsp_IIC_ReadPage(EEPROM_BLOCK0, (INT8U)g_AccAddr.CurEEAccddr, (INT8U *) &g_accKm,   Register_Len);
        
        check1 = Api_CreateCRCCheckSum((INT8U *) &g_accKm, Register_Len - 2);
        
        if((check1 != g_accKm.bCheckSun) || (g_accKm.Checkflag != CheckFlag) || (g_accKm.LongAccKm > 10000000))
        {
            g_AccAddr.CurEEAccddr += Register_Len;
        }
        else
        {
            break;
        }
        bsp_WDOG_Feed();
    }
    for(; g_AccAddr.CurEEAccddr <= (EEACC_END - Register_Len);)
    {
        (void)bsp_IIC_ReadPage(EEPROM_BLOCK0, (INT8U)g_AccAddr.CurEEAccddr, (INT8U *) &g_accKm,   Register_Len);
        (void)bsp_IIC_ReadPage(EEPROM_BLOCK0, g_AccAddr.CurEEAccddr + Register_Len, (INT8U *) &g_oldAccKm, Register_Len);
        
        bsp_WDOG_Feed();
        
        if((g_accKm.Checkflag == CheckFlag) && (g_oldAccKm.Checkflag == CheckFlag) && \
           (g_accKm.LongAccKm <= 10000000)  && (g_oldAccKm.LongAccKm <= 10000000))
        {
            check1 = Api_CreateCRCCheckSum((INT8U *) &g_accKm,   Register_Len - 2);
            check2 = Api_CreateCRCCheckSum((INT8U *) &g_oldAccKm, Register_Len - 2);
            
            if((check1 == g_accKm.bCheckSun) && (check2 == g_oldAccKm.bCheckSun))
            {
                if(g_accKm.LongAccKm <= g_oldAccKm.LongAccKm)
                {
                    if((g_accKm.LongAccKm + 100) > g_oldAccKm.LongAccKm)
                    {
                        g_AccAddr.CurEEAccddr += Register_Len;
                    }
                    else
                    {
                        break;
                    }
                }
                else
                {
                    break;
                }
            }
            else
            {
                break;
            }
        }
        else
        {
            break;
        }
        bsp_WDOG_Feed();
    }
    g_ReadState = bsp_IIC_ReadPage(EEPROM_BLOCK0, (INT8U)g_AccAddr.CurEEAccddr, (INT8U *) &g_accKm,   Register_Len);
    check1 = Api_CreateCRCCheckSum((INT8U *) &g_accKm,   Register_Len - 2);
    
    if((g_accKm.Checkflag != CheckFlag) || (g_accKm.LongAccKm > 10000000) || (check1 != g_accKm.bCheckSun))
    {
        g_ReadState = bsp_IIC_ReadPage(EEPROM_BLOCK0, EEBAKACC, (INT8U *) &g_accKm,   Register_Len);
        check1 = Api_CreateCRCCheckSum((INT8U *) &g_accKm,   Register_Len - 2);
        if((g_accKm.Checkflag != CheckFlag) || (g_accKm.LongAccKm > 10000000) || (check1 != g_accKm.bCheckSun))
        {
            g_accKm.Checkflag = CheckFlag;
            g_accKm.LongAccKm = null;
            g_accKm.ShortAccKm = null;
            RamShortAccKmA=0;
            g_accKm.RemnantPulse = null;
            g_accKm.FuelSum = 3000;
            g_accKm.Dis100Km = 400;
            g_accKm.bCheckSun = Api_CreateCRCCheckSum((INT8U *) &g_accKm, Register_Len - 2);
        }
    }
    
    Api_CopyRam((INT8U *)&g_oldAccKm, (INT8U *)&g_accKm, Register_Len);
    Enable_signal(g_sysFlag.Bits.AccSaveState);
    Disable_signal(g_sysFlag.Bits.AccKmValid);
}
/*-------------------------------------------------------------------------
* Function Name  : Api_WriteAccReg
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_WriteAccReg(void)
{
    if((g_accKm.LongAccKm <= 10000000) && (g_ReadState == RunComplete))
    {
        g_accKm.Checkflag = CheckFlag;
        g_accKm.bCheckSun = Api_CreateCRCCheckSum((INT8U *)&g_accKm, Register_Len - 2);
        
        g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, (INT8U)g_AccAddr.CurEEAccddr, (INT8U *) &g_accKm, Register_Len);
        
        if(g_AccAddr.CurEEAccddr >= EEACC_END)
        {
            g_AccAddr.CurEEAccddr = EEACC_START;
        }
        else
        {
            g_AccAddr.CurEEAccddr += Register_Len;
        }
        Api_CopyRam((INT8U *)&g_oldAccKm, (INT8U *)&g_accKm, Register_Len);
    }
}

/*-------------------------------------------------------------------------
* Function Name  : Api_ClearAccStock
* Description    :
* Input          : None
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_ClearAccStock(void)
{
    if(g_sysFlag.Bits.AccSaveState)
    {
        bsp_WDOG_Feed();
        
        g_accKm.Checkflag = CheckFlag;
        g_accKm.LongAccKm = null;
        g_accKm.ShortAccKm = null;
        g_accKm.FuelSum = 3000;
        g_accKm.Dis100Km = 400;
        g_accKm.RemnantPulse = null;
        g_accKm.bCheckSun  = Api_CreateCRCCheckSum((INT8U *)&g_accKm, sizeof(_Register) - 2);
        
        bsp_Delay(5000);
        g_accKmClrStep ++;
        switch(g_accKmClrStep)
        {
            case 1:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 0, (INT8U *)&g_accKm, Register_Len);
                break;
            case 2:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 16, (INT8U *)&g_accKm, Register_Len);
                break;
            case 3:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 32, (INT8U *)&g_accKm, Register_Len);
                break;
            case 4:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 48, (INT8U *)&g_accKm, Register_Len);
                break;
            case 5:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 64, (INT8U *)&g_accKm, Register_Len);
                break;
            case 6:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 80, (INT8U *)&g_accKm, Register_Len);
                break;
            case 7:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEACC_START + 96, (INT8U *)&g_accKm, Register_Len);
                break;
            case 8:
                g_bReturn = bsp_IIC_WritePage(EEPROM_BLOCK0, EEBAKACC, (INT8U *)&g_accKm, Register_Len);
                g_sysFlag.Bits.AccSaveState = Disable;
                g_accKmClrStep = null;
                g_sysFlag.Bits.ClearODO = 0;
                break;
            default:
                ;
        }
        
        bsp_WDOG_Feed();
        Api_CopyRam((INT8U *)&g_oldAccKm, (INT8U *)&g_accKm, sizeof(_Register));
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Api_ReadMeterInfo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_ReadMeterInfo(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data)
{
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd, (INT8U *)&Data[0], 16);
    bsp_WDOG_Feed();
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd + 16, (INT8U *)&Data[16], 16);
    bsp_WDOG_Feed();
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd + 32, (INT8U *)&Data[32], 4);
}
/*-------------------------------------------------------------------------
* Function Name  : Api_WriteMeterInfo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_WriteMeterInfo(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data)
{
    bsp_WDOG_Feed();
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd, (INT8U *)&Data[0], 16);
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd + 16, (INT8U *)&Data[16], 16);
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd + 32, (INT8U *)&Data[32], 4);
    bsp_Delay(6000);
}
/*-------------------------------------------------------------------------
* Function Name  : Api_ReadProductInfo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_ReadProductInfo(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data)
{
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd, (INT8U *)&Data[0], 16);
    bsp_WDOG_Feed();
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd + 16, (INT8U *)&Data[16], 16);
    bsp_WDOG_Feed();
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd + 32, (INT8U *)&Data[32], 16);
    bsp_WDOG_Feed();
    (void)bsp_IIC_ReadPage(PhyAdd, MemAdd + 48, (INT8U *)&Data[48], 4);
}
/*-------------------------------------------------------------------------
* Function Name  : Api_WriteProductInfo
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Api_WriteProductInfo(INT8U  PhyAdd, INT8U  MemAdd, INT8U *Data)
{
    bsp_WDOG_Feed();
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd, (INT8U *)&Data[0], 16);
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd + 16, (INT8U *)&Data[16], 16);
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd + 32, (INT8U *)&Data[32], 16);
    bsp_Delay(6000);
    (void)bsp_IIC_WritePage(PhyAdd, MemAdd + 48, (INT8U *)&Data[48], 4);
    bsp_Delay(6000);
}

/*-------------------------------------------------------------------------
* Function Name  : Write2EData                                      64Bytes
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Write2EData(void)
{
    INT8U i;
    for (i = 0; i < (sizeof(Diag2eData) / 16); i++)
    {
        (void)bsp_IIC_WritePage(EEPROM_BLOCK_DIAG_2E, (EE_2E_ADDR+(i * 16)), (INT8U *)&Diag2eData + i * 16, 16);
        bsp_Delay(6000);
    }
}
/*-------------------------------------------------------------------------
* Function Name  : Init2EData                                       64Bytes
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void Init2EData(void)
{
    INT8U i;
    INT32U wTemp = null;    
    
    for (i = 0; i < (sizeof(Diag2eData) / 16); i++)
    {
        (void)bsp_IIC_ReadPage(EEPROM_BLOCK_DIAG_2E, (EE_2E_ADDR+(i * 16)), (INT8U *)&Diag2eData + i * 16, 16);
        bsp_Delay(6000);
    }
    
    g_chksun = Api_CreateCRCCheckSum((INT8U*)&Diag2eData,sizeof(Diag2eData)-2);
    if((Diag2eData.bFlag	!= CheckFlag)||(g_chksun !=Diag2eData.bCheckSum ))
    {
        //---- F190 ----//
        (void)memset((INT8U *)&Diag2eData.D_F190[0], 0, 17);
        
        //---- F192 ----//
        (void)memset((INT8U *)&Diag2eData.D_F192[0], 0, 11);     

        //---- F199 ----//
        (void)memset((INT8U *)&Diag2eData.D_F199[0], 0, 4); 
        
        //---- FCAA ----//
        
        

        wTemp = 5624;//ʶEPROMǷɹдӲ
        Diag2eData.D_FCAA[0] = (wTemp>>8) & 0xff;//Byte0-Byte1::Bit5 - Bit0 PPK           
        Diag2eData.D_FCAA[1] =  wTemp     & 0xff;                         
        //ppk
        Radio.VehRadio = ((INT16U)Diag2eData.D_FCAA[0]<<8)|((INT16U)Diag2eData.D_FCAA[1]);

        //---- F1A8 ----//
        Diag2eData.D_F1A8[0] =   90;//Byte0   ʵ120,+30           ٱֵ           : default:120km/h
 

        Diag2eData.D_F1A8[1] = 0x09; //Byte1::Bit0        ٱ             : default:1 
                                        //Byte1::Bit2 - Bit1 Һ               : default:2 18FE5600
                                        //Byte1::Bit3        ѹ                 : default:1 
                                        //Byte1::Bit7 - Bit4                  : default:0            
        
               

        Diag2eData.D_F1A8[2] = 0x01;//Byte2::Bit3 - Bit0 ״̬           : default:2 ˹ ġ壻MF3.24.8ġ
                                    //Byte2::Bit7 - Bit4 λ                 : default:0 km/hL/100km
 
       
        Diag2eData.D_F1A8[3] = 0x46;//3200-5000rpm  
                                        //Byte3::Bit0        ƫLDWS             : default:0 δ
                                        //Byte3::Bit3 - Bit1 ˮ±         : default:2 105degC 
                                        //Byte3::Bit7 - Bit4 תٱ           : default:2 3200rpm        
                                          
                                                              
        Diag2eData.D_F1A8[4] = 0x20;//Byte4::Bit6 - Bit5 ȼͱ           : default:0 E105F7
                                    //Byte4::Bit7        ȴҺҺλ       : default:0 δ
        Diag2eData.D_F1A8[5] = 0x02;//Byte5::Bit1 - Bit0 (ABS+EBD)/ESC        : default:2 CANABS+EBD
                                    //Byte5::Bit2        ȫ             : default:0 δ
                                    //Byte5::Bit5 - Bit4 ̥ѹ             : default:0 δ
                                    //Byte5::Bit7 - Bit6            : default:0 δ
                                    
        
        Diag2eData.D_F1A8[6] = 0x00; 
        (void)memset(&Diag2eData.D_F1A8[7], 0, 14);
        //ٱֵ
        SetMeuMsg.OverSpeed        =  Diag2eData.D_F1A8[0] + 30;      //--//
        //ٱ
        ConfigItem.OverSpdConfig   = (Diag2eData.D_F1A8[1])    & 0x01;
        //Һ
        ConfigItem.AdblueConfig    = (Diag2eData.D_F1A8[1]>>1) & 0x03;
        //ѹ
        ConfigItem.GasConfig       = (Diag2eData.D_F1A8[1]>>3) & 0x01;        
        //
        SetMeuMsg.Language         = (Diag2eData.D_F1A8[1]>>4) + 1;   //--//
        //״̬          
        ConfigItem.EngConfig       =  Diag2eData.D_F1A8[2]     & 0x0f;//--// 
        //ƫ       
        ConfigItem.LDWSConfig      =  Diag2eData.D_F1A8[3]     & 0x01;
        //ˮ±
        ConfigItem.TempConfig      = (Diag2eData.D_F1A8[3]>>1) & 0x07;
        //תٺ
        g_RedArea                  = (Diag2eData.D_F1A8[3]>>4) & 0x0F;
        g_RedArea                  = 2400 + g_RedArea * 200;          //--//
        //ȼ
        ConfigItem.FuelConfig      = (Diag2eData.D_F1A8[4]>>5) & 0x03;       
        //ȴҺλ
        ConfigItem.CoolLevelConfig = (Diag2eData.D_F1A8[4]>>7) & 0x01;//--//
        //ƶϵͳ-EBD
        ConfigItem.ABS_ESCConfig   =  Diag2eData.D_F1A8[5]     & 0x03;
        //ȫ
        ConfigItem.AirBagConfig    = (Diag2eData.D_F1A8[5]>>2) & 0x01;
        //̥ѹ
        ConfigItem.TpmsConfig      = (Diag2eData.D_F1A8[5]>>4) & 0x03;//--//           
    }
    else
    { 
        //-- FCAA --//
        //ppk
        Radio.VehRadio= ((INT16U)Diag2eData.D_FCAA[0]<<8)|((INT16U)Diag2eData.D_FCAA[1]);
             
        //-- F1A8 --//
        //ٱֵ
        SetMeuMsg.OverSpeed        =  Diag2eData.D_F1A8[0] + 30;      //--//
        //ٱ
        ConfigItem.OverSpdConfig   = (Diag2eData.D_F1A8[1])    & 0x01;
        //Һ
        ConfigItem.AdblueConfig    = (Diag2eData.D_F1A8[1]>>1) & 0x03;
        //ѹ
        ConfigItem.GasConfig       = (Diag2eData.D_F1A8[1]>>3) & 0x01;        
        //
        SetMeuMsg.Language         = (Diag2eData.D_F1A8[1]>>4) + 1;   //--//
        //״̬          
        ConfigItem.EngConfig       =  Diag2eData.D_F1A8[2]     & 0x0f;//--// 
        //ƫ       
        ConfigItem.LDWSConfig      =  Diag2eData.D_F1A8[3]     & 0x01;
        //ˮ±
        ConfigItem.TempConfig      = (Diag2eData.D_F1A8[3]>>1) & 0x07;
        //תٺ
        g_RedArea                  = (Diag2eData.D_F1A8[3]>>4) & 0x0F;
        g_RedArea                  = 2400 + g_RedArea * 200;          //--//
        //ȼ
        ConfigItem.FuelConfig      = (Diag2eData.D_F1A8[4]>>5) & 0x03;       
        //ȴҺλ
        ConfigItem.CoolLevelConfig = (Diag2eData.D_F1A8[4]>>7) & 0x01;//--//
        //ƶϵͳ-EBD
        ConfigItem.ABS_ESCConfig   =  Diag2eData.D_F1A8[5]     & 0x03;
        //ȫ
        ConfigItem.AirBagConfig    = (Diag2eData.D_F1A8[5]>>2) & 0x01;
        //̥ѹ
        ConfigItem.TpmsConfig      = (Diag2eData.D_F1A8[5]>>4) & 0x03;//--// 
    }    
}
/*-------------------------------------------------------------------------
* Function Name  : App_2E_Write_handle
* Description    :
* Input          :
* Output         : None
* Return         : None
* onther         :
--------------------------------------------------------------------------*/
void App_2E_Write_handle(void)
{
    Diag2eData.bFlag=0x55;
    Diag2eData.bCheckSum = Api_CreateCRCCheckSum((INT8U*)&Diag2eData,sizeof(Diag2eData)-2);
    Write2EData();
}