/*
 * api_GpioMap.h
 *
 *  Created on: Aug 10, 2014
 *      Author: QTC
 */
 
#ifdef        GLOBALS_API_GPIOMAP
#define   EXTERN_API_GPIOMAP
#else
#define   EXTERN_API_GPIOMAP     extern
#endif

#ifndef API_GPIOMAP_H_
#define API_GPIOMAP_H_
/****************************************************************************************************************************************************
GPIOӳ
****************************************************************************************************************************************************/

/*===================================================================================================================================================
PORTA ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      |         ˿       |    |    |  ֵ    |  ˵
===================================================================================================================================================*/       
//#define     D0                          PORTA_PA0  	        // 87       OUT	    0                          
//#define     D1                          PORTA_PA1  	        // 88       OUT	    0                          
//#define     D2                          PORTA_PA2  	        // 89       OUT	    0                           
//#define     D3                          PORTA_PA3  	        // 90       OUT	    0                          
//#define     D4                          PORTA_PA4  	        // 91       OUT	    0                          
//#define     D5                          PORTA_PA5  	        // 92       OUT	    0                          
//#define     D6                          PORTA_PA6  	        // 93       OUT	    0                           
//#define     D7                          PORTA_PA7  	        // 94       OUT	    0                          

/*===================================================================================================================================================
PORTB ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ    |  ˵
===================================================================================================================================================*/
//#define     A0                        PORTB_PB0  	        // 86       OUT	    0                           
//#define     XRES                      PORTB_PB1  	        // 95       OUT	    0                           
//#define     XWR     		              PORTB_PB2           // 96       OUT	    0                           
//#define     XCS			                  PORTB_PB3           // 97       OUT     0                         
#define     LED_REAR_FOG_OUT            PORTB_PB4  	        // 100      OUT	    1                           
#define     LED_ECO_OUT                 PORTB_PB5  	        // 101      OUT	    1                           ECOָʾ
#define     LED_ESC_OUT                 PORTB_PB6  	        // 102      OUT	    1                           ESCָʾ
//#define     N.C.                      PORTB_PB7  	        // 103      OUT	    0                           

/*===================================================================================================================================================
PTT ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define   LINE_E_SPEED_PWM            PTT_PTT0             // 52       IN      0	  	   0             0     תƵӲ19
#define   LINE_IN_HOOVES              PTT_PTT1             // 53       IN      0	  	   0             0     Ƭĥ Ӳ 18
#define   LINE_IN_Power_takeoff       PTT_PTT2             // 54       IN      0	  	   0             0     ȡ Ӳ17
#define   LINE_IN_BRAKING             PTT_PTT3             // 55       IN      0	  	   0             0     ƶ Ӳ5
#define   LINE_IN_POSITION            PTT_PTT4             // 57       IN      0	  	   0             0     λõӲ Ӳ7 
#define   LINE_IN_LOW_BEAM            PTT_PTT5             // 58       IN      0	  	   0             0      Ӳ8
#define   LINE_IN_HIGH_BEAM           PTT_PTT6             // 59       IN      0	  	   0             0     Զ Ӳ9 
#define   LINE_IN_OILn                PTT_PTT7             // 60       IN      0	  	   0             0     ѹ Ӳ10

/*===================================================================================================================================================
PTS ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    pKeyMIn                    PTS_PTS0            // 39       IN       0	  	   0             0       ť  
#define    pKeyLIn                    PTS_PTS1            // 40       IN       0	  	   0             0       ť 
#define    LINE_IN_REARFOG            PTS_PTS2            // 43       IN       0	  	   0             0        Ӳ24  
#define    LINE_IN_FRONTFOG           PTS_PTS3            // 44       IN       0	  	   0             0       ǰ Ӳ23  
#define    pSTBOut                    PTS_PTS4            // 47       OUT      1	  	   0             0       CANSTB        
#define    pKeyRIn                    PTS_PTS5            // 48       IN       0	  	   0             0       ť   
//#define    N.C.                     PTS_PTS6            // 49       OUT      0	  	   0             0         
//#define    N.C.                     PTS_PTS7            // 50       OUT      0	  	   0             0         

/*===================================================================================================================================================
PTP ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/   
#define    LCD_BL_PWM                 PTP_PTP0            // 29       OUT     0        0             0         ̱PWM
#define    LED_BL_PWM                 PTP_PTP1            // 30       OUT     0        0             0         ҺPWM
//#define    SCL                      PTP_PTP2            // 31       OUT     0        0             0         EEPROM SCL
//#define    SDA                      PTP_PTP3            // 32       OUT     0        0             0         EEPROM SDA
#define    LINE_BUZZER                PTP_PTP4            // 33       OUT     1        0             0         
#define    LINE_BUZZER_PWM            PTP_PTP5            // 34       OUT     0        0             0         PWM
#define    LED_POSLAMP_G              PTP_PTP6            // 35       OUT     1        0             0         λõ
#define    LINE_IN_OPEN_DOORn         PTP_PTP7            // 36       IN      0        0             0         ſ Ӳ28

/*===================================================================================================================================================
PTH ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define     LINE_IN_WAITTOSTART       PTH_PTH0             // 63        IN      0	  	   0             0     Ԥָʾ Ӳ14       
#define     LED_LIFT_OUT              PTH_PTH1             // 64       OUT      1	  	   0             0     תָʾ      
#define     LINE_IN_RIGHT             PTH_PTH2             // 65        IN      0	  	   0             0     ת Ӳ32      
#define     LINE_IN_LIFT              PTH_PTH3             // 66        IN      0	  	   0             0     ת Ӳ31           
#define     LED_FRONTFOG_OUT          PTH_PTH4             // 75       OUT      1	  	   0             0     ǰ
#define     LED_LOWBEAM_OUT           PTH_PTH5             // 76       OUT      1	  	   0             0                   
#define     LED_HIGHBEAM_OUT          PTH_PTH6             // 83       OUT      1	  	   0             0     Զ      
//#define    N.C.                     PTH_PTH7             // 84       OUT      0	  	   0             0           

/*===================================================================================================================================================
PT1AD ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
===================================================================================================================================================*/
//#define  N.C.                       PT1AD_PT1AD0	       // 108      OUT	    0        0                         
#define  ADC_GAS2                     PT1AD_PT1AD1	       // 109      IN       0        0	            ѹ2     
#define  ADC_GAS1                  		PT1AD_PT1AD2         // 110      IN       0        0              ѹ1
#define  LINE_5V_OUT                  PT1AD_PT1AD3         // 111      OUT      1        0              5V
#define  LED_RIGHT_OUT                PT1AD_PT1AD4	       // 112      OUT      1        0              תָʾ
#define  LED_SafeBelt_OUT             PT1AD_PT1AD5         // 1        OUT      1        0              ݰȫָʾ
#define  ADC_FUEL                     PT1AD_PT1AD6         // 2        IN       0        0              ȼADɼ
#define  ADC_FUEL_KL                  PT1AD_PT1AD7         // 3        IN       1        0              ȼ͵Դɼ    
  
/*===================================================================================================================================================
PTR ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define	CAN1_RXD               			  PTR_PTR0             // 45       IN       0	  	   0             0          
#define	CAN1_TXD               		    PTR_PTR1             // 46       OUT      0	  	   0             0		
#define LINE_IN_CONTAINERn            PTR_PTR2             // 37       IN       0	  	   0             0       Ӳ27   
#define LINE_V_SPEED_PWM              PTR_PTR3             // 38       IN       0	  	   0             0      ƵPWM Ӳ30 
#define	LINE_IN_PARKING               PTR_PTR4             // 56       IN       0	  	   0             0      פƶ Ӳ6
#define	LINT_IN_SAFEBELTn             PTR_PTR5             // 61       IN       0	  	   0             0      ݰȫ Ӳ12
#define LINT_IN_OBDn                  PTR_PTR6             // 62       IN       0	  	   0             0			OBDӲ Ӳ13    
//#define XRD_MCU                     PTR_PTR7             // 85       OUT      0	  	   0             0          

/*===================================================================================================================================================
PTU ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
//#define    N.C                       PTU_PTU0            // 9        OUT      0         0             0       ZHS_COS- ٱ
//#define    N.C.                      PTU_PTU1            // 10       OUT      0         0             0       ZHS_COS+
//#define    N.C.                      PTU_PTU2            // 11       OUT      0         0             0       ZHS_SIN-
//#define    N.C.                      PTU_PTU3            // 12       OUT      0         0             0       ZHS_SIN+
//#define    N.C.                      PTU_PTU4            // 15       OUT      0         0             0       LCH_COS- תٱ
//#define    N.C.                      PTU_PTU5            // 16       OUT      0         0             0       LCH_COS+
//#define    N.C.                      PTU_PTU6            // 17       OUT      0         0             0       LCH_SIN-
//#define    N.C.                      PTU_PTU7            // 18       OUT      0         0             0       LCH_SIN+

/*===================================================================================================================================================
PTV ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    LCH_ZERO                  PTV_PTV0            // 19       IN       0        0             0      תٵ
#define  DB8379_SIN_P                PTV_PTV1            // 20       OUT      0        0             0
#define  DB8379_RST_P                PTV_PTV2            // 21       OUT      0        0             0
//#define  N.C.                      PTV_PTV3            // 22       OUT      0        0             0
#define  DB8379_OE_P                 PTV_PTV4            // 25       OUT      0        0             0
#define  DB8379_LE_P                 PTV_PTV5            // 26       OUT      0        0             0
#define  DB8379_CLK_P                PTV_PTV6            // 27       OUT      0        0             0
//#define  N.C.                      PTV_PTV7            // 28       OUT      0        0             0

/*===================================================================================================================================================
PTM ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  /  |  ˵
===================================================================================================================================================*/
#define    LED_EXCSysHighTemp_OUT      PTM_PTM0            // 69       OUT      1	  	   0             0         ϵͳ¶ȸָʾ
#define    LED_Power_TakeOFF_Out       PTM_PTM1            // 70       OUT      1	  	   0             0         ȡָʾ 
#define    LED_ESCOFF_OUT              PTM_PTM2            // 71       OUT      1	  	   0             0         ESCOFFָʾ   
//#define   N.C.                       PTM_PTM3            // 72       OUT      0	  	   0             0         MCU Ӳ10     

/*===================================================================================================================================================
PT0AD ˿
-----------------------------------------------------------------------------------------------------------------------------------------------------
         |                      | ˿                |    |    |  ֵ  |  ʹ  |  ˵
===================================================================================================================================================*/
#define      LINE_FUEL_5V_OUT          PT0AD_PT0AD0        // 4        OUT      1         0         ȼ͵Դ5V
#define      ADC_KL30                  PT0AD_PT0AD1        // 5        IN       0         0         IG-ON
#define      ADC_KL15                  PT0AD_PT0AD2        // 6        IN       0         0         
#define      ZHS_ZERO                  PT0AD_PT0AD3        // 7        IN       0         0         ٵ                 

/****************************************************************************************************************************************************

****************************************************************************************************************************************************/


#endif /* API_GPIOMAP_H_ */
