from flask import Flask, request, jsonify
import requests

app = Flask(__name__)

DEEPSEEK_API_KEY = "sk-54852946bf7d49e99b05250651327453"
DEEPSEEK_API_BASE = "https://api.deepseek.com/v1"

# OpenAI 的模型别名映射到 DeepSeek 模型
MODEL_MAP = {
    "gpt-3.5-turbo": "deepseek-chat",
    "gpt-4": "deepseek-coder"
}

@app.route("/v1/chat/completions", methods=["POST"])
def chat_completions():
    data = request.json.copy()
    model = data.get("model")

    # 替换成 DeepSeek 的真实模型名
    if model in MODEL_MAP:
        data["model"] = MODEL_MAP[model]

    headers = {
        "Authorization": f"Bearer {DEEPSEEK_API_KEY}",
        "Content-Type": "application/json"
    }
    resp = requests.post(
        f"{DEEPSEEK_API_BASE}/chat/completions",
        headers=headers,
        json=data
    )
    return jsonify(resp.json())

@app.route("/v1/models", methods=["GET"])
def models():
    # 伪装成支持 OpenAI 模型
    return jsonify({
        "object": "list",
        "data": [
            {"id": "gpt-3.5-turbo", "object": "model"},
            {"id": "gpt-4", "object": "model"}
        ]
    })

if __name__ == "__main__":
    app.run(host="127.0.0.1", port=8000)
