#include "AMT630H.h"
#include <stdint.h>
#include "UartProtocol.h"
#include "Components.h"
#include "PicBin.h"
#include "GpioUser.h"
//#include "AMT630H_Datas.h"
#define AMT630H_ERR_TIME            50000U
#define AMT630H_RELEASE_MODE        1U
void mwAmt630hUartRecvData(void);
#define UART2_BUF       0x1000U
unsigned int AMT630H_InitTime = 0;
uint8_t g_sysFlag_Lcdcheck = 0;
/* Initialization */
LCD_TFT_PARA_ST LcdSoundParamterData;
SOFTWARE_VERSION_ST amt630Version;
LCD_TFT_MIPI_PARA_ST g_LCD_TFT_MIPI_PARA_ST;
const uint8_t verify[48U] = {196u,203,149,157,48,48,49,86,
                             49,46,51,57,255,255,255,255,
                             50,46,48,48,255,255,255,255,
                             50,48,50,53,48,49,48,54,
                             0,0,0,0,0,0,0,0,
                             0,0,0,0,0,0,0,0};
RN6752_PARA_ST Rn6752InputType;
uint16_t  AMT630_CLK_TIME;
uint8_t Amt630hInitFinishFlag = 0;

uint32_t Amt630hInitTimerCnts = 0;
uint32_t Amt630hSequentialTimerCnts = 0;
uint32_t Amt630hFlashCheckTimerCnts = 0;
uint32_t Amt630hServiceTimerCnts = 0;


/* SOC Error */
uint16_t AMT630H_REQ_Time[ALIVE_COUNTER_TOTAL] = { 0 };
uint8_t AMT630H_Err = 0U;
uint8_t AMT630H_AliveCounter[ALIVE_COUNTER_TOTAL] = { 0 };
uint16_t AMT630H_CrcErrTime = 0;
uint32_t AMT630H_CrcErrCounter = 0;
uint8_t AMT630H_CrcErrMaxCounter = 0;

/* Flash Check */
#define  FLASH_CHECK_TIME_NUM       20000
s_AMT630H_FlashCheck_t AMT630H_FlashCheck;
/* Delay Time */
unsigned long Delay_Time = 0;
unsigned long Delay_Time_Set = 0;

/* Refresh Time */
unsigned long AMT630H_RefreshTime = 0;
static uint8_t AMT630H_Animation_Start = 0;
static uint8_t AMT630H_Animation_Finish = 0;
static uint16_t AMT630H_Animation_DispPic = 0;
static uint16_t AMT630H_Animation_RefreshTime = 0;
static uint16_t AMT630H_Animation_RefreshTime_default = 0;
// static const uint16_t BootAnimationList[AMT630H_ANIMATION_PIC_NUM] = {
//     0,
// };
void AMT630_CLK(void)
{
    // AMT630_CLK_TIME += 100;
    // if (AMT630_CLK_TIME <= 3000)
    // {
    //     PackedTransfer_SetTftIoMode(1);
    // }
    // else
    // {
    //     PackedTransfer_SetTftIoMode(0);
    //     if (AMT630_CLK_TIME == 6000)
    //         AMT630_CLK_TIME = 0u;
    // }
}

void AMT630H_Animation_PlayProc(uint16_t PicIndex)
{
    unsigned char *pBuf;
    uint32_t tmpLen = 0;
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0); 
    SetPageBackground(GRAPHICS_PAGE_0, PicIndex);
    PackedTransfer_Page();
  //  PackedTransfer_GetSwVer();

}
/* Timer */
void AMT630H_Timer(unsigned char Tms)
{
    unsigned char i = 0U;

    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_REQ_Time[i] < AMT630H_ERR_TIME)
        {
            AMT630H_REQ_Time[i] += Tms;
        }
    }
    if(AMT630H_RefreshTime < AMT630H_REFRESH_TIME)
    {
        AMT630H_RefreshTime += Tms;
    }
    if(Delay_Time < Delay_Time_Set)
    {
        Delay_Time += Tms;
    }
    if(AMT630H_InitTime < 5000)
    {
        AMT630H_InitTime += Tms;
    }
    if(AMT630H_Animation_Finish == 0)
    {
        if(AMT630H_Animation_RefreshTime < AMT630H_ANIMATION_TIME)
        {
            AMT630H_Animation_RefreshTime += Tms;
        }
    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
    }
}
void Delay_Time_Ctrl(unsigned long Tms)
{
    Delay_Time = 0;
    Delay_Time_Set = Tms;

    while(Delay_Time < Delay_Time_Set)
    {
        RTE_WDT_Clear();
    }

    Delay_Time = 0;
    Delay_Time_Set = 0;
}
void Delay_Time_Ctrl1(unsigned long Tms)
{
    Delay_Time = 0;
    Delay_Time_Set = Tms;

    while(Delay_Time < Delay_Time_Set)
    {
        RTE_WDT_Clear();
    }

    Delay_Time = 0;
    Delay_Time_Set = 0;
}
uint8_t UartRevBuff[0x1000] = { 0 };
uint8_t UartRevBuff1[UART2_BUF] = {0};
uint32_t UartLastCnt = 0;
uint32_t UartRevCnts = 0;
void Amt630hUartRecvData(uint16_t u16UARTData)
{
    UartRevBuff[UartRevCnts++] = (u16UARTData & 0xff);
    if (UartRevCnts >= 0x1000) 
    {
        UartRevCnts = 0;
    }
}

void AMT630H(void)
{
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_High);
    Gen_TimeDelay(50 , 1000);
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_Low);
    Gen_TimeDelay(120, 1000);
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_High);
}

void AMT630H_RstCtrl(void)
{
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, GpioOut_High);  
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);//630
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 0);//630
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 1);
    RTE_GPIO_Set_Level(ABS_Faulty_lights, 1);//630   
    Delay_Time_Ctrl(15);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 1);
    RTE_GPIO_Config(RTE_GPIO_PORT13_PIN00, GpioOut_High);//燃油水温切电使能
    Delay_Time_Ctrl(20);
   
}

void Amt630hInit(void)
{
    uint8_t i = 0;
    AMT630H_RstCtrl();
    AMT630H();
    Delay_Time_Ctrl(100);
    // RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);  
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, RTE_GPIO_DIR_IN); 
    Delay_Time_Ctrl(20); 
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_Low); 
    Delay_Time_Ctrl(20); 
    RTE_GPIO_Set_Level(ABS_Faulty_lights, 0);//1.8vEN
    // RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);
    Delay_Time_Ctrl(100);
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, GpioOut_High);  
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 1);
    RTE_GPIO_Set_Level(ABS_Faulty_lights, 1);//630   
    Delay_Time_Ctrl(15);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 1);
    Delay_Time_Ctrl(20);
    AMT630H();
    AMT630_CLK_TIME = 0u;
    AMT630H_RefreshTime = AMT630H_REFRESH_TIME;
    // Error State Init
    AMT630H_Err = 0U;
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        AMT630H_REQ_Time[i] = 0U;
        AMT630H_AliveCounter[i] = 0;
    }
    AMT630H_CrcErrTime = 0;
    AMT630H_CrcErrCounter = 0;

    // Param Config
    LcdSoundParamterData.LcdWidth = 320;
    LcdSoundParamterData.LcdHeight = 1280;
    LcdSoundParamterData.LcdBpp = 32;
    LcdSoundParamterData.LcdInterfaceType = LCD_INTERFACE_MIPI;
    LcdSoundParamterData.LcdWiringMode = LCD_WIRING_MODE_RGB;
    LcdSoundParamterData.LcdWiringBitOrder = LCD_WIRING_BIT_ORDER_MSB;
    g_LCD_TFT_MIPI_PARA_ST.MipiLane = 3;
    g_LCD_TFT_MIPI_PARA_ST.MipiDisplaymMode = 0;
    LcdSoundParamterData.LcdTimingVBP = 12;
    LcdSoundParamterData.LcdTimingVFP = 16;
    LcdSoundParamterData.LcdTimingVSW = 2;
    LcdSoundParamterData.LcdTimingHBP = 50;
    LcdSoundParamterData.LcdTimingHFP = 50;
    LcdSoundParamterData.LcdTimingHSW = 24;
    LcdSoundParamterData.LcdClkFreq = 26200000;
    g_LCD_TFT_MIPI_PARA_ST.MipiNpPolarityInverse = 0;
    g_LCD_TFT_MIPI_PARA_ST.MipiClkFreq = 280000000;

    // LcdSoundParamterData.LcdWidth = 1024;
    // LcdSoundParamterData.LcdHeight = 600;
    // LcdSoundParamterData.LcdBpp = 32;
    // LcdSoundParamterData.LcdVideoInputValid = 0;
    // LcdSoundParamterData.Ark7116ResetPin = 0;
    // LcdSoundParamterData.LcdInterfaceType = LCD_INTERFACE_LVDS;
    // LcdSoundParamterData.LcdWiringMode = LCD_WIRING_MODE_BGR;
    // LcdSoundParamterData.LcdWiringBitOrder = LCD_WIRING_BIT_ORDER_MSB;
    // LcdSoundParamterData.LcdDotClkReverse = 0;  /* NuoMa 50pin TFT */
    // LcdSoundParamterData.LvdsPanelFormat = LVDS_PANEL_FORMAT_TI;
    // LcdSoundParamterData.LvdsPanelData = LVDS_PANEL_DATA_8BIT;

    // LcdSoundParamterData.LcdTimingVBP = 12;
    // LcdSoundParamterData.LcdTimingVFP = 20;
    // LcdSoundParamterData.LcdTimingVSW = 4;

    // LcdSoundParamterData.LcdTimingHBP = 160;
    // LcdSoundParamterData.LcdTimingHFP = 160;
    // LcdSoundParamterData.LcdTimingHSW = 24;

    // LcdSoundParamterData.LcdClkFreq = 51200000;

    // LcdSoundParamterData.SoundChannelNum = 0;
    // LcdSoundParamterData.SoundFreq = AUDIO_FREQ_48K;
    SetLcdParameter(&LcdSoundParamterData,&g_LCD_TFT_MIPI_PARA_ST,AMT630_UART3,&Rn6752InputType);
    SetSwVerBuf((uint8_t*)&amt630Version);

    User_PicIndexDataInit();
    ResetInitedState();    

    AnalysisUartData();

    AMT630H_InitTime = 0;

    AMT630H_Animation_Start = 0;
    AMT630H_Animation_Finish = 0;
    AMT630H_Animation_DispPic = 0;
    AMT630H_Animation_RefreshTime = 0;
    AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);

    Amt630hInitFinishFlag = 0;

    AMT630H_FlashCheck.Flag = 0;
    AMT630H_FlashCheck.InquireTime = 0;
    AMT630H_FlashCheck.CheckStateTime = 0;
    AMT630H_FlashCheck.Result = 0;
}
void AMT630H_Sleep12(void)
{
    if (Get_Abnormal_voltage_condition() != 1u)
    {
        if (Common_GetIgnOffTime() > 2000)
        {
            PackedTransfer_SetTftIoMode(0);
        }
        else
        {

            if (Common_GetIgnOnTimeL() > 1000)
            {
                PackedTransfer_SetTftIoMode(1);
            }
            // else
            // {
            //     PackedTransfer_SetTftIoMode(0);
            // }
        }
    }
}

void AMT630H_Sleep(void)
{
    // RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);  
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, RTE_GPIO_DIR_IN); 
    Delay_Time_Ctrl(20); 
    RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_Low); 
    Delay_Time_Ctrl(20); 
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);
    RTE_GPIO_Config(RTE_GPIO_PORT04_PIN03, RTE_GPIO_DIR_IN);//VCC1V2_AMT_EN(630H电源)
    RTE_GPIO_Config(RTE_GPIO_PORT13_PIN00, RTE_GPIO_DIR_IN);//燃油水温切电使能
    RTE_GPIO_Set_Level(ABS_Faulty_lights, 0);//1.8vEN
    // RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);
     
}
static void AMT630H_AliveCounterMonitor(void)
{
    uint8_t i = 0;
    if(AMT630H_CrcErrCounter != GetCrcErrCnts())
    {
        AMT630H_CrcErrCounter = GetCrcErrCnts();
        AMT630H_CrcErrTime++;
        if(AMT630H_CrcErrTime >= 120)
        {
            // AMT630H_Err = 1;
        }
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0;
        }
    }
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_AliveCounter[i] != GetAliveCounter(i))
        {
            AMT630H_AliveCounter[i] = GetAliveCounter(i);
            AMT630H_REQ_Time[i] = 0;
            if(AMT630H_CrcErrMaxCounter < AMT630H_CrcErrTime)
            {
                AMT630H_CrcErrMaxCounter = (unsigned char)AMT630H_CrcErrTime;
            }
            AMT630H_CrcErrTime = 0;
        }
        if(AMT630H_REQ_Time[i] >= AMT630H_ERR_TIME)
        {
            AMT630H_Err = 1;
        }
    }
}

void AMT630H_Main(void)
{
    unsigned char i;
    AnalysisUartData();
    mwAmt630hUartRecvData();
    // SetSwVerBuf(amt630Version);
    if(GetLcdInitSt() != 1)
    {
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0U;           
        }
        return;
    }
    // Get_RESET();
    AMT630H_AliveCounterMonitor();
    if(AMT630H_Err == 1U)
    {
        AMT630H_Err = 0;
        Amt630hInit();
        AMT630H_Animation_Finish = 1;
        return;
    }
    if(g_sysFlag_Lcdcheck == 1)
    {
        if(AMT630H_FlashCheck.Flag == 0)
        {
            AMT630H_FlashCheck.Flag = 1;
            AMT630H_FlashCheck.InquireTime = 0;
            AMT630H_FlashCheck.CheckStateTime = 0;
            PackedTransfer_CheckFlash();           
            AMT630H_FlashCheck.Result = 0xFF;
        }
        if(AMT630H_FlashCheck.Flag == 1)
        {
            // if(AMT630H_FlashCheck.InquireTime >= 100)
            {
                AMT630H_FlashCheck.InquireTime = 0;
                AMT630H_FlashCheck.Result = PackedTransfer_CheckFlashGetResult();
                if(AMT630H_FlashCheck.Result != 0xFF)
                {
                    if(AMT630H_FlashCheck.Result == 1)
                    {
                        // PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_PASS, 3000);
                        AMT630H_FlashCheck.Flag = 3;
                    }
                    else if (AMT630H_FlashCheck.CheckStateTime >= FLASH_CHECK_TIME_NUM)
                    {
                        // PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_FAIL, 60000);
                        AMT630H_FlashCheck.Flag = 2;
                    }
                }
                
            }
            // else
            // {
            //     PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECKING, 60000);
            // }
        }
    }
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(1)
        {
            AMT630H_Animation_RefreshTime = 0;
            if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
            {                
                AMT630H_RefreshTime = 0;
                AMT630H_GUI_DisplayProc();
                //SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);
                //SetPageBackground( GRAPHICS_PAGE_0, Pic_0001_0_0 );
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0002_751_440);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0003_681_441);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0005_521_444);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0010_90_443);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0012_0_95);
                //PackedTransfer_Page();
            }
        }
        else
        {
            // AMT630H_RefreshTime = 0;
            // if(AMT630H_Animation_Start == 0)
            // {
            //     AMT630H_Animation_Start = 1;                
            //     AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);
            // }
            // if(AMT630H_Animation_RefreshTime >= AMT630H_Animation_RefreshTime_default)
            // {
            //     AMT630H_Animation_RefreshTime = 0;
            //     AMT630H_Animation_PlayProc(BootAnimationList[AMT630H_Animation_DispPic]);
            //     AMT630H_Animation_DispPic++;
            //     if(AMT630H_Animation_DispPic >= AMT630H_ANIMATION_PIC_NUM)
            //     {
            //         AMT630H_Animation_Finish = 1;
            //     }
            // }
        } 
        

    }
    else
    {

        AMT630H_Animation_RefreshTime = 0;
        if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
        {
            AMT630H_RefreshTime = 0;
            AnalysisUartData();
            SetPageGuid(GRAPHICS_PAGE_0, 5, 2, 0);
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0002_0_0);
            PackedTransfer_Page();
            // AMT630H_GUI_DisplayProc();
        }
    }
}

unsigned char AMT630H_isInitFinish(void)
{
    if((AMT630H_InitTime >= 600) || (GetLcdInitSt() == 1))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

uint8_t rx_flag = 0;
void mwAmt630hUartRecvData(void)
{
    
    uint32_t rxCnt = 0;
    uint32_t tmpCnt = 0;
    uint8_t overFlowFlag = 0;
    
    rxCnt = DMAVEC->CTRL[4].DMRLD - DMAVEC->CTRL[4].DMACT;// accumulate receive Counts 

    if (rxCnt != UartLastCnt)
    {
        rx_flag = 1;
        if (rxCnt > UartLastCnt)
        {
            tmpCnt = rxCnt - UartLastCnt;
        }
        else 
        {
            tmpCnt = UART2_BUF - UartLastCnt;
            overFlowFlag = 1;
        }

        UartLastCnt = rxCnt;

    }

    if (rx_flag == 1)
    {
        if (overFlowFlag == 0)
        {
            memcpy(&UartRevBuff[UartRevCnts],&UartRevBuff1[UartRevCnts],tmpCnt);
            UartRevCnts += tmpCnt;
            if (UartRevCnts >= UART2_BUF)
            {   
                UartRevCnts = 0;
            }
        }
        else 
        {
            memcpy(&UartRevBuff[UartRevCnts],&UartRevBuff1[UartRevCnts],tmpCnt);
            UartRevCnts = 0;
            memcpy(&UartRevBuff[UartRevCnts],&UartRevBuff1[UartRevCnts],rxCnt);
            overFlowFlag = 0;
            UartRevCnts += rxCnt;
        }
        rx_flag = 0;
    }

    

}
