#include "Components.h"
#include "UartProtocol.h"
#include "PicBin.h"
#include "Telltales_user.h"
#include "Display.h"
#include "PowerManagement\PowerManag_user.h"
#define NO_PIC 0XFFFFU

uint32_t Uptime = 0u; /*开机时间*/
uint8_t Uptime_Staus = 0u; /*开机时间结束标志位*/
extern uint16_t Disp_Valid;
extern uint8_t Old_Staus;
uint16_t Stime = 0u;
uint16_t Vtime = 0u;
uint32_t DispVechileSpeed = 0u;
extern uint8_t                g_sysFlag_Lcdcheck;
extern s_AMT630H_FlashCheck_t AMT630H_FlashCheck;
uint32_t                       Color_Timer       = 0U;
uint8_t                       Color_State       = 0U;

static const uint32_t StartUp_Animation_Array[40u] = {Pic_0413_0_0,Pic_0412_0_0,Pic_0410_0_0,Pic_0410_0_0,Pic_0409_0_0,Pic_0408_0_0,Pic_0407_0_0,Pic_0406_0_0,Pic_0405_0_0,Pic_0404_0_0,Pic_0403_0_0,Pic_0402_0_0,Pic_0401_0_0,Pic_0400_0_0,Pic_0399_0_0,Pic_0398_0_0,
                                                      Pic_0397_0_0,Pic_0396_0_0,Pic_0395_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,
                                                      Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0,Pic_0394_0_0};


/*转速表盘序列帧图片*/
static const uint32_t Rotate_Speed[201u] = {Pic_0254_1_448, Pic_0253_1_448, Pic_0252_1_448, Pic_0251_1_448, Pic_0250_1_448, Pic_0249_1_448, Pic_0248_1_448, Pic_0247_1_448, Pic_0246_1_448, Pic_0245_1_448, Pic_0244_1_448, Pic_0243_1_448, Pic_0242_1_448, Pic_0241_1_448, Pic_0240_1_448,
                                            Pic_0239_1_448, Pic_0238_1_448, Pic_0237_1_448, Pic_0236_1_448, Pic_0235_1_448, Pic_0234_1_448, Pic_0233_1_448, Pic_0232_1_448, Pic_0231_1_448, Pic_0230_1_448, Pic_0229_1_448, Pic_0228_1_448, Pic_0227_1_448, Pic_0226_1_448, Pic_0225_1_448,
                                            Pic_0224_1_448, Pic_0223_1_448, Pic_0222_1_448, Pic_0221_1_448, Pic_0220_1_448, Pic_0219_1_448, Pic_0218_1_448, Pic_0217_1_448, Pic_0216_1_448, Pic_0215_1_448, Pic_0214_1_448, Pic_0213_1_448, Pic_0212_1_448, Pic_0211_1_448, Pic_0210_1_448,
                                            Pic_0209_1_448, Pic_0208_1_448, Pic_0207_1_448, Pic_0206_1_448, Pic_0205_1_448, Pic_0204_1_448, Pic_0203_1_448, Pic_0202_1_448, Pic_0201_1_448, Pic_0200_1_448, Pic_0199_1_448, Pic_0198_1_448, Pic_0197_1_448, Pic_0196_1_448, Pic_0195_1_448,
                                            Pic_0194_1_448, Pic_0193_1_448, Pic_0192_1_448, Pic_0191_1_448, Pic_0190_1_448, Pic_0189_1_448, Pic_0188_1_448, Pic_0187_1_448, Pic_0186_1_448, Pic_0185_1_448, Pic_0184_1_448, Pic_0183_1_448, Pic_0182_1_448, Pic_0181_1_448, Pic_0180_1_448,
                                            Pic_0179_1_448, Pic_0178_1_448, Pic_0177_1_448, Pic_0176_1_448, Pic_0175_1_448, Pic_0174_1_448, Pic_0173_1_448, Pic_0172_1_448, Pic_0171_1_448, Pic_0170_1_448, Pic_0169_1_448, Pic_0168_1_448, Pic_0167_1_448, Pic_0166_1_448, Pic_0165_1_448,
                                            Pic_0164_1_448, Pic_0163_1_448, Pic_0162_1_448, Pic_0161_1_448, Pic_0160_1_448, Pic_0159_1_448, Pic_0158_1_448, Pic_0157_1_448, Pic_0156_1_448, Pic_0155_1_448, Pic_0154_1_448, Pic_0153_1_448, Pic_0152_1_448, Pic_0151_1_448, Pic_0150_1_448,
                                            Pic_0149_1_448, Pic_0148_1_448, Pic_0147_1_448, Pic_0146_1_448, Pic_0145_1_448, Pic_0144_1_448, Pic_0143_1_448, Pic_0142_1_448, Pic_0141_1_448, Pic_0140_1_448, Pic_0139_1_448, Pic_0138_1_448, Pic_0137_1_448, Pic_0136_1_448, Pic_0135_1_448,
                                            Pic_0134_1_448, Pic_0133_1_448, Pic_0132_1_448, Pic_0131_1_448, Pic_0130_1_448, Pic_0129_1_448, Pic_0128_1_448, Pic_0127_1_448, Pic_0126_1_448, Pic_0125_1_448, Pic_0124_1_448, Pic_0123_1_448, Pic_0122_1_448, Pic_0121_1_448, Pic_0120_1_448,
                                            Pic_0119_1_448, Pic_0118_1_448, Pic_0117_1_448, Pic_0116_1_448, Pic_0115_1_448, Pic_0114_1_448, Pic_0113_1_448, Pic_0112_1_448, Pic_0111_1_448, Pic_0110_1_448, Pic_0109_1_448, Pic_0108_1_448, Pic_0107_1_448, Pic_0106_1_448, Pic_0105_1_448,
                                            Pic_0104_1_448, Pic_0103_1_448, Pic_0102_1_448, Pic_0101_1_448, Pic_0100_1_448, Pic_0099_1_448, Pic_0098_1_448, Pic_0097_1_448, Pic_0096_1_448, Pic_0095_1_448, Pic_0094_1_448, Pic_0093_1_448, Pic_0092_1_448, Pic_0091_1_448, Pic_0090_1_448,
                                            Pic_0089_1_448, Pic_0088_1_448, Pic_0087_1_448, Pic_0086_1_448, Pic_0085_1_448, Pic_0084_1_448, Pic_0083_1_448, Pic_0082_1_448, Pic_0081_1_448, Pic_0080_1_448, Pic_0079_1_448, Pic_0078_1_448, Pic_0077_1_448, Pic_0076_1_448, Pic_0075_1_448,
                                            Pic_0074_1_448, Pic_0073_1_448, Pic_0072_1_448, Pic_0071_1_448, Pic_0070_1_448, Pic_0069_1_448, Pic_0068_1_448, Pic_0067_1_448, Pic_0066_1_448, Pic_0065_1_448, Pic_0064_1_448, Pic_0063_1_448, Pic_0062_1_448, Pic_0061_1_448, Pic_0060_1_448,
                                            Pic_0059_1_448, Pic_0058_1_448, Pic_0057_1_448, Pic_0056_1_448, Pic_0055_1_448, Pic_0054_1_448};

/*车速数字*/
static const uint16_t DS_Figure[10u] = {Pic_0255_85_619, Pic_0256_86_621, Pic_0257_86_619, Pic_0258_85_619, Pic_0259_86_617, Pic_0260_85_619, Pic_0261_85_619, Pic_0262_86_619, Pic_0263_85_619, Pic_0264_86_619};

/*水温表格*/
static const uint16_t Water_Temperature[10u] = {Pic_0039_0_795, Pic_0038_0_880, Pic_0037_0_888, Pic_0036_0_896, Pic_0035_0_904, Pic_0034_0_911, Pic_0033_0_919, Pic_0032_0_928, Pic_0030_0_936,NO_PIC};

/*水温数字*/
static const uint16_t WT_Figure[10u] = {Pic_0042_2_845, Pic_0043_2_845, Pic_0044_2_845, Pic_0045_2_845, Pic_0046_2_844, Pic_0047_2_845, Pic_0048_2_845, Pic_0049_2_845, Pic_0050_2_845, Pic_0051_2_845};

/*燃油表格*/
static const uint16_t Fuel_Oil[10u] = {Pic_0013_0_409, Pic_0012_0_382, Pic_0011_0_374, Pic_0010_0_364, Pic_0009_0_358, Pic_0008_0_350, Pic_0007_0_341, Pic_0006_0_334, Pic_0005_0_324, Pic_0004_0_312};

/*燃油表格开路*/
static const uint16_t F_Fuel_Oil[9u] = {Pic_0012_0_382, Pic_0011_0_374, Pic_0010_0_364, Pic_0009_0_358, Pic_0008_0_350, Pic_0007_0_341, Pic_0006_0_334, Pic_0005_0_324, Pic_0004_0_312};

/*燃油数字*/
static const uint16_t F_Figure[10u] = {Pic_0017_2_430, Pic_0018_2_431, Pic_0019_2_430, Pic_0020_2_430, Pic_0021_2_430, Pic_0022_2_430, Pic_0023_2_430, Pic_0024_2_430, Pic_0025_2_430, Pic_0026_2_430};

/*电压数字*/
static const uint16_t V_Figure[10u] = {Pic_0277_296_1163, Pic_0279_296_1164, Pic_0280_296_1163, Pic_0281_296_1164, Pic_0282_296_1163, Pic_0283_296_1164, Pic_0284_296_1163, Pic_0285_296_1163, Pic_0286_296_1163, Pic_0287_296_1163};

/*时间数字*/
static const uint16_t T_Figure[10u] = {Pic_0277_6_1195, Pic_0279_6_1196, Pic_0280_6_1195, Pic_0281_6_1196, Pic_0282_6_1195, Pic_0283_6_1196, Pic_0284_6_1195, Pic_0285_6_1195, Pic_0286_6_1195, Pic_0287_6_1195};

/*里程数字*/
static const uint16_t OT_Figure[10u] = {Pic_0277_6_96, Pic_0279_6_97, Pic_0280_6_96, Pic_0281_6_97, Pic_0282_6_96, Pic_0283_6_97, Pic_0284_6_96, Pic_0285_6_96, Pic_0286_6_96, Pic_0287_6_96};

/*上行驶模式*/
static const uint16_t A_Driving_Mode[3u] = {Pic_0295_214_870, Pic_0294_214_870, Pic_0293_214_870};

/*中行驶模式*/
static const uint16_t M_Driving_Mode[3u] = {Pic_0299_125_824, Pic_0300_125_819, Pic_0301_125_801};

/*下行驶模式*/
static const uint16_t U_Driving_Mode[3u] = {Pic_0298_77_866, Pic_0296_77_867, Pic_0297_77_867};

/*轮胎选择模式*/
static const uint16_t T_Dis_Sizes[4u] = {Pic_0359_147_972, Pic_0359_113_972, Pic_0359_79_972, Pic_0359_45_972};

/*左侧档位*/
static const uint16_t L_Tap_Position[5u] = {Pic_0273_120_114, Pic_0275_120_116, Pic_0271_120_117, Pic_0272_120_115,Pic_0274_120_115 };

/*中间档位*/
static const uint16_t M_Tap_Position[5u] = {Pic_0268_19_157, Pic_0267_6_152, Pic_0270_21_166, Pic_0269_19_157, Pic_0266_19_157};

/*右侧档位*/
static const uint16_t R_Tap_Position[5u] = {Pic_0273_120_330,Pic_0275_120_332, Pic_0271_120_333, Pic_0272_120_331,Pic_0274_120_331 };

/*自扫*/
static const uint16_t Self_Scanning[5u] = {Pic_0002_0_0,Pic_0414_0_0, Pic_0415_0_0, Pic_0416_0_0, Pic_0417_0_0};
void AMT630H_GUI_ReadPosittion_Display(void);
void AMT630H_GUI_BACKGRAND(void);

void AMT630H_GUI_DisplayProc(void)
{
    AnalysisUartData();
    SetPageGuid(GRAPHICS_PAGE_0, 5, 2, 0);
    if(Get_Dis_Old_Staus() == 3)
    {
        Uptime = 40u;
    }
    if(Get_Dis_Old_Staus() == 4)
    {
        Uptime = 0u;
        Old_Staus = 5u;
    }
    if (Get_Voltage_Anomaly() == 2)
    {
        Uptime = 40u;
    }
    if (Uptime < 40u)
    {
        // AnalysisUartData();
        // SetPageGuid(GRAPHICS_PAGE_0, 5, 2, 0);
        SetPageBackground(GRAPHICS_PAGE_0, (uint16_t)StartUp_Animation_Array[Uptime]);
        Uptime++;

        Uptime_Staus = 0u;
    }

    if (Uptime >= 40)
    {
        Uptime_Staus = 1u;
        if(Common_GetIgnOnTime() > 2000)
        {
            Disp_Valid = 0u;
        }
        else
        {
            Disp_Valid = 1u;
        }
        AMT630H_GUI_Background();  
    }

    PackedTransfer_Page();
}

void AMT630H_GUI_Background()
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        // if (Uptime <= 400u)
        // {
        //     Uptime++;
        //     SetPageBackground(GRAPHICS_PAGE_0, StartUp_Animation_Array[Uptime / 10u]);
        // }else
        // {
            AMT630H_GUI_ReadPosittion_Display();

        // }  
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_0);
    }
}

/*背景显示函数*/
void AMT630H_GUI_BACKGRAND()
{

    SetPageBackground(GRAPHICS_PAGE_0, Pic_0001_0_0);
    

    
    SetPagePic(GRAPHICS_PAGE_0, Pic_0292_0_849);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0304_116_1075);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0305_76_1161);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0306_60_921);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0307_13_1001);
    
    // SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_406);
}

/*指示灯显示*/
static void AMT630H_GUI_Light()
{
    if (LED_Turn_Left_Judgement() == 1) // 左转灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0368_44_431);
    }
    if (LED_Turn_Right_Judgement() == 1) // 右转灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0369_45_816);
    }
    if (Get_TelltalesLedSts(em_LED_High_Beam)) // 远光灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0370_265_244);
    }
    if (Get_TelltalesLedSts(em_LED_Dipped_Head_Light)) // 近光灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0371_264_286);
    }
    if (Get_TelltalesLedSts(em_LED_Efi_Faul)) // 电喷故障灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0373_265_377);
    }
    if (Get_TelltalesLedSts(em_LED_ABS)) // ABS
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0374_262_429);
    }
    if (Get_TelltalesLedSts(em_LED_Oil_Pressure_Alert)) // 机油报警灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0375_267_476);
    }
    if (Get_TelltalesLedSts(em_LED_Hand_Brake) == 1) // 手刹车指示灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0378_262_824);
    } 
    else if (Get_TelltalesLedSts(em_LED_Hand_Brake) == 2)
    {
        if (FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0378_262_824);
        }
    }
    if (Get_TelltalesLedSts(em_LED_Battery_Voltage)) // 电池电压指示灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0376_265_780);
    }
    if (Get_TelltalesLedSts(em_LED_Fuel_Level_Low) == 1) // 燃油液位指示灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0387_233_462);
    }
    else if (Get_TelltalesLedSts(em_LED_Fuel_Level_Low) == 2)
    {
        if (FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0387_233_462);
        }
    }
    if (Get_TelltalesLedSts(em_LED_Coolant_Temperature) == 1) // 水温报警灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0388_234_789);
    }
    else if (Get_TelltalesLedSts(em_LED_Coolant_Temperature) == 2)
    {
        if (FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0388_234_789);
        }
    }
    if (Get_TelltalesLedSts(em_LED_Safety_Belt) == 1) // 安全带未系
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_260_965);
    }
    else if (Get_TelltalesLedSts(em_LED_Safety_Belt) == 2)
    {
        if (FLASH_SYNC_1Hz)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0381_260_965);
        }
    }
     if (Get_TelltalesLedSts(em_LED_Width_Lamp)) // 示宽灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0372_265_329);
    }
    if (Get_TelltalesLedSts(em_LED_OPC)) // OPC指示灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0379_265_868);
    }
    if (Get_TelltalesLedSts(em_LED_EPS)) // EPS故障灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_263_914);
    }
    if (Get_TelltalesLedSts(em_LED_Booster_Switch)) // 加力开关
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0382_261_1005);
    }
    if (Get_TelltalesLedSts(em_LED_Brake_Level)) // 制动液位
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0383_228_419);
    }
    if (Get_TelltalesLedSts(em_LED_Turtle_Lamp)) // 乌龟灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0385_202_805);
    }
    if (Get_TelltalesLedSts(em_LED_Maintain)) // 维修灯
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0384_203_443);
    }
    if (Get_TelltalesLedSts(em_LED_Speed_Limit_Icon)) // 限速图标
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0386_227_829);
    }
    if (Get_TelltalesLedSts(em_LED_Display_Drive) == 3) // 二驱
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
    }
    else if (Get_TelltalesLedSts(em_LED_Display_Drive) == 2) // 二驱后锁死
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_83_989);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_133_978);
    }
    else if (Get_TelltalesLedSts(em_LED_Display_Drive) == 1) // 四驱
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0308_116_1075);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0309_76_1161);
    }
    else if (Get_TelltalesLedSts(em_LED_Display_Drive) == 4) // 四驱后锁死
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0308_116_1075);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0309_76_1161);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_83_989);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_133_978);
    }
    else if (Get_TelltalesLedSts(em_LED_Display_Drive) == 5) // 四驱前锁死
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0308_116_1075);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0309_76_1161);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0317_140_1136);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0319_187_1126);
    }
    else if (Get_TelltalesLedSts(em_LED_Display_Drive) == 6) // 四驱锁死
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0308_116_1075);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0309_76_1161);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0317_140_1136);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0319_187_1126);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_83_989);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_133_978);
    }
}

/*车速显示*/
void AMT630H_GUI_Car_Speed()
{

    uint32_t DS_HundredsPlace = 0u;
    uint32_t DS_TensPlace = 0u;
    uint32_t DS_UnitsPlace = 0u;
    if (Get_Self() == 1)
    {
        DispVechileSpeed = Get_DispVechileSpeed();
    }
    else
    {
        if (Vtime >= 4u)
        {
            DispVechileSpeed = Get_DispVechileSpeed();
            Vtime = 0u;
        }else
        {
            Vtime++;
        }

    }
    
    

    // 计算百位、十位和个位
    DS_HundredsPlace = (DispVechileSpeed / 1000u) % 10u;
    DS_TensPlace = (DispVechileSpeed / 100u) % 10u;
    DS_UnitsPlace = (DispVechileSpeed / 10u) % 10u;

    if (DispVechileSpeed < 100u)
    {
        // 1位数车速
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_UnitsPlace], 85u, 619u);
    }
    else if (DispVechileSpeed < 1000u)
    {
        // 2位数车速
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_TensPlace], 85u, 597u);
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_UnitsPlace], 85u, 641u);
    }
    else if (DispVechileSpeed <= 1990u)
    {
        // 3位数车速
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_HundredsPlace], 86u, 582u);
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_TensPlace],85u,616u);
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[DS_UnitsPlace], 85u, 660u);
    }
    else
    {
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[1], 86u, 582u);
        SetPagePic(GRAPHICS_PAGE_0, DS_Figure[9]);
        SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[9], 85u, 660u);
    }
}
/*转速显示函数*/
static void AMT630H_GUI_ESpeed()
{
    uint32_t DispEngineSpeed = 0u;
    DispEngineSpeed = (Get_DispEngineSpeed() / 50u);
    if(DispEngineSpeed > 200)
    {
        DispEngineSpeed = 200u;
    }
    SetPagePic(GRAPHICS_PAGE_0, (uint16_t)Rotate_Speed[DispEngineSpeed]);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0418_9_522);
}

/*单位切换*/
void AMT630H_GUI_Dis_Unit()
{
    if (Get_Self() == 1)
    {
        // if (Get_Dis_Unit())
        // {
            // SetPagePic(GRAPHICS_PAGE_0, Pic_0393_175_625);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0392_179_622);

        // }
    }else
    {
        if (Get_Dis_Unit())
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0391_6_107);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0393_175_625);
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0289_6_107);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0392_179_622);
    }

    }
    
    
}

/*档位显示函数*/
void AMT630H_GUI_Tap_Position()
{
    uint16_t Tap_Position = 0u;
    Tap_Position = Get_TelltalesLedSts(em_LED_Tap_Position);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0276_244_225);
    if (Get_Self() == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, M_Tap_Position[0]);
        SetPagePic(GRAPHICS_PAGE_0, L_Tap_Position[4]);
        SetPagePic(GRAPHICS_PAGE_0, R_Tap_Position[1]);
    }
    else
    {
        if (Tap_Position == 1)
        {
            SetPagePic(GRAPHICS_PAGE_0, M_Tap_Position[Tap_Position - 1]);
            SetPagePic(GRAPHICS_PAGE_0, L_Tap_Position[4]);
            SetPagePic(GRAPHICS_PAGE_0, R_Tap_Position[Tap_Position]);
        }
        else if (Tap_Position == 5)
        {
            SetPagePic(GRAPHICS_PAGE_0, M_Tap_Position[Tap_Position - 1]);
            SetPagePic(GRAPHICS_PAGE_0, L_Tap_Position[Tap_Position - 2]);
            SetPagePic(GRAPHICS_PAGE_0, R_Tap_Position[0]);
        }
        else if ((Tap_Position >= 2) && (Tap_Position <= 4))
        {
            SetPagePic(GRAPHICS_PAGE_0, M_Tap_Position[Tap_Position - 1]);
            SetPagePic(GRAPHICS_PAGE_0, L_Tap_Position[Tap_Position - 2]);
            SetPagePic(GRAPHICS_PAGE_0, R_Tap_Position[Tap_Position]);
        }
    }
}

/*里程函数*/
void AMT630H_ODO_Trip_Value()
{
    uint32_t ODO = Get_ODO_Value();   // 总计
    uint32_t Trip = Get_Trip_Value(); // 小计
    uint16_t O_H_ThousandsPlace = 0;
    uint16_t O_T_ThousandsPlace = 0;
    uint16_t O_ThousandsPlace = 0;
    uint16_t O_HundredsPlace = 0;
    uint16_t O_TensPlace = 0;
    uint16_t O_UnitsPlace = 0;
    uint16_t O_DecimalPlace = 0;
    uint16_t T_HundredsPlace = 0;
    uint16_t T_TensPlace = 0;
    uint16_t T_UnitsPlace = 0;
    uint16_t T_DecimalPlace = 0;
    O_H_ThousandsPlace = (uint16_t)((ODO / 1000000u) % 10);
    O_T_ThousandsPlace = (uint16_t)((ODO / 100000u) % 10u);
    O_ThousandsPlace = (uint16_t)((ODO / 10000u) % 10u);
    O_HundredsPlace = (uint16_t)((ODO / 1000u) % 10u);
    O_TensPlace = (uint16_t)((ODO / 100u) % 10u);
    O_UnitsPlace = (uint16_t)((ODO / 10u) % 10u);
    O_DecimalPlace = (uint16_t)(ODO % 10u);
    T_HundredsPlace = (uint16_t)((Trip / 1000u) % 10);
    T_TensPlace = (uint16_t)((Trip / 100u) % 10u);
    T_UnitsPlace = (uint16_t)((Trip / 10u) % 10u);
    T_DecimalPlace = (uint16_t)(Trip % 10u);
    if (Get_Dis_OdoAndTrip() == 1) // 小计显示
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0291_4_145);
        if (Trip < 10u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[0], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[T_DecimalPlace]);
        }
        else if (Trip < 100u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[T_DecimalPlace]);
        }
        else if (Trip < 1000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[T_DecimalPlace]);
        }
        else
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_HundredsPlace], 6u, 66u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[T_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[T_DecimalPlace]);
        }
    }
    else if (Get_Dis_OdoAndTrip() == 0) // 总计显示
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0290_7_145);
        if (ODO < 10u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[0], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 100u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 1000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 10000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_HundredsPlace], 6u, 66u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 100000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_ThousandsPlace], 6u, 58u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_HundredsPlace], 6u, 66u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 1000000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_T_ThousandsPlace], 6u, 50u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_ThousandsPlace], 6u, 58u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_HundredsPlace], 6u, 66u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
        else if (ODO < 10000000u)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_H_ThousandsPlace], 6u, 42u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_T_ThousandsPlace], 6u, 50u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_ThousandsPlace], 6u, 58u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_HundredsPlace], 6u, 66u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_TensPlace], 6u, 74u);
            SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[O_UnitsPlace], 6u, 82u);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
            SetPagePic(GRAPHICS_PAGE_0, OT_Figure[O_DecimalPlace]);
        }
    }
}

/*行驶模式显示函数*/
void AMT630H_Driving_Mode()
{
    uint16_t Driving_Mode = 0u;
    Driving_Mode = Get_Driving_Mode();
    if (Driving_Mode == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, M_Driving_Mode[0]);
        SetPagePic(GRAPHICS_PAGE_0, A_Driving_Mode[2]);
        SetPagePic(GRAPHICS_PAGE_0, U_Driving_Mode[1]);
    }
    else if (Driving_Mode == 2)
    {
        SetPagePic(GRAPHICS_PAGE_0, M_Driving_Mode[2]);
        SetPagePic(GRAPHICS_PAGE_0, A_Driving_Mode[1]);
        SetPagePic(GRAPHICS_PAGE_0, U_Driving_Mode[0]);
    }
    else if (Driving_Mode == 3)
    {
        SetPagePic(GRAPHICS_PAGE_0, M_Driving_Mode[1]);
        SetPagePic(GRAPHICS_PAGE_0, A_Driving_Mode[0]);
        SetPagePic(GRAPHICS_PAGE_0, U_Driving_Mode[2]);
    }
    else
    {
    }
    SetPagePic(GRAPHICS_PAGE_0, Pic_0302_181_866);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0303_116_866);
}

/*轮胎显示函数*/
void AMT630H_GUI_Dis_Old_Staus()
{

    uint8_t Dis_Sizes = 0;
    SetPagePic(GRAPHICS_PAGE_0, Pic_0310_60_921);//四驱
    SetPagePic(GRAPHICS_PAGE_0, Pic_0311_13_1001);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0308_116_1075);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0309_76_1161);
    Dis_Sizes = Get_Dis_Sizes();
    SetPagePic(GRAPHICS_PAGE_0, Pic_0358_206_1041);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0361_155_1094);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0362_121_1094);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0363_87_1094);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0364_53_1094);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0360_158_1070);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0360_124_1070);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0360_90_1070);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0360_56_1070);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0388_234_789);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0378_262_824);
    switch (Dis_Sizes)
    {
    case 0:
        SetPagePic(GRAPHICS_PAGE_0, T_Dis_Sizes[Dis_Sizes]);
        break;
    case 1:
        SetPagePic(GRAPHICS_PAGE_0, T_Dis_Sizes[Dis_Sizes]);
        break;
    case 2:
        SetPagePic(GRAPHICS_PAGE_0, T_Dis_Sizes[Dis_Sizes]);
        break;
    case 3:
        SetPagePic(GRAPHICS_PAGE_0, T_Dis_Sizes[Dis_Sizes]);
        break;
    default:
        break;
    }

    SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[9], 6u, 66u);
    SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[9], 6u, 74u);
    SetPagePicFree(GRAPHICS_PAGE_0, OT_Figure[9], 6u, 82u);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0278_6_91);
    SetPagePic(GRAPHICS_PAGE_0, OT_Figure[9]);

    SetPagePic(GRAPHICS_PAGE_0, WT_Figure[9]);
    SetPagePicFree(GRAPHICS_PAGE_0, WT_Figure[9], 2u, 837u);
    SetPagePicFree(GRAPHICS_PAGE_0, WT_Figure[9], 2u, 829u);
    // SetPagePic(GRAPHICS_PAGE_0, F_Figure[9]);
    SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[9], 2u, 430u);
    SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[9], 2u, 424u);
    SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[9], 2u, 418u);
    SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[9], 6u, 1187u);
    SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[9], 6u, 1165u);
    SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[9], 6u, 1173u);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0365_6_1182);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0366_6_1206);
    SetPagePic(GRAPHICS_PAGE_0, (uint16_t)Rotate_Speed[200u]);
    SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[9], 86u, 582u);
    SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[9], 85u, 621u);
    SetPagePicFree(GRAPHICS_PAGE_0, DS_Figure[9], 85u, 660u);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0381_260_965);//安全带
    SetPagePic(GRAPHICS_PAGE_0, Pic_0387_233_462);//燃油

 }

/*时间数显函数*/
void AMT630H_GUI_Time()
{
    uint16_t Hour_Time = 0u;
    uint16_t Minute_Time = 0u;
    uint16_t H_UnitsPlace = 0u;
    uint16_t H_TensPlace = 0u;
    uint16_t M_UnitsPlace = 0u;
    uint16_t M_TensPlace = 0u;
    uint8_t Flicker = 0;
    Flicker = Get_Flicker();
    Hour_Time = Get_Dis_Hour_Time();
    Minute_Time = Get_Dis_Minute_Time();
    H_TensPlace = Hour_Time / 10u;
    H_UnitsPlace = Hour_Time % 10u;
    M_TensPlace = Minute_Time / 10u;
    M_UnitsPlace = Minute_Time % 10u;
    if (Get_Dis_Timer_Set() == 1)
    {
        if (Flicker == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_TensPlace], 6u, 1165u);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
        }
        else
        {
            /*时间闪烁位置*/
            switch (Flicker)
            {
            case 1:
                SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
                break;
            case 2:
                SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_TensPlace], 6u, 1165u);

                break;
            case 3:
                SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_TensPlace], 6u, 1165u);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
                break;
            case 4:
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_TensPlace], 6u, 1165u);
                SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
                break;

            default:
                break;
            }
        }
    }
    else
    {
        if (H_TensPlace == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, T_Figure[M_UnitsPlace]);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[M_TensPlace], 6u, 1187u);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_TensPlace], 6u, 1165u);
            SetPagePicFree(GRAPHICS_PAGE_0, T_Figure[H_UnitsPlace], 6u, 1173u);
        }
    }

    if (Get_AMorPM() == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0366_6_1206);
    }
    else if (Get_AMorPM() == 2)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0367_6_1207);
    }
    if (Get_Time_Cocln())
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0365_6_1182);
    }
}

/*电压数显函数*/
void AMT630H_GUI_Battery_Voltage_Display()
{
    uint16_t Battery_Voltage = 0u;
    uint16_t V_TensPlace = 0u;
    uint16_t V_UnitsPlace = 0u;
    uint16_t V_DecimalPlace = 0u;
    Battery_Voltage = Get_Battery_Voltage_Display();
    SetPagePic(GRAPHICS_PAGE_0, Pic_0278_296_1157);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0390_295_1111);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0389_296_1171);
    V_TensPlace = Battery_Voltage / 100u;
    V_UnitsPlace = (Battery_Voltage / 10u) % 10u;
    V_DecimalPlace = Battery_Voltage % 10u;
    if (Battery_Voltage < 10u)
    {
        SetPagePic(GRAPHICS_PAGE_0, V_Figure[V_DecimalPlace]);
        SetPagePicFree(GRAPHICS_PAGE_0, V_Figure[0], 296u, 1148u);
    }
    else if (Battery_Voltage < 100u)
    {
        SetPagePic(GRAPHICS_PAGE_0, V_Figure[V_DecimalPlace]);
        SetPagePicFree(GRAPHICS_PAGE_0, V_Figure[V_UnitsPlace], 296u, 1148u);
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, V_Figure[V_DecimalPlace]);
        SetPagePicFree(GRAPHICS_PAGE_0, V_Figure[V_UnitsPlace], 296u, 1148u);
        SetPagePicFree(GRAPHICS_PAGE_0, V_Figure[V_TensPlace], 296u, 1140u);
    }
}

/*水温表显示函数*/
void AMT630H_GUI_Water_Temperature()
{
    uint16_t CurCoolantSetp = 0u;     // 水温格数
    uint16_t Coolant_Percentage = 0u; // 水温度数
    uint16_t TW_HundredsPlace = 0u;   // 水温百位
    uint16_t TW_TensPlace = 0u;       // 水温十位
    uint16_t TW_UnitsPlace = 0u;      // 水温个位
    CurCoolantSetp = Get_CurCoolantSetp();
    Coolant_Percentage = Get_Coolant_Percentage();
    TW_HundredsPlace = Coolant_Percentage / 100u;
    TW_TensPlace = (Coolant_Percentage / 10u) % 10u;
    TW_UnitsPlace = Coolant_Percentage % 10u;
    SetPagePic(GRAPHICS_PAGE_0, Pic_0040_0_750);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0028_0_774);

    /*水温表格显示*/
    if (Get_Coolant_Sensor_State() == CoolantSensorNormal)
    {
        for (size_t i = 0; i <= CurCoolantSetp; i++)
        {
            
            SetPagePic(GRAPHICS_PAGE_0, Water_Temperature[i]);
        }
    }
    else if ((Get_Coolant_Sensor_State() == CoolantSensorShortCircuit) ||
             (Get_Coolant_Sensor_State() == CoolantSensorOpenCircuit))
    {
        if (FLASH_SYNC_1Hz)
        {
            for (size_t i = 0; i <= 8; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, Water_Temperature[i]);
            }
        }
    }
    /*水温数字显示*/
    if (Get_Self() == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0041_2_852);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0053_2_809);
    }
    else
    {
        if ((Get_Coolant_Sensor_State() == CoolantSensorShortCircuit) ||
            (Get_Coolant_Sensor_State() == CoolantSensorOpenCircuit))
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, WT_Figure[0]);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0041_2_852);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0053_2_809);
            }
        }
        else
        {
            if (Coolant_Percentage == 0u)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0042_2_845);
            }
            else if ((Coolant_Percentage < 10u))
            {
                SetPagePic(GRAPHICS_PAGE_0, WT_Figure[TW_UnitsPlace]);
            }
            else if ((Coolant_Percentage < 100u))
            {
                SetPagePic(GRAPHICS_PAGE_0, WT_Figure[TW_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, WT_Figure[TW_TensPlace], 2u, 837u);
            }
            else if ((Coolant_Percentage < 1000u))
            {
                SetPagePic(GRAPHICS_PAGE_0, WT_Figure[TW_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, WT_Figure[TW_TensPlace], 2u, 837u);
                SetPagePicFree(GRAPHICS_PAGE_0, WT_Figure[TW_HundredsPlace], 2u, 829u);
            }

            SetPagePic(GRAPHICS_PAGE_0, Pic_0041_2_852);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0053_2_809);
        }
    }
   
}

//校验函数
void Flash_Check(void)
{
    uint8_t Flash_Check_Value = 0U;
    SetPageGuid(GRAPHICS_PAGE_0, 2u, 0u, 0u); 
    switch ( Color_State )
    {
        case 0U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0002_0_0);//蓝
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 1U;
            }
            break;
        case 1U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0414_0_0);//绿
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 2U;
            }
            break;
        case 2U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0415_0_0);//红
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 3U;
            }
            break;
        case 3U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0416_0_0);//黑
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 4U;
            }
            break;
        case 4U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0416_0_0);//白
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 5U;
            }
            break;
        case 5U:
            g_sysFlag_Lcdcheck = 1u;
            if ( Color_Timer < 60U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 6U;
            }
            break;
        case 7U:
            SetPageBackground(GRAPHICS_PAGE_0, Pic_0417_0_0);//红
            if ( Color_Timer < 10U )
            {
                Color_Timer++;
            }
            else
            {
                Color_Timer = 0U;
                Color_State = 6U;
            }
            break;
        default:
            if ( AMT630H_FlashCheck.Flag == 3u)
            {
                PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_PASS, 3000U);
                Gen_TimeDelay(20 * 1000, 1000);
                // if ( Color_Timer < 60U )
                // {
                //     Color_Timer++;
                // }
                // else
                {
                    Color_Timer     = 0U;
                    Color_State     = 9U;
                    // FlashCheckFlag  = 2U;
                }
            }
            else if ( AMT630H_FlashCheck.Flag == 2u )
            {
                PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_FAIL, 3000U);
                if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
                {
                    Color_State = 7u;
                }
                else 
                {
                    // FlashCheckFlag = 2U;
                }
            }
            else
            {
                PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECKING, 2800U);
            }
            break;
    }
    PackedTransfer_Page();

}

/*燃油表显示函数*/
void AMT630H_GUI_Fuel_Oil()
{
    uint16_t CurFuelSetp = 0u;
    uint16_t Fuel_Percentage = 0u; // 燃油度数
    uint16_t F_HundredsPlace = 0u; // 燃油百位
    uint16_t F_TensPlace = 0u;     // 燃油十位
    uint16_t F_UnitsPlace = 0u;    // 燃油个位
    CurFuelSetp = Get_CurFuelSetp();
    Fuel_Percentage = Get_Fuel_Percentage();
    F_HundredsPlace = Fuel_Percentage / 100u;
    F_TensPlace = (Fuel_Percentage / 10u) % 10u;
    F_UnitsPlace = Fuel_Percentage % 10u;
    SetPagePic(GRAPHICS_PAGE_0, Pic_0014_0_261);
    SetPagePic(GRAPHICS_PAGE_0, Pic_0003_0_285);

    /*燃油表格显示*/
    if (Get_Fuel_Sensor_State() == FuelSensorNormal)
    {
        if (CurFuelSetp == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Fuel_Oil[0]);
        }
        else
        {
            for (size_t i = 1; i <= (CurFuelSetp+1u); i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, Fuel_Oil[i]);
            }
        }
    }
    else if ((Get_Fuel_Sensor_State() == FuelSensorOpenCircuit) ||
             (Get_Fuel_Sensor_State() == FuelSensorShortCircuit))
    {
        if (FLASH_SYNC_1Hz)
        {
            for (size_t i = 0; i <= 8; i++)
            {
                SetPagePic(GRAPHICS_PAGE_0, F_Fuel_Oil[i]);
            }
        }
    }
    /*燃油数字显示*/
    if (Get_Self() == 1)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0015_2_447);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0016_2_438);
    }
    else
    {
        if ((Get_Fuel_Sensor_State() == FuelSensorOpenCircuit) ||
            (Get_Fuel_Sensor_State() == FuelSensorShortCircuit))
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, F_Figure[0]);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0015_2_447);
                SetPagePic(GRAPHICS_PAGE_0, Pic_0016_2_438);
            }
        }
        else
        {

           if ((Fuel_Percentage < 10u))
            {
                SetPagePic(GRAPHICS_PAGE_0, F_Figure[F_UnitsPlace]);
            }
            else if ((Fuel_Percentage < 100u))
            {
                SetPagePic(GRAPHICS_PAGE_0, F_Figure[F_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[F_TensPlace], 2u, 423u);
            }
            else if ((Fuel_Percentage < 1000u))
            {
                SetPagePic(GRAPHICS_PAGE_0, F_Figure[F_UnitsPlace]);
                SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[F_TensPlace], 2u, 423u);
                SetPagePicFree(GRAPHICS_PAGE_0, F_Figure[F_HundredsPlace], 2u, 418u);
            }
            SetPagePic(GRAPHICS_PAGE_0, Pic_0015_2_447);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0016_2_438);
        }
    }
}
void Boot_Animation_KL15_Init(void)
{
    Uptime = 0u;
    Stime = 0u;
}

void AMT630H_GUI_ReadPosittion_Display(void)
{
    uint8_t ti = 0;
    /*轮胎显示函数*/
    if (Get_Dis_Old_Staus() == 3)
    {
        // uint16_t CurFuelSetp = 0u;
        // uint16_t CurCoolantSetp = 0u;
        // CurCoolantSetp = Get_CurCoolantSetp();
        // CurFuelSetp = Get_CurFuelSetp();
        AMT630H_GUI_BACKGRAND();
        AMT630H_GUI_Light();
        for (size_t i = 0; i <= 8; i++)
        {
            SetPagePic(GRAPHICS_PAGE_0, F_Fuel_Oil[i]);
        }
        for (size_t i = 0; i <= 8; i++)
        {
            SetPagePic(GRAPHICS_PAGE_0, Water_Temperature[i]);
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0015_2_447);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0016_2_438);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0041_2_852);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0053_2_809);
        AMT630H_GUI_Tap_Position();
        AMT630H_GUI_Dis_Old_Staus();
    }

    else
    {
        if (Get_Self() == 1)
        {
            AMT630H_GUI_BACKGRAND();
            AMT630H_GUI_ESpeed();
            AMT630H_GUI_Tap_Position();
            AMT630H_GUI_Fuel_Oil();
            AMT630H_GUI_Water_Temperature();
            AMT630H_GUI_Car_Speed();
            AMT630H_GUI_Light();
            AMT630H_GUI_Dis_Unit();
            // AMT630H_Driving_Mode();
            SetPagePic(GRAPHICS_PAGE_0, M_Driving_Mode[0]);
            SetPagePic(GRAPHICS_PAGE_0, A_Driving_Mode[2]);
            SetPagePic(GRAPHICS_PAGE_0, U_Driving_Mode[1]);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0317_140_1136);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0319_187_1126);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0316_83_989);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0318_133_978);
        }
        else
        {
            if (Get_Mileage_Rear_Door() == 1)
            {
                // while (ti < 5)
                // {
                //     if (Stime <= 200u)
                //     {
                //         SetPageBackground(GRAPHICS_PAGE_0, Self_Scanning[ti]);
                //     }
                //     else
                //     {
                //         ti++;
                //         Stime = 0u;
                //     }
                //         Stime++;
                // }
                // if (ti == 5)
                // {
            
                // // }
                // Stime++;
                // if (Stime <= 10u)
                // {
                //     ti = 0u;
                // }
                // else if (Stime <= 20u)
                // {
                //     ti = 1u;
                // }
                // else if (Stime <= 30u)
                // {
                //     ti = 2u;
                // }
                // else if (Stime <= 40u)
                // {
                //     ti = 3u;
                // }
                // else if (Stime <= 50u)
                // {
                //     ti = 4u;
                // }
                // else
                // {
                //     Stime = 0u;
                // }
                // SetPageBackground(GRAPHICS_PAGE_0, Self_Scanning[ti]);
                Flash_Check();
            }
            else
            {
                Stime = 0;
                AMT630H_GUI_BACKGRAND();
                AMT630H_GUI_Light();
                AMT630H_GUI_ESpeed();
                AMT630H_GUI_Water_Temperature();
                AMT630H_GUI_Fuel_Oil();
                AMT630H_GUI_Car_Speed();
                AMT630H_GUI_Tap_Position();
                AMT630H_GUI_Battery_Voltage_Display();
                AMT630H_GUI_Time();
                AMT630H_Driving_Mode();
                AMT630H_ODO_Trip_Value();
                AMT630H_GUI_Dis_Unit();
            }
        }
    }
}

uint8_t Get_Uptime_Staus(void)
{
   return Uptime_Staus;
}
uint8_t Get_Up_time(void)
{
    return Uptime;
}
