#include "common.h"
#include "Components.h"
#include "Display.h"
#include "flash.h"
#include "UDS\UDS_ISO14229_Services.h"
#include "Mileage\Service_Interval.h"
DataTimeStruct DataTime;
uint16_t Driving_mode = 0u;
uint32_t timerk = 0;
uint8_t g_u8RTC_H = 0;
uint8_t Intermediate_Variable = 0;
uint8_t Dis_Hour_Tenb;
uint8_t Dis_Hour_Bit;
uint8_t Dis_Minute_Tenb;
uint8_t Dis_Minute_Bit;
uint8_t g_u8Time_Cocln = 0;//冒号
uint8_t g_u8AMorPM = 1;//0:无显示 1:AM 2:PM
uint8_t g_u8Flicker = 0;//0:全灭 1：小时十位亮 2：小时个位亮 3：分钟十位亮 4： 分钟个位亮
RTC_CounterTypeDef counter_value;
RTC_CounterTypeDef date_time;

void Display_KL15_KL30_Init(void)
{
    Driving_mode = 0u;

}

void Driving_Mode_Display(void)
{
    uint16_t Mode = 0;
    Mode = Get_CAN_CH0_ID_402_Sig_ETC_performance_mode();
    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {    
        if (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_ECU_402_Msg_Count) == CAN_SIG_NORMAL)
        {
            if (Mode == 0)
            {
                Driving_mode = 1u;
            }
            else if (Mode == 1)
            {
                Driving_mode = 2u;
            }
            else if (Mode == 2)
            {
                Driving_mode = 3u;
            }
        }
        if((Common_GetIgnOnTime() > 1990u) && (Common_GetIgnOnTime() <= 2000u))
        {
            Driving_mode = 0u;
        }
    }
}

void TIME_Service(void)
{
    g_u8RTC_H++;
    Intermediate_Variable++;
    if (g_u8RTC_H > 4)
    {
        g_u8RTC_H = 1u;
    }
}


/*保存时间*/
void Double_Empvalue(void)
{
   	RTE_RTC_Get_CounterValue(&date_time);
	counter_value.time.RTC_Hours = RTC_Bcd2ToByte(date_time.time.RTC_Hours);
	counter_value.time.RTC_Minutes = RTC_Bcd2ToByte(date_time.time.RTC_Minutes);
	counter_value.time.RTC_Seconds = RTC_Bcd2ToByte(date_time.time.RTC_Seconds); 
    Dis_Hour_Tenb = counter_value.time.RTC_Hours / 10u;
    Dis_Hour_Bit = counter_value.time.RTC_Hours % 10u;
    Dis_Minute_Tenb = counter_value.time.RTC_Minutes / 10u;
    Dis_Minute_Bit = counter_value.time.RTC_Minutes % 10u;
    DataTime.Dis_Seconds = counter_value.time.RTC_Seconds;
    DataTime.Dis_Hour = counter_value.time.RTC_Hours;
    DataTime.Dis_Minute = counter_value.time.RTC_Minutes;
    DataTime.RTC_H12 = counter_value.time.RTC_H12;
    DataTime.Dis_Timer_Set = 1U;  //存储标志位
    DataTime.Val_ServiceMil100m = Get_g_ServiceMil100m();
    DataTime.Val_ServiceTimer1s = Get_g_ServiceTimer1s();
}
/**
 * @description: 针对于新MCU情况下的 D_Flash初始化
 * @return {*}
 */
void D_Flash_Init(void)
{
    // flashRead((uint8_t*)APP_DATA_WRITE, sizeof(DataTime), (uint8_t *)&DataTime);
    // if(Init_Flash_Buf[0]==0XFF)
    // {
    //     EraseSector(APP_DATA_WRITE);
    //     Init_Flash_Buf[0]=0;
    //     ProgramPage(APP_DATA_WRITE, sizeof(DataTime), (uint8_t *)&DataTime);
    // }
}
/**
 * @description: D_Flash 的设置写入 
 * @return {*} 0成功 1失败
 */
uint8_t D_Flash_Set(void)
{
    uint8_t result = 0;
    EraseSector(APP_DATA_WRITE);
    result = ProgramPage(APP_DATA_WRITE, sizeof(DataTime), (uint8_t *)&DataTime);
    return result;
}

uint8_t D_Flash_Get(void)
{   
    flashRead((uint8_t*)APP_DATA_WRITE, sizeof(DataTime), (uint8_t *)&DataTime);
    return 1u;
}

void D_Flash_Clear(void)
{
    EraseSector(APP_DATA_WRITE);
}
void Time_Assignment(void)
{
    RTC_CounterTypeDef time_temp;
    // uint32_t TempBuf[20] = {0};
    uint8_t Size = 0u;
    uint8_t BackLight = 0u;
    // Gen_TimeDelay(10,1000);
    // eeprom_ReadRecord(EEPROM_BLOCK_08, (uint8_t *)&DataTime, 8);
    D_Flash_Get();
    if (DataTime.Dis_Timer_Set == 1u )
    {
        Size = (DataTime.Size_Back_Light / 10);
        BackLight = (DataTime.Size_Back_Light % 10);
        time_temp.time.RTC_Hours = (DataTime.Dis_Hour);
        time_temp.time.RTC_Minutes = (DataTime.Dis_Minute);
        time_temp.time.RTC_Seconds = (DataTime.Dis_Seconds);
        time_temp.time.RTC_H12 = (DataTime.RTC_H12);
        v_g_ServiceMil100m(DataTime.Val_ServiceMil100m);
        v_g_ServiceTimer1s(DataTime.Val_ServiceTimer1s);
        RTC_SetTime(&time_temp.time);
        DataTime.Dis_Timer_Set = 0u;
        if (DataTime.ODO_KM_Memory == 0u)
        {
            Dis_OdoAndTrip(0u);
            Dis_Unit(0u);
        }
        else if (DataTime.ODO_KM_Memory == 1u)
        {
            Dis_OdoAndTrip(0u);
            Dis_Unit(1u);
        }
        else if (DataTime.ODO_KM_Memory == 2u)
        {
            Dis_OdoAndTrip(1u);
            Dis_Unit(0u);
        }
        else if (DataTime.ODO_KM_Memory == 3u)
        {
            Dis_OdoAndTrip(1u);
            Dis_Unit(1u);
        }
        DataTime.ODO_KM_Memory = 0u;
        if(Size == 4u)
        {
            Dis_Sizes_Read(3u);
        }
        else if (Size == 2u)
        {
            Dis_Sizes_Read(1u);
        }
        if(BackLight == 5u)
        {
            Luminous_Value_Pwm_Alter(300u);
        }
        else if (BackLight == 4u)
        {
            Luminous_Value_Pwm_Alter(500u);
        }
        else if (BackLight == 3u)
        {
            Luminous_Value_Pwm_Alter(600u);
        }
        else if (BackLight == 2u)
        {
            Luminous_Value_Pwm_Alter(700u);
        }
        else if (BackLight == 1u)
        {
            Luminous_Value_Pwm_Alter(800u);
        }
        DataTime.Size_Back_Light = 0u;
        Gen_TimeDelay(10,1000);
        D_Flash_Clear();
        D_Flash_Set();
        // eeprom_WriteRecord(EEPROM_BLOCK_08, ( uint8_t * )&DataTime, 8);
    }
}
/*单位及里程存储*/
void ODO_KM_Memory_Feature(void) 
{
    if((Get_Dis_Unit() == 0u) && (Get_Dis_OdoAndTrip() == 0u))
    {
        DataTime.ODO_KM_Memory = 0u;
    }
    else if((Get_Dis_Unit() == 1u) && (Get_Dis_OdoAndTrip() == 0u))
    {
        DataTime.ODO_KM_Memory = 1u;
    }
    else if((Get_Dis_Unit() == 0u) && (Get_Dis_OdoAndTrip() == 1u))
    {
        DataTime.ODO_KM_Memory = 2u;
    }
    else if((Get_Dis_Unit() == 1u) && (Get_Dis_OdoAndTrip() == 1u))
    {
        DataTime.ODO_KM_Memory = 3u;
    }
}
/*轮胎尺寸及背光存储*/
void Size_Back_Light_Feature(void)
{
    uint8_t Size = 0u;
    uint8_t Back_Light = 0u;
    uint8_t Val = 0u;
    if(Get_Luminous_Value_Pwm() == 300u)
    {
        Back_Light = 5u;
    }
    else if(Get_Luminous_Value_Pwm() == 500u)
    {
        Back_Light = 4u;
    }
    else if(Get_Luminous_Value_Pwm() == 600u)
    {
        Back_Light = 3u;
    }
    else if(Get_Luminous_Value_Pwm() == 700u)
    {
        Back_Light = 2u;
    }
    else if(Get_Luminous_Value_Pwm() == 800u)
    {
        Back_Light = 1u;
    }
     if(Get_Dis_Sizes() == 3u)
    {
        Size = 40u;
    }
    else if(Get_Dis_Sizes() == 1u)
    {
        Size = 20u;
    }
    DataTime.Size_Back_Light = (Size + Back_Light);
    D_Flash_Clear();
    D_Flash_Set();
}
void Time_Cocln_server(void)
{
    static uint32_t Led_Old_Staus = 0;
    RTC_CounterTypeDef time_temp;
    RTE_RTC_Get_CounterValue(&date_time);
	time_temp.time.RTC_Hours = RTC_Bcd2ToByte(date_time.time.RTC_Hours);
	time_temp.time.RTC_Minutes = RTC_Bcd2ToByte(date_time.time.RTC_Minutes);
	time_temp.time.RTC_Seconds = RTC_Bcd2ToByte(date_time.time.RTC_Seconds);
	if(g_u8RTC_H == 0u)
	{
		if(FLASH_SYNC_1Hz)
		{
			g_u8Time_Cocln = 1u;
		}
		else
		{
			g_u8Time_Cocln = 0u;
		}
	}
	else
	{
		g_u8Time_Cocln = 1u;
	}
	if(g_u8RTC_H == 1u)
	{
		if(FLASH_SYNC_1Hz)
		{
			g_u8Flicker = 1u;//小时灭
		}
		else
		{
			g_u8Flicker = 0u;
		}
	}
	else if(g_u8RTC_H == 2u)
	{
		if(FLASH_SYNC_1Hz)
		{
			g_u8Flicker = 2u;//小时灭
		}
		else
		{
			g_u8Flicker = 0u;
		}
	}
    else if (g_u8RTC_H == 3u)
    {
        if (FLASH_SYNC_1Hz)
        {
            g_u8Flicker = 3u; // 分钟灭
        }
        else
        {
            g_u8Flicker = 0u;
        }
    }
    else if (g_u8RTC_H == 4u)
    {
        if (FLASH_SYNC_1Hz)
        {
            g_u8Flicker = 4u; // 分钟灭
        }
        else
        {
            g_u8Flicker = 0u;
        }
    }
    else
	{
		g_u8Flicker = 0u;
	}
    if (Get_Dis_Timer_Set() == 1)
    {
        timerk++;
        if (timerk >= 200u)
        {
            time_temp.time.RTC_Seconds = 0u;
            RTC_SetTime(&time_temp.time);
            g_u8RTC_H = 0u;
            Intermediate_Variable = 0u;
            Dis_Timer_Set_(0);
        }
        else
        {
            if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
            {
                if (g_u8RTC_H == 1)
                {
                    time_temp.time.RTC_Hours = ((Dis_Hour_Tenb * 10u) + (time_temp.time.RTC_Hours % 10u));
                }
                if (g_u8RTC_H == 2)
                {
                    time_temp.time.RTC_Hours = ((time_temp.time.RTC_Hours / 10u) + Dis_Hour_Bit);
                }
                if (g_u8RTC_H == 3u)
                {
                    time_temp.time.RTC_Minutes = ((Dis_Minute_Tenb * 10u) + (time_temp.time.RTC_Hours % 10u));
                }
                if (g_u8RTC_H == 4u)
                {
                    time_temp.time.RTC_Minutes = ((time_temp.time.RTC_Hours / 10u) + Dis_Minute_Bit);
                }
                time_temp.time.RTC_Seconds = 0u;
                RTC_SetTime(&time_temp.time);
                g_u8RTC_H = 0u;
                Intermediate_Variable = 0u;
                Dis_Timer_Set_(0);
            }
        }
    }
    else
    {
        timerk = 0u;
    }
    if (Led_Old_Staus != Intermediate_Variable)
    {
        Led_Old_Staus = Intermediate_Variable;
        timerk = 0u;
    }
}
	

uint8_t Time_Set = 0u;
void Time_Display_Service(void)//50ms  task
{	

	RTE_RTC_Get_CounterValue(&date_time);
	counter_value.time.RTC_Hours = RTC_Bcd2ToByte(date_time.time.RTC_Hours);
	counter_value.time.RTC_Minutes = RTC_Bcd2ToByte(date_time.time.RTC_Minutes);
	counter_value.time.RTC_Seconds = RTC_Bcd2ToByte(date_time.time.RTC_Seconds);
	if(Time_Set == 0u)
	{
		if((counter_value.time.RTC_Hours < 24) && (counter_value.time.RTC_Minutes < 60) && (counter_value.time.RTC_Seconds < 60))
		{
			Time_Set = 1u;
			RTC_SetTime(&counter_value.time);
		}
	}
}

void Hour_Adjust(void)
{
	RTC_CounterTypeDef time_temp;
	//更改时间
	RTE_RTC_Get_CounterValue(&date_time);
    
	time_temp.time.RTC_Hours = RTC_Bcd2ToByte(date_time.time.RTC_Hours);
	time_temp.time.RTC_Minutes = RTC_Bcd2ToByte(date_time.time.RTC_Minutes);
	time_temp.time.RTC_Seconds = RTC_Bcd2ToByte(date_time.time.RTC_Seconds);
    if( Common_Get_IG_Sts() == COMMON_POWER_ON )
    {
        if (g_u8RTC_H == 1u)
        {
            Intermediate_Variable++;
            time_temp.time.RTC_Hours += 10u;
        }
        if (time_temp.time.RTC_Hours >= 30)
        {
            time_temp.time.RTC_Hours -= 30u;
        }
        if (g_u8RTC_H == 2)
        {
            Intermediate_Variable++;
            time_temp.time.RTC_Hours++;
        }

        if (time_temp.time.RTC_Hours > 23u)
        {
            time_temp.time.RTC_Hours = 0u;
        }
        
    }
    time_temp.time.RTC_Seconds = 0u;
    RTC_SetTime(&time_temp.time);
}

void Min_Adjust(void)
{

	RTC_CounterTypeDef time_temp;
	//更改时间
	RTE_RTC_Get_CounterValue(&date_time);   
	time_temp.time.RTC_Hours = RTC_Bcd2ToByte(date_time.time.RTC_Hours);
	time_temp.time.RTC_Minutes = RTC_Bcd2ToByte(date_time.time.RTC_Minutes);
	time_temp.time.RTC_Seconds = RTC_Bcd2ToByte(date_time.time.RTC_Seconds);

    if (Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        if (g_u8RTC_H == 3)
        {
            Intermediate_Variable++;
            time_temp.time.RTC_Minutes += 10u;
        }
        if (time_temp.time.RTC_Minutes >= 60u)
        {
            time_temp.time.RTC_Minutes -= 60u;
        }
        if (g_u8RTC_H == 4)
        {
            Intermediate_Variable++;
            time_temp.time.RTC_Minutes++;
        }
        if (time_temp.time.RTC_Minutes > 59u)
        {
            time_temp.time.RTC_Minutes = 0u;
        }

    }
    time_temp.time.RTC_Seconds = 0u;
    RTC_SetTime(&time_temp.time);
}
/*时间显示小时*/
uint8_t Get_Dis_Hour_Time(void)
{
    uint8_t u8RTC_Hours = 0u;
    u8RTC_Hours = counter_value.time.RTC_Hours;
    if (u8RTC_Hours == 12U)
    {
        g_u8AMorPM = 2U;
    }
    else  if(u8RTC_Hours > 12U)
    {
        u8RTC_Hours -= 12U;
        g_u8AMorPM = 2U;
    }
    else if (u8RTC_Hours == 0U)
    {
        u8RTC_Hours = 12U;
        g_u8AMorPM = 1U;
    }
    else
    {
        g_u8AMorPM = 1u;
    }
    return u8RTC_Hours;
}

/*返回分钟时间*/
uint8_t Get_Dis_Minute_Time(void)
{
	return counter_value.time.RTC_Minutes;
}

/*1AM，2PM*/
uint8_t Get_AMorPM(void)
{
	return g_u8AMorPM;
}

/*：闪烁*/
uint8_t Get_Time_Cocln(void)
{
	return g_u8Time_Cocln;
}
/*闪烁1小时十位，2小时个位，3分钟十位，4分钟个位*/
uint8_t Get_Flicker(void)
{
	return g_u8Flicker;
}
/*行驶模式*/
uint16_t Get_Driving_Mode()
{
    return Driving_mode;
}
