#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_

#include "common.h"
#include "Components.h"
#ifdef Platform_16Bit
    #define Light_uint8_t  unsigned char
    #define Light_uint16_t unsigned int
    #define Light_uint32_t unsigned long

#else
    #define Light_uint8_t  unsigned char
    #define Light_uint16_t unsigned short
    #define Light_uint32_t unsigned int
    #define Light_uint64_t unsigned long long

#endif


#ifndef Backlight_NULL
    #define Backlight_NULL ( void * )0u
#endif /* NULL */
/*光感数据存储结构体*/
typedef struct 
{
    uint32_t u32Result;
    uint8_t u8DayandNightSts; 

}Backlight_User_OPT3004_st_t;

extern Backlight_User_OPT3004_st_t opt3004;
void Backlight_KL30_Wakeup_Init(void);
void Backlight_SetPwm_cotrol(void);
void ADProcess_NTC_Temp_Service(void);
void Luminous_Time_Alter(uint16_t Val);
void Luminous_Value_Pwm_Alter(uint16_t Val);
uint16_t Get_Luminous_Value_Pwm(void);
uint16_t Get_Luminous_Value_recovery(void);

#endif
