#include "Data_Coolant.h"
#include "Components.h"
#include "Backlight.h"
#include "Battery_Voltage.h"
#include "PowerManagement\PowerManag_user.h"

#define Coolant_DATA_TIME 50u /*这里填写多长时间采集一个数据，单位ms*/
#define Coolant_DATA_NUM 20u  /*水温电阻采集数据总数 最大255*/
#define Coolant_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define Coolant_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/

#define RETURN_DIFFERENCE 25u /*判断上升或下降的回差，精度0.1*/

#define Coolant_SEG_UP 0u
#define Coolant_SEG_DOWN 1u

uint16_t g_u16CoolantData[Coolant_DATA_NUM];
uint8_t g_u8CoolantDataCount = 0u;

/*** 水温上升表格 ***/
static const uint16_t Water_Temperature_Table_Up [9u] =
    /*显示段：| 0 | 1 |  2   |  3  | 4 |  5  | 6 | 7 | 8 |  ...*/
{30, 230,350,500,650,1000,1350,1850,2650}; // 上升时小于等于表值则熄灭相应段

/*** 水温下降表格 ***/
static const uint16_t Water_Temperature_Table_Dn [ 9u ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |      ...*/
{60,260,380,530,680,1030,1380,1880,2680}; // 下降时小于等于表值则熄灭相应段

/*** 水温上升表格 ***/
static const uint16_t Water_TemperatureCan_Table_Up [9u] =
    /*显示段：| 0 | 1 |  2   |  3  | 4 |  5  | 6 | 7 | 8 |  ...*/
    {3180,3280,3380,3480,3580,3680,3780,3930,4330};    // 上升时小于等于表值则熄灭相应段

/*** 燃油液位下降表格 ***/
static const uint16_t Water_TemperatureCan_Table_Dn [ 9u ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |      ...*/
    {3150,3250,3350,3450,3550,3650,3750,3900,4300};    // 下降时小于等于表值则熄灭相应段

uint16_t CoolantR = 0u; /*滤波后的水温电阻，精度0.1*/
static uint16_t Coolantpercentage_last = 0u;
static uint16_t CoolantpercentageVal = 0u;
uint8_t g_u8DesCoolantSetp = 0u;
static uint8_t g_u8CurCoolantSetp = 0u;
static uint16_t percentage;
static uint16_t Coolant_Self_Inspection_Stage = 0u;
static uint8_t Coolant_Timerf = 0u;
static uint8_t Last = 0u;
uint8_t g_u8CoolantInitFlag = 0u;
uint8_t g_u8CoolantEmergency_StopFlag = 0u;
uint8_t g_u8CoolantStateInitFlag = 0u;
uint8_t g_u8CoolantDir = Coolant_SEG_UP;
uint16_t Coolantpercentage = 0u;
CoolantTemperature CoolantTemperatureCtrl;
CoolantSensorSts_t CoolantSensorState = CoolantSensorNormal;
uint16_t g_u16CoolantSensorNormalTime = 0u;
uint32_t g_u16CoolantCanValue = 0u;
uint16_t g_u16CoolantSensorShortTime = 0u;
uint16_t g_u16CoolantSensorOpenTime = 0u;
uint16_t timer_Staus = 0;
uint32_t  CoolantNumChangeTime = 0;
uint32_t CoolantNumTime = 0;
uint8_t g_u8CoolantADCompleteFlg = 0u;
uint8_t  g_u8DeCoolantSetp = 0;
static uint16_t g_DropoutTime = 0u;
static uint16_t CoolantSensorStaus = 1;
static uint16_t Coolant_SensorStaus = 0;
static uint8_t g_u8CoolantRedFlg = 0u;
static uint16_t Coolant_Efficacious = 0;
static uint16_t CooltimeCount = 0;
uint8_t DstSeg = 0u;
uint8_t C_DstSeg = 0u;
uint32_t Coolant_C_Value_Last = 0;
static uint16_t Coolant_Value_Last = 0;
void Coolant_KL30_Init(void)
{
    g_u8DesCoolantSetp = 0u;
    g_u8CurCoolantSetp = 0u;
    Coolant_Timerf = 0u;
    Last = 0u;
    Coolant_Self_Inspection_Stage = 0u;
    Coolant_Efficacious = 0;
    g_u8CoolantInitFlag = 1u;
    g_u8CoolantStateInitFlag = 1u;
    CoolantSensorStaus = 1;
    g_u8CoolantDir = Coolant_SEG_UP;
    CoolantSensorState = CoolantSensorNormal;
    g_u16CoolantSensorNormalTime = 0u;
    g_u16CoolantSensorShortTime = 0u;
    g_u16CoolantSensorOpenTime = 0u;
    CoolantNumChangeTime = 0u;
    CoolantNumTime = 0u;
    timer_Staus = 0u;
    g_u8CoolantADCompleteFlg = 0u;
    g_u8DeCoolantSetp = 0u;
    Coolant_SensorStaus = 0u;
    g_DropoutTime = 0u;
    g_u8CoolantRedFlg = 0u;
    Coolantpercentage = 0u;
    g_u16CoolantCanValue = 0u;
    DstSeg = 0u;
    C_DstSeg = 0u;
    Coolant_C_Value_Last = 0u;
    Coolant_Value_Last = 0u;
    g_u8CoolantEmergency_StopFlag = 0u;
}

void Coolant_KL15_Init(void)
{
    g_u8DesCoolantSetp = 0u;
    g_u8CurCoolantSetp = 0u;
    Coolant_Efficacious = 0;
    Coolant_Timerf = 0u;
    Last = 0u;
    Coolant_Self_Inspection_Stage = 0u;
    g_u8CoolantInitFlag = 1u;
    g_u8CoolantStateInitFlag = 1u;
    CoolantSensorStaus = 1;
    g_u8CoolantDir = Coolant_SEG_UP;
    CoolantSensorState = CoolantSensorNormal;
    g_u16CoolantSensorNormalTime = 0u;
    g_u16CoolantSensorShortTime = 0u;
    g_u16CoolantSensorOpenTime = 0u;
    CoolantNumChangeTime = 0u;
    CoolantNumTime = 0u;
    timer_Staus = 0u;
    g_u8CoolantADCompleteFlg = 0u;
    g_u8DeCoolantSetp = 0u;
    Coolant_SensorStaus = 0u;
    g_DropoutTime = 0u;
    g_u8CoolantRedFlg = 0u;
    Coolantpercentage = 0u;
    g_u16CoolantCanValue = 0u;
    DstSeg = 0u;
    C_DstSeg = 0u;
    Coolant_C_Value_Last = 0u;
    Coolant_Value_Last = 0u;
    g_u8CoolantEmergency_StopFlag = 0u;
}

void Coolant_R_Cal(uint8_t deltaTime)
{
    uint16_t CoolantRes = 0;
    uint8_t i, j;
    uint32_t temp32;


    if (g_u8CoolantStateInitFlag)
    {
        CoolantR = ADC_Read_Signal(ADC_CH_COOLANT_TEMP_R);
    }

    if (CooltimeCount >= Coolant_DATA_TIME)
    {
        CooltimeCount = 0;
        if (g_u8CoolantDataCount < Coolant_DATA_NUM)
        {
            /*获取水温电阻*/
            CoolantRes = ADC_Read_Signal(ADC_CH_COOLANT_TEMP_R);

            /*四舍五入*/
            if (CoolantRes < 65535)
            {
                if ((CoolantRes % 10u) >= 5u)
                {
                    CoolantRes += 5u;
                }
            }
            else
            {
                CoolantRes = 0xFFFF;
            }
            /*由小到大插入数据*/
            for (i = 0; i < g_u8CoolantDataCount; i++)
            {
                if (CoolantRes < g_u16CoolantData[i])
                {
                    break;
                }
            }
            for (j = g_u8CoolantDataCount; j > i; j--)
            {
                g_u16CoolantData[j] = g_u16CoolantData[j - 1];
            }
            g_u16CoolantData[i] = CoolantRes;
            g_u8CoolantDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = Coolant_CAL_START; i < Coolant_CAL_END; i++)
            {
                temp32 += g_u16CoolantData[i];
            }
            CoolantR = (uint16_t)(temp32 / (Coolant_CAL_END - Coolant_CAL_START));
            g_u8CoolantDataCount = 0u;
            g_u8CoolantADCompleteFlg = 1u;
        }
    }
    CooltimeCount += deltaTime;
}

void Coolant_State_Check(uint8_t deltaTime)
{
    if (Coolant_Efficacious != 1)//can在线
    {
        if (CoolantR < 30)
        { /*短路3*/
            g_u16CoolantSensorOpenTime = 0u;
            g_u16CoolantSensorNormalTime = 0u;
            if ((g_u16CoolantSensorShortTime > 3000u) || ((g_u8CoolantStateInitFlag) && (g_u16CoolantSensorShortTime > 3000u)))
            {
                CoolantSensorState = CoolantSensorShortCircuit;
                g_u8DesCoolantSetp = 0u;
                g_u8CurCoolantSetp = 8u;
                g_u8CoolantInitFlag = 1u;
                g_u8CoolantStateInitFlag = 0u;
                g_u8CoolantDir = Coolant_SEG_UP;
            }
            else
            {
                g_u16CoolantSensorShortTime += deltaTime;
            }
        }
        else if (CoolantR > 5000u)
        { /*开路 500*/
            g_u16CoolantSensorShortTime = 0u;
            g_u16CoolantSensorNormalTime = 0u;
            if ((g_u16CoolantSensorOpenTime > 3000u) || ((g_u8CoolantStateInitFlag) && (g_u16CoolantSensorOpenTime >= 3000u)))
            {
                CoolantSensorState = CoolantSensorOpenCircuit;
                g_u8DesCoolantSetp = 0u;
                g_u8CurCoolantSetp = 8u;
                g_u8CoolantInitFlag = 1u;
                g_u8CoolantStateInitFlag = 0u;
                g_u8CoolantDir = Coolant_SEG_UP;
            }
            else
            {
                g_u16CoolantSensorOpenTime += deltaTime;
            }
        }
        else
        {
            g_u16CoolantSensorShortTime = 0u;
            Coolant_Efficacious = 0u;
            g_u16CoolantSensorOpenTime = 0u;
            CoolantSensorState = CoolantSensorNormal;
            g_u8CoolantStateInitFlag = 0u;
        }
    }
    else
    {
        g_u16CoolantSensorOpenTime = 0u;
        g_u16CoolantSensorShortTime = 0u;
    }
}

void Coolant_Gauges_Cal(uint8_t deltaTime)
{
    static uint16_t time = 0u;
    static uint16_t timer = 0u;
    static uint16_t timerA = 0u;
    g_u16CoolantCanValue = Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature();
    if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_ECU_101_Msg_Count) == CAN_SIG_NORMAL) && (g_u16CoolantCanValue != 0xFFFF))//can在线且不等于FFFF
    {
        Coolant_Efficacious = 1u;
        timerA = 0u;
        if ((g_u16CoolantCanValue < 2380u))//小于零下35度
        {
            g_u8DesCoolantSetp = 0u;
            CoolantSensorState = CoolantSensorNormal;
        }
        else if(g_u16CoolantCanValue >= 4330u)//大于160度
        {
            g_u8DesCoolantSetp = 8u;
            CoolantSensorState = CoolantSensorNormal;
        }
        else
        {
            if (g_u16CoolantCanValue > Coolant_C_Value_Last) // 新燃油液位高于前次燃油液位,查上升表
            {
                while (C_DstSeg < 9u)
                {
                    if (g_u16CoolantCanValue < Water_TemperatureCan_Table_Up[C_DstSeg])
                        break;
                    C_DstSeg++;
                }
            }
            else if (g_u16CoolantCanValue < Coolant_C_Value_Last) // 新燃油液位低于前次燃油液位,查下降表
            {
                while (C_DstSeg)
                {
                    if (g_u16CoolantCanValue > Water_TemperatureCan_Table_Dn[C_DstSeg - 1u])
                        break;
                    C_DstSeg--;
                }
            }
            Coolant_C_Value_Last = g_u16CoolantCanValue;
            g_u8DesCoolantSetp = C_DstSeg;
            CoolantSensorState = CoolantSensorNormal;
        }
        if (Common_GetIgnOnTime() > 1950u)//自检后
        {
            g_u8CoolantRedFlg = 0u;
            timer += deltaTime;
            if (g_u8CoolantInitFlag)
            {
                g_u8CoolantInitFlag = 0u;
                timer = 0u;
                g_u8CurCoolantSetp = g_u8DesCoolantSetp;
            }
            if (g_DropoutTime < 12000u)//自检后立即指示
            {
                g_DropoutTime += deltaTime;
                if (CoolantSensorStaus == 1u)
                {
                    CoolantSensorStaus = 2u;
                    Coolant_Value_Last = g_u8DesCoolantSetp;
                }
                if (Coolant_Value_Last == g_u8DesCoolantSetp)
                {
                    g_u8CurCoolantSetp = g_u8DesCoolantSetp;
                    Coolant_Value_Last = g_u8DesCoolantSetp;
                }
            }
            else
            {
            }
            if (timer >= 12000)
            { /* 12S变化一格 */
                timer = 0;
                if (g_u8CurCoolantSetp < g_u8DesCoolantSetp)
                {
                    g_u8CurCoolantSetp++;
                }
                else if (g_u8CurCoolantSetp > g_u8DesCoolantSetp)
                {
                    g_u8CurCoolantSetp--;
                }
            }

            if (g_u8CurCoolantSetp == g_u8DesCoolantSetp)
            {
                timer = 0u;
            }
        }
        else
        {
            g_u8CoolantInitFlag = 1u;
        }
    }
    else
    {
        if ((CoolantSensorState == CoolantSensorNormal) && (CoolantR <= 5000u) && (CoolantR > 30u))//硬线判断
        {
            timerA = 0u;
            Coolant_Efficacious = 0u;
            /*采集完第一组数据后，开始计算水温格数*/

            if (g_u8CoolantInitFlag)
            {
            }
            if (CoolantR < Coolant_Value_Last) // 新燃油液位高于前次燃油液位,查上升表
            {
                while (DstSeg)
                {

                    if (CoolantR > Water_Temperature_Table_Up[DstSeg - 1u])
                    {
                        break;
                    }
                    DstSeg--;
                }
            }
            else if (CoolantR > Coolant_Value_Last) // 新燃油液位低于前次燃油液位,查下降表
            {
                while (DstSeg < 9u)
                {
                    if (CoolantR < Water_Temperature_Table_Dn[DstSeg])
                    {
                        break;
                    }
                    DstSeg++;
                }
            }
            Coolant_Value_Last = CoolantR;
            g_u8DesCoolantSetp = 9u - DstSeg;

            /*IGN ON 2秒/故障恢复后，开始走格  立即指向当前格*/
            if (Common_GetIgnOnTime() >= 2000u)
            {
                      time += deltaTime;
                if (g_u8CoolantInitFlag)
                {
                    g_u8CoolantInitFlag = 0u;
                    time = 0u;
                    g_u8CurCoolantSetp = g_u8DesCoolantSetp;
                }
                if (g_DropoutTime < 12000u)
                {
                    g_DropoutTime += deltaTime;
                    if (CoolantSensorStaus == 1u)
                    {
                        CoolantSensorStaus = 2u;
                        Coolant_Value_Last = g_u8DesCoolantSetp;
                    }
                    if (Coolant_Value_Last == g_u8DesCoolantSetp)
                    {
                        g_u8CurCoolantSetp = g_u8DesCoolantSetp;
                        Coolant_Value_Last = g_u8DesCoolantSetp;
                    }
                }
                else
                {
                }
                if (time >= 12000u)
                { /* 12S变化一格 */
                    time = 0u;
                    if (g_u8CurCoolantSetp < g_u8DesCoolantSetp)
                    {
                        g_u8CurCoolantSetp++;
                    }
                    else if (g_u8CurCoolantSetp > g_u8DesCoolantSetp)
                    {
                        g_u8CurCoolantSetp--;
                    }
                }

                if (g_u8CurCoolantSetp == g_u8DesCoolantSetp)
                {
                    time = 0u;
                }
            }
        }
        /*can和硬线均掉线*/
        else
        {
            timer_Staus = 0u;
            g_u8CoolantRedFlg = 0u;
            timerA += deltaTime;
            if (g_u8CoolantInitFlag)
            {
                g_u8CoolantInitFlag = 0u;
                g_u8CurCoolantSetp = g_u8DesCoolantSetp;
            }
            if (Coolant_Efficacious == 1u)
            {
                CoolantSensorState = CoolantSensorNormal;
                if (g_u16CoolantCanValue != 0xFFFF)
                {
                    if (timerA >= 2000u) // 2秒后判can掉线
                    {
                        g_u8CurCoolantSetp = 8u;
                        CoolantSensorState = CoolantSensorShortCircuit;
                        Coolant_Efficacious = 2u;
                        g_u8CoolantInitFlag = 1u;
                        Coolant_SensorStaus = 1u;
                    }
                }
                else
                {
                     if (timerA >= 3000u) // 3秒后判can掉线
                    {
                        g_u8CurCoolantSetp = 8u;
                        CoolantSensorState = CoolantSensorShortCircuit;
                        Coolant_Efficacious = 2u;
                        g_u8CoolantInitFlag = 1u;
                        Coolant_SensorStaus = 1u;
                    }
                }
            }
            if (Coolant_Efficacious == 0u)
            {
                CoolantSensorState = CoolantSensorNormal;
                if (timerA >= 3000u)//3秒后判硬线掉线
                {
                    g_u8CurCoolantSetp = 8u;
                    CoolantSensorState = CoolantSensorShortCircuit;
                    Coolant_Efficacious = 2u;
                    g_u8CoolantInitFlag = 1u;
                    Coolant_SensorStaus = 1u;
                }
            }
        }
    }
    /*水温信号由掉线到在线3秒判断*/
    if(Common_GetIgnOnTime() >= 2000u)
    {
        if (CoolantSensorState == CoolantSensorNormal)
        {
            if (Coolant_SensorStaus == 1u)
            {
                timer_Staus += deltaTime;
                if (timer_Staus <= 3000u)
                {
                    g_u8CurCoolantSetp = 8u;
                    CoolantSensorState = CoolantSensorShortCircuit;
                    Coolant_Efficacious = 2u;
                    g_u8CoolantInitFlag = 1u;
                }
                else
                {
                    timer_Staus = 0u;
                    Coolant_SensorStaus = 0u;
                }
            }
            if ((CoolantR <= 5000u) && (CoolantR > 30u))
            {
            }
            else
            {
                if (CAN_RX_Get_TimeStamp(&CAN_CH0_CanMsgOp, CAN_CH0_ID_ECU_101_Msg_Count) >= 20u)
                {
                    timer_Staus = 0u;
                }
            }
        }
        else
        {
            timer_Staus = 0;
            // Coolant_SensorStaus = 0u;
        }
    }
}
/*水温数显*/
void Coolant_Percentage_Figure(uint8_t deltaTime)
{

    if (Coolant_SensorStaus == 1u)//掉线置零
    {
        CoolantTemperatureCtrl.CoolantTemperatureCurrent = 0u;
        CoolantpercentageVal = 0u;
        Coolantpercentage = 0u; 
        percentage = 0u;
    }
    else//水温信号在线
    {
        if (CoolantR > 3985u)// 短路开路置0
        {
            CoolantpercentageVal = 0u;
        }
        if ((CoolantR <= 3985u) && (CoolantR > 2650u))
        {
            CoolantpercentageVal = ((3985u - CoolantR) / 29u); // 减去-35摄氏度的阻值1015
        }
        else if ((CoolantR <= 2650u) && (CoolantR > 1850u))
        {
            CoolantpercentageVal = ((2650u - CoolantR) / 80u) + 44u;
        }
        else if ((CoolantR <= 1850u) && (CoolantR > 1350u))
        {
            CoolantpercentageVal = ((1850u - CoolantR) / 50u) + 54u;
        }
        else if ((CoolantR <= 1350u) && (CoolantR > 1000u))
        {
            CoolantpercentageVal = ((1350u - CoolantR) / 35u) + 64u;
        }
        else if ((CoolantR <= 1000u) && (CoolantR > 650u))
        {
            CoolantpercentageVal = ((1000u - CoolantR) / 35u) + 74u;
        }
        else if ((CoolantR <= 650u) && (CoolantR > 500u))
        {
            CoolantpercentageVal = ((650u - CoolantR) / 15u) + 84u;
        }
        else if ((CoolantR <= 500u) && (CoolantR > 350u))
        {
            CoolantpercentageVal = ((500u - CoolantR) / 15u) + 94u;
        }
        else if ((CoolantR <= 350u) && (CoolantR > 230u))
        {
            CoolantpercentageVal = ((350u - CoolantR) / 8u) + 104u;
        }
        else if ((CoolantR <= 230u) && (CoolantR > 30u))
        {
            CoolantpercentageVal = ((230u - CoolantR) / 5u) + 119u;
            if ((CoolantR <= 35u))
            {
                CoolantpercentageVal = 160u;
            }
        }
        if (Coolant_Efficacious == 1u)//can在线
        {

            if (g_u16CoolantCanValue > 2730u)
            {
                CoolantpercentageVal = (uint16_t)((g_u16CoolantCanValue - 2730u) / 10u);
            }
            else
            {
                CoolantpercentageVal = 0u;
            }
            if (g_u16CoolantCanValue >= 4330u)
            {
                CoolantpercentageVal = 160u;
            }
        }
        /*格数有变化*/
        if (g_u8DesCoolantSetp != g_u8CurCoolantSetp)
        {
            /*计算时间*/
            if ((g_u8DeCoolantSetp == 1u) || (g_u8DeCoolantSetp == 2u))
            {
                CoolantNumTime += deltaTime;
            }
            else
            {
                // if (Coolantpercentage == CoolantpercentageVal)
                // {

                if (g_u8DesCoolantSetp > g_u8CurCoolantSetp)//目标格数大于当前格数
                {
                    if (Coolantpercentage < CoolantpercentageVal)
                    {
                        g_u8DeCoolantSetp = 1u;
                        CoolantNumChangeTime = ((g_u8DesCoolantSetp - g_u8CurCoolantSetp)) * 12000u;
                        CoolantNumChangeTime = CoolantNumChangeTime / (CoolantpercentageVal - Coolantpercentage);
                    }
                }
                else//目标格数小于当前格数
                {
                    if (Coolantpercentage > CoolantpercentageVal)
                    {
                        g_u8DeCoolantSetp = 2u;
                        CoolantNumChangeTime = ((g_u8CurCoolantSetp - g_u8DesCoolantSetp)) * 12000u;
                        CoolantNumChangeTime = CoolantNumChangeTime / (Coolantpercentage - CoolantpercentageVal);
                    }
                }
                // }
            }
            
            if (Get_Self() != 1)//自检期间不进入
            {
                if (CoolantNumTime > CoolantNumChangeTime)
                {
                    if (g_u8DesCoolantSetp > g_u8CurCoolantSetp)
                    {
                        Coolantpercentage += 1u;
                    }
                    else
                    {
                        Coolantpercentage -= 1u;
                    }
                    CoolantNumTime = 0u;
                }
            }
            if (g_u8DeCoolantSetp == 1)
            {
                if (CoolantpercentageVal > percentage)
                {
                    // if (g_u8CoolantEmergency_StopFlag < 1)
                    // {
                        percentage = Coolantpercentage;
                    // }
                }
                else
                {
                    //急停
                    // g_u8CoolantEmergency_StopFlag++;
                }
            }
            if (g_u8DeCoolantSetp == 2)
            {
                if (CoolantpercentageVal < percentage)
                {
                    // if (g_u8CoolantEmergency_StopFlag < 1)
                    // {
                        percentage = Coolantpercentage;
                    // }
                }
                else
                {
                    //急停
                    // g_u8CoolantEmergency_StopFlag++;
                }
            }
            
        }
        else//格数无变化时
        {
            g_u8CoolantEmergency_StopFlag = 0U;
            Coolantpercentage = CoolantpercentageVal;
            CoolantNumTime = 0u;
            CoolantNumChangeTime = 0u;
            g_u8DeCoolantSetp = 0u;
        }
    }

    if ((Get_Self() == 1u) || (timer_Staus == 3000u))//自检或掉线恢复时
    {
        if (CoolantR > 3985u)// 短路开路置0
        {
            CoolantpercentageVal = 0u;
        }
        if ((CoolantR <= 3985u) && (CoolantR > 2650u))
        {
            CoolantpercentageVal = ((3985u - CoolantR) / 29u); // 减去-35摄氏度的阻值1015
        }
        else if ((CoolantR <= 2650u) && (CoolantR > 1850u))
        {
            CoolantpercentageVal = ((2650u - CoolantR) / 80u) + 44u;
        }
        else if ((CoolantR <= 1850u) && (CoolantR > 1350u))
        {
            CoolantpercentageVal = ((1850u - CoolantR) / 50u) + 54u;
        }
        else if ((CoolantR <= 1350u) && (CoolantR > 1000u))
        {
            CoolantpercentageVal = ((1350u - CoolantR) / 35u) + 64u;
        }
        else if ((CoolantR <= 1000u) && (CoolantR > 650u))
        {
            CoolantpercentageVal = ((1000u - CoolantR) / 35u) + 74u;
        }
        else if ((CoolantR <= 650u) && (CoolantR > 500u))
        {
            CoolantpercentageVal = ((650u - CoolantR) / 15u) + 84u;
        }
        else if ((CoolantR <= 500u) && (CoolantR > 350u))
        {
            CoolantpercentageVal = ((500u - CoolantR) / 15u) + 94u;
        }
        else if ((CoolantR <= 350u) && (CoolantR > 230u))
        {
            CoolantpercentageVal = ((350u - CoolantR) / 8u) + 104u;
        }
        else if ((CoolantR <= 230u) && (CoolantR > 30u))
        {
            CoolantpercentageVal = ((230u - CoolantR) / 5u) + 119u;
            if ((CoolantR <= 35u))
            {
                CoolantpercentageVal = 160u;
            }
        }
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_ECU_101_Msg_Count) == CAN_SIG_NORMAL) && (g_u16CoolantCanValue != 0xFFFF))
        {
            if (g_u16CoolantCanValue > 2730u)
            {
                CoolantpercentageVal = (uint16_t)((g_u16CoolantCanValue - 2730u) / 10u);
            }
            else
            {
                CoolantpercentageVal = 0u;
            }
            if (CoolantpercentageVal >= 160u)
            {
                CoolantpercentageVal = 160u;
            }
        }

        CoolantTemperatureCtrl.CoolantTemperatureCurrent = CoolantpercentageVal;
        // percentage = CoolantpercentageVal;
        Coolantpercentage = CoolantpercentageVal;
    }
    // if (Get_Voltage_Anomaly() == 2)
    // {
    //     CoolantTemperatureCtrl.CoolantTemperatureCurrent = CoolantpercentageVal;
    // }
    if (Coolantpercentage >=  Coolantpercentage_last) // 上升
    {
       percentage = Coolantpercentage;
        Coolantpercentage_last = Coolantpercentage;
    }
    else // 下降
    {
        if (((Coolantpercentage_last - Coolantpercentage) > 2u) || (Coolantpercentage == 0u))
        {
           percentage = Coolantpercentage;
            Coolantpercentage_last = Coolantpercentage;   
        }
        else // 保持上一状态
        {
           percentage =Coolantpercentage_last;
        }
    }
    CoolantTemperatureCtrl.Goal = percentage;
    Duty_Cycle_Delta(CoolantTemperatureCtrl.Goal, &CoolantTemperatureCtrl.CoolantTemperatureCurrent, &CoolantTemperatureCtrl.Time);
}

void Coolant_Self_InspectionOld(void)
{
    if (Common_GetIgnOnTime() < 2000u)
    {
        if (Get_Voltage_Anomaly() == 2u)
        {
        }
        else
        {
            if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
            {
                Coolant_Self_Inspection_Stage = 0u;
                Coolant_Timerf = 0u;
            }
            else
            {

                if (Get_Dis_Old_Staus() == 3u)
                {
                    Coolant_Timerf = 0u;
                }
                Coolant_Self_Inspection_Stage = 1u;
                if (Coolant_Timerf <= 20u)
                {
                    CoolantSensorState = CoolantSensorNormal;
                    g_u8CurCoolantSetp = 0u;
                    if (GetLcdInitSt() == 1u)
                    {
                        if (Get_Uptime_Staus() == 1u)
                        {
                            Coolant_Timerf++;
                        }
                    }
                    if (Coolant_Timerf >= 3u)
                    {
                        if (Coolant_Self_Inspection_Stage == 1u)
                        {
                            if (Coolant_Timerf <= 10u)
                            {
                                Last = ((Coolant_Timerf) * 100u) / 125u;
                                g_u8CurCoolantSetp = Last;
                            }
                            else
                            {
                                Last = 8u - (((Coolant_Timerf - 10u) * 100u) / 125u);
                                g_u8CurCoolantSetp = Last;
                            }
                        }
                    }
                }
                else
                {
                    Coolant_Self_Inspection_Stage = 2u;
                }
            }
        }
    }
}

void Coolant_Cal_Sevice(uint8_t deltaTime)
{
    /*检测水温电阻状态*/
    Coolant_State_Check(deltaTime);

    /*显示水温格*/
    Coolant_Gauges_Cal(deltaTime);
    Coolant_Percentage_Figure(deltaTime);
}
/*0正常，1表格红色*/
uint8_t Get_CurCoolantRed(void)
{
    return g_u8CoolantRedFlg;
}
/*返回百分比%*/
uint16_t Get_Coolant_Percentage(void)
{
    return CoolantTemperatureCtrl.CoolantTemperatureCurrent;
}
/*格数*/
uint8_t Get_CurCoolantSetp(void)
{
    return g_u8CurCoolantSetp;
}
/*状态*/
CoolantSensorSts_t Get_Coolant_Sensor_State(void)
{
    return CoolantSensorState;
}