const statusMap = ["下载", "编译", "文件处理", "文件上传", "完成"];
const notifyMap = ["未开启", "发送失败", "已发送"];
const typeMap = ["KELL", "IAR_EW_940", "IAR_EW_850", "IAR_PM", "GHS", "GCC"];

// 加载数据函数
function loadData(queryParams = "") {
    fetch("/query_all" + queryParams)  <!-- 这是刷新按钮点击时调用的接口 -->
        .then(response => response.json())
        .then(data => {
            console.log(data); // 调试用，查看返回的数据格式
            const tableBody = document.getElementById("recordTableBody");
            const noRecordMsg = document.getElementById("no-record");
            tableBody.innerHTML = ""; // 清空表格
            if (data.status === "success" && data.data.length > 0) {
                data.data.forEach(item => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td>${item.id}</td>
                        <td>${item.project_name}</td>
                        <td>${item.project_group}</td>
                        <td>${item.builder}</td>
                        <td>${item.create_time}</td>
                        <td>${item.build_time}</td>
                        <td>${statusMap[item.status]}</td>
                        <td>${notifyMap[item.wechat_notify]}</td>
                        <td>${notifyMap[item.email_notify]}</td>
                        <td>${typeMap[item.build_type]}</td>
                    `;
                    tableBody.appendChild(row);
                });
                noRecordMsg.style.display = "none";  // 隐藏没有记录的提示
            } else {
                noRecordMsg.style.display = "block";  // 显示没有记录的提示
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("加载数据时发生错误，请稍后重试！");
        });
}

// 搜索数据函数
function searchData(queryParams = "") {
    fetch("/get_filtered_records" + queryParams)  <!-- 这是搜索按钮点击时调用的接口 -->
        .then(response => response.json())
        .then(data => {
            console.log(data); // 调试用，查看返回的数据格式
            const tableBody = document.getElementById("recordTableBody");
            const noRecordMsg = document.getElementById("no-record");
            tableBody.innerHTML = ""; // 清空表格
            if (data.status === "success" && data.data.length > 0) {
                data.data.forEach(item => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td>${item.id}</td>
                        <td>${item.project_name}</td>
                        <td>${item.project_group}</td>
                        <td>${item.builder}</td>
                        <td>${item.create_time}</td>
                        <td>${item.build_time}</td>
                        <td>${statusMap[item.status]}</td>
                        <td>${notifyMap[item.wechat_notify]}</td>
                        <td>${notifyMap[item.email_notify]}</td>
                        <td>${typeMap[item.build_type]}</td>
                    `;
                    tableBody.appendChild(row);
                });
                noRecordMsg.style.display = "none";  // 隐藏没有记录的提示
            } else {
                noRecordMsg.style.display = "block";  // 显示没有记录的提示
            }
        })
        .catch(error => {
            console.error("Error:", error);
            alert("加载数据时发生错误，请稍后重试！");
        });
}

// 获取搜索表单的查询参数
function getQueryParams() {
    const projectName = document.getElementById("project_name").value.trim();
    const builder = document.getElementById("builder").value.trim();
    const createTime = document.getElementById("create_time").value.trim();

    let queryParams = "";
    if (projectName) {
        queryParams += `?project_name=${encodeURIComponent(projectName)}`;
    }
    if (builder) {
        queryParams += (queryParams ? `&` : `?`) + `builder=${encodeURIComponent(builder)}`;
    }
    if (createTime) {
        queryParams += (queryParams ? `&` : `?`) + `create_time=${encodeURIComponent(createTime)}`;
    }

    return queryParams;
}

// 点击搜索按钮时触发
document.getElementById("searchBtn").addEventListener("click", function (event) {
    event.preventDefault();  // 防止表单提交
    const queryParams = getQueryParams(); // 获取查询参数
    searchData(queryParams); // 调用 searchData 进行模糊查询
});

// 自动触发刷新
document.getElementById("refreshBtn").addEventListener("click", function () {
    const queryParams = getQueryParams();  // 获取查询参数
    loadData(queryParams); // 调用 loadData 刷新数据
});
window.onload = loadData(""); // 默认加载所有数据