#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#include "Components.h"
#include "CAN_Signal\CAN_Lib.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;

typedef enum
{
    CAN_CH0_ID_DIAG_EMS_RESP_Msg_Count,
    CAN_CH0_ID_DIAG_EMS_REQ_Msg_Count,
    CAN_CH0_ID_DIAG_FUNC_REQ_Msg_Count,
    CAN_CH0_ID_Dash_Set_Msg_Count,
    CAN_CH0_ID_PKE__Msg_Count,
    CAN_CH0_ID_PKE_Msg_Count,
    CAN_CH0_ID_TBOX_Msg_Count,
    CAN_CH0_ID_T_BOX_Msg_Count,
    CAN_CH0_ID_EPS_Msg_Count,
    CAN_CH0_ID_ECU_402_Msg_Count,
    CAN_CH0_ID_ECU_401_Msg_Count,
    CAN_CH0_ID_ECU_400_Msg_Count,
    CAN_CH0_ID_Cluster_238_Msg_Count,
    CAN_CH0_ID_ISG_111_Msg_Count,
    CAN_CH0_ID_ECU_101_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,                          
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{
    CAN_CH0_ID_DASHBOARD_213_Msg_Count,
    CAN_CH0_ID_ABS_100_Msg_Count,
    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_DASHBOARD_213_Msg    0x213ul
#define  CAN_CH0_ID_DIAG_EMS_RESP_Msg    0x7E8ul
#define  CAN_CH0_ID_DIAG_EMS_REQ_Msg     0x7E0ul
#define  CAN_CH0_ID_DIAG_FUNC_REQ_Msg    0x7DFul
#define  CAN_CH0_ID_Dash_Set_Msg         0x404ul
#define  CAN_CH0_ID_PKE__Msg             0x212ul
#define  CAN_CH0_ID_PKE_Msg              0x15Ful
#define  CAN_CH0_ID_TBOX_Msg             0x620ul
#define  CAN_CH0_ID_T_BOX_Msg            0x621ul
#define  CAN_CH0_ID_EPS_Msg              0x5FAul
#define  CAN_CH0_ID_ECU_402_Msg          0x402ul
#define  CAN_CH0_ID_ECU_401_Msg          0x401ul
#define  CAN_CH0_ID_ECU_400_Msg          0x400ul
#define  CAN_CH0_ID_Cluster_238_Msg      0x238ul
#define  CAN_CH0_ID_ISG_111_Msg          0x111ul
#define  CAN_CH0_ID_ECU_101_Msg          0x101ul
#define  CAN_CH0_ID_ABS_100_Msg          0x100ul

// extern uint8_t  Get_CAN_CH0_ID_213_Sig_Dashboard_GEAR(void);
// extern uint8_t  Get_CAN_CH0_ID_213_Sig_Vehicle_Speed_Limt(void);
// extern uint8_t  Get_CAN_CH0_ID_213_Sig_EPS_mode(void);
// extern uint8_t  Get_CAN_CH0_ID_213_Sig_a24WD_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b7(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b6(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b5(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b4(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b3(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b2(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b1(void);
extern uint8_t  Get_CAN_CH0_ID_7E8_Sig_Diag_EMS_Resp_Sig_b0(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b7(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b6(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b5(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b4(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b3(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b2(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b1(void);
extern uint8_t  Get_CAN_CH0_ID_7E0_Sig_Diag_EMS_Req_Sig_b0(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b7(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b6(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b5(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b4(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b3(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b2(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b1(void);
extern uint8_t  Get_CAN_CH0_ID_7DF_Sig_Diag_Funct_Req_Sig_b0(void);
extern uint8_t  Get_CAN_CH0_ID_404_Sig_Sport_State(void);
extern uint8_t  Get_CAN_CH0_ID_404_Sig_Oil_Pressure_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_404_Sig_Front_Axle_Lock_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_404_Sig_ETC_Target_Performance_Mode(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_PKE_CheckSum(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_PKE_AliveCounter(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_PKE_Ignition_Enable2(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_PKE_Ignition_Enable(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_PKE_TBOX_KeyAuthentSts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_signallamp_outsts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_BCM_Start_SwSts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_ecustart_insts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_start_relay_outsts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_K15_outsts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_horn_outsts(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_BCM_TurnIndicatorLeft(void);
extern uint8_t  Get_CAN_CH0_ID_212_Sig_BCM_TurnIndicatorRight(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte7(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte6(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte5(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte4(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte3(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte2(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte1(void);
extern uint8_t  Get_CAN_CH0_ID_15F_Sig_PKE_TBOX_ChallengeCodByte0(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_620_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeSecond(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeMinute(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeHour(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeDate(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeMonth(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeYear(void);
extern uint8_t  Get_CAN_CH0_ID_620_Sig_TBOX_TimeValid(void);
extern uint8_t  Get_CAN_CH0_ID_621_Sig_TBOX_621_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_621_Sig_TBOX_PowerReq(void);
extern uint8_t  Get_CAN_CH0_ID_621_Sig_TBOX_Pitch(void);
extern uint8_t  Get_CAN_CH0_ID_621_Sig_TBOX_Roll(void);
extern uint8_t  Get_CAN_CH0_ID_5FA_Sig_EPS_fault_light(void);
extern uint16_t Get_CAN_CH0_ID_5FA_Sig_EPS_fault_code(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_402_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_402_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_a2WD_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Reay_Axle_Lock_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Thrust_Augmentation_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_High_Gear_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Low_Gear_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Rear_Gear_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Brake_Switch_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ETC_performance_mode_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_ETC_performance_mode(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Power_Mode_State(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Hot_Engine_Warning(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_TCS_Indicator_Request(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Idle_stop_request(void);
extern uint8_t  Get_CAN_CH0_ID_402_Sig_Engine_Troq_Request(void);
extern uint16_t Get_CAN_CH0_ID_402_Sig_ECU_History_Fault_Code(void);
extern uint16_t Get_CAN_CH0_ID_402_Sig_ECU_Current_Fault_Code(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_CoolantFAN_State(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Autostart_Req_State(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Autostart_Req(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_MIL_State(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Gear_State(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Fuel_Consumption(void);
extern uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void);
extern uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Environment_Presure(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Fuel_Level_Signal(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Oil_Preseeure_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Head_Light_compensation_switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Hand_Brake_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Neutral_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Park_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Safety_Belt_Switch(void);
extern uint8_t  Get_CAN_CH0_ID_400_Sig_Seat_switch(void);
extern uint8_t  Get_CAN_CH0_ID_238_Sig_TCS_Disable_Request(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Fault_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_Engine_Reverse_State(void);
extern uint8_t  Get_CAN_CH0_ID_111_Sig_Engine_Reverse_State_Valid(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Checksum(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Livecounter(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position_State(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position(void);
extern uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void);
extern uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_Checksum(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_Livecounter(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_Supplier(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_St_ABS(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_F_wheelSpeed_Rear(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_F_ABS(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_F_vehiclereference(void);
// extern uint16_t Get_CAN_CH0_ID_100_Sig_ABS1_N_vehiclereference(void);
// extern uint16_t Get_CAN_CH0_ID_100_Sig_ABS1_N_wheelSpeed_Rear(void);
// extern uint8_t  Get_CAN_CH0_ID_100_Sig_ABS1_F_wheelSpeed_Front(void);
// extern uint16_t Get_CAN_CH0_ID_100_Sig_ABS1_N_wheelSpeed_Front(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
