from websocket_server import WebsocketServer


# 接收到客户端连接时触发
def new_client(client, server):
    print("新的客户端连接：{}".format(client['address']))


# 接收到客户端消息时触发
def message_received(client, server, message):
    print("收到来自{}的消息：{}".format(client['address'], message))
    print("lovesosoi")
    server.send_message(client, "server 收到消息：{}".format(message))  # 回复消息给客户端


PORT = 8222  # 服务器端口
server = WebsocketServer(host='0.0.0.0', port=PORT)  # 创建WebSocket服务器
print("服务器已经开启")
server.set_fn_new_client(new_client)  # 注册新客户端连接事件处理方法
server.set_fn_message_received(message_received)  # 注册消息接收事件处理方法
server.run_forever()  # 运行WebSocket服务器
