#include "Battery_Voltage.h"
#include "Components.h"


BatteryVoltage BatteryVoltageCtrl;
uint16_t Digital_Voltage = 0u;
uint16_t DigitalVoltage_Timer = 0u;
/******************************************************************************
函数名：Duty_Cycle_Delta
�?  能：阻尼处理
�?  数：�?
返回值：�?
******************************************************************************/
void Duty_Cycle_Delta(uint16_t Goal, uint16_t *Current, uint16_t *DampingTimer)
{

    uint16_t Delta  = 0;
    uint16_t Delta1 = 0;

    if ( Goal > (*Current) )    //�?标值大于当前�?
    {
        Delta  = Goal - (*Current);
        Delta1 = Goal - (*Current);

        (*DampingTimer)++;

        if ( (*DampingTimer) >= 5 )
        {
            (*DampingTimer) = 0;

            Delta /= 10;

            if ( Delta == 0 )
            {
                Delta = 1;
            }

            if ( (*Current) < Goal )
            {
                (*Current) += Delta;
            }
            if ( (*Current) > Goal )
            {
                (*Current)      = Goal;
                (*DampingTimer) = 0;
            }
        }
    }
    else if ( Goal < (*Current) )    //�?标值小于当前�?
    {
        Delta = (*Current) - Goal;

        (*DampingTimer)++;

        if ( (*DampingTimer) >= 5 )
        {
            (*DampingTimer) = 0;

            Delta /= 10;

            if ( Delta == 0 )
            {
                Delta = 1;
            }
            if ( (*Current) > Goal )
            {
                (*Current) -= Delta;
            }
            if ( (*Current) < Goal )
            {
                (*Current)      = Goal;
                (*DampingTimer) = 0;
            }
        }
    }
}

void Display_Battery_Voltage(void)
{
    if(DigitalVoltage_Timer >= 30)//3秒采集一次
    {
        DigitalVoltage_Timer = 0;
        Digital_Voltage = ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) / 100U;
    }
    else
    {
       DigitalVoltage_Timer++;
    } 
    BatteryVoltageCtrl.BatteryVoltageCurrent = Digital_Voltage;
}
uint16_t Get_Battery_Voltage_Display(void)              //获取电池电压表数值
{
    return BatteryVoltageCtrl.BatteryVoltageCurrent;
}