#include "GpioUser.h"
#include "Components.h"



void Gpio_Init(_GpioUser_Enum InitMode)
{
    if (InitMode == Gpio_Uvalid)
    {
        return;
    }

    if ((InitMode == Gpio_KL30_Init) || (InitMode == Gpio_WakeUp_Init))
    {
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN00, GpioOut_Low);  //1.8V电使能
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN01, RTE_GPIO_DIR_IN);  //KL15
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN02, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_Low);  
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, GpioOut_High);  
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN05, GpioOut_Low);  //L_BiasBitSW 里程百位---
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN06, GpioOut_Low);  //L_BiasBitSW 里程千位---

        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN00, RTE_GPIO_DIR_IN);  //表盘背光-PWM
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN01, RTE_GPIO_DIR_IN);   //蜂鸣器控制
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN02, GpioOut_Low);      
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN03, RTE_GPIO_DIR_IN);     
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN04, RTE_GPIO_DIR_IN);  //ABS报警
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, RTE_GPIO_DIR_IN);  //机油压力报警
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN07, RTE_GPIO_DIR_IN); 

        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN00, RTE_GPIO_DIR_IN);  //AVDD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN01, RTE_GPIO_DIR_IN);  //GND
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN02, RTE_GPIO_DIR_IN);  //KL30-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN03, RTE_GPIO_DIR_IN);  //KL15-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, RTE_GPIO_DIR_IN);  //NTC-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN05, RTE_GPIO_DIR_IN);  //燃油信号输入-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN06, RTE_GPIO_DIR_IN);  //水温信号输入-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN07, RTE_GPIO_DIR_IN);  //BiasBitSW-燃油-AD---

        RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT03_PIN01, RTE_GPIO_DIR_OUT);      //SDB_LED_DRIVER

        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN00, GpioOut_Low);      //SWDIO-编程
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN02, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN03, GpioOut_Low);      //VCC1V2_AMT_EN(630H电源)

        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN00, RTE_GPIO_DIR_IN);  //
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN01, GpioOut_Low);     //
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN02, GpioOut_High);  
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN03, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN04, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN05, RTE_GPIO_DIR_IN);  

        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN00, GpioOut_High);      //存储SCL
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN01, GpioOut_Low);      //存储SDA
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN02, GpioOut_Low);      //SCL_MCU
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN03, RTE_GPIO_DIR_IN);      //SDA_MCU

        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN00, RTE_GPIO_DIR_IN);  //制动液位
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN01, RTE_GPIO_DIR_IN);  
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN03, RTE_GPIO_DIR_IN);  //L_BiasBitSW 里程万位---
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN04, RTE_GPIO_DIR_IN);  //近光灯
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN05, RTE_GPIO_DIR_IN);  //示宽灯信号输入-N-IN-MCU
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN06, RTE_GPIO_DIR_IN);     
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN07, GpioOut_Low);      

        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN00, GpioOut_High);  //L_BiasBitSW_POW---
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN01, GpioOut_Low);      //X1
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN02, RTE_GPIO_DIR_IN);      //X2
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN03, GpioOut_Low);      //XT1
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN04, RTE_GPIO_DIR_IN);      //XT2

        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN00, GpioOut_High);  //燃油水温切电使能
        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN06, RTE_GPIO_DIR_IN);      //3004中断(未更改配置)
        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN07, GpioOut_Low);      //SWCLK-编程

        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN00, GpioOut_Low);     //3.3V电使能
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN01, RTE_GPIO_DIR_IN);  //L_BiasBitSW_燃油_OUT---
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN06, RTE_GPIO_DIR_IN);  //硬件版本识别
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN07, GpioOut_Low);      
    }
    else 
    {
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN00, GpioOut_High);//1.8V电使能
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN01, RTE_GPIO_DIR_IN);//KL15
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN03, GpioOut_High); 
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN04, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN05, RTE_GPIO_DIR_IN);//L_BiasBitSW 里程百位---
        RTE_GPIO_Config(RTE_GPIO_PORT00_PIN06, RTE_GPIO_DIR_IN);//L_BiasBitSW 里程千位---

        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN00, RTE_GPIO_DIR_OUT);//表盘背光-PWM
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN01, RTE_GPIO_DIR_IN);//蜂鸣器控制
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN03, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN04, RTE_GPIO_DIR_IN);//ABS报警
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN05, RTE_GPIO_DIR_IN);//机油压力报警
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN06, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT01_PIN07, RTE_GPIO_DIR_IN); 

        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN00, RTE_GPIO_DIR_IN);//AVDD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN01, RTE_GPIO_DIR_IN);//GND
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN02, RTE_GPIO_DIR_IN);//KL30-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN03, RTE_GPIO_DIR_IN);//KL15-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN04, RTE_GPIO_DIR_IN);//NTC-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN05, RTE_GPIO_DIR_IN);//燃油信号输入-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN06, RTE_GPIO_DIR_IN);//水温信号输入-AD
        RTE_GPIO_Config(RTE_GPIO_PORT02_PIN07, RTE_GPIO_DIR_IN);//BiasBitSW-燃油-AD---

        RTE_GPIO_Config(RTE_GPIO_PORT03_PIN00, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT03_PIN01, RTE_GPIO_DIR_IN);//SDB_LED_DRIVER

        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN00, RTE_GPIO_DIR_IN);//SWDIO-编程
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN01, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT04_PIN03, GpioOut_High);//VCC1V2_AMT_EN(630H电源)

        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN00, RTE_GPIO_DIR_IN);//切电控制-MCU-OUT-2
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN01, RTE_GPIO_DIR_IN);//切电控制-MCU-OUT-1
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN03, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN04, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT05_PIN05, RTE_GPIO_DIR_IN); 

        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN00, RTE_GPIO_DIR_IN);//存储SCL
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN01, RTE_GPIO_DIR_IN);//存储SDA
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN02, RTE_GPIO_DIR_IN);//SCL_MCU
        RTE_GPIO_Config(RTE_GPIO_PORT06_PIN03, RTE_GPIO_DIR_IN);//SDA_MCU

        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN00, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN01, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN02, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN03, RTE_GPIO_DIR_IN);//L_BiasBitSW 里程万位---
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN04, RTE_GPIO_DIR_IN);//近光灯
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN05, RTE_GPIO_DIR_IN);//ABS故障信号输入-N-IN-MCU
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN06, RTE_GPIO_DIR_IN); 
        RTE_GPIO_Config(RTE_GPIO_PORT07_PIN07, RTE_GPIO_DIR_IN); 

        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN00, RTE_GPIO_DIR_IN);//L_BiasBitSW_POW---
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN01, RTE_GPIO_DIR_IN);//X1
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN02, RTE_GPIO_DIR_IN);//X2
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN03, RTE_GPIO_DIR_IN);//XT1
        RTE_GPIO_Config(RTE_GPIO_PORT12_PIN04, RTE_GPIO_DIR_IN);//XT2

        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN00, RTE_GPIO_DIR_IN);//燃油水温切电使能
        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN06, RTE_GPIO_DIR_IN);//3004中断(未更改配置)
        RTE_GPIO_Config(RTE_GPIO_PORT13_PIN07, RTE_GPIO_DIR_IN);//SWCLK-编程

        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN00, GpioOut_High);//3.3V电使能
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN01, RTE_GPIO_DIR_IN);//L_BiasBitSW_燃油_OUT---
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN06, RTE_GPIO_DIR_IN);//硬件版本识别
        RTE_GPIO_Config(RTE_GPIO_PORT14_PIN07, RTE_GPIO_DIR_IN); 
    }
}
