import os
import re


def addName(folder_path,prefix):
    # 设置文件夹路径
    # folder_path = r'C:\Users\18545\Desktop\25601440灰阶图PNG'  # 替换为你的文件夹路径，例如 r'C:\Users\you\Pictures'

    # 设置前缀
    # prefix = 'ic_2560_1440_hj_'

    # 遍历文件夹中的所有 .png 文件
    for filename in os.listdir(folder_path):
        if filename.lower().endswith('.png'):
            new_name = prefix + filename
            old_path = os.path.join(folder_path, filename)
            new_path = os.path.join(folder_path, new_name)
            os.rename(old_path, new_path)
            print(f'Renamed: {filename} -> {new_name}')

    print('批量重命名完成！')


def changeName(folder_path):
    # 配置项
    # folder_path = r'C:\Users\18545\Desktop\c390'  # 替换为你的文件夹路径
    old_res = '1920_720'
    new_res = '1920_720_hj'

    # 遍历文件夹中的所有文件
    for filename in os.listdir(folder_path):
        if old_res in filename:
            new_name = filename.replace(old_res, new_res)
            old_path = os.path.join(folder_path, filename)
            new_path = os.path.join(folder_path, new_name)
            os.rename(old_path, new_path)
            print(f'Renamed: {filename} -> {new_name}')

    print('批量替换分辨率完成！')


def get_sort_key(filename):
    """
    为文件名生成一个用于自然排序的"键"。
    它会尝试提取文件名末尾的数字。
    - 如果成功，返回 (0, 数字)，以便按数值排序。
    - 如果失败，返回 (1, 文件名)，以便按字母排序。
    这样可以确保所有带数字后缀的文件排在前面，并按数字大小正确排序。
    """
    # re.search(r'(\d+)$', filename) 查找字符串末尾($)的一个或多个数字(\d+)
    match = re.search(r'(\d+)$', filename)
    if match:
        # 如果找到数字，返回一个元组 (类型标识, 数字值)
        # 类型0代表数字，会排在类型1（字符串）前面
        return (0, int(match.group(1)))
    else:
        # 如果没找到数字，返回 (类型标识, 原始字符串)
        return (1, filename)


def create_drawable_array_code(image_directory, array_name):
    """
    扫描指定目录中的.png文件，并生成一个经过自然排序的Java/Kotlin int数组声明。

    :param image_directory: 包含.png图片的文件夹路径。
    :param array_name: 你想为生成的数组指定的变量名。
    :return: 包含完整数组声明的字符串，如果出错则返回None。
    """
    if not os.path.isdir(image_directory):
        print(f"错误：找不到目录 '{image_directory}'")
        return None

    drawable_names = []
    for filename in os.listdir(image_directory):
        if filename.lower().endswith(".png"):
            base_name = os.path.splitext(filename)[0]
            drawable_names.append(base_name)

    if not drawable_names:
        print(f"在目录 '{image_directory}' 中没有找到任何.png文件。")
        return f"// 在目录 '{image_directory}' 中没有找到任何.png文件"

    # --- 关键改动在这里 ---
    # 使用自定义的 get_sort_key 函数进行自然排序
    drawable_names.sort(key=get_sort_key)

    indent = "    "
    array_items = [f"{indent}R.drawable.{name}" for name in drawable_names]

    array_content_string = ",\n".join(array_items)
    final_code = f"int[] {array_name} = {{\n{array_content_string}\n}};"

    return final_code
if __name__ == '__main__':
    url=r'C:\Users\18545\Desktop\1920532灰阶图PNG'
    prex=r'ic_1920_532_hj_'
    addName(url,prex)
    # changeName()
    s=create_drawable_array_code(url,prex)
    print(s)