#ifndef _CAN_APP_TX_H_
#define _CAN_APP_TX_H_

#include "stdint.h"
#include "Components.h"
//#pragma MESSAGE DISABLE C1106

/*****************************************************************************************************
ID  :  0x50A
报文： IP_50A
信号：
       |- IP_QDashACCFail
       |- IP_DISFail
       |-
       |-
       |-
       |- IP_FuelLeftoverVD
       |-
       |- IP_DisAfterIgnOn
       |-
       |- IP_PassengerLCDALEDSts
       |- IP_DriverLCDALEDSts
       |- IP_ModeSeting
       |- IP_FuelLeftover
       |- IP_FuelLeftover_AD
       |- IP_FuelLevelPercent
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t  IP_ABS1_N_wheelSpeed_Front_L: 8;

        uint8_t  IP_ABS1_N_wheelSpeed_Rear_L: 2;
        uint8_t  : 1;
        uint8_t  IP_ABS1_N_wheelSpeed_Front_H: 5;

        uint8_t  IP_ABS1_N_wheelSpeed_Rear_M: 8;

        uint8_t  : 5;
        uint8_t  IP_ABS1_N_wheelSpeed_Rear_H: 3;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;


    } Sig;
} CANMsg100Union;

/*****************************************************************************************************
ID  :  0x530
报文： IP_530
信号：
       |- IP_AvgFuelConsumption
       |- IP_FuelLevel
       |- IP_FuelGageType
       |- IP_EngineOffTime
       |- IP_TotalOdometer
       |- IP_AfeAfterIgnOn
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint16_t IP_EngineOffTime_H : 8;    // IP_EngineOffTime
        uint16_t IP_EngineOffTime_L : 8;    // IP_EngineOffTime

        uint32_t IP_TotalOdometer_H : 8;    // IP_TotalOdometer
        uint32_t IP_TotalOdometer_M : 8;    // IP_TotalOdometer
        uint32_t IP_TotalOdometer_L : 8;    // IP_TotalOdometer

        uint8_t IP_FuelGageType : 2;    // IP_FuelGageType
        uint8_t IP_FuelLevel    : 4;    // IP_FuelLevel
        uint8_t                 : 2;

        uint8_t IP_AllAvgFuelConsumption : 8;    // IP_AvgFuelConsumption
        uint8_t IP_AfeAfterIgnOn      : 8;    // IP_AfeAfterIgnOn
    } Sig;

} CANMsg530Union;

/*****************************************************************************************************
ID  :  0x210
报文： IP_210
信号：
       |- IC_BrkOilLowWarn
       |- IC_SafetyBeltDRVSide
       |- IC_VehSpdDisplayVd
       |- IC_VehSpdDisplay_H
       |- IC_VehSpdDisplay_L
*****************************************************************************************************/
typedef union
{
    uint8_t Msg[8];
    struct
    {

        uint8_t IC_TripDistance_1  : 8;

        uint8_t IC_TripDistance_2  : 8;

        uint8_t IC_TripDistance_3  : 8;

        uint8_t IC_TripDistance_4  : 8;

        uint8_t IC_TotalVehicleDistance1 : 8;

        uint8_t IC_TotalVehicleDistance2 : 8;

        uint8_t IC_TotalVehicleDistance3 : 8;

        uint8_t IC_TotalVehicleDistance4 : 8;

    } Sig;

} CANMsg210Union;

/*****************************************************************************************************
ID  :  0x211
报文： IP_211
信号：
       |- IC_BrkOilLowWarn
       |- IC_SafetyBeltDRVSide
       |- IC_VehSpdDisplayVd
       |- IC_VehSpdDisplay_H
       |- IC_VehSpdDisplay_L
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t  : 8;

        uint8_t IP_shift : 8;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;

        uint8_t  : 8;


    } Sig;

} CANMsg213Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Res0        : 8;
        uint8_t Res1        : 8;
        uint8_t Res2        : 8;
        uint8_t Res3        : 8;
        uint8_t Res4        : 8;
        uint8_t Res5        : 8;
        uint8_t IC_VSpeed_L : 8;
        uint8_t IC_VSpeed_H : 8;
    } Sig;
} CANMsg0CFE6C17Union;

/*****************************************************************************************************
ID  :  0x385
报文： IP_385
信号：
       |- IP_MessageAlertSoundSetStatus
       |- IP_RearSeatbeltWarningEnableFB
       |- IP_WarningVolumeSettingFB
       |- IP_AlarmSoundSetStatus
       |- IP_Adaptivedimminglevel
       |- IP_DimmingModeSetStatus
       |- IP_SoundStyleSetStatus
       |- IP_AlarmSoundStatus
       |- IP_WelcomeSoundSetStatus
       |- IP_DimmingSetStatus
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_MessageAlertSoundSetStatus : 3;    // IP_MessageAlertSoundSetStatus       7
        uint8_t IP_DimmingSetStatus           : 4;    //                           7
        uint8_t IP_MaintainReset              : 1;    //                              7

        uint8_t IP_RearSeatbeltWarningEnableFB : 2;    // IP_RearSeatbeltWarningEnableFB  7
        uint8_t IP_WarningVolumeSettingFB      : 3;    // IP_WarningVolumeSettingFB      7
        uint8_t IP_AlarmSoundSetStatus         : 3;    // IP_AlarmSoundSetStatus      7

        uint8_t IP_Adaptivedimminglevel : 8;    //                      7

        uint8_t IP_DimmingModeSetStatus : 2;
        uint8_t IP_SoundStyleSetStatus  : 3;    // IP_SoundStyleSetStatus      7
        uint8_t IP_AlarmSoundStatus     : 3;    //              7

        uint8_t IP_VehicleSpeedIndicatorOutput_H : 1;
        uint8_t IP_ECnsAvgReset                  : 1;    // ok
        uint8_t IP_WelcomeSoundSetStatus         : 3;    // IP_WelcomeSoundSetStatus
        uint8_t IP_EngineCoolanTemperatureHigh   : 1;    // ok
        uint8_t IP_EngineOilPressureLowSts       : 1;    // ok
        uint8_t IP_FuelLow                       : 1;    // ok

        uint8_t IP_VehicleSpeedIndicatorOutput_M : 8;

        uint8_t                                  : 2;
        uint8_t IP_EnergyDspSts                  : 1;
        uint8_t IP_BrakeFluidState               : 1;
        uint8_t IP_VehicleSpeedIndicatorOutput_L : 4;

        uint8_t IP_RealFuelConsumption : 8;
    } Sig;
} CANMsg385Union;

/*****************************************************************************************************
ID  :  0x52E
报文： IP_52E
信号：
       |- IP_SunroofControlReq
       |- IP_IndirectTPMSReset
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_SunroofControlReq : 8;

        uint8_t                      : 2;
        uint8_t IP_IndirectTPMSReset : 1;
        uint8_t IP_AddOilStatus      : 2;
        uint8_t IP_SmallMapEntry     : 2;
        uint8_t IP_MipiScreenFailure : 1;

        uint8_t IP_ImformationTransmission_Request : 5;
        uint8_t IP_TrafficLaneRecon                : 2;

        uint8_t IP_HUConnection_acknowledge : 2;
        uint8_t IP_MusicEntry               : 2;
        uint8_t IP_HUTaskCounter            : 4;

        uint32_t                     : 32;
    } Sig;
} CANMsg52EUnion;

/*****************************************************************************************************
ID  :  0x69B
报文： IP_69B
信号：
       |- IP_SunroofControlReq
       |- IP_IndirectTPMSReset
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_DTC1_HighByte : 8;
        uint8_t IP_DTC1_MiddByte : 8;
        uint8_t IP_DTC1_LowByte  : 8;
        uint8_t IP_DTC1_Status   : 8;
        uint8_t IP_DTC2_HighByte : 8;
        uint8_t IP_DTC2_MiddByte : 8;
        uint8_t IP_DTC2_LowByte  : 8;
        uint8_t IP_DTC2_Status   : 8;
    } Sig;
} CANMsg69BUnion;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_HUHeartbeat    : 2;
        uint8_t IP_HUConnectReply : 1;
        uint8_t                   : 5;

        uint8_t IP_TimeMinAfterIgnOn : 6;
        uint8_t                      : 2;

        uint8_t IP_TimeHourAfterIgnOn : 7;
        uint8_t                       : 1;

        uint8_t      : 8;
        uint8_t      : 8;
        uint8_t      : 8;
        uint8_t      : 8;
        uint8_t      : 8;
    } Sig;
} CANMsg609Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_RisksAvoidTimes_H : 8;

        uint8_t IP_TotalRisksAvoidTimes_H : 6;
        uint8_t IP_RisksAvoidTimes_L      : 2;

        uint8_t IP_TotalRisksAvoidTimes_L : 8;

        uint8_t IP_AIDrvDisAfterIgnOn_H: 8;

        uint8_t IP_TotalAIDrvDis_H     : 1;
        uint8_t                        : 1;
        uint8_t IP_AIDrvDisAfterIgnOn_L: 6;
        
        uint8_t IP_TotalAIDrvDis_M : 8;
        uint8_t IP_TotalAIDrvDis_L : 8;
        uint8_t      : 8;
    } Sig;
} CANMsg60BUnion;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_SGNameError : 4;
        uint8_t                : 4;

        uint8_t IP_Error : 4;
        uint8_t          : 4;

        uint8_t IP_Statuts : 8;

        uint8_t IP_DteCFe: 8;

        uint8_t IP_DteRfl_H : 2;
        uint8_t IP_CalFuel  : 4;
        uint8_t             : 2;
        
        uint8_t IP_DteRfl_L : 8;

        uint8_t      : 8;
        uint8_t      : 8;
    } Sig;
} CANMsg620Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_HUBuzzerWarning : 8;

        // uint8_t IP_DayBiasLightStatus   : 4;
        // uint8_t IP_NightBiasLightStatus : 4;
        uint8_t IP_BiasLightCurrentSta    : 8;

        uint8_t IP_ShemeColorsSwitchStatus       : 3;
        uint8_t IP_ImformationTransmissionStatus : 5;

        uint8_t IP_ACCInterfaceDisplaySts : 2;
        uint8_t IP_BiasLightCurrentStatus : 2;
        uint8_t IP_SmallWindowStatus      : 4;

        uint8_t                     : 3;
        uint8_t IP_DTEDspMode       : 2;
        uint8_t IP_HUTransFaultType : 3;
        
        uint8_t IP_TotalOdometer_Oil_H : 8;

        uint8_t IP_TotalOdometer_Oil_M : 8;
        uint8_t IP_TotalOdometer_Oil_L : 8;
    } Sig;
} CANMsg640Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_o_FuelTgt : 4;
        uint8_t IP_i_IGN     : 2;
        uint8_t IP_o_Diag    : 2;

        uint8_t IP_VehSpd : 8;
        // uint8_t           : 4;

        uint8_t IP_o_DteCfe_H : 8;
        uint8_t IP_o_DteCfe_L : 8;

        uint8_t IP_o_DteRfl_H : 8;
        uint8_t IP_o_DteRfl_L : 8;

        uint8_t IP_o_DteDisp_H: 8;
        uint8_t IP_o_DteDisp_L: 8;
    } Sig;
} CANMsg6F1Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t o_CurSampFuel_H : 8;

        uint8_t o_CurSampFuel_L : 8;

        uint8_t i_FuelAD_H : 8;

        uint8_t i_FuelAD_L : 8;

        uint8_t o_FuelLeftOver_H : 8;

        uint8_t o_FuelLeftOver_L : 8;
        uint8_t TripMile_H : 8;
        uint8_t TripMile_L : 8;
    } Sig;
} CANMsg6F2Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t AvgVehicleSpeed_H : 8;

        uint8_t AvgVehicleSpeed_L : 8;

        uint8_t InsFc_Lp100km : 8;

        uint8_t InsFc_L_h : 8;

        uint8_t NearFc : 8;

        uint8_t IdleFc_H : 8;
        uint8_t IdleFc_L : 8;
        uint8_t          : 8;
    } Sig;
} CANMsg6F3Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t DrvSig_TimeHour_1_H : 8;

        uint8_t DrvSig_TimeHour_1_L : 8;

        uint8_t DrvSig_TimeMinute_1 : 8;

        uint8_t DrvSig_Mile_1_H : 8;

        uint8_t DrvSig_Mile_1_M : 8;

        uint8_t DrvSig_Mile_1_L : 8;
        uint8_t TripDrvSig_AvgFc_1 : 8;
        uint8_t          : 8;
    } Sig;
} CANMsg6F5Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t DrvSig_TimeHour_2_H : 8;

        uint8_t DrvSig_TimeHour_2_L : 8;

        uint8_t DrvSig_TimeMinute_2 : 8;

        uint8_t DrvSig_Mile_2_H : 8;

        uint8_t DrvSig_Mile_2_M : 8;

        uint8_t DrvSig_Mile_2_L : 8;
        uint8_t TripDrvSig_AvgFc_2 : 8;
        uint8_t          : 8;
    } Sig;
} CANMsg6F7Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t DrvSig_TimeHour_H : 8;

        uint8_t DrvSig_TimeHour_L : 8;

        uint8_t DrvSig_TimeMinute : 8;

        uint8_t DrvSig_Mile_H : 8;

        uint8_t DrvSig_Mile_M : 8;

        uint8_t DrvSig_Mile_L : 8;
        uint8_t TripDrvSig_AvgFc : 8;
        uint8_t          : 8;
    } Sig;
} CANMsg6F8Union;

/*****************************************************************************************************
ID  :  0x28A
报文： IP_28A
信号：
*****************************************************************************************************/
// typedef union
// {
//     uint8_t Msg [ 8 ];
//     struct
//     {
//         uint8_t IP_KEY_UP    : 2;
//         uint8_t IP_KEY_DOWN  : 2;
//         uint8_t IP_KEY_LEFT  : 2;
//         uint8_t IP_KEY_RIGHT : 2;

//         uint8_t                    : 1;
//         uint8_t IP_KEY_CURSTOM     : 2;
//         uint8_t IP_KEY_SPEECH      : 2;
//         uint8_t                    : 1;
//         uint8_t IP_KEY_OK          : 2;

//         uint8_t IP_DisplayMode_2        : 4;
//         uint8_t IP_RaceModeRecordStatus : 2;
//         uint8_t IP_DisplayModeMemory    : 2;

//         uint8_t IP_DisplaySpeed_H : 8;

//         uint8_t                   : 3;
//         uint8_t IP_DisplaySpeed_L : 5;

//         uint8_t : 8;
//         uint8_t : 8;
//         uint8_t : 8;
//     } Sig;
// } CANMsg28AUnion;

/*****************************************************************************************************
ID  :  0x28A
报文： IP_28A
信号：
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_VoiceReq : 8;

        uint8_t IP_VoicePlayTimesReq : 5;
        uint8_t                      : 1;
        uint8_t IP_LFReq             : 2;

        uint8_t IP_MsgWarningReq : 8;

        uint8_t IP_TurnWarningReq         : 3;
        uint8_t IP_AlarmReqRollingCounter : 3;
        uint8_t IP_RFReq                  : 2;

        uint8_t IP_LRReq               : 2;
        uint8_t IP_TypeOfCutSoundShort : 3;
        uint8_t IP_SeatBeltWarningReq  : 3;

        uint8_t IP_VoicePlayCycleReq_H  : 1;
        uint8_t IP_RRReq                : 2;
        uint8_t IP_VoicePlayIntervalReq : 5;

        uint8_t                        : 4;
        uint8_t IP_VoicePlayCycleReq_L : 4;

        uint8_t : 8;
    } Sig;
} CANMsg28AUnion;

/*****************************************************************************************************
ID  :  0x2DE
报文： IP_2DE
信号：
*****************************************************************************************************/
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IP_QDashACCFail        : 2;
        uint8_t IP_DISFail             : 1;
        uint8_t IP_PassengerLCDALEDSts : 1;
        uint8_t IP_DriverLCDALEDSts    : 1;
        uint8_t IP_LongTermClrFlg      : 1;
        uint8_t IP_RefuelEndClrFlg     : 1;
        uint8_t IP_ShortTermClrFlg     : 1;

        uint8_t IP_Odometer_H     : 1;
        uint8_t IP_AddOilMode_Req : 2;
        uint8_t                   : 5;


        uint8_t IP_Odometer_M : 8;

        uint8_t IP_Odometer_L : 8;

        uint8_t IP_EngineSpeedOutput_H : 8;

        uint8_t IP_EngineSpeedOutput_L : 8;

        uint8_t IP_RollingCounter_2DE   : 4;
        uint8_t IP_WholeTermClrFlg      : 1;
        uint8_t IP_SCSSeatBeltControl   : 2;
        uint8_t                         : 2;

        uint8_t IP_CRCCheck_2DE : 8;
    } Sig;
} CANMsg2DEUnion;



#endif
