#include "Backlight.h"
#include "Components.h"
Backlight_User_OPT3004_st_t opt3004;
typedef struct
{
    Light_uint16_t Temperature; /* 温度 */
    Light_uint16_t Resistance;  /* 阻值 */
} _st_Backlight;

typedef struct
{
    Light_uint16_t BacklightLevel; /* 背光等级 */
    Light_uint16_t BacklightDuty;  /* 背光占空比 */
} _st_BacklightLevel;
#define AD_AVE_BUFF_LEN (5)

typedef struct
{
    uint16_t Voltage;    // AD采集电压值
    uint8_t  Degree;     //温度值
} NTCStaticAttrStruct;

//温度数组长度
#define NTC_TEMP_ARRAY_LEN (11)
/*** 温度升表格 ***/
static const NTCStaticAttrStruct NTCStaticAttrs [ NTC_TEMP_ARRAY_LEN ] = {
    {2312, 75},
    {2359, 76},
    {2405, 77},
    {2452, 78},
    {2498, 79},
    {2544, 80},
    {2589, 81},
    {2634, 82},
    {2679, 83},
    {2724, 84},
    {2770, 85},
};

#define Backlight_Max 10
#define BacklightLevel_Max 5
uint8_t NTCDegree;
#define NTCDEGREE NTCDegree
uint8_t Backlight_Cnt = 0;
uint16_t NTC_Time_Count = 0u;
uint8_t NTC_DstSeg = 0u;
uint16_t NTC_Last = 0u;
uint16_t Luminous_Time = 0u;
uint32_t Luminous_Value_Pwm = 0u;
uint16_t Luminous_Value_time = 0u;
uint16_t Luminous_Value_Old = 0u;
uint16_t Luminous_Value_Last = 0u;
uint16_t Luminous_Value_recovery = 0u;

Light_uint16_t GetBacklightDutyByLevel(Light_uint16_t level)
{
    return 0;
}

typedef void (*SetPwm)(Light_uint16_t Pwm);
typedef Light_uint8_t (*SetPwmEnable)(void);
typedef Light_uint8_t (*SetPwmLevel)(void);
typedef Light_uint16_t (*NtcRes)(void);

typedef struct
{
    SetPwm SetPwmCbk;           /* 设置PWM回调函数 */
    SetPwmEnable SetPwmEnCbk;   /* 设置PWM使能回调函数 */
    SetPwmLevel SetPwmLevelCbk; /* 背光等级回调函数 */
    NtcRes NtcResCbk;           /* 获取电阻值回调函数 */
} BackLightExtPara;

typedef struct
{
    SetPwm SetPwmCbk;           /* 设置PWM回调函数 */
    SetPwmEnable SetPwmEnCbk;   /* 设置PWM使能回调函数 */
    SetPwmLevel SetPwmLevelCbk; /* 背光等级回调函数 */
    NtcRes NtcResCbk;
    Light_uint8_t BacklightEn;     /* 背光使能 */
    Light_uint16_t BacklightPwm;   /* 背光PWM */
    Light_uint16_t BacklightLevel; /* 背光等级 */
} _Backlight_Op;

_Backlight_Op Backlight_Operate;


/* 设置PWM回调函数 */
void Backlight_SetPwm(Light_uint16_t Pwm)
{
    // TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, Pwm);
}
/*背光控制函数，此函数需放在50ms调用*/
void Backlight_SetPwm_cotrol(void)
{
    uint32_t Luminous_Value = 0u;
    uint32_t NTC_Value = 0u;
    uint16_t NTC_Valid = 0u;
    OPT3004_Read_Result(&opt3004.u32Result);
    NTC_Value = ADC_Read_Signal(ADC_CH_NTC);
    Luminous_Value = opt3004.u32Result / 10u;//获取光感值
    Luminous_Value_recovery = Luminous_Value;
    if(GetLcdInitSt() == 1)//630初始化
    {
        if(Luminous_Time <= 200u)
        {
            Luminous_Time += 50u;
        }
        else
        {
            if (Backlight_Cnt == 0) // 背光初始化
            {
                Backlight_Cnt = 1;
                TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000u, 64000000u);
                TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_Low);
            }
            if (Common_Get_IG_Sts() == COMMON_POWER_ON)
            {
                if ((Get_Uptime_Staus() == 0u) || (Get_Self() == 1u))
                {
                    TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 300u); // 背光控制
                }
                else
                {
                    if (Luminous_Value <= 300)
                    {
                        Luminous_Value_Old = 1u;
                    }
                    else if ((Luminous_Value <= 400))
                    {
                        Luminous_Value_Old = 2u;
                    }
                    else if ((Luminous_Value <= 600))
                    {
                        Luminous_Value_Old = 3u;
                    }
                    else if ((Luminous_Value <= 700))
                    {
                        Luminous_Value_Old = 4u;
                    }
                    else
                    {
                        Luminous_Value_Old = 5u;
                    }
                    if (Luminous_Value_Last == Luminous_Value_Old) // 持续3s维持同一光感值
                    {
                        if (Luminous_Value_time < 60u)
                        {
                            Luminous_Value_time++;
                        }
                        else
                        {
                            Luminous_Value_Pwm = Luminous_Value_Last;
                        }
                    }
                    else
                    {
                        Luminous_Value_Last = Luminous_Value_Old;
                        Luminous_Value_time = 0u;
                    }
                    if (Luminous_Value_Pwm == 1u) // 根据光感输出背光
                    {
                        Luminous_Value_Pwm = 800u;
                    }
                    else if (Luminous_Value_Pwm == 2u)
                    {
                        Luminous_Value_Pwm = 700u;
                    }
                    else if (Luminous_Value_Pwm == 3u)
                    {
                        Luminous_Value_Pwm = 600u;
                    }
                    else if (Luminous_Value_Pwm == 4u)
                    {
                        Luminous_Value_Pwm = 500u;
                    }
                    else if (Luminous_Value_Pwm == 5u)
                    {
                        Luminous_Value_Pwm = 300u;
                    }
                /*NTC控制背光，优先级高于光感*/
                if (NTCDegree < 75)
                {
                }
                else if ((NTCDegree <= 80))
                {
                  Luminous_Value_Pwm = ( 1000u - ((1000u - Luminous_Value_Pwm) * 8u / 10u )); 
                  Luminous_Value_time = 60u;
                }
                else if ((NTCDegree <= 85))
                {
                  Luminous_Value_Pwm = ( 1000u - (( 1000u - Luminous_Value_Pwm) * 7u / 10u ));
                  Luminous_Value_time = 60u;
                }
                else
                {
                  Luminous_Value_Pwm = ( 1000u - (( 1000u - Luminous_Value_Pwm) * 2u / 10u ));
                  Luminous_Value_time = 60u;
                }
                TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, Luminous_Value_Pwm); // 背光控制
                }

            }
            else
            {
                TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0u); // 下15电置零
                Luminous_Value_time = 60u;
                Luminous_Value = 0u;
                Luminous_Value_Old = 0u;
                Luminous_Value_Last = 0u;
                Backlight_Cnt = 0;
                Luminous_Time = 0;
                NTCDegree = 0u;
            }
        }
    }
}
/* 设置PWM使能回调函数 */
Light_uint8_t Backlight_SetPwmEn(void)
{
    
    return 1;
}

/* 背光等级回调函数 */
Light_uint8_t Backlight_SetPwmLevel(void)
{

    return 1;
}

/* 获取电阻值回调函数 */
Light_uint8_t Backlight_NtcRes(void)
{

    return 1;
}

void Backlight_Init(BackLightExtPara *backlightInit)
{
    Backlight_Operate.SetPwmCbk = backlightInit->SetPwmCbk;
    Backlight_Operate.SetPwmEnCbk = backlightInit->SetPwmEnCbk;
    Backlight_Operate.SetPwmLevelCbk = backlightInit->SetPwmLevelCbk;
    Backlight_Operate.NtcResCbk = backlightInit->NtcResCbk;
}

void Backlight_KL30_Wakeup_Init(void)
{
    Backlight_Cnt = 0;
    Luminous_Time = 0u;
    Luminous_Value_time = 60u;
    Luminous_Value_Old = 0u;
    Luminous_Value_Last = 0u;
    Luminous_Value_recovery = 0u;
    NTC_Time_Count = 0u;
    NTC_DstSeg = 0u;
    NTC_Last = 0u;
    NTCDegree = 0u;
}



/**
 * 根据给定的背光表和输入电阻值，获取对应的温度值。
 * 这个函数通过线性插值方法在背光表中查找与输入电阻最接近的温度值。
 * @param backlightTable 背光表，包含电阻和对应温度的数组。
 * @param size 背光表的大小，即数组的元素个数。
 * @param input 输入的电阻值。
 * @return 返回对应的温度值。
 */
Light_uint16_t Get_Ntc_Temp(_st_Backlight *backlightTable, Light_uint8_t size, Light_uint16_t input)
{
    Light_uint16_t result = 0;
    Light_uint32_t temp = 0;
    Light_uint8_t i = 0;

    if (input >= backlightTable[0].Resistance)
    {
        result = backlightTable[0].Temperature;
    }
    else if (input <= backlightTable[size - 1].Resistance)
    {
        result = backlightTable[size - 1].Temperature;
    }
    else
    {
        for (i = 0; i < size - 1; i++)
        {
            if ((input < backlightTable[i].Resistance) && (input >= backlightTable[i + 1].Resistance))
            {
                temp = backlightTable[i + 1].Temperature - backlightTable[i].Temperature;
                temp *= (backlightTable[i].Resistance - input);
                temp /= (backlightTable[i].Resistance - backlightTable[i + 1].Resistance);
                temp += backlightTable[i].Temperature;
                result = (Light_uint16_t)temp;
                break;
            }
        }
    }

    return result;
}

Light_uint16_t Get_Pwm_Factor_Optimized(Light_uint16_t CurrentTemp)
{
}

typedef struct
{
    Light_uint8_t destFactor;
    Light_uint8_t curFactor;
    Light_uint16_t NtcDelayTimer;
    Light_uint16_t u16DialcurDuty;
    Light_uint16_t u16DialdestDuty;
    Light_uint16_t u16DialDampingTimer;
} _st_BacklightFactor_Ctrl;

_st_BacklightFactor_Ctrl BacklightFactorCtrl;

/**
 * @brief 实现数据的渐变效果
 * 该函数用于更新当前值，使其逐渐接近目标值，渐变的步长由step参数控制。同时，通过timer参数来实现一定的延迟效果，
 * 仅当计时器达到或超过预设的timedelay时，才会进行一次渐变操作。这有助于平滑数据的变化，避免突变。
 * @param cur 当前值的指针，函数将更新这个值
 * @param dest 目标值，当前值将逐渐变化到这个值
 * @param step 每次变化的步长
 * @param timer 计时器的指针，用于实现变化的延迟
 * @param timedelay 延迟的时间阈值，当计时器达到或超过这个值时，才会进行变化
 */
void U16_Data_Gradient(Light_uint16_t *cur, Light_uint16_t dest, Light_uint16_t step, Light_uint16_t *timer, const Light_uint16_t timedelay)
{
    if (*cur > dest)
    {
        if ((*cur - dest) > step)
        {
            if (*timer >= timedelay)
            {
                (*cur) -= step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
    else
    {
        if ((dest - *cur) > step)
        {
            if (*timer >= timedelay)
            {
                (*cur) += step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
}

//根据电压值，确定热敏电阻的温度(摄氏度)
uint8_t ADProcess_NTC_Temp_Get(uint16_t NTCVoltage)
{
    uint8_t i;

    if ( NTCVoltage < 2312 )
        return 0;

    if ( NTCVoltage > 5000 )
        return 0;

    if ( (NTCVoltage > 2770) && (NTCVoltage < 5000) )
        return 85;

    //寻找所在的温度段
    for ( i = 0; i < NTC_TEMP_ARRAY_LEN; i++ )
    {
        if ( NTCVoltage <= NTCStaticAttrs [ i ].Voltage )
            return NTCStaticAttrs [ i ].Degree;
    }
    return 0;
}

//获取热敏电阻采集温度服务
//周期：20ms
void ADProcess_NTC_Temp_Service(void)
{
    //热敏电阻电压采集消抖
    static uint8_t  CalcCnt          = 0;
    static uint32_t Calc             = 0;
    uint32_t        AnalogNtcVoltage = 0;

    if ( ADC_Read_Signal_Valid(ADC_CH_NTC_R) == 1 )
    {
        AnalogNtcVoltage = ADC_Read_Signal(ADC_CH_NTC);
        AnalogNtcVoltage *= 5000;
        AnalogNtcVoltage /= 4096;
        if ( AnalogNtcVoltage < 5000 )
        {

            //采集次数增加
            CalcCnt++;
            //采集值累计
            Calc += AnalogNtcVoltage;

            //采集次数超过50次，取平均值（50*20ms=1S）
            if ( CalcCnt >= 50 )
            {
                //热敏电阻的采集电压有效，获取对应的温度值
                NTCDegree = ADProcess_NTC_Temp_Get(Calc / 50);
                //重新采集50次
                CalcCnt = 0;
                Calc    = 0;
            }
        }
        // end
    }
    //采集的电压异常
}

void Luminous_Time_Alter(uint16_t Val)
{
    Luminous_Time = Val;
}

void Luminous_Value_Pwm_Alter(uint16_t Val)
{
    Luminous_Value_Pwm = Val;
}
uint16_t Get_Luminous_Value_Pwm(void)
{
    return Luminous_Value_Pwm;
}
uint16_t Get_Luminous_Value_recovery(void)
{
    return Luminous_Value_recovery;
}

