
#include "Data_VSpeed.h"
#include "Components.h"
#include "CommonInterface.h"
#include "PowerManagement\PowerManag_user.h"
#include  "CAN_CH0_CAN_Communication_Matrix.h"
#include "FreIn.h"
#include "FreIn_User.h"

uint32_t DataVSpeedActual;
uint32_t DataVSpeedActual_ignoreError;
uint32_t DataVSpeedDisp;
uint32_t DataVSpeedHysteresis;
uint8_t  DataVSpeedValid;
uint8_t  DataVSpeedstaus;
uint8_t Offline_timer = 0;
uint16_t timerDataVSpeed = 0;
uint32_t Vspeed = 0;
uint8_t Vehicle_Speed_Duty_Valid = 0u;
uint8_t Vehicle_Speed_Duty_HZ_Valid = 0u;
uint16_t Speed_Self_InspectionTimer = 0u;
uint32_t Speed_Self_Inspection_Last = 0u;
uint32_t timerDutyDataVSpeed = 0u;
uint32_t Vehicle_Speed_HZ_Last = 0u;
DataVSpeedSamplerStruct DataVSpeedSampler;
DataVSPeedDampingStruct DataVSPeedDamping;
uint8_t V_DstSeg = 0u;
#define DATA_APPR_DIR_INC 0x01
#define DATA_APPR_DIR_DEC 0x02
/*** 车速频率升表格 ***/
static const uint16_t Vehicle_Speed_Duty_Table_Up [4u] =
    /*显示段：| 0 | 1 |  2   |  3  | 4 |  ...*/
{10500, 20200,30200,40200}; // 上升时小于等于表值则熄灭相应段

/***车速频率下降表格 ***/
static const uint16_t Vehicle_Speed_Duty_Table_Dn [ 4u ] =
    /*显示段：|    0     |    1     |    2     |    3     |    4     |      ...*/
{10000,19700,29700,39700}; // 下降时小于等于表值则熄灭相应段

/******************************************************************************
函数名：Data_Vehicle_Speed_KL30_Init
功  能：车速数据KL30初始化
参  数：无
返回值：无
******************************************************************************
注  意：该函数KL30初始化被调用一次
******************************************************************************/
void Data_Vehicle_Speed_KL30_Init(void)
{
    DataVSpeedActual             = 0;
    DataVSpeedActual_ignoreError = 0;
    DataVSpeedDisp               = 0;
    DataVSpeedHysteresis         = 0;
    DataVSpeedValid              = 0;
    DataVSpeedSampler.Cnt        = 0;
    DataVSPeedDamping.Speed      = 0;
    DataVSPeedDamping.Delta      = 0;
    DataVSpeedstaus              = 0;
    Offline_timer                = 0;
    timerDataVSpeed              = 0;
    V_DstSeg                     = 0u;
    Vehicle_Speed_HZ_Last        = 0u;
    Vehicle_Speed_Duty_Valid     = 1u;
    Vehicle_Speed_Duty_HZ_Valid  = 1u;
    DataVSPeedDamping.Dir        = DATA_APPR_DIR_INC;
}

/******************************************************************************
函数名：Data_Vehicle_Speed_Wakeup_Init
功  能：车速数据唤醒初始化
参  数：无
返回值：无
******************************************************************************
注  意：该函数唤醒初始化被调用一次
******************************************************************************/
void Data_Vehicle_Speed_Wakeup_Init(void)
{
    DataVSpeedDisp          = 0;
    DataVSpeedHysteresis    = 0;
    DataVSPeedDamping.Speed = 0;
    DataVSPeedDamping.Delta = 0;
    DataVSpeedstaus         = 0;
    Offline_timer           = 0;
    timerDataVSpeed         = 0;
    V_DstSeg                = 0u;
    Vehicle_Speed_HZ_Last   = 0u;
    Vehicle_Speed_Duty_Valid = 1u;
    Vehicle_Speed_Duty_HZ_Valid = 1u;
    DataVSPeedDamping.Dir   = DATA_APPR_DIR_INC;
}
/******************************************************************************
函数名：Data_Vehicle_Speed_Duty_Cycle_Detection
功  能：车速占空比检测函数
参  数：无
返回值：无
******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_Vehicle_Speed_Duty_Cycle_Detection(void)
{
    uint32_t Vehicle_Speed_HZ = 0U;
    uint32_t Vehicle_Speed_Duty = 0u;
    uint8_t  Vehicle_Speed_Dut_Valid = 0u;
    if (Fre_In_Get_Channel_Status(FRE_VEHICLE) == FRE_STATUS_VALID)
    {
        Vehicle_Speed_HZ += Fre_In_Get_Channel_HZ(FRE_VEHICLE);
        Vehicle_Speed_Duty = Fre_In_Get_Channel_Duty(FRE_VEHICLE);
    }
    if (Vehicle_Speed_HZ > Vehicle_Speed_HZ_Last) // 新燃油液位高于前次燃油液位,查上升表
    {
        while (V_DstSeg < 5u)
        {
            if (Vehicle_Speed_HZ < Vehicle_Speed_Duty_Table_Up[V_DstSeg])
                break;
            V_DstSeg++;
        }
    }
    else if (Vehicle_Speed_HZ < Vehicle_Speed_HZ_Last) // 新燃油液位低于前次燃油液位,查下降表
    {
        while (V_DstSeg)
        {
            if (Vehicle_Speed_HZ > Vehicle_Speed_Duty_Table_Dn[V_DstSeg - 1u])
                break;
            V_DstSeg--;
        }
    }
    Vehicle_Speed_HZ_Last = Vehicle_Speed_HZ;
    Vehicle_Speed_Dut_Valid = V_DstSeg;
    if (Vehicle_Speed_Dut_Valid == 1)
    {
        if ((Vehicle_Speed_Duty >= 120) && (Vehicle_Speed_Duty <= 880))
        {
            Vehicle_Speed_Duty_Valid = 1u;
            Vehicle_Speed_Duty_HZ_Valid = 1u;
        }
        else
        {
            Vehicle_Speed_Duty_Valid = 0u;
        }
    }
    else if (Vehicle_Speed_Dut_Valid == 2)
    {
        if ((Vehicle_Speed_Duty >= 170) && (Vehicle_Speed_Duty <= 830))
        {
            Vehicle_Speed_Duty_Valid = 1u;
            Vehicle_Speed_Duty_HZ_Valid = 1u;
        }
        else
        {
            Vehicle_Speed_Duty_Valid = 0u;
        }
    }
    else if (Vehicle_Speed_Dut_Valid >= 3)
    {
        if ((Vehicle_Speed_Duty >= 250) && (Vehicle_Speed_Duty <= 750))
        {
            Vehicle_Speed_Duty_Valid = 1u;
            Vehicle_Speed_Duty_HZ_Valid = 1u;
        }
        else
        {
            Vehicle_Speed_Duty_Valid = 0u;
        }
    }
    else
    {
        Vehicle_Speed_Duty_Valid = 1u;
        Vehicle_Speed_Duty_HZ_Valid = 1u;
    }
}
/******************************************************************************
函数名：Data_Vehicle_Speed_Processing_Service
功  能：车速数据处理函数
参  数：无
返回值：无
******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_Vehicle_Speed_Processing_Service(void)
{
    uint8_t  i         = 0U;
    uint16_t Delta     = 0U;
    uint32_t VSpeed    = 0U;
    uint32_t VSpeedCal = 0U;
    uint32_t VSpeedpwm = 0U;
    static uint8_t time = 0;
    static uint32_t MeanValue = 0;
    static uint32_t MeanValueA = 0;
    //上电
    if(Common_Get_IG_Sts( ) == COMMON_POWER_ON )
    {
        // 第1步：获取实际车速值及车速有效性
        if (Fre_In_Get_Channel_Status(FRE_VEHICLE) == FRE_STATUS_VALID)
        {
            DataVSpeedstaus = 1;
            time++;
            MeanValue += Fre_In_Get_Channel_HZ(FRE_VEHICLE);
            if (time == 5)
            {
                MeanValue /= 50;
                MeanValueA = MeanValue;
                MeanValue = 0;
                time = 0;
            }
            if (MeanValueA > 10000)
            {
                DataVSpeedValid = 0;
                DataVSpeedActual = 0;
                DataVSpeedActual_ignoreError = 0;
                DataVSpeedSampler.Cnt = 0;
            }
            else
            {
                if (Vehicle_Speed_Duty_HZ_Valid  == 1)
                {
                    if (DataVSpeedValid == 0)
                    {
                        DataVSpeedValid = 1;
                        VSpeed = Fre_In_Get_Channel_HZ(FRE_VEHICLE)*100u;
                        // VSpeed = MeanValueA * 100;
                        if (Get_Dis_Sizes() == 1)
                        {
                            VSpeed /= 2425;
                        }
                        if (Get_Dis_Sizes() == 3)
                        {
                            VSpeed /= 2183;
                        }
                        DataVSpeedActual_ignoreError = (uint16_t)VSpeed;
                        if (VSpeed > 1990)
                        {
                            VSpeed = 1990;
                        }
                        DataVSpeedActual = (uint16_t)VSpeed;
                    }
                    else
                    {
                        DataVSpeedSampler.Buffer[DataVSpeedSampler.Cnt] = Fre_In_Get_Channel_HZ(FRE_VEHICLE) / 10;
                        i = DataVSpeedSampler.Cnt;
                        while ((i > 0) && (DataVSpeedSampler.Buffer[i] < DataVSpeedSampler.Buffer[i - 1]))
                        {
                            VSpeed = DataVSpeedSampler.Buffer[i];
                            DataVSpeedSampler.Buffer[i] = DataVSpeedSampler.Buffer[i - 1];
                            DataVSpeedSampler.Buffer[i - 1] = (uint16_t)VSpeed;
                            i--;
                        }

                        DataVSpeedSampler.Cnt++;
                        if (DataVSpeedSampler.Cnt >= 3)
                        {
                            DataVSpeedSampler.Cnt = 0;
                            VSpeed = DataVSpeedSampler.Buffer[1];
                            if (VSpeed > 10000)
                            {
                                VSpeed = 0;
                            }
                            else
                            {
                                VSpeed *= 1000;
                                if (Get_Dis_Sizes() == 1)
                                {
                                    VSpeed /= 2425;
                                }
                                if (Get_Dis_Sizes() == 3)
                                {
                                    VSpeed /= 2183;
                                }
                            }
                            DataVSpeedActual_ignoreError = (uint16_t)VSpeed;
                            if (VSpeed > 1990)
                            {
                                VSpeed = 1990;
                            }
                            DataVSpeedActual = (uint16_t)VSpeed;
                        }
                    }
                }
                else
                {
                    DataVSpeedValid = 0;
                    DataVSpeedActual = 0;
                    DataVSpeedActual_ignoreError = 0;
                    DataVSpeedSampler.Buffer[0] = 0;
                    DataVSpeedSampler.Buffer[1] = 0;
                    DataVSpeedSampler.Buffer[2] = 0;
                    DataVSpeedSampler.Cnt = 0;
                }
                if ((Fre_In_Get_Channel_HZ(FRE_VEHICLE) > 73000))
                {
                    if (timerDataVSpeed >= 250)
                    {
                        DataVSpeedActual = 0;
                        Vehicle_Speed_Duty_HZ_Valid = 0u;

                    }
                    else
                    {
                        timerDataVSpeed++;
                    }
                }
                else
                {
                    timerDataVSpeed = 0;
                }
                if((Vehicle_Speed_Duty_Valid == 0))
                {
                    if (timerDutyDataVSpeed >= 50)
                    {
                        DataVSpeedActual = 0;
                        DataVSpeedValid = 0;
                        Vehicle_Speed_Duty_HZ_Valid = 0u;
                    }
                    else
                    {
                        timerDutyDataVSpeed++;
                    }
                }
                else
                {
                    timerDutyDataVSpeed = 0u;
                }
            }
        }
        else
        {
            DataVSpeedValid = 0;
            DataVSpeedActual = 0;
            DataVSpeedActual_ignoreError = 0;
            DataVSpeedSampler.Buffer[0] = 0;
            DataVSpeedSampler.Buffer[1] = 0;
            DataVSpeedSampler.Buffer[2] = 0;
            DataVSpeedSampler.Cnt = 0;
        }
    }
    else
    {
        DataVSpeedValid = 0;
        DataVSpeedActual = 0;
        DataVSpeedActual_ignoreError = 0;
        DataVSpeedSampler.Buffer[0] = 0;
        DataVSpeedSampler.Buffer[1] = 0;
        DataVSpeedSampler.Buffer[2] = 0;
        DataVSpeedSampler.Cnt = 0;
        DataVSpeedstaus = 0;
    }


    // 第2步：车速的阻尼处理
    VSpeed = DataVSpeedActual;
    if ( VSpeed > DataVSPeedDamping.Speed )    // 实际值比当前显示值大时
    {
        Delta = ( uint16_t )VSpeed - DataVSPeedDamping.Speed;

        if ( DataVSPeedDamping.Dir == DATA_APPR_DIR_INC )    // 显示值正在向实际值增加,则维持当前方向调节增加速度
        {
            if ( DataVSPeedDamping.Delta < Delta )           // 当前增量小于显示值与实际值的差值,则提升增加的速度
            {
                DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
                if ( DataVSPeedDamping.Delta > Delta )
                    DataVSPeedDamping.Delta = Delta;
            }
            else    // 当前增量大于等于显示值与实际值的差值,保持增量与当前差值同步,增加的速度即逐步减小
                DataVSPeedDamping.Delta = Delta;

            Delta = DataVSPeedDamping.Delta;
            Delta /= DATA_VSPEED_DAMPING_FACTOR;

            if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )
                Delta = DATA_VSPEED_APPR_SPEED_MIN;

            DataVSPeedDamping.Speed += Delta;
            if ( DataVSPeedDamping.Speed > VSpeed )
                DataVSPeedDamping.Speed = ( uint16_t )VSpeed;
        }
        else    // 显示值正在减小,则尽快减速至速度为最小时更换方向
        {
            if ( DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP )
                DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
            else
                DataVSPeedDamping.Delta = 0;

            Delta = DataVSPeedDamping.Delta;
            Delta /= DATA_VSPEED_DAMPING_FACTOR;

            if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )         // 已减速至最小速度
                DataVSPeedDamping.Dir = DATA_APPR_DIR_INC;    // 更换方向
            else
            {
                if ( DataVSPeedDamping.Speed > Delta )
                    DataVSPeedDamping.Speed -= Delta;
                else
                    DataVSPeedDamping.Speed = 0;
            }
        }
    }
    else if ( VSpeed < DataVSPeedDamping.Speed )    // 实际值比当前显示值小时
    {
        Delta = DataVSPeedDamping.Speed - ( uint16_t )VSpeed;

        if ( DataVSPeedDamping.Dir == DATA_APPR_DIR_INC )    // 显示值仍在增加,则尽快减速至速度为最小时更换方向
        {
            if ( DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP )
                DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
            else
                DataVSPeedDamping.Delta = 0;

            Delta = DataVSPeedDamping.Delta;
            Delta /= DATA_VSPEED_DAMPING_FACTOR;

            if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )         // 已减速至最小速度
                DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC;    // 更换方向
            else
            {
                DataVSPeedDamping.Speed += Delta;
                if ( DataVSPeedDamping.Speed > 1990 )
                     DataVSPeedDamping.Speed = 1990;
            }
        }
        else                                          // 显示值正在向实际值减小,则维持当前方向调节增加速度
        {
            if ( DataVSPeedDamping.Delta < Delta )    // 当前(负)增量小于显示值与实际值的差值,则提升减小的速度
            {
                DataVSPeedDamping.Delta += DATA_VSPEED_INC_STEP;
                if ( DataVSPeedDamping.Delta > Delta )
                    DataVSPeedDamping.Delta = Delta;
            }
            else    // 当前(负)增量大于等于显示值与实际值的差值,保持(负)增量与当前差值同步,减小的速度即逐步减小
                DataVSPeedDamping.Delta = Delta;

            Delta = DataVSPeedDamping.Delta;
            Delta /= DATA_VSPEED_DAMPING_FACTOR;

            if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )
                Delta = DATA_VSPEED_APPR_SPEED_MIN;

            if ( DataVSPeedDamping.Speed < VSpeed + Delta )
                DataVSPeedDamping.Speed = ( uint16_t )VSpeed;
            else
                DataVSPeedDamping.Speed -= Delta;
        }
    }
    else    // 实际值与当前显示值相等时
    {
        Delta = DataVSPeedDamping.Delta;
        Delta /= DATA_VSPEED_DAMPING_FACTOR;

        if ( Delta > DATA_VSPEED_APPR_SPEED_MIN )                    // 当前的速度不是最小,说明数值正在增加/减小中,则继续原过程
        {
            if ( DataVSPeedDamping.Delta > DATA_VSPEED_DEC_STEP )    // 显示值越过了实际值,必然要先减速至最小速度,再改变方向返回实际值
                DataVSPeedDamping.Delta -= DATA_VSPEED_DEC_STEP;
            else
                DataVSPeedDamping.Delta = 0;

            Delta = DataVSPeedDamping.Delta;
            Delta /= DATA_VSPEED_DAMPING_FACTOR;

            if ( DataVSPeedDamping.Dir == DATA_APPR_DIR_INC )     // 显示值当前是增加方向
            {
                if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )         // 已减速至最小速度
                    DataVSPeedDamping.Dir = DATA_APPR_DIR_DEC;    // 更换方向
                else
                {
                    DataVSPeedDamping.Speed += Delta;
                    if ( DataVSPeedDamping.Speed > 1990 )
                         DataVSPeedDamping.Speed = 1990;
                }
            }
            else                                                  // 显示值当前是减小方向
            {
                if ( Delta < DATA_VSPEED_APPR_SPEED_MIN )         // 已减速至最小速度
                    DataVSPeedDamping.Dir = DATA_APPR_DIR_INC;    // 更换方向
                else
                {
                    if ( DataVSPeedDamping.Speed > Delta )
                        DataVSPeedDamping.Speed -= Delta;
                    else
                        DataVSPeedDamping.Speed = 0;
                }
            }
        }
    }

    // 第3步：生成显示车速
     if ( (DataVSPeedDamping.Speed >= DataVSpeedHysteresis))
    {
        if ( DataVSPeedDamping.Speed - DataVSpeedHysteresis >= DATA_VSPEED_HYSTERESIS )
        {
            DataVSpeedHysteresis = DataVSPeedDamping.Speed;
        }
    }
    else
    {
        if ( DataVSpeedHysteresis - DataVSPeedDamping.Speed >= DATA_VSPEED_HYSTERESIS )
        {
            DataVSpeedHysteresis = DataVSPeedDamping.Speed;
        }
    }

    VSpeedCal = (uint32_t)DataVSpeedHysteresis;
    if ((Get_Self() != 1) && (Get_Uptime_Staus() != 0))
    {
        // if (1)
        // {
            VSpeedCal *= 106;
            VSpeedCal /= 100;
            if ((VSpeedCal % 10) >= 5)
            {
                VSpeedCal += 5; /* 四舍五入 */
            }
            DataVSpeedDisp = (uint16_t)VSpeedCal;
        // }
        // else
        // {
        //     DataVSpeedDisp = 0;
        // }
        if (Get_Dis_Unit() == 1)
        {
            DataVSpeedDisp *= 256;
            DataVSpeedDisp /= 412;
            if (DataVSpeedDisp >= 1233)
            {
                DataVSpeedDisp = 1240;
            }
            Vspeed = DataVSpeedDisp;
        }
        else
        {
            Vspeed = DataVSpeedDisp;
        }
    }
}
void Speed_Self_Inspection(void)
{
    if (Get_Voltage_Anomaly() == 2u)
    {
    }
    else
    {
        if (Get_Uptime_Staus() == 0)
        {
            Speed_Self_InspectionTimer = 0u;
            Speed_Self_Inspection_Last = 0u;
        }
        if (Get_Dis_Old_Staus() == 3)
        {
            Speed_Self_InspectionTimer = 0u;
        }
        if (Common_Get_IG_Sts() == COMMON_POWER_OFF)
        {
            Speed_Self_InspectionTimer = 0u;
            Speed_Self_Inspection_Last = 0u;
        }
        else
        {
            if (Speed_Self_InspectionTimer <= 202)
            {
                if (Speed_Self_InspectionTimer >= 1u)
                {
                    Speed_Self_InspectionTimer++;
                    Vspeed = 0u;
                    DataVSpeedValid = 0u;
                    if (Speed_Self_InspectionTimer <= 102u)
                    {
                        Speed_Self_Inspection_Last += 202u;
                        DataVSpeedDisp = (Speed_Self_Inspection_Last / 10u);
                    }
                    else
                    {
                        Speed_Self_Inspection_Last -= 202u;
                        DataVSpeedDisp = (Speed_Self_Inspection_Last / 10u);
                    }
                }
                else
                {
                    if (GetLcdInitSt() == 1)
                    {
                        if (Get_Uptime_Staus() == 1u)
                        {
                            Speed_Self_InspectionTimer++;
                        } 
                    }
                }
            }
            else
            {
            }
        }
    }
}

/*车速有效位：有效=1，无效=0*/
uint8_t Get_VechileSpeedValid(void)
{
    return DataVSpeedValid;
}
/*真实的车速，精度10倍,*/
uint32_t Get_ActualVechileSpeed(void)
{
    return DataVSpeedActual;
}
/*显示车速，精度10倍，取整，舍去小数点*/
uint32_t Get_DispVechileSpeed(void)
{
    Vspeed = DataVSpeedDisp;
    return Vspeed;
}



