import subprocess
from pathlib import Path

# 定义不同版本的 iarbuild.exe 路径
IARBUILD_VERSIONS = {
    1: r"C:\Program Files (x86)\IAR Systems\Embedded Workbench 9.0\common\bin\iarbuild.exe",
    2: r"C:\Program Files (x86)\IAR Systems\Embedded Workbench 8.4\common\bin\iarbuild.exe",
    3: r"C:\Program Files\IAR Systems\Embedded Workbench 9.1\common\bin\iarbuild.exe"
}


def build_iar_project(ewp_path, build_type, build_mode="Debug"):
    """
    使用指定版本的 iarbuild.exe 编译项目

    参数:
        ewp_path: IAR 项目文件路径 (str 或 Path)
        build_type: 编译器版本 (1, 2, 3 等)
        build_mode: 编译模式 (Debug/Release)

    返回:
        tuple: (success: bool, output: str, error: str)
    """
    # 获取对应版本的编译器路径
    iarbuild_path = IARBUILD_VERSIONS.get(build_type)
    if not iarbuild_path:
        return False, "", f"Invalid build type: {build_type}"

    if not Path(iarbuild_path).exists():
        return False, "", f"iarbuild.exe not found at: {iarbuild_path}"

    if not Path(ewp_path).exists():
        return False, "", f"Project file not found: {ewp_path}"

    # 执行编译命令
    result = subprocess.run(
        [iarbuild_path, str(ewp_path), "-build", build_mode, "-log", "errors"],
        capture_output=True,
        text=True
    )

    # 返回编译结果
    return (
        result.returncode == 0,
        result.stdout,
        result.stderr
    )


# 示例调用
if __name__ == "__main__":
    # 示例参数
    project_file = r".\C655_V0.01\IARProject\C655.ewp"
    selected_version = 1  # 1 对应 IAR 9.0

    # 调用编译函数
    success, output, error = build_iar_project(project_file, selected_version)

    # 处理返回结果（这部分由调用者决定）
    print(f"Success: {success}")
    if output:
        print(f"Output:\n{output}")
    if error:
        print(f"Error:\n{error}")

    # 可以根据 success 决定后续操作
    if not success:
        exit(1)