import os
import shutil
import stat
import subprocess
import requests

from model.RecvData import GitlabPayload


def bk():
    # ======== 配置信息 ========
    GITLAB_URL = "http://tyw-server.synology.me:12345"
    GITLAB_API_TOKEN = "3WxJ46oPKLTeEmDQAPp8"
    GITLAB_PROJECT_ID = "1556"
    BUILD_FILE = "files/output.zip"
    LOCAL_REPO_PATH = "dist"
    TAG_NAME = "v1.0.1"
    BRANCH_NAME = "xxx"

    # 带用户名和 token 的 clone 地址（推荐 token 代替密码）
    repo_url = f"http://oauth2:{GITLAB_API_TOKEN}@tyw-server.synology.me:12345/shihaixin/autocompliecode.git"

    # ======== 工具函数 ========
    def remove_readonly(func, path, _):
        os.chmod(path, stat.S_IWRITE)
        func(path)

    def tag_exists(tag_name):
        result = subprocess.run(["git", "-C", LOCAL_REPO_PATH, "tag"], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        tag_output = result.stdout.decode()
        return tag_name in tag_output.splitlines()

    # ======== 步骤 1: 拉取代码 ========
    if os.path.exists(LOCAL_REPO_PATH):
        shutil.rmtree(LOCAL_REPO_PATH, onerror=remove_readonly)
        print(f"🧹 已删除目录: {LOCAL_REPO_PATH}")

    os.makedirs(LOCAL_REPO_PATH)
    print(f"✅ 已重新创建目录: {LOCAL_REPO_PATH}")

    subprocess.run(["git", "clone", "-b", BRANCH_NAME, repo_url, LOCAL_REPO_PATH], check=True)
    print(f"✅ 仓库克隆完成: {repo_url} (分支: {BRANCH_NAME})")

    # ======== 步骤 2: 模拟构建产物 ========
    print("🚧 模拟编译中...")

    if not os.path.exists(BUILD_FILE):
        with open(BUILD_FILE, "w") as f:
            f.write("This is a mock build file.\n")
    print(f"✅ 编译完成，生成产物: {BUILD_FILE}")

    # ======== 步骤 3: 创建 tag 并推送 ========
    if tag_exists(TAG_NAME):
        print(f"⚠️ Git tag '{TAG_NAME}' 已存在，跳过创建。")
    else:
        subprocess.run(["git", "-C", LOCAL_REPO_PATH, "tag", TAG_NAME], check=True)
        subprocess.run(["git", "-C", LOCAL_REPO_PATH, "push", "origin", TAG_NAME], check=True)
        print(f"🏷️ Git tag '{TAG_NAME}' created and pushed.")

    # ======== 步骤 4: 上传构建产物 ========
    with open(BUILD_FILE, "rb") as f:
        files = {"file": (os.path.basename(BUILD_FILE), f)}
        headers = {"PRIVATE-TOKEN": GITLAB_API_TOKEN}
        upload_url = f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}/uploads"
        response = requests.post(upload_url, headers=headers, files=files)

    if response.status_code != 201:
        print(f"❌ 上传构建产物失败: {response.text}")
        exit(1)

    file_info = response.json()
    file_url = file_info["url"]
    print(f"✅ 文件上传成功: {file_url}")

    # ======== 步骤 5: 创建或更新 Release ========
    release_payload = {
        "name": f"Release {TAG_NAME}",
        "tag_name": TAG_NAME,
        "description": f"Auto released for tag {TAG_NAME}",
        "assets": {
            "links": [
                {
                    "name": os.path.basename(BUILD_FILE),
                    "url": f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}{file_url}"
                }
            ]
        }
    }

    release_url = f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}/releases"
    release_res = requests.post(release_url, headers=headers, json=release_payload)

    if release_res.status_code == 409:
        # 已存在 Release，更新之
        update_url = f"{release_url}/{TAG_NAME}"
        release_res = requests.put(update_url, headers=headers, json=release_payload)

    if release_res.ok:
        print(f"🚀 Release 发布成功: {TAG_NAME}")
    else:
        print(f"❌ Release 发布失败: {release_res.status_code} - {release_res.text}")


def creatTagAndRelease(recv_data: GitlabPayload, confDict: dict, url: str):
    # url=shihaixin/autocompliecode.git
    # ======== 配置信息 ========
    GITLAB_URL = "http://tyw-server.synology.me:12345"  # 地址可以写死，暂时不换
    GITLAB_API_TOKEN = "3WxJ46oPKLTeEmDQAPp8"  # 需要替换，当前是我的token
    GITLAB_PROJECT_ID = recv_data.metadata.project_id
    BUILD_FILE = confDict['jar_project_url']
    LOCAL_REPO_PATH = confDict['build_dist_url'] + "//dist"
    TAG_NAME = confDict['tag_name']
    BRANCH_NAME = recv_data.commit.branch

    # 带用户名和 token 的 clone 地址（推荐 token 代替密码）
    repo_url = f"http://oauth2:{GITLAB_API_TOKEN}@tyw-server.synology.me:12345/{url}"

    # ======== 工具函数 ========
    def remove_readonly(func, path, _):
        os.chmod(path, stat.S_IWRITE)
        func(path)

    def tag_exists(tag_name):
        result = subprocess.run(["git", "-C", LOCAL_REPO_PATH, "tag"], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        tag_output = result.stdout.decode()
        return tag_name in tag_output.splitlines()

    # ======== 步骤 1: 拉取代码 ========
    if os.path.exists(LOCAL_REPO_PATH):
        shutil.rmtree(LOCAL_REPO_PATH, onerror=remove_readonly)
        print(f"🧹 已删除目录: {LOCAL_REPO_PATH}")

    os.makedirs(LOCAL_REPO_PATH)
    print(f"✅ 已重新创建目录: {LOCAL_REPO_PATH}")

    subprocess.run(["git", "clone", "-b", BRANCH_NAME, repo_url, LOCAL_REPO_PATH], check=True)
    print(f"✅ 仓库克隆完成: {repo_url} (分支: {BRANCH_NAME})")

    # ======== 步骤 2: 模拟构建产物 ========
    print("🚧 模拟编译中...")

    if not os.path.exists(BUILD_FILE):
        with open(BUILD_FILE, "w") as f:
            f.write("This is a mock build file.\n")
    print(f"✅ 编译完成，生成产物: {BUILD_FILE}")

    if confDict.get('tag') == 1:
        # ======== 步骤 3: 创建 tag 并推送 ========
        if tag_exists(TAG_NAME):
            print(f"⚠️ Git tag '{TAG_NAME}' 已存在，跳过创建。")
        else:
            subprocess.run(["git", "-C", LOCAL_REPO_PATH, "tag", TAG_NAME], check=True)
            subprocess.run(["git", "-C", LOCAL_REPO_PATH, "push", "origin", TAG_NAME], check=True)
            print(f"🏷️ Git tag '{TAG_NAME}' created and pushed.")

    release_status_code = 0
    release_status_text = ""
    if confDict.get('release') == '1':
        # ======== 步骤 4: 上传构建产物 ========
        with open(BUILD_FILE, "rb") as f:
            files = {"file": (os.path.basename(BUILD_FILE), f)}
            headers = {"PRIVATE-TOKEN": GITLAB_API_TOKEN}
            upload_url = f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}/uploads"
            response = requests.post(upload_url, headers=headers, files=files)

        if response.status_code != 201:
            print(f"❌ 上传构建产物失败: {response.text}")
            exit(1)

        file_info = response.json()
        file_url = file_info["url"]
        print(f"✅ 文件上传成功: {file_url}")

        # ======== 步骤 5: 创建或更新 Release ========
        release_payload = {
            "name": f"Release {TAG_NAME}",
            "tag_name": TAG_NAME,
            "description": f"Auto released for tag {TAG_NAME}",
            "assets": {
                "links": [
                    {
                        "name": os.path.basename(BUILD_FILE),
                        "url": f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}{file_url}"
                    }
                ]
            }
        }

        release_url = f"{GITLAB_URL}/api/v4/projects/{GITLAB_PROJECT_ID}/releases"
        release_res = requests.post(release_url, headers=headers, json=release_payload)

        if release_res.status_code == 409:
            # 已存在 Release，更新之
            update_url = f"{release_url}/{TAG_NAME}"
            release_res = requests.put(update_url, headers=headers, json=release_payload)
        release_status_code = release_res.ok
        release_status_text = release_res.text

    if release_status_code:
        print(f"🚀 Release 发布成功: {TAG_NAME}")
        return {
            'code': 0,
            'message': "消息发送成功",
            'error_message': ""
        }
    else:
        print(f"❌ Release 发布失败: {release_status_code} - {release_status_text}")
        return {
            'code': release_status_code,
            'message': "消息发送失败",
            'error_message': f"{release_status_text}"
        }


if __name__ == '__main__':
    creatTagAndRelease()
