import websocket

# 连接成功时的回调函数
def on_open(ws):
    print("WebSocket连接已建立")
    ws.send("Hello, WebSocket!") # 发送消息

# 接收到服务器消息时的回调函数
def on_message(ws, message):
    print("收到来自服务器的消息：{}".format(message))

# 关闭连接时的回调函数
def on_close(ws):
    print("WebSocket连接已断开")

# 创建WebSocket客户端实例，并注册回调函数
ws = websocket.WebSocketApp("ws://localhost:6677/", # WebSocket服务器地址
                            on_open=on_open, # 连接成功时的回调函数
                            on_message=on_message, # 接收到消息时的回调函数
                            on_close=on_close) # 关闭连接时的回调函数

# 运行WebSocket客户端
ws.run_forever()