import requests
import json

from model import RecvData
from model.RecvData import GitlabPayload

def test():
    webhook_url = 'https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=752b9124-5c68-41ed-99b4-3607eab8349c'

    data = {
        "msgtype": "template_card",
        "template_card": {
            "card_type": "text_notice",
            "source": {
                "icon_url": "https://wework.qpic.cn/wwpic/252813_jOfDHtcISzuodLa_1629280209/0",
                "desc": "软件二部",
                "desc_color": 0
            },
            "main_title": {
                "title": "长安655项目",
                "desc": "master 分支"
            },
            "emphasis_content": {
                "title": "V1.0.0",
                "desc": "当前版本"
            },
            "quote_area": {
                "type": 1,
                "url": "https://work.weixin.qq.com/?from=openApi",
                "appid": "APPID",
                "pagepath": "PAGEPATH",
                "title": "本次升级内容",
                "quote_text": "无"
            },
            "horizontal_content_list": [{
                "keyname": "打包人",
                "value": "时先生"
            },
                {
                    "keyname": "项目地址",
                    "value": "点击访问",
                    "type": 1,
                    "url": "http://tyw-server.synology.me:12345/shihaixin/autocompliecode"
                },
                {
                    "keyname": "Jobs地址",
                    "value": "点击访问",
                    "type": 1,
                    "url": "http://tyw-server.synology.me:12345/shihaixin/autocompliecode/-/jobs"
                }
            ],
            "jump_list": [{
                "type": 1,
                "url": "http://tyw-server.synology.me:12345/shihaixin/autocompliecode",
                "title": "项目地址"
            }
            ],
            "card_action": {
                "type": 1,
                "url": "http://tyw-server.synology.me:12345/shihaixin/autocompliecode"
            }
        }
    }
    headers = {'Content-Type': 'application/json'}

    response = requests.post(webhook_url, headers=headers, data=json.dumps(data))

    if response.status_code == 200:
        print("✅ 消息发送成功")
    else:
        print(f"❌ 消息发送失败: {response.status_code}, {response.text}")


def sendWx(recv_data: GitlabPayload, confDict: dict, url: str):
    webhook_url = f"https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key={confDict['wechat_webhook']}"

    data = {
        "msgtype": "template_card",
        "template_card": {
            "card_type": "text_notice",
            "source": {
                "icon_url": "https://wework.qpic.cn/wwpic/252813_jOfDHtcISzuodLa_1629280209/0",
                "desc": "软件二部",
                "desc_color": 0
            },
            "main_title": {
                "title": f"{recv_data.metadata.project_name}",
                "desc": f"{recv_data.commit.branch} 分支"
            },
            "emphasis_content": {
                "title": f"{confDict['version_name']}",
                "desc": "当前版本"
            },
            "quote_area": {
                "type": 1,
                "url": "https://work.weixin.qq.com/?from=openApi",
                "appid": "APPID",
                "pagepath": "PAGEPATH",
                "title": "本次升级内容",
                "quote_text": f"{recv_data.commit.message}"
            },
            "horizontal_content_list": [{
                "keyname": "打包人",
                "value": f"{recv_data.metadata.user_login}"
            },
                {
                    "keyname": "项目地址",
                    "value": "点击访问",
                    "type": 1,
                    "url": f"{url.replace('.git','')}"
                },
                {
                    "keyname": "Jobs地址",
                    "value": "点击访问",
                    "type": 1,
                    "url":  f"{url.replace('.git','')+'/-/jobs'}"
                }
            ],
            "jump_list": [{
                "type": 1,
                "url": f"{url.replace('.git','')}",
                "title": "项目地址"
            }
            ],
            "card_action": {
                "type": 1,
                "url":f"{url.replace('.git','')}"
            }
        }
    }
    headers = {'Content-Type': 'application/json'}

    response = requests.post(webhook_url, headers=headers, data=json.dumps(data))

    if response.status_code == 200:
        print("✅ 消息发送成功")
        return {
            'code': 0,
            'message': "消息发送成功",
            'error_message': ""
        }
    else:
        print(f"❌ 消息发送失败: {response.status_code}, {response.text}")
        return {
            'code': response.status_code,
            'message': "消息发送失败",
            'error_message': f"{response.text}"
        }


if __name__ == '__main__':
    # sendWx()
    test()
