
#include "Sys_Scheduler_Lib.h"
#include "Components.h"
//#include "CommonInterface.h"
#include "RTE.h"
#include "FreIn.h"
#include "FreIn_User.h"
#include "Telltales_user.h"
#include "Display.h"
#include "PowerManagement\PowerManagement.h"
#include "PowerManagement\PowerManag_user.h"
#include "Line_In\Line_In.h"
#include "AMT630H\UartProtocol.h"
#include "tim.h"
#include "UDS\DoCAN_ISO15765.h"
#include "UDS\UDS_ISO14229_Server.h"
#include "OPT3004.h"
#include "UDS\UDS_ISO14229_Services.h"
#include "RTE_GPIO_BAT32A279.h"
#include "CAN_Signal\CAN_Lib.h"
#include "Can_User.h"
void Sys_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
    DoCAN_Communication_Service();
    UDS_Server_Application_Service();
}

void Sys_2ms_Tasks(void)
{
    Common_Input_Para();
    Sys_Status_Update_Service();
    Analog_Signal_Conv_Service();
}

void Sys_5ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
    
}

void Sys_10ms_Tasks(void)
{
    Speed_Self_Inspection();
    Fre_In_Service(FRE_VEHICLE);
    Fre_In_Time_Out_Handle(10);
    LED_Turn_Left_Judgement();
    LED_Turn_Right_Judgement();
    Line_In_Debounce_Service(10u);
    Mileage_Total_Clearing();
    Data_Mileage_Write_EEPROM();
    Fuel_R_Cal(10u);
    Coolant_R_Cal(10u);
    tyre_Size();
    Driving_Mode_Display();
    Key_Service();
    Can_BusOff_Recover(10u);
}

void Sys_20ms_Tasks(void)
{
    Data_Vehicle_Speed_Duty_Cycle_Detection();
    Data_Vehicle_Speed_Processing_Service();
    Data_Engine_Speed_Processing_Service();
    ADProcess_NTC_Temp_Service();
}

void Sys_50ms_Tasks(void)
{
    Telltales_Management();
    Time_Display_Service();
    Time_Cocln_server();
    Backlight_SetPwm_cotrol();
    Optical_Fault_Recovery();
    Self_Inspection();
    AMT630H_Main();
}


extern void PackedTransfer_GetSwVer(void);
void Sys_100ms_Tasks(void)
{
    S3_ServerCNTT();
    Fuel_Cal_Sevice(100u);
    Coolant_Cal_Sevice(100u);
    Fuel_Self_InspectionOld();
    Coolant_Self_InspectionOld();
    Service_Interval_Processing();
    Service_Interval_TimerISR();
    Display_Battery_Voltage();
    PackedTransfer_GetSwVer();
    // AMT630_CLK();
    AMT630H_Sleep12();
}

uint16_t task_2ms = 0u;
uint32_t task_100ms = 0u;
void Sys_Exact_1ms_Tasks(void)
{
    GenDelay_Tick();
    eeprom_1ms_timeCount();
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 1u);
    task_2ms++;
    if (task_2ms >= 2)
    {
        task_2ms = 0;
        AMT630H_Timer(2);
        Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 2000u);//无外发
        DoCAN_Timer_Update(2000u);
    }
    // Pwm_Controller();
    Pwm_Controller_Buzzer_X();
    if(task_100ms >= 100)
    {
        task_100ms = 0;
        Services_Mileage_Callback();
    }
    else
    {
        task_100ms++;
    }
}

